package eleme.openapi.sdk.api.entity.couponBill;

import eleme.openapi.sdk.api.enumeration.couponBill.*;
import eleme.openapi.sdk.api.entity.couponBill.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class OpenApiInStoreBill{

    /**
     * 订单子类型细分, orderSubType下一级描述
     */
    private String orderSubTypeSubdivision;
    public String getOrderSubTypeSubdivision() {
        return orderSubTypeSubdivision;
    }
    public void setOrderSubTypeSubdivision(String orderSubTypeSubdivision) {
        this.orderSubTypeSubdivision = orderSubTypeSubdivision;
    }
    
    /**
     * 结算事由
     */
    private String settlementReason;
    public String getSettlementReason() {
        return settlementReason;
    }
    public void setSettlementReason(String settlementReason) {
        this.settlementReason = settlementReason;
    }
    
    /**
     * 备注
     */
    private String remark;
    public String getRemark() {
        return remark;
    }
    public void setRemark(String remark) {
        this.remark = remark;
    }
    
    /**
     * 店铺ID
     */
    private Long shopId;
    public Long getShopId() {
        return shopId;
    }
    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
    
    /**
     * 门店名称
     */
    private String shopName;
    public String getShopName() {
        return shopName;
    }
    public void setShopName(String shopName) {
        this.shopName = shopName;
    }
    
    /**
     * 结算入账ID
     */
    private Long settleAccountShopId;
    public Long getSettleAccountShopId() {
        return settleAccountShopId;
    }
    public void setSettleAccountShopId(Long settleAccountShopId) {
        this.settleAccountShopId = settleAccountShopId;
    }
    
    /**
     * 商品ID
     */
    private Long itemId;
    public Long getItemId() {
        return itemId;
    }
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
    
    /**
     * 商品名称
     */
    private String itemName;
    public String getItemName() {
        return itemName;
    }
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
    
    /**
     * 商品类型, CASH_VOUCHER- 卡券, GROUP_BUY - 团购券
     */
    private String itemType;
    public String getItemType() {
        return itemType;
    }
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }
    
    /**
     * 券码
     */
    private String ticketCode;
    public String getTicketCode() {
        return ticketCode;
    }
    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }
    
    /**
     * 订单子类型, IN_STORE_TICKET_SETTLE - 结算, IN_STORE_TICKET_REFUND - 退结算
     */
    private String orderSubType;
    public String getOrderSubType() {
        return orderSubType;
    }
    public void setOrderSubType(String orderSubType) {
        this.orderSubType = orderSubType;
    }
    
    /**
     * 订单号
     */
    private Long alscOrderNo;
    public Long getAlscOrderNo() {
        return alscOrderNo;
    }
    public void setAlscOrderNo(Long alscOrderNo) {
        this.alscOrderNo = alscOrderNo;
    }
    
    /**
     * 账单日期
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date billDate;
    public Date getBillDate() {
        return billDate;
    }
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    
    /**
     * 结算日期
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date settleDate;
    public Date getSettleDate() {
        return settleDate;
    }
    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    
    /**
     * 核销流水号
     */
    private Long useTransId;
    public Long getUseTransId() {
        return useTransId;
    }
    public void setUseTransId(Long useTransId) {
        this.useTransId = useTransId;
    }
    
    /**
     * 下单时间 - 正向单有值
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date placeOrderTime;
    public Date getPlaceOrderTime() {
        return placeOrderTime;
    }
    public void setPlaceOrderTime(Date placeOrderTime) {
        this.placeOrderTime = placeOrderTime;
    }
    
    /**
     * 消费时间 - 正向单有值
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date useTime;
    public Date getUseTime() {
        return useTime;
    }
    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }
    
    /**
     * 撤销时间 - 逆向单有值
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date reverseTime;
    public Date getReverseTime() {
        return reverseTime;
    }
    public void setReverseTime(Date reverseTime) {
        this.reverseTime = reverseTime;
    }
    
    /**
     * 退款时间 - 逆向单有值
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date refundTime;
    public Date getRefundTime() {
        return refundTime;
    }
    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }
    
    /**
     * 售价
     */
    private BigDecimal salePrice;
    public BigDecimal getSalePrice() {
        return salePrice;
    }
    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }
    
    /**
     * 结算金额
     */
    private BigDecimal settleAmount;
    public BigDecimal getSettleAmount() {
        return settleAmount;
    }
    public void setSettleAmount(BigDecimal settleAmount) {
        this.settleAmount = settleAmount;
    }
    
    /**
     * 用户支付金额
     */
    private BigDecimal buyerAmount;
    public BigDecimal getBuyerAmount() {
        return buyerAmount;
    }
    public void setBuyerAmount(BigDecimal buyerAmount) {
        this.buyerAmount = buyerAmount;
    }
    
    /**
     * 信息技术服务费（抽佣）
     */
    private BigDecimal technologyServiceFeeAmount;
    public BigDecimal getTechnologyServiceFeeAmount() {
        return technologyServiceFeeAmount;
    }
    public void setTechnologyServiceFeeAmount(BigDecimal technologyServiceFeeAmount) {
        this.technologyServiceFeeAmount = technologyServiceFeeAmount;
    }
    
    /**
     * 信息技术服务费（抽佣）折扣系数, 90表示90%
     */
    private BigDecimal technologyServiceFeeDiscount;
    public BigDecimal getTechnologyServiceFeeDiscount() {
        return technologyServiceFeeDiscount;
    }
    public void setTechnologyServiceFeeDiscount(BigDecimal technologyServiceFeeDiscount) {
        this.technologyServiceFeeDiscount = technologyServiceFeeDiscount;
    }
    
    /**
     * 信息技术服务费率（抽佣）, 1表示1%
     */
    private BigDecimal technologyServiceFeeRate;
    public BigDecimal getTechnologyServiceFeeRate() {
        return technologyServiceFeeRate;
    }
    public void setTechnologyServiceFeeRate(BigDecimal technologyServiceFeeRate) {
        this.technologyServiceFeeRate = technologyServiceFeeRate;
    }
    
    /**
     * 支付技术服务费
     */
    private BigDecimal payServiceFeeAmount;
    public BigDecimal getPayServiceFeeAmount() {
        return payServiceFeeAmount;
    }
    public void setPayServiceFeeAmount(BigDecimal payServiceFeeAmount) {
        this.payServiceFeeAmount = payServiceFeeAmount;
    }
    
    /**
     * 支付技术服务费率,1 表示1%
     */
    private BigDecimal payServiceFeeRate;
    public BigDecimal getPayServiceFeeRate() {
        return payServiceFeeRate;
    }
    public void setPayServiceFeeRate(BigDecimal payServiceFeeRate) {
        this.payServiceFeeRate = payServiceFeeRate;
    }
    
    /**
     * 商家活动补贴
     */
    private BigDecimal merchantCampSubsidy;
    public BigDecimal getMerchantCampSubsidy() {
        return merchantCampSubsidy;
    }
    public void setMerchantCampSubsidy(BigDecimal merchantCampSubsidy) {
        this.merchantCampSubsidy = merchantCampSubsidy;
    }
    
    /**
     * 商家代金券补贴
     */
    private BigDecimal merchantVoucherSubsidy;
    public BigDecimal getMerchantVoucherSubsidy() {
        return merchantVoucherSubsidy;
    }
    public void setMerchantVoucherSubsidy(BigDecimal merchantVoucherSubsidy) {
        this.merchantVoucherSubsidy = merchantVoucherSubsidy;
    }
    
    /**
     * 平台活动补贴
     */
    private BigDecimal platformCampSubsidy;
    public BigDecimal getPlatformCampSubsidy() {
        return platformCampSubsidy;
    }
    public void setPlatformCampSubsidy(BigDecimal platformCampSubsidy) {
        this.platformCampSubsidy = platformCampSubsidy;
    }
    
    /**
     * 平台代金券补贴
     */
    private BigDecimal platformVoucherSubsidy;
    public BigDecimal getPlatformVoucherSubsidy() {
        return platformVoucherSubsidy;
    }
    public void setPlatformVoucherSubsidy(BigDecimal platformVoucherSubsidy) {
        this.platformVoucherSubsidy = platformVoucherSubsidy;
    }
    
}