package eleme.openapi.sdk.api.entity.couponProduct;

import eleme.openapi.sdk.api.enumeration.couponProduct.*;
import eleme.openapi.sdk.api.entity.couponProduct.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class OCouponItem{

    /**
     * 商品状态，ONLINE("上线")，OFFLINE("下线")
     */
    private String status;
    public String getStatus() {
        return status;
    }
    public void setStatus(String status) {
        this.status = status;
    }
    
    /**
     * 类目ID
     */
    private Long categoryId;
    public Long getCategoryId() {
        return categoryId;
    }
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    
    /**
     * 购买须知
     */
    private List<String> purchaseNotes;
    public List<String> getPurchaseNotes() {
        return purchaseNotes;
    }
    public void setPurchaseNotes(List<String> purchaseNotes) {
        this.purchaseNotes = purchaseNotes;
    }
    
    /**
     * 券不可用时间
     */
    private OUsageTime unavailableDate;
    public OUsageTime getUnavailableDate() {
        return unavailableDate;
    }
    public void setUnavailableDate(OUsageTime unavailableDate) {
        this.unavailableDate = unavailableDate;
    }
    
    /**
     * 券可用时间，参考unavailableDate
     */
    private OUsageTime availableDate;
    public OUsageTime getAvailableDate() {
        return availableDate;
    }
    public void setAvailableDate(OUsageTime availableDate) {
        this.availableDate = availableDate;
    }
    
    /**
     * 券有效期
     */
    private OCouponPeriod couponPeriod;
    public OCouponPeriod getCouponPeriod() {
        return couponPeriod;
    }
    public void setCouponPeriod(OCouponPeriod couponPeriod) {
        this.couponPeriod = couponPeriod;
    }
    
    /**
     * 售卖时间
     */
    private OSaleTime saleTime;
    public OSaleTime getSaleTime() {
        return saleTime;
    }
    public void setSaleTime(OSaleTime saleTime) {
        this.saleTime = saleTime;
    }
    
    /**
     * 用户限购数据信息
     */
    private OUserLimitBuy userLimitBuy;
    public OUserLimitBuy getUserLimitBuy() {
        return userLimitBuy;
    }
    public void setUserLimitBuy(OUserLimitBuy userLimitBuy) {
        this.userLimitBuy = userLimitBuy;
    }
    
    /**
     * 菜品信息
     */
    private List<OCouponItemPackageGroup> packageGroups;
    public List<OCouponItemPackageGroup> getPackageGroups() {
        return packageGroups;
    }
    public void setPackageGroups(List<OCouponItemPackageGroup> packageGroups) {
        this.packageGroups = packageGroups;
    }
    
    /**
     * 库存信息
     */
    private OCouponItemBudget budget;
    public OCouponItemBudget getBudget() {
        return budget;
    }
    public void setBudget(OCouponItemBudget budget) {
        this.budget = budget;
    }
    
    /**
     * 商品券描述
     */
    private String description;
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * 适用门店数量
     */
    private Integer shopNum;
    public Integer getShopNum() {
        return shopNum;
    }
    public void setShopNum(Integer shopNum) {
        this.shopNum = shopNum;
    }
    
    /**
     * 图片列表
     */
    private List<OItemMaterial> images;
    public List<OItemMaterial> getImages() {
        return images;
    }
    public void setImages(List<OItemMaterial> images) {
        this.images = images;
    }
    
    /**
     * 售价，单位元
     */
    private Double salePrice;
    public Double getSalePrice() {
        return salePrice;
    }
    public void setSalePrice(Double salePrice) {
        this.salePrice = salePrice;
    }
    
    /**
     * 原价，单位元
     */
    private Double originalPrice;
    public Double getOriginalPrice() {
        return originalPrice;
    }
    public void setOriginalPrice(Double originalPrice) {
        this.originalPrice = originalPrice;
    }
    
    /**
     * 商品名称
     */
    private String itemName;
    public String getItemName() {
        return itemName;
    }
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
    
    /**
     * 外部系统商品code
     */
    private String itemExtCode;
    public String getItemExtCode() {
        return itemExtCode;
    }
    public void setItemExtCode(String itemExtCode) {
        this.itemExtCode = itemExtCode;
    }
    
    /**
     * 商品子类型，GENERAL("通用"),CAKE("蛋糕"),BUFFET("自助餐"),     CASH_VOUCHER("代金券")
     */
    private String subItemType;
    public String getSubItemType() {
        return subItemType;
    }
    public void setSubItemType(String subItemType) {
        this.subItemType = subItemType;
    }
    
    /**
     * 商品类型,GROUP_BUY("团购券"),CASH_VOUCHER("代金券")
     */
    private String itemType;
    public String getItemType() {
        return itemType;
    }
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }
    
    /**
     * 饿了么系统商品ID
     */
    private Long itemId;
    public Long getItemId() {
        return itemId;
    }
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
    
}