package eleme.openapi.sdk.api.entity.product;

import eleme.openapi.sdk.api.enumeration.product.*;
import eleme.openapi.sdk.api.entity.product.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class ChainItemDTO{

    /**
     * 商品所属连锁总店店铺Id
     */
    private Long shopId;
    public Long getShopId() {
        return shopId;
    }
    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
    
    /**
     * 商品所属连锁总店分组Id
     */
    private String gid;
    public String getGid() {
        return gid;
    }
    public void setGid(String gid) {
        this.gid = gid;
    }
    
    /**
     * 连锁总店商品Id
     */
    private String iid;
    public String getIid() {
        return iid;
    }
    public void setIid(String iid) {
        this.iid = iid;
    }
    
    /**
     * 连锁总店商品名称
     */
    private String name;
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * 连锁总店商品描述
     */
    private String description;
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * 连锁总店商品图片hash
     */
    private String imageHash;
    public String getImageHash() {
        return imageHash;
    }
    public void setImageHash(String imageHash) {
        this.imageHash = imageHash;
    }
    
    /**
     * 连锁总店商品单位
     */
    private String unit;
    public String getUnit() {
        return unit;
    }
    public void setUnit(String unit) {
        this.unit = unit;
    }
    
    /**
     * 连锁总店商品最小购买量
     */
    private Integer minPurchaseQuantity;
    public Integer getMinPurchaseQuantity() {
        return minPurchaseQuantity;
    }
    public void setMinPurchaseQuantity(Integer minPurchaseQuantity) {
        this.minPurchaseQuantity = minPurchaseQuantity;
    }
    
    /**
     * 连锁总店商品特色标签
     */
    private List<ItemLabelDTO> itemLabels;
    public List<ItemLabelDTO> getItemLabels() {
        return itemLabels;
    }
    public void setItemLabels(List<ItemLabelDTO> itemLabels) {
        this.itemLabels = itemLabels;
    }
    
    /**
     * 连锁总店商品规格(决定商品价格)
     */
    private List<ChainSkuDTO> skus;
    public List<ChainSkuDTO> getSkus() {
        return skus;
    }
    public void setSkus(List<ChainSkuDTO> skus) {
        this.skus = skus;
    }
    
    /**
     * 连锁总店商品属性(不决定商品价格)
     */
    private List<ItemPropertyDTO> attributes;
    public List<ItemPropertyDTO> getAttributes() {
        return attributes;
    }
    public void setAttributes(List<ItemPropertyDTO> attributes) {
        this.attributes = attributes;
    }
    
    /**
     * 连锁总店售卖时间
     */
    private ItemSaleTimeDTO sellingTime;
    public ItemSaleTimeDTO getSellingTime() {
        return sellingTime;
    }
    public void setSellingTime(ItemSaleTimeDTO sellingTime) {
        this.sellingTime = sellingTime;
    }
    
    /**
     * 连锁总店上下架状态
     */
    private ItemShelfStatusDTO itemShelfStatus;
    public ItemShelfStatusDTO getItemShelfStatus() {
        return itemShelfStatus;
    }
    public void setItemShelfStatus(ItemShelfStatusDTO itemShelfStatus) {
        this.itemShelfStatus = itemShelfStatus;
    }
    
    /**
     * 连锁总店商品原材料
     */
    private List<ItemMaterialDTO> materials;
    public List<ItemMaterialDTO> getMaterials() {
        return materials;
    }
    public void setMaterials(List<ItemMaterialDTO> materials) {
        this.materials = materials;
    }
    
}