package eleme.openapi.sdk.api.enumeration.order;

public enum OSelfDeliveryStateEnum {
    /**
     * 商家已送出
     */
    DELIVERY_START("DELIVERY_START"), 
    
    /**
     * 商家已取消
     */
    DELIVERY_CANCEL("DELIVERY_CANCEL"), 
    
    /**
     * 商家已送达
     */
    DELIVERY_COMPLETE("DELIVERY_COMPLETE"), 
    
    /**
     * 骑手接单
     */
    DELIVERY_KNIGHT_ACCEPT("DELIVERY_KNIGHT_ACCEPT"), 
    
    /**
     * 骑手到店
     */
    DELIVERY_KNIGHT_REACH_SHOP("DELIVERY_KNIGHT_REACH_SHOP"), 
    
    /**
     * 骑手取消配送(待其他骑手配送，一般用于更换骑手场景)
     */
    DELIVERY_KNIGHT_CANCEL("DELIVERY_KNIGHT_CANCEL");
    

    private String orderDesc;
    OSelfDeliveryStateEnum(String orderDesc) {
        this.orderDesc = orderDesc;
    }
}