package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.ad.*;
import eleme.openapi.sdk.api.enumeration.ad.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 斗金服务
 */
@Service("eleme.ad")
public class AdService extends BaseNopService {
    public AdService(Config config,Token token) {
        super(config, token, AdService.class);
    }

    /**
     * 查询斗金推广设置
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinCpcSolutionFindResponse findDouJinCpcSolution(EDouJinCpcSolutionFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.findDouJinCpcSolution", params);
    }

    /**
     * 查询斗金推广点击分布信息
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinClickDistributionReportFindResponse findDouJinClickDistributionReport(EDouJinClickDistributionReportFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.findDouJinClickDistributionReport", params);
    }

    /**
     * 查询斗金推广效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinEffectiveReportFindResponse findDouJinEffectReport(EDouJinEffectiveReportFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.findDouJinEffectReport", params);
    }

    /**
     * 设置斗金时段
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinUpdateResponse updateDouJinTime(EDouJinTimeUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.updateDouJinTime", params);
    }

    /**
     * 设置斗金定向
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinUpdateResponse updateDouJinTarget(EDouJinTargetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.updateDouJinTarget", params);
    }

    /**
     * 设置斗金预算
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinUpdateResponse updateDouJinBudget(EDouJinBudgetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.updateDouJinBudget", params);
    }

    /**
     * 设置斗金出价
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinUpdateResponse updateDouJinBid(EDouJinBidUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.updateDouJinBid", params);
    }

    /**
     * 设置斗金状态
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinUpdateResponse updateDouJinState(EDouJinStateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.updateDouJinState", params);
    }

    /**
     * 设置斗金投放渠道
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinUpdateResponse updateDouJinChannel(EDouJinChannelUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.updateDouJinChannel", params);
    }

    /**
     * 创建斗金计划
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinCpcSolutionCreateResponse createDouJinSolution(EDouJinCpcSolutionCreateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.createDouJinSolution", params);
    }

    /**
     * 查询斗金最大可用余额
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinAccountBalanceFindResponse findDouJinAccountBalance(EDouJinAccountBalanceFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpc.findDouJinAccountBalance", params);
    }

    /**
     * 查询账户余额
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EAccountBalanceFindResponse findAccountBalance(EAccountBalanceFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.common.findAccountBalance", params);
    }

    /**
     * 查询活动列表
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EShopActivityListGetResponse getActivityList(EShopActivityListGetRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.common.getActivityList", params);
    }

    /**
     * 查询商家折扣券
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EShopDiscountCouponQueryResponse queryDiscountCouponDetails(EShopDiscountCouponQueryRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.common.queryDiscountCouponDetails", params);
    }

    /**
     * 查询商户广告诊断建议
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EShopDiagnoseResponse syncDiagnose(EShopDiagnoseRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.common.syncDiagnose", params);
    }

    /**
     * 一键采纳诊断建议
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EShopOperateResponse optimizeTask(EShopOptimizeTaskRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.common.optimizeTask", params);
    }

    /**
     * 分页查询推广魔方-稳定转化场景连锁计划
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionChainSolutionFindResponse stableconversionchainFindSolution(EStableConversionChainSolutionFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.findSolution", params);
    }

    /**
     * 创建推广魔方-稳定转化场景连锁计划
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public ECpcChainSolutionCreateResponse stableconversionchainCreateSolution(EStableConversionChainSolutionCreateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.createSolution", params);
    }

    /**
     * 设置推广魔方-稳定转化场景连锁计划状态
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse stableconversionchainUpdateState(EChainStateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.updateState", params);
    }

    /**
     * 设置推广魔方-稳定转化场景连锁计划时段
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse stableconversionchainUpdateTime(EChainTimeUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.updateTime", params);
    }

    /**
     * 设置推广魔方-稳定转化场景连锁计划日期
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDate(EChainDateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.updateDate", params);
    }

    /**
     * 设置推广魔方-稳定转化场景连锁计划名称
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateTitle(EChainTitleUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.updateTitle", params);
    }

    /**
     * 设置推广魔方-稳定转化场景连锁计划预算
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse stableconversionchainUpdateBudget(EChainBudgetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.updateBudget", params);
    }

    /**
     * 设置推广魔方-稳定转化场景连锁计划推广目标力度
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateStyle(EChainStyleUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.updateStyle", params);
    }

    /**
     * 设置推广魔方-稳定转化场景连锁计划单元投放状态
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateStableConversionChainAdGroupState(EChainAdGroupStateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.updateStableConversionChainAdGroupState", params);
    }

    /**
     * 推广魔方-稳定转化场景连锁计划下新增门店
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainShopUpdateResponse addShop(EStableConversionChainShopAddRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.addShop", params);
    }

    /**
     * 推广魔方-稳定转化场景连锁计划下删除门店
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainShopUpdateResponse deleteShop(EChainShopDeleteRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.deleteShop", params);
    }

    /**
     * 推广魔方连锁店计划-日期维度效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainEffectiveReportFindWithCampaignAndDateResponse findEffectReportWithCampaignAndDate(EStableConversionChainEffectiveReportFindWithCampaignAndDateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.findEffectReportWithCampaignAndDate", params);
    }

    /**
     * 推广魔方连锁店计划-门店-日期维度效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainEffectiveReportFindWithCampaignAndShopAndDateResponse findEffectReportWithCampaignAndShopAndDate(EStableConversionChainEffectiveReportFindWithCampaignAndShopAndDateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversionchain.findEffectReportWithCampaignAndShopAndDate", params);
    }

    /**
     * 分页查询斗金连锁计划
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDouJinCpcChainSolutionFindResponse doujincpcchainFindDouJinCpcSolution(ECpcChainSolutionFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.findDouJinCpcSolution", params);
    }

    /**
     * 创建斗金连锁计划
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public ECpcChainSolutionCreateResponse doujincpcchainCreateDouJinSolution(ECpcChainSolutionCreateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.createDouJinSolution", params);
    }

    /**
     * 设置斗金连锁计划状态
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse doujincpcchainUpdateDouJinState(EChainStateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinState", params);
    }

    /**
     * 设置斗金连锁计划投放渠道
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse doujincpcchainUpdateDouJinChannel(EChainChannelUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinChannel", params);
    }

    /**
     * 设置斗金连锁计划出价助手
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDouJinBidType(EChainBidTypeUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinBidType", params);
    }

    /**
     * 设置斗金连锁计划时段
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse doujincpcchainUpdateDouJinTime(EChainTimeUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinTime", params);
    }

    /**
     * 设置斗金连锁计划日期
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDouJinDate(EChainDateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinDate", params);
    }

    /**
     * 设置斗金连锁计划名称
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDouJinTitle(EChainTitleUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinTitle", params);
    }

    /**
     * 设置斗金连锁计划日预算（废弃，改为通过直接改动门店预算，计划预算为单元预算总和）
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse doujincpcchainUpdateDouJinBudget(EChainBudgetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinBudget", params);
    }

    /**
     * 设置斗金连锁计划门店出价
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse doujincpcchainUpdateDouJinBid(EChainBidUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinBid", params);
    }

    /**
     * 设置斗金连锁计划门店预算
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDouJinShopBudget(EChainShopBudgetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinShopBudget", params);
    }

    /**
     * 设置斗金连锁计划定向
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse doujincpcchainUpdateDouJinTarget(EDouJinChainTargetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinTarget", params);
    }

    /**
     * 设置斗金连锁计划单元投放状态
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDouJinChainAdGroupState(EChainAdGroupStateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.updateDouJinChainAdGroupState", params);
    }

    /**
     * 新增斗金连锁计划门店
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainShopUpdateResponse addDouJinShop(EChainShopAddRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.addDouJinShop", params);
    }

    /**
     * 删除斗金连锁计划门店
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainShopUpdateResponse deleteDouJinShop(EChainShopDeleteRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.deleteDouJinShop", params);
    }

    /**
     * 查询门店的最低预算和最低出价
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainShopCityPriceFindResponse doujinFindShopCityPrice(EChainShopCityPriceFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.findShopCityPrice", params);
    }

    /**
     * 斗金连锁品牌资金计划维度效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainEffectiveReportFindWithCampaignAndDateResponse doujinFindEffectReportWithCampaignAndDate(EChainEffectiveReportFindWithCampaignAndDateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.findEffectReportWithCampaignAndDate", params);
    }

    /**
     * 斗金连锁分店资金门店x日期维度效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainEffectiveReportFindWithShopAndDateResponse doujinFindEffectReportWithShopAndDate(EChainEffectiveReportFindWithShopAndDateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.findEffectReportWithShopAndDate", params);
    }

    /**
     * 斗金连锁品牌资金门店x计划x日期维度效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainEffectiveReportFindWithCampaignAndShopAndDateResponse doujinFindEffectReportWithCampaignAndShopAndDate(EChainEffectiveReportFindWithCampaignAndShopAndDateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.doujincpcchain.findEffectReportWithCampaignAndShopAndDate", params);
    }

    /**
     * 分页查询单店推广魔方
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionSolutionFindResponse findSolution(EStableConversionSolutionFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversion.findSolution", params);
    }

    /**
     * 创建单店魔方
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionSolutionResponse createSolution(EStableConversionSolutionCreateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversion.createSolution", params);
    }

    /**
     * 设置推广魔方-计划状态
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionUpdateResponse updateState(EStableConversionStateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversion.updateState", params);
    }

    /**
     * 设置推广魔方-计划预算
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionUpdateResponse updateBudget(EStableConversionBudgetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversion.updateBudget", params);
    }

    /**
     * 设置推广魔方-计划出价
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionUpdateResponse updateBid(EStableConversionBidUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversion.updateBid", params);
    }

    /**
     * 设置推广魔方-计划时段
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionUpdateResponse updateTime(EStableConversionTimeUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversion.updateTime", params);
    }

    /**
     * 设置推广魔方-计划定向
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionUpdateResponse updateTarget(EStableConversionTargetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversion.updateTarget", params);
    }

    /**
     * 推广魔方-查询推广效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EStableConversionEffectiveReportFindResponse findEffectReport(EStableConversionEffectiveReportFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.stableconversion.findEffectReport", params);
    }

    /**
     * 查询优享大牌推广设置
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayCpcSolutionFindResponse findDisplayCpcSolution(EDisplayCpcSolutionFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.findDisplayCpcSolution", params);
    }

    /**
     * 查询优享大牌推广效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayEffectiveReportFindResponse findDisplayEffectReport(EDisplayEffectiveReportFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.findDisplayEffectReport", params);
    }

    /**
     * 设置优享大牌时段
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayUpdateResponse updateDisplayTime(EDisplayTimeUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.updateDisplayTime", params);
    }

    /**
     * 设置优享大牌定向
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayUpdateResponse updateDisplayTarget(EDisplayTargetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.updateDisplayTarget", params);
    }

    /**
     * 设置优享大牌预算
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayUpdateResponse updateDisplayBudget(EDisplayBudgetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.updateDisplayBudget", params);
    }

    /**
     * 设置优享大牌出价
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayUpdateResponse updateDisplayBid(EDisplayBidUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.updateDisplayBid", params);
    }

    /**
     * 设置优享大牌状态
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayUpdateResponse updateDisplayState(EDisplayStateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.updateDisplayState", params);
    }

    /**
     * 创建优享大牌计划
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayCpcSolutionCreateResponse createDisplaySolution(EDisplayCpcSolutionCreateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.createDisplaySolution", params);
    }

    /**
     * 查询优享大牌最大可用余额
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayAccountBalanceFindResponse findDisplayAccountBalance(EDisplayAccountBalanceFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpc.findDisplayAccountBalance", params);
    }

    /**
     * 分页查询优享大牌连锁计划
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EDisplayCpcChainSolutionFindResponse displaycpcchainFindDisplayCpcSolution(ECpcChainSolutionFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.findDisplayCpcSolution", params);
    }

    /**
     * 创建优享大牌连锁计划
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public ECpcChainSolutionCreateResponse displaycpcchainCreateDisplaySolution(ECpcChainSolutionCreateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.createDisplaySolution", params);
    }

    /**
     * 设置优享大牌连锁计划状态
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse displaycpcchainUpdateDisplayState(EChainStateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.updateDisplayState", params);
    }

    /**
     * 设置优享大牌连锁计划时段
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse displaycpcchainUpdateDisplayTime(EChainTimeUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.updateDisplayTime", params);
    }

    /**
     * 设置优享大牌连锁计划日期
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDisplayDate(EChainDateUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.updateDisplayDate", params);
    }

    /**
     * 设置优享大牌连锁计划名称
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDisplayTitle(EChainTitleUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.updateDisplayTitle", params);
    }

    /**
     * 设置优享大牌连锁计划日预算
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse displaycpcchainUpdateDisplayBudget(EChainBudgetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.updateDisplayBudget", params);
    }

    /**
     * 设置优享大牌连锁计划门店出价
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse displaycpcchainUpdateDisplayBid(EChainBidUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.updateDisplayBid", params);
    }

    /**
     * 设置优享大牌连锁计划门店预算
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse updateDisplayShopBudget(EChainShopBudgetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.updateDisplayShopBudget", params);
    }

    /**
     * 设置优享大牌连锁计划定向
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainUpdateResponse displaycpcchainUpdateDisplayTarget(EDisplayChainTargetUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.updateDisplayTarget", params);
    }

    /**
     * 新增优享大牌连锁计划门店
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainShopUpdateResponse addDisplayShop(EChainShopAddRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.addDisplayShop", params);
    }

    /**
     * 删除优享大牌连锁计划门店
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainShopUpdateResponse deleteDisplayShop(EChainShopDeleteRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.deleteDisplayShop", params);
    }

    /**
     * 查询门店的最低预算和最低出价
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainShopCityPriceFindResponse findShopCityPrice(EChainShopCityPriceFindRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.findShopCityPrice", params);
    }

    /**
     * 优享cpc连锁品牌资金计划维度效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainEffectiveReportFindWithCampaignAndDateResponse displaycpcchainFindEffectReportWithCampaignAndDate(EChainEffectiveReportFindWithCampaignAndDateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.findEffectReportWithCampaignAndDate", params);
    }

    /**
     * 优享cpc连锁分店资金门店x日期维度效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainEffectiveReportFindWithShopAndDateResponse findEffectReportWithShopAndDate(EChainEffectiveReportFindWithShopAndDateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.findEffectReportWithShopAndDate", params);
    }

    /**
     * 优享cpc连锁品牌资金门店x计划x日期维度效果数据
     *
     * @param request 请求参数
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public EChainEffectiveReportFindWithCampaignAndShopAndDateResponse displaycpcchainFindEffectReportWithCampaignAndShopAndDate(EChainEffectiveReportFindWithCampaignAndShopAndDateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ad.displaycpcchain.findEffectReportWithCampaignAndShopAndDate", params);
    }
}
