package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.alliance.*;
import eleme.openapi.sdk.api.enumeration.alliance.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 渠道管理服务
 */
@Service("eleme.alliance")
public class AllianceService extends BaseNopService {
    public AllianceService(Config config,Token token) {
        super(config, token, AllianceService.class);
    }

    /**
     * 创建三级渠道
     *
     * @param channelLevel3CreateRequest 三级渠道信息
     * @return 创建成功的三级渠道信息
     * @throws ServiceException 服务异常
     */
    public ChannelLevel3Response createChannelLevel3(ChannelLevel3CreateRequest channelLevel3CreateRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("channelLevel3CreateRequest", channelLevel3CreateRequest);
        return call("eleme.alliance.createChannelLevel3", params);
    }

    /**
     * 编辑三级渠道配置数据
     *
     * @param channelLevel3BatchUpdateRequest 渠道配置批量编辑
     * @return 编辑成功的三级渠道信息
     * @throws ServiceException 服务异常
     */
    public ChannelLevel3BatchResponse updateChannelLevel3(ChannelLevel3BatchUpdateRequest channelLevel3BatchUpdateRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("channelLevel3BatchUpdateRequest", channelLevel3BatchUpdateRequest);
        return call("eleme.alliance.updateChannelLevel3", params);
    }

    /**
     * 查询三级渠道配置数据
     *
     * @param channelLevel3QueryRequest 渠道信息批量查询
     * @return 查询成功的三级渠道信息
     * @throws ServiceException 服务异常
     */
    public ChannelLevel3BatchResponse queryChannelLevel3List(ChannelLevel3QueryRequest channelLevel3QueryRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("channelLevel3QueryRequest", channelLevel3QueryRequest);
        return call("eleme.alliance.queryChannelLevel3List", params);
    }

    /**
     * 查询机构账单
     *
     * @param queryInstitutionBillRequest 机构账单查询
     * @return 查询成功的订单信息
     * @throws ServiceException 服务异常
     */
    public QueryInstitutionBillResponse queryInstitutionBill(QueryInstitutionBillRequest queryInstitutionBillRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("queryInstitutionBillRequest", queryInstitutionBillRequest);
        return call("eleme.alliance.queryInstitutionBill", params);
    }

    /**
     * 外部渠道外卖店铺商品搜索
     *
     * @param requestDTO $fieldStruct.fieldComments
     * @return 结果
     * @throws ServiceException 服务异常
     */
    public SearchResponseDTO search(SearchRequestDTO requestDTO) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("requestDTO", requestDTO);
        return call("eleme.alliance.search", params);
    }

    /**
     * 查询用户订单列表
     *
     * @param orderRequestDTO 订单请求参数
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public AllianceResponseDTO getOrderList(UserOrderRequestDTO orderRequestDTO) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orderRequestDTO", orderRequestDTO);
        return call("eleme.alliance.getOrderList", params);
    }

    /**
     * 解绑渠道账号
     *
     * @param unbindRequestDTO $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public AllianceUnbindResponseDTO unbindUser(UserUnbindRequestDTO unbindRequestDTO) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("unbindRequestDTO", unbindRequestDTO);
        return call("eleme.alliance.unbindUser", params);
    }

    /**
     * 查询订单信息
     *
     * @param channelOrderQueryRequest 订单信息查询
     * @return 查询成功的订单信息
     * @throws ServiceException 服务异常
     */
    public ChannelOrderInfoResponse queryOrderInfo(ChannelOrderQueryRequest channelOrderQueryRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("channelOrderQueryRequest", channelOrderQueryRequest);
        return call("eleme.alliance.queryOrderInfo", params);
    }
}
