package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.couponBill.*;
import eleme.openapi.sdk.api.enumeration.couponBill.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 到店账单服务
 */
@Service("eleme.couponBill")
public class CouponBillService extends BaseNopService {
    public CouponBillService(Config config,Token token) {
        super(config, token, CouponBillService.class);
    }

    /**
     * 根据店铺ID和卡券code查询账单信息
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public List<OpenApiInStoreBill> queryInStoreBillByTicketCode(OpenapiInStoreBillQueryRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponBill.queryInStoreBillByTicketCode", params);
    }

    /**
     * 查询到店的余额流水变动
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public OBalanceLogResponse queryInStoreBalanceLog(OQueryBalanceLogRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponBill.queryInStoreBalanceLog", params);
    }

    /**
     * 分页查询到店账单的日汇总信息
     *
     * @param pageQuery $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public InStoreBillSummaryResponse pageQueryInStoreSummaryInfo(OpenapiInStoreBillPageQueryRequest pageQuery) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return call("eleme.couponBill.pageQueryInStoreSummaryInfo", params);
    }

    /**
     * 根据店铺ID和账期范围分页查询账单信息
     *
     * @param pageQuery $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public InStoreBillsResponse pageQueryInStoreBill(OpenapiInStoreBillPageQueryRequest pageQuery) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return call("eleme.couponBill.pageQueryInStoreBill", params);
    }
}
