package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.couponFulfill.*;
import eleme.openapi.sdk.api.enumeration.couponFulfill.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 到店核销服务
 */
@Service("eleme.couponFulfill")
public class CouponFulfillService extends BaseNopService {
    public CouponFulfillService(Config config,Token token) {
        super(config, token, CouponFulfillService.class);
    }

    /**
     * 到店券核销执行
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public DaodianTicketUseOpenApiResult use(DaodianTicketUseOpenApiRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponFulfill.use", params);
    }

    /**
     * 到店券核销撤销
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public DaodianTicketReverseOpenApiResult reverse(DaodianTicketReverseOpenApiRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponFulfill.reverse", params);
    }

    /**
     * 到店卡券查询
     *
     * @param request 到店券查询请求
     * @return 到店券查询结果
     * @throws ServiceException 服务异常
     */
    public DaodianTicketQueryOpenApiResult query(DaodianTicketQueryOpenApiRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponFulfill.query", params);
    }

    /**
     * 核销前咨询可核销的券信息
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public DaodianTicketConsultOpenApiResult consult(DaodianTicketConsultOpenApiRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponFulfill.consult", params);
    }

    /**
     * 自助核销
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public DaodianTicketUseOpenApiResult selfUse(DaodianTicketUseOpenApiRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponFulfill.self.use", params);
    }

    /**
     * 到店发券回调
     *
     * @param request 请求
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public DaodianTicketSendFinishOpenApiResult sendFinish(DaodianTicketSendFinishOpenApiRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponFulfill.sendFinish", params);
    }

    /**
     * 用户可用券查询
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public DaodianTicketSelfConsultOpenApiResult selfConsult(DaodianTicketSelfConsultOpenApiRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponFulfill.self.consult", params);
    }
}
