package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.couponProduct.*;
import eleme.openapi.sdk.api.enumeration.couponProduct.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 到店商品服务
 */
@Service("eleme.couponProduct")
public class CouponProductService extends BaseNopService {
    public CouponProductService(Config config,Token token) {
        super(config, token, CouponProductService.class);
    }

    /**
     * DD商品分页查询接口
     *
     * @param request 根据门店ID查询被关联的券商品
     * @return 团券列表数据
     * @throws ServiceException 服务异常
     */
    public OCouponItemQueryResponse queryCouponItemByPage(ORelatedCouponItemQueryRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.couponProduct.queryCouponItemByPage", params);
    }
}
