package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.openShop.*;
import eleme.openapi.sdk.api.enumeration.openShop.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 开店服务
 */
@Service("eleme.openShop")
public class OpenShopService extends BaseNopService {
    public OpenShopService(Config config,Token token) {
        super(config, token, OpenShopService.class);
    }

    /**
     * 获取所有餐饮频道的类目信息
     *
     * @return 类目信息
     * @throws ServiceException 服务异常
     */
    public List<CategoryInfoVO> getAllCateringCategory() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.openShop.getAllCateringCategory", params);
    }

    /**
     * 获取所有行政区划信息
     *
     * @return 所有的行政区划信息
     * @throws ServiceException 服务异常
     */
    public List<DivisionInfoVO> getAllDivisionInfo() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.openShop.getAllDivisionInfo", params);
    }

    /**
     * 资质证照类文件上传
     *
     * @param request 请求参数
     * @return 上传结果
     * @throws ServiceException 服务异常
     */
    public UploadFileResponse uploadFile(UploadFileRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.openShop.uploadFile", params);
    }

    /**
     * 保存草稿
     *
     * @param request 请求参数
     * @return 保存草稿结果
     * @throws ServiceException 服务异常
     */
    public SaveDraftResponse saveDraft(SaveDraftRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.openShop.saveDraft", params);
    }

    /**
     * 查询草稿
     *
     * @param request 请求参数
     * @return 查询草稿结果
     * @throws ServiceException 服务异常
     */
    public GetDraftResponse getDraft(GetDraftRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.openShop.getDraft", params);
    }

    /**
     * 开店申请预校验
     *
     * @param request 请求参数
     * @return 开店申请预校验结果
     * @throws ServiceException 服务异常
     */
    public PreCheckResponse preCheck(PreCheckRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.openShop.preCheck", params);
    }

    /**
     * 提交开店申请
     *
     * @param request 请求参数
     * @return 提交开店申请结果
     * @throws ServiceException 服务异常
     */
    public SubmitResponse submit(SubmitRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.openShop.submit", params);
    }

    /**
     * 查询开店申请
     *
     * @param request 请求参数
     * @return 查询开店申请结果
     * @throws ServiceException 服务异常
     */
    public GetDetailByApplyIdResponse getDetailByApplyId(GetDetailByApplyIdRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.openShop.getDetailByApplyId", params);
    }

    /**
     * 创建开店申请
     *
     * @param request 请求参数
     * @return 创建开店申请结果
     * @throws ServiceException 服务异常
     */
    public CreateResponse create(CreateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.openShop.create", params);
    }
}
