package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.phoneVerify.*;
import eleme.openapi.sdk.api.enumeration.phoneVerify.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * eleme.phoneVerify
 */
@Service("eleme.phoneVerify")
public class PhoneVerifyService extends BaseNopService {
    public PhoneVerifyService(Config config,Token token) {
        super(config, token, PhoneVerifyService.class);
    }

    /**
     * 证件图片上传
     *
     * @param request $fieldStruct.fieldComments
     * @return 错误消息
     * @throws ServiceException 服务异常
     */
    public String uploadIdCard(eleme.openapi.sdk.api.entity.phoneVerify.upload.PhoneRealNameFileUploadRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.phoneVerify.uploadIdCard", params);
    }

    /**
     * 实名认证结果查询
     *
     * @param request $fieldStruct.fieldComments
     * @return 错误消息
     * @throws ServiceException 服务异常
     */
    public String queryAuthResult(eleme.openapi.sdk.api.entity.phoneVerify.query.QueryPhoneRealNameRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.phoneVerify.queryAuthResult", params);
    }

    /**
     * 固话实名认证隐私号
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回码
     * @throws ServiceException 服务异常
     */
    public String authFixedPhone(eleme.openapi.sdk.api.entity.phoneVerify.realName.FixedPhoneRealNameInfoRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.phoneVerify.authFixedPhone", params);
    }

    /**
     * 手机号实名认证隐私号
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回码
     * @throws ServiceException 服务异常
     */
    public String authMobilePhone(eleme.openapi.sdk.api.entity.phoneVerify.realName.CellPhoneRealNameInfoRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.phoneVerify.authMobilePhone", params);
    }
}
