package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.pintuan.*;
import eleme.openapi.sdk.api.enumeration.pintuan.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 拼团服务
 */
@Service("eleme.pintuan")
public class PintuanService extends BaseNopService {
    public PintuanService(Config config,Token token) {
        super(config, token, PintuanService.class);
    }

    /**
     * 批量查询店铺拼团商品
     *
     * @param shopId 店铺ID
     * @return 拼团商品
     * @throws ServiceException 服务异常
     */
    public List<PinItem> getAllPinItems(Long shopId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return call("eleme.pintuan.getAllPinItems", params);
    }

    /**
     * 创建拼团商品映射，更新商品ext_code字段
     *
     * @param request 拼团商品映射信息
     * @return 操作结果
     * @throws ServiceException 服务异常
     */
    public PinItemOperationResult updatePinItemMapping(UpdatePinItemMappingRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.pintuan.updatePinItemMapping", params);
    }

    /**
     * 查询单个拼团商品明细
     *
     * @param request 查询单个拼团商品的入参
     * @return 拼团商品
     * @throws ServiceException 服务异常
     */
    public PinItem querySinglePinItem(SinglePinItemRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.pintuan.querySinglePinItem", params);
    }

    /**
     * 操作拼团商品的上下架
     *
     * @param request 拼团商品上下架请求的入参
     * @return 操作结果
     * @throws ServiceException 服务异常
     */
    public PinItemOperationResult updatePinItemOnShelf(UpdatePinItemOnShelfRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.pintuan.updatePinItemOnShelf", params);
    }

    /**
     * 修改拼团商品的库存
     *
     * @param request 库存信息
     * @return 操作结果
     * @throws ServiceException 服务异常
     */
    public PinItemOperationResult updatePinItemStock(UpdatePinItemStockRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.pintuan.updatePinItemStock", params);
    }
}
