package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.sms.*;
import eleme.openapi.sdk.api.enumeration.sms.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 短信服务
 */
@Service("eleme.sms")
public class SmsService extends BaseNopService {
    public SmsService(Config config,Token token) {
        super(config, token, SmsService.class);
    }

    /**
     * 根据订单号发送短信
     *
     * @param request 短信发送请求
     * @return 短信发送结果
     * @throws ServiceException 服务异常
     */
    public SmsResponse sendMessage(SmsRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.sms.sendMessage", params);
    }

    /**
     * 根据手机号发送短信
     *
     * @param request 短信发送请求
     * @return 短信发送结果
     * @throws ServiceException 服务异常
     */
    public SmsResponse sendMessageByPhone(SmsPhoneRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.sms.sendMessageByPhone", params);
    }

    /**
     * 查询短信发送结果
     *
     * @param taskIds 短信发送taskId列表,一次最多20个
     * @return 短信发送结果
     * @throws ServiceException 服务异常
     */
    public List<SmsSendResult> querySendResult(List<String> taskIds) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("taskIds", taskIds);
        return call("eleme.sms.querySendResult", params);
    }

    /**
     * 根据订单号发送短信（蜂鸟服务商专用）
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public SmsResponse sendMessage4FN(SmsRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.sms.sendMessage4FN", params);
    }
}
