package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.ticket.*;
import eleme.openapi.sdk.api.enumeration.ticket.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 小票服务
 */
@Service("eleme.ticket")
public class TicketService extends BaseNopService {
    public TicketService(Config config,Token token) {
        super(config, token, TicketService.class);
    }

    /**
     * 创建小票设置页面token
     *
     * @param ticketTokenRequest 创建小票token信息
     * @return  生成的token信息
     * @throws ServiceException 服务异常
     */
    public TicketTokenResponse createTicketToken(TicketTokenRequest ticketTokenRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("ticketTokenRequest", ticketTokenRequest);
        return call("eleme.ticket.createTicketToken", params);
    }

    /**
     * 根据店铺id获取店铺小票打印联配置数据
     *
     * @param shopId 店铺ID
     * @return 打印联设置信息
     * @throws ServiceException 服务异常
     */
    public List<PrintConfigView> queryPrintSettings(Long shopId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return call("eleme.ticket.queryPrintSettings", params);
    }

    /**
     * 根据店铺id修改店铺小票打印联配置数据
     *
     * @param request 打印联设置
     * @return 打印联更新结果
     * @throws ServiceException 服务异常
     */
    public Boolean updatePrintSettings(UpdatePrintSettingsRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ticket.updatePrintSettings", params);
    }

    /**
     * 打印测试小票
     *
     * @param shopId 店铺ID
     * @param ticketType 打印联信息
     * @return 测试打印信息
     * @throws ServiceException 服务异常
     */
    public List<TicketContentView> getTestTicketData(Long shopId, List<String> ticketType) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("ticketType", ticketType);
        return call("eleme.ticket.getTestTicketData", params);
    }

    /**
     * 小票补打接口
     *
     * @param request 小票补打信息
     * @return 小票补打信息
     * @throws ServiceException 服务异常
     */
    public List<TicketContentView> getTicketDataForPull(TicketDataForPullRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.ticket.getTicketDataForPull", params);
    }
}
