package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.userAuth.*;
import eleme.openapi.sdk.api.enumeration.userAuth.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * C端用户授权服务
 */
@Service("eleme.userAuth")
public class UserAuthService extends BaseNopService {
    public UserAuthService(Config config,Token token) {
        super(config, token, UserAuthService.class);
    }

    /**
     * C端授权发送短信验证码
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public SmsAuthSendCodeResultResponse smsSend(SmsAuthSendCodeRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.userAuth.smsSend", params);
    }

    /**
     * 商家维度查询授权场景码
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public QuerySceneCodeResponse merchantQuerySceneCode(MerchantQuerySceneRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.userAuth.merchantQuerySceneCode", params);
    }

    /**
     * 商户维度申请创建场景码
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public ApplySceneCodeResponse merchantApplySceneCode(MerchantApplySceneRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.userAuth.merchantApplySceneCode", params);
    }

    /**
     * 校验短信并获取授权令牌
     *
     * @param request $fieldStruct.fieldComments
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public SmsAuthValidateCodeResponse validateCode(SmsAuthValidateCodeRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.userAuth.validateCode", params);
    }
}
