package eleme.openapi.sdk.efs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.*;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.internal.SkipMd5CheckStrategy;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import eleme.openapi.sdk.api.entity.content.OEfsConfig;
import eleme.openapi.sdk.api.exception.ServiceException;

import java.io.File;
import java.util.Properties;

public class EfsClient {

    private AmazonS3 s3client;

    private AWSCredentialsProvider credentialsProvider;

    private OEfsConfig efsConfig;

    public EfsClient(OEfsConfig efsConfig) {
        this.efsConfig = efsConfig;
    }

    public void init() {
        String accessId = efsConfig.getCredentials().getAccessKeyId();
        String secretKey = efsConfig.getCredentials().getSecretAccessKey();
        String token = efsConfig.getCredentials().getSessionToken();

        Properties properties = System.getProperties();
        properties.setProperty(SkipMd5CheckStrategy.DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY, "true");
        AWSCredentials credentials = new BasicSessionCredentials(accessId, secretKey, token);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setSignerOverride("AWSS3V4SignerType");
        credentialsProvider = new AWSStaticCredentialsProvider(credentials);
        s3client =  AmazonS3ClientBuilder
                .standard()
                .withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(efsConfig.getEfsAddress(), "eleme"))
                .withPathStyleAccessEnabled(true)
                .withClientConfiguration(clientConfiguration)
                .withCredentials(credentialsProvider)
                .build();
    }

    public String putObject(File videoFile, String bucketName, String key) throws ServiceException {
        try{
            PutObjectResult result = s3client.putObject(new PutObjectRequest(bucketName, key, videoFile));
            return result.getVersionId();
        }catch (AmazonServiceException ase) {
            throw new ServiceException("SERVER_ERROR", ase.getMessage());
        }catch(AmazonClientException ace) {
            throw new ServiceException("CLIENT_ERROR", ace.getMessage());
        }
    }
}
