package eleme.openapi.sdk.media.trace;


import eleme.openapi.sdk.utils.JacksonUtils;

import java.util.HashMap;
import java.util.Map;

import static eleme.openapi.sdk.media.upload.impl.StringUtils.isNotEmpty;

/**
 * Created by huamulou on 15/12/18.
 */
public class ReportStore {
    public Map<Reporter.ReportFactor, String> factorValues;
    public Map<String, String> argsValues;
    public static String SPILITER = "|";
    public static String NEWLINE = "\n|\r";


    public ReportStore() {
        this.factorValues = new HashMap<Reporter.ReportFactor, String>();
        this.argsValues = new HashMap<String, String>();
    }

    public Map<Reporter.ReportFactor, String> getFactorValues() {
        return factorValues;
    }

    public void setFactorValues(Map<Reporter.ReportFactor, String> factorValues) {
        this.factorValues = factorValues;
    }

    public Map<String, String> getArgsValues() {
        return argsValues;
    }

    public void setArgsValues(Map<String, String> argsValues) {
        this.argsValues = argsValues;
    }

    public void addFactor(Reporter.ReportFactor factor, String value) {
        if (factor != null && isNotEmpty(value))
            factorValues.put(factor, value);
    }

    public String filterValue(String arg) {
        return arg.replaceAll(SPILITER, "").replaceAll(NEWLINE, "");
    }

    public void addFactor(Reporter.ReportFactor factor, Object value) {
        if (factor != null && value != null)
            factorValues.put(factor, (String.valueOf(value)));
    }

    public void addArgs(String key, String value) {
        if (isNotEmpty(key) && isNotEmpty(value))
            argsValues.put(key, value);
    }


    public void addArgs(Reporter.ArgsFactor argsFactor, String value) {
        if (argsFactor != null && isNotEmpty(value))
            argsValues.put(argsFactor.desc, value);
    }

    public void addArgs(Reporter.ArgsFactor argsFactor, Object value) {
        if (argsFactor != null && value != null)
            argsValues.put(argsFactor.desc, String.valueOf(value));
    }


    public void addArgs(String argsFactor, Object value) {
        if (argsFactor != null && value != null)
            argsValues.put(argsFactor, String.valueOf(value));
    }


    public String getReport() {

        String argsSeg = JacksonUtils.obj2json(argsValues);
        argsSeg = argsSeg == null ? "" : filterValue(argsSeg);

        StringBuilder firstSeg = new StringBuilder("");

        String[] values = new String[Reporter.ReportFactor.values().length];

        for (int i = 0; i < values.length; i++) {
            Reporter.ReportFactor factorCur = Reporter.ReportFactor.values()[i];
            if (factorCur.equals(Reporter.ReportFactor.ARGS)) {
                firstSeg.append(argsSeg);
                continue;
            }
            String value = factorValues.get(Reporter.ReportFactor.values()[i]);
            value = value == null ? "" : value;
            firstSeg.append(filterValue(value)).append(SPILITER);
        }
        return firstSeg.toString();
    }


}
