package eleme.openapi.sdk.media.upload;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * upload request
 * 
 * @author jinli Feb 5, 2015
 */
public class UploadRequest extends BaseUploadRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    private String dir;                                                 // media file dir
    private String name;                                                // media file name
    private String md5;                                                 // md5 of file content
    private File file;                                                  // media file body
    private InputStream inputStream;                                    // media file input stream
    private long inputLength;                                           // media file input length
    private Map<String, String> metas = new HashMap<String, String>();  // media file metadata, used by magic vars, be persisted
    private Map<String, String> vars = new HashMap<String, String>();   // custom vars, used by magic vars, not be persisted
    private Map<String, Object> extendPars = new HashMap<String, Object>();   // custom extend parameters, set in http body, not be persisted

    public UploadRequest() {
    }

    public UploadRequest(String token) {
        super(token);
    }

    public UploadRequest(UploadPolicy uploadPolicy) {
        super(uploadPolicy);
    }

    public String getDir() {
        return dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public long getInputLength() {
        return inputLength;
    }

    public void setInputStream(InputStream inputStream, long inputLength) {
        this.inputStream = inputStream;
        this.inputLength = inputLength;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public Map<String, String> getMetas() {
        return metas;
    }

    public void setMetas(Map<String, String> metas) {
        this.metas = metas;
    }

    public Map<String, String> getVars() {
        return vars;
    }

    public void setVars(Map<String, String> vars) {
        this.vars = vars;
    }

    public Map<String, Object> getExtendPars() {
        return extendPars;
    }

    public void setExtendPars(Map<String, Object> extendPars) {
        this.extendPars = extendPars;
    }

    public void addMeta(String name, String value) {
        if (getMetas() == null) {
            setMetas(new HashMap<String, String>());
        }
        getMetas().put(name, value);
    }

    public void addVar(String name, String value) {
        if (getVars() == null) {
            setVars(new HashMap<String, String>());
        }
        getVars().put(name, value);
    }

}
