/*
 * Decompiled with CFR 0.152.
 */
package me.elgregos.eventsk.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.r2dbc.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.elgregos.eventsk.config.JsonNodeToJsonConverter;
import me.elgregos.eventsk.config.JsonToJsonNodeConverter;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.r2dbc.config.AbstractR2dbcConfiguration;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;

@Configuration
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lme/elgregos/eventsk/config/R2dbcPostgresConfig;", "Lorg/springframework/data/r2dbc/config/AbstractR2dbcConfiguration;", "connectionFactory", "Lio/r2dbc/spi/ConnectionFactory;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lio/r2dbc/spi/ConnectionFactory;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getConnectionFactory", "()Lio/r2dbc/spi/ConnectionFactory;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "r2dbcCustomConversions", "Lorg/springframework/data/r2dbc/convert/R2dbcCustomConversions;", "events-k"})
public class R2dbcPostgresConfig
extends AbstractR2dbcConfiguration {
    @NotNull
    private final ConnectionFactory connectionFactory;
    @NotNull
    private final ObjectMapper objectMapper;

    public R2dbcPostgresConfig(@NotNull ConnectionFactory connectionFactory, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.connectionFactory = connectionFactory;
        this.objectMapper = objectMapper;
    }

    @NotNull
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public ConnectionFactory connectionFactory() {
        return this.getConnectionFactory();
    }

    @Bean
    @NotNull
    public R2dbcCustomConversions r2dbcCustomConversions() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add(new JsonNodeToJsonConverter());
        converters.add(new JsonToJsonNodeConverter(this.getObjectMapper()));
        return new R2dbcCustomConversions(this.getStoreConversions(), (Collection)converters);
    }
}

