/*
 * Decompiled with CFR 0.152.
 */
package me.elgregos.eventsk.infrastructure;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.elgregos.eventsk.domain.Event;
import me.elgregos.eventsk.infrastructure.EventBus;
import me.elgregos.eventsk.infrastructure.ReactorEventBusKt;
import me.elgregos.eventsk.infrastructure.ReactorEventSubscriber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/elgregos/eventsk/infrastructure/ReactorEventBus;", "IdType", "Lme/elgregos/eventsk/infrastructure/EventBus;", "()V", "publishedCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "sink", "Lreactor/core/publisher/Sinks$Many;", "Lme/elgregos/eventsk/domain/Event;", "publishEvent", "event", "subscribe", "", "subscriber", "Lme/elgregos/eventsk/infrastructure/ReactorEventSubscriber;", "events-k"})
public final class ReactorEventBus<IdType>
implements EventBus<IdType> {
    @NotNull
    private final Sinks.Many<Event<IdType>> sink;
    @NotNull
    private final AtomicInteger publishedCount;

    public ReactorEventBus() {
        Sinks.Many many = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"many().multicast().onBac\u2026SMALL_BUFFER_SIZE, false)");
        this.sink = many;
        this.publishedCount = new AtomicInteger(0);
    }

    @Override
    @NotNull
    public Event<IdType> publishEvent(@NotNull Event<IdType> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.sink.emitNext(event, Sinks.EmitFailureHandler.FAIL_FAST);
        ReactorEventBusKt.access$getLogger$p().debug((Function0)new Function0<Object>(this){
            final /* synthetic */ ReactorEventBus<IdType> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Published : " + ReactorEventBus.access$getPublishedCount$p(this.this$0).addAndGet(1);
            }
        });
        return event;
    }

    public final void subscribe(@NotNull ReactorEventSubscriber<IdType> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        this.sink.asFlux().subscribe((CoreSubscriber)subscriber);
    }

    public static final /* synthetic */ AtomicInteger access$getPublishedCount$p(ReactorEventBus $this) {
        return $this.publishedCount;
    }
}

