/*
 * Decompiled with CFR 0.152.
 */
package me.escoffier.certs.junit5;

import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.escoffier.certs.AliasRequest;
import me.escoffier.certs.CertificateFiles;
import me.escoffier.certs.CertificateGenerator;
import me.escoffier.certs.CertificateRequest;
import me.escoffier.certs.junit5.Alias;
import me.escoffier.certs.junit5.Certificate;
import me.escoffier.certs.junit5.Certificates;
import me.escoffier.certs.junit5.CertificatesSource;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;

public class CertificateGenerationExtension
implements BeforeAllCallback,
ParameterResolver {
    List<CertificateFiles> certificateFiles = new ArrayList<CertificateFiles>();

    public static CertificateGenerationExtension getInstance(ExtensionContext extensionContext) {
        return (CertificateGenerationExtension)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get(CertificateGenerationExtension.class, CertificateGenerationExtension.class);
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).getOrComputeIfAbsent(CertificateGenerationExtension.class, c -> this);
        Optional maybe = AnnotationUtils.findAnnotation((AnnotatedElement)extensionContext.getRequiredTestClass(), Certificates.class);
        if (maybe.isEmpty()) {
            return;
        }
        Certificates annotation = (Certificates)maybe.get();
        for (Certificate certificate : annotation.certificates()) {
            String baseDir = annotation.baseDir();
            File file = new File(baseDir);
            file.mkdirs();
            CertificateGenerator generator = new CertificateGenerator(file.toPath(), annotation.replaceIfExists());
            CertificateRequest request = new CertificateRequest().withName(certificate.name()).withClientCertificate(certificate.client()).withFormats(Arrays.asList(certificate.formats())).withCN(certificate.cn()).withPassword(certificate.password().isEmpty() ? null : certificate.password()).withDuration(Duration.ofDays(certificate.duration()));
            for (String san : certificate.subjectAlternativeNames()) {
                request.withSubjectAlternativeName(san);
            }
            for (Alias alias : certificate.aliases()) {
                AliasRequest nested = new AliasRequest().withCN(alias.cn()).withPassword(alias.password()).withClientCertificate(alias.client());
                request.withAlias(alias.name(), nested);
                for (String s : alias.subjectAlternativeNames()) {
                    nested.withSubjectAlternativeName(s);
                }
            }
            this.certificateFiles.addAll(generator.generate(request));
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (extensionContext.getRequiredTestMethod().isAnnotationPresent(CertificatesSource.class)) {
            return false;
        }
        Type type = parameterContext.getParameter().getParameterizedType();
        if (type instanceof ParameterizedType) {
            ParameterizedType type2 = (ParameterizedType)type;
            if (((Class)type2.getRawType()).isAssignableFrom(List.class)) {
                Type argument = type2.getActualTypeArguments()[0];
                return CertificateFiles.class.isAssignableFrom((Class)argument);
            }
            return false;
        }
        return CertificateFiles.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Type type = parameterContext.getParameter().getParameterizedType();
        if (type instanceof ParameterizedType) {
            ParameterizedType type2 = (ParameterizedType)type;
            if (((Class)type2.getRawType()).isAssignableFrom(List.class)) {
                Type argument = type2.getActualTypeArguments()[0];
                return this.certificateFiles.stream().filter(f -> ((Class)argument).isAssignableFrom(f.getClass())).collect(Collectors.toList());
            }
            return null;
        }
        return this.certificateFiles.stream().filter(f -> parameterContext.getParameter().getType().isAssignableFrom(f.getClass())).findFirst().orElse(null);
    }
}

