/*
 * Decompiled with CFR 0.152.
 */
package me.escoffier.loom.loomunit;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingStream;
import me.escoffier.loom.loomunit.InternalEvents;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Collector
implements Consumer<RecordedEvent> {
    public static final String CARRIER_PINNED_EVENT_NAME = "jdk.VirtualThreadPinned";
    private static final Logger LOGGER = Logger.getLogger(Collector.class.getName());
    private final List<Function<RecordedEvent, Boolean>> observers = new CopyOnWriteArrayList<Function<RecordedEvent, Boolean>>();
    private final List<RecordedEvent> events = new CopyOnWriteArrayList<RecordedEvent>();
    private final RecordingStream stream;
    volatile State state = State.INIT;

    public Collector() {
        LOGGER.log(Level.FINE, "Creating collector");
        try {
            this.stream = new RecordingStream();
            this.stream.enable(CARRIER_PINNED_EVENT_NAME).withStackTrace();
            this.stream.enable(InternalEvents.InitializationEvent.class).withoutStackTrace();
            this.stream.enable(InternalEvents.ShutdownEvent.class).withoutStackTrace();
            this.stream.enable(InternalEvents.CapturingStartedEvent.class).withoutStackTrace();
            this.stream.enable(InternalEvents.CapturingStoppedEvent.class).withoutStackTrace();
            this.stream.setMaxSize(100L);
            this.stream.setReuse(true);
            this.stream.setOrdered(true);
            this.stream.onEvent(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init() throws InterruptedException {
        long begin = System.nanoTime();
        CountDownLatch latch = new CountDownLatch(1);
        this.observers.add(re -> {
            if (re.getEventType().getName().equals("me.escoffier.loom.loomunit.InternalEvents.InitializationEvent")) {
                latch.countDown();
                return true;
            }
            return false;
        });
        this.stream.startAsync();
        new InternalEvents.InitializationEvent().commit();
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Unable to start JFR collection, RecordingStartedEvent event not received after 10s");
        }
        long end = System.nanoTime();
        this.state = State.STARTED;
        LOGGER.log(Level.FINE, "Event collection started in {0}s", (end - begin) / 1000000L);
    }

    public void start(ExtensionContext context) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        String id = context.getUniqueId();
        long begin = System.nanoTime();
        this.observers.add(re -> {
            if (re.getEventType().getName().equals("me.escoffier.loom.loomunit.InternalEvents.CapturingStartedEvent") && id.equals(re.getString("id"))) {
                this.events.clear();
                this.state = State.COLLECTING;
                latch.countDown();
                return true;
            }
            return false;
        });
        new InternalEvents.CapturingStartedEvent(id).commit();
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Unable to start JFR collection, START_EVENT event not received after 10s");
        }
        long end = System.nanoTime();
        LOGGER.log(Level.FINE, "Event capturing started in {0}s", (end - begin) / 1000000L);
    }

    public List<RecordedEvent> stop(ExtensionContext context) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        String id = context.getUniqueId();
        long begin = System.nanoTime();
        this.observers.add(re -> {
            if (re.getEventType().getName().equals("me.escoffier.loom.loomunit.InternalEvents.CapturingStoppedEvent")) {
                this.state = State.STARTED;
                latch.countDown();
                return true;
            }
            return false;
        });
        new InternalEvents.CapturingStoppedEvent(id).commit();
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Unable to start JFR collection, STOP_EVENT event not received after 10s");
        }
        long end = System.nanoTime();
        LOGGER.log(Level.FINE, "Event collection stopped in {0}s", (end - begin) / 1000000L);
        return new ArrayList<RecordedEvent>(this.events);
    }

    public void shutdown() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        long begin = System.nanoTime();
        this.observers.add(re -> {
            if (re.getEventType().getName().equals("me.escoffier.loom.loomunit.InternalEvents.ShutdownEvent")) {
                latch.countDown();
                return true;
            }
            return false;
        });
        InternalEvents.ShutdownEvent event = new InternalEvents.ShutdownEvent();
        event.commit();
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Unable to stop JFR collection, RecordingStoppedEvent event not received at 10s");
        }
        this.state = State.INIT;
        long end = System.nanoTime();
        LOGGER.log(Level.FINE, "Event collector shutdown in {0}s", (end - begin) / 1000000L);
        this.stream.stop();
    }

    @Override
    public void accept(RecordedEvent re) {
        if (this.state == State.COLLECTING) {
            this.events.add(re);
        }
        ArrayList toBeRemoved = new ArrayList();
        this.observers.forEach(c -> {
            if (((Boolean)c.apply(re)).booleanValue()) {
                toBeRemoved.add(c);
            }
        });
        this.observers.removeAll(toBeRemoved);
    }

    public List<RecordedEvent> getEvents() {
        return new ArrayList<RecordedEvent>(this.events);
    }

    static enum State {
        INIT,
        STARTED,
        COLLECTING;

    }
}

