/*
 * Decompiled with CFR 0.152.
 */
package me.escoffier.vertx.completablefuture;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class VertxCompletableFuture<T>
extends CompletableFuture<T>
implements CompletionStage<T> {
    private final Executor executor;
    private final Context context;

    public VertxCompletableFuture(Vertx vertx) {
        this(Objects.requireNonNull(vertx).getOrCreateContext());
    }

    public VertxCompletableFuture(Context context) {
        this.context = Objects.requireNonNull(context);
        this.executor = command -> context.runOnContext(v -> command.run());
    }

    private VertxCompletableFuture(Context context, CompletableFuture<T> future) {
        this(context);
        Objects.requireNonNull(future).whenComplete((T res, U err) -> {
            if (err != null) {
                this.completeExceptionally((Throwable)err);
            } else {
                this.complete(res);
            }
        });
    }

    public VertxCompletableFuture() {
        this(Vertx.currentContext());
    }

    public static <T> VertxCompletableFuture<T> from(Vertx vertx, CompletableFuture<T> future) {
        return VertxCompletableFuture.from(vertx.getOrCreateContext(), future);
    }

    public static <T> VertxCompletableFuture<T> from(Vertx vertx, Future<T> future) {
        return VertxCompletableFuture.from(vertx.getOrCreateContext(), future);
    }

    public static <T> VertxCompletableFuture<T> from(Context context, CompletableFuture<T> future) {
        VertxCompletableFuture res = new VertxCompletableFuture(Objects.requireNonNull(context));
        Objects.requireNonNull(future).whenComplete((T result, U error) -> {
            if (context == Vertx.currentContext()) {
                res.complete((Object)result, (Throwable)error);
            } else {
                res.context.runOnContext(v -> res.complete((Object)result, (Throwable)error));
            }
        });
        return res;
    }

    public static <T> VertxCompletableFuture<T> from(Context context, Future<T> future) {
        VertxCompletableFuture res = new VertxCompletableFuture(Objects.requireNonNull(context));
        Objects.requireNonNull(future).setHandler(ar -> {
            if (context == Vertx.currentContext()) {
                res.completeFromAsyncResult((AsyncResult)ar);
            } else {
                res.context.runOnContext(v -> res.completeFromAsyncResult((AsyncResult)ar));
            }
        });
        return res;
    }

    public static <T> VertxCompletableFuture<T> supplyAsync(Vertx vertx, Supplier<T> supplier) {
        return VertxCompletableFuture.supplyAsync(Objects.requireNonNull(vertx).getOrCreateContext(), supplier);
    }

    public static VertxCompletableFuture<Void> runAsync(Vertx vertx, Runnable runnable) {
        return VertxCompletableFuture.runAsync(Objects.requireNonNull(vertx).getOrCreateContext(), runnable);
    }

    public static <T> VertxCompletableFuture<T> supplyAsync(Context context, Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        VertxCompletableFuture future = new VertxCompletableFuture(Objects.requireNonNull(context));
        context.runOnContext(v -> {
            try {
                future.complete(supplier.get());
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static VertxCompletableFuture<Void> runAsync(Context context, Runnable runnable) {
        Objects.requireNonNull(runnable);
        VertxCompletableFuture<Void> future = new VertxCompletableFuture<Void>(context);
        context.runOnContext(v -> {
            try {
                runnable.run();
                future.complete(null);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static <T> VertxCompletableFuture<T> supplyBlockingAsync(Vertx vertx, Supplier<T> supplier) {
        return VertxCompletableFuture.supplyBlockingAsync(Objects.requireNonNull(vertx).getOrCreateContext(), supplier);
    }

    public static VertxCompletableFuture<Void> runBlockingAsync(Vertx vertx, Runnable runnable) {
        return VertxCompletableFuture.runBlockingAsync(Objects.requireNonNull(vertx).getOrCreateContext(), runnable);
    }

    public static VertxCompletableFuture<Void> runBlockingAsync(Context context, Runnable runnable) {
        Objects.requireNonNull(runnable);
        VertxCompletableFuture<Void> future = new VertxCompletableFuture<Void>(Objects.requireNonNull(context));
        context.executeBlocking(fut -> {
            try {
                runnable.run();
                future.complete(null);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        }, null);
        return future;
    }

    public static <T> VertxCompletableFuture<T> supplyBlockingAsync(Context context, Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        VertxCompletableFuture future = new VertxCompletableFuture(context);
        context.executeBlocking(fut -> {
            try {
                fut.complete(supplier.get());
            }
            catch (Throwable e) {
                fut.fail(e);
            }
        }, ar -> {
            if (ar.failed()) {
                future.completeExceptionally(ar.cause());
            } else {
                future.complete(ar.result());
            }
        });
        return future;
    }

    public static <T> Future<T> toFuture(CompletableFuture<T> future) {
        Future fut = Future.future();
        Objects.requireNonNull(future).whenComplete((T res, U err) -> {
            if (err != null) {
                fut.fail(err);
            } else {
                fut.complete(res);
            }
        });
        return fut;
    }

    public static VertxCompletableFuture<Void> allOf(Vertx vertx, CompletableFuture<?> ... futures) {
        CompletableFuture<Void> all = CompletableFuture.allOf(futures);
        return VertxCompletableFuture.from(vertx, all);
    }

    public static VertxCompletableFuture<Void> allOf(Context context, CompletableFuture<?> ... futures) {
        CompletableFuture<Void> all = CompletableFuture.allOf(futures);
        return VertxCompletableFuture.from(context, all);
    }

    public static VertxCompletableFuture<Object> anyOf(Vertx vertx, CompletableFuture<?> ... futures) {
        CompletableFuture<Object> all = CompletableFuture.anyOf(futures);
        return VertxCompletableFuture.from(vertx, all);
    }

    public static VertxCompletableFuture<Object> anyOf(Context context, CompletableFuture<?> ... futures) {
        CompletableFuture<Object> all = CompletableFuture.anyOf(futures);
        return VertxCompletableFuture.from(context, all);
    }

    public VertxCompletableFuture<T> withContext() {
        Context context = Objects.requireNonNull(Vertx.currentContext());
        return this.withContext(context);
    }

    public VertxCompletableFuture<T> withContext(Vertx vertx) {
        return this.withContext(Objects.requireNonNull(vertx).getOrCreateContext());
    }

    public VertxCompletableFuture<T> withContext(Context context) {
        VertxCompletableFuture future = new VertxCompletableFuture(Objects.requireNonNull(context));
        this.whenComplete((T res, U err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                future.complete(res);
            }
        });
        return future;
    }

    public Context context() {
        return this.context;
    }

    @Override
    public <U> VertxCompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return new VertxCompletableFuture<T>(this.context, super.thenApply((Function)fn));
    }

    @Override
    public <U> VertxCompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return new VertxCompletableFuture<T>(this.context, super.thenApplyAsync((Function)fn, executor));
    }

    public VertxCompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenAcceptAsync((Consumer)action, executor));
    }

    @Override
    public VertxCompletableFuture<Void> thenRun(Runnable action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenRun(action));
    }

    @Override
    public VertxCompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenRunAsync(action, executor));
    }

    @Override
    public <U, V> VertxCompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return new VertxCompletableFuture<T>(this.context, super.thenCombine((CompletionStage)other, (BiFunction)fn));
    }

    public <U> VertxCompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenAcceptBoth((CompletionStage)other, (BiConsumer)action));
    }

    public <U> VertxCompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, executor));
    }

    public VertxCompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.runAfterBoth((CompletionStage)other, action));
    }

    public VertxCompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> VertxCompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return new VertxCompletableFuture<T>(this.context, super.applyToEither((CompletionStage)other, (Function)fn));
    }

    @Override
    public <U> VertxCompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return new VertxCompletableFuture<T>(this.context, super.applyToEitherAsync((CompletionStage)other, (Function)fn, executor));
    }

    public VertxCompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public VertxCompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    public VertxCompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.runAfterEither((CompletionStage)other, action));
    }

    public VertxCompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> VertxCompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return new VertxCompletableFuture<T>(this.context, super.thenCompose((Function)fn));
    }

    @Override
    public VertxCompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return new VertxCompletableFuture<T>(this.context, super.whenComplete((BiConsumer)action));
    }

    @Override
    public VertxCompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return new VertxCompletableFuture<T>(this.context, super.whenCompleteAsync((BiConsumer)action, executor));
    }

    @Override
    public <U> VertxCompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return new VertxCompletableFuture<T>(this.context, super.handle((BiFunction)fn));
    }

    @Override
    public <U> VertxCompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return new VertxCompletableFuture<T>(this.context, super.handleAsync((BiFunction)fn, executor));
    }

    @Override
    public <U> VertxCompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return new VertxCompletableFuture<T>(this.context, super.thenApplyAsync((Function)fn, this.executor));
    }

    public VertxCompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenAccept((Consumer)action));
    }

    public VertxCompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenAcceptAsync((Consumer)action, this.executor));
    }

    @Override
    public VertxCompletableFuture<Void> thenRunAsync(Runnable action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenRunAsync(action, this.executor));
    }

    @Override
    public <U, V> VertxCompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return new VertxCompletableFuture<T>(this.context, super.thenCombineAsync((CompletionStage)other, (BiFunction)fn, this.executor));
    }

    public <U> VertxCompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, this.executor));
    }

    public VertxCompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.runAfterBothAsync((CompletionStage)other, action, this.executor));
    }

    @Override
    public <U> VertxCompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return new VertxCompletableFuture<T>(this.context, super.applyToEitherAsync((CompletionStage)other, (Function)fn, this.executor));
    }

    public VertxCompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.acceptEitherAsync((CompletionStage)other, (Consumer)action, this.executor));
    }

    public VertxCompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return new VertxCompletableFuture<Void>(this.context, (CompletableFuture<Void>)super.runAfterEitherAsync((CompletionStage)other, action, this.executor));
    }

    @Override
    public <U> VertxCompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return new VertxCompletableFuture<T>(this.context, super.thenComposeAsync((Function)fn, this.executor));
    }

    @Override
    public <U> VertxCompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return new VertxCompletableFuture<T>(this.context, super.thenComposeAsync((Function)fn, executor));
    }

    @Override
    public <U, V> VertxCompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return new VertxCompletableFuture<T>(this.context, super.thenCombineAsync((CompletionStage)other, (BiFunction)fn, executor));
    }

    @Override
    public VertxCompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return new VertxCompletableFuture<T>(this.context, super.whenCompleteAsync((BiConsumer)action, this.executor));
    }

    @Override
    public <U> VertxCompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return new VertxCompletableFuture<T>(this.context, super.handleAsync((BiFunction)fn, this.executor));
    }

    @Override
    public VertxCompletableFuture<T> toCompletableFuture() {
        return this;
    }

    public Future<T> toFuture() {
        return VertxCompletableFuture.toFuture(this);
    }

    private void complete(T result, Throwable error) {
        if (error == null) {
            super.complete(result);
        } else {
            super.completeExceptionally(error);
        }
    }

    private void completeFromAsyncResult(AsyncResult<T> ar) {
        if (ar.succeeded()) {
            super.complete(ar.result());
        } else {
            super.completeExceptionally(ar.cause());
        }
    }
}

