/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl;

import java.util.List;
import kotlin.jvm.functions.Function0;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.DeclarationDescriptorVisitor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ReceiverParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.LazyClassReceiverParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.LazySubstitutingClassDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.name.Name;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.InnerClassesScopeWrapper;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.MemberScope;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.SubstitutingScope;
import me.eugeniomarletti.kotlin.metadata.shadow.storage.NotNullLazyValue;
import me.eugeniomarletti.kotlin.metadata.shadow.storage.StorageManager;
import me.eugeniomarletti.kotlin.metadata.shadow.types.SimpleType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeConstructorSubstitution;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeProjection;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeSubstitution;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeSubstitutor;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractClassDescriptor
implements ClassDescriptor {
    private final Name name;
    protected final NotNullLazyValue<SimpleType> defaultType;
    private final NotNullLazyValue<MemberScope> unsubstitutedInnerClassesScope;
    private final NotNullLazyValue<ReceiverParameterDescriptor> thisAsReceiverParameter;

    public AbstractClassDescriptor(@NotNull StorageManager storageManager, @NotNull Name name) {
        this.name = name;
        this.defaultType = storageManager.createLazyValue(new Function0<SimpleType>(){

            public SimpleType invoke() {
                return TypeUtils.makeUnsubstitutedType(AbstractClassDescriptor.this, AbstractClassDescriptor.this.getUnsubstitutedMemberScope());
            }
        });
        this.unsubstitutedInnerClassesScope = storageManager.createLazyValue(new Function0<MemberScope>(){

            public MemberScope invoke() {
                return new InnerClassesScopeWrapper(AbstractClassDescriptor.this.getUnsubstitutedMemberScope());
            }
        });
        this.thisAsReceiverParameter = storageManager.createLazyValue(new Function0<ReceiverParameterDescriptor>(){

            public ReceiverParameterDescriptor invoke() {
                return new LazyClassReceiverParameterDescriptor(AbstractClassDescriptor.this);
            }
        });
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ClassDescriptor getOriginal() {
        return this;
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedInnerClassesScope() {
        return (MemberScope)this.unsubstitutedInnerClassesScope.invoke();
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        return (ReceiverParameterDescriptor)this.thisAsReceiverParameter.invoke();
    }

    @Override
    @NotNull
    public MemberScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
        assert (typeArguments.size() == this.getTypeConstructor().getParameters().size()) : "Illegal number of type arguments: expected " + this.getTypeConstructor().getParameters().size() + " but was " + typeArguments.size() + " for " + this.getTypeConstructor() + " " + this.getTypeConstructor().getParameters();
        if (typeArguments.isEmpty()) {
            return this.getUnsubstitutedMemberScope();
        }
        TypeSubstitutor substitutor = TypeConstructorSubstitution.create(this.getTypeConstructor(), typeArguments).buildSubstitutor();
        return new SubstitutingScope(this.getUnsubstitutedMemberScope(), substitutor);
    }

    @Override
    @NotNull
    public MemberScope getMemberScope(@NotNull TypeSubstitution typeSubstitution) {
        if (typeSubstitution.isEmpty()) {
            return this.getUnsubstitutedMemberScope();
        }
        TypeSubstitutor substitutor = TypeSubstitutor.create(typeSubstitution);
        return new SubstitutingScope(this.getUnsubstitutedMemberScope(), substitutor);
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor.isEmpty()) {
            return this;
        }
        return new LazySubstitutingClassDescriptor(this, substitutor);
    }

    @Override
    @NotNull
    public SimpleType getDefaultType() {
        return (SimpleType)this.defaultType.invoke();
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        visitor.visitClassDescriptor(this, null);
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitClassDescriptor(this, data);
    }
}

