/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassConstructorDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassKind;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.DeclarationDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.FunctionDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.Modality;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.SourceElement;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.TypeParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.Visibility;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.annotations.Annotations;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.ClassConstructorDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.ClassDescriptorBase;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.DeclarationDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.name.Name;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.MemberScope;
import me.eugeniomarletti.kotlin.metadata.shadow.storage.LockBasedStorageManager;
import me.eugeniomarletti.kotlin.metadata.shadow.types.ClassTypeConstructorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinTypeKt;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeConstructor;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableClassDescriptor
extends ClassDescriptorBase {
    private final ClassKind kind;
    private final boolean isInner;
    private Modality modality;
    private Visibility visibility;
    private TypeConstructor typeConstructor;
    private List<TypeParameterDescriptor> typeParameters;
    private final Collection<KotlinType> supertypes = new ArrayList<KotlinType>();

    public MutableClassDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull ClassKind kind, boolean isInner2, boolean isExternal, @NotNull Name name, @NotNull SourceElement source) {
        super(LockBasedStorageManager.NO_LOCKS, containingDeclaration, name, source, isExternal);
        assert (kind != ClassKind.OBJECT) : "Fix isCompanionObject()";
        this.kind = kind;
        this.isInner = isInner2;
    }

    @Override
    @Nullable
    public ClassDescriptor getCompanionObjectDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.Companion.getEMPTY();
    }

    public void setModality(@NotNull Modality modality) {
        assert (modality != Modality.SEALED) : "Implement getSealedSubclasses() for this class: " + this.getClass();
        this.modality = modality;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.kind;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public boolean isCompanionObject() {
        return false;
    }

    @Override
    public boolean isExpect() {
        return false;
    }

    @Override
    public boolean isActual() {
        return false;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    public void addSupertype(@NotNull KotlinType supertype) {
        assert (!KotlinTypeKt.isError(supertype)) : "Error types must be filtered out in DescriptorResolver";
        if (TypeUtils.getClassDescriptor(supertype) != null) {
            this.supertypes.add(supertype);
        }
    }

    @NotNull
    public Set<ClassConstructorDescriptor> getConstructors() {
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public ClassConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return null;
    }

    public void setTypeParameterDescriptors(@NotNull List<TypeParameterDescriptor> typeParameters) {
        if (this.typeParameters != null) {
            throw new IllegalStateException("Type parameters are already set for " + this.getName());
        }
        this.typeParameters = new ArrayList<TypeParameterDescriptor>(typeParameters);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        return this.typeParameters;
    }

    public void createTypeConstructor() {
        assert (this.typeConstructor == null) : this.typeConstructor;
        this.typeConstructor = new ClassTypeConstructorImpl(this, this.typeParameters, this.supertypes);
        for (FunctionDescriptor functionDescriptor : this.getConstructors()) {
            ((ClassConstructorDescriptorImpl)functionDescriptor).setReturnType(this.getDefaultType());
        }
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope() {
        return MemberScope.Empty.INSTANCE;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        return MemberScope.Empty.INSTANCE;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getSealedSubclasses() {
        return Collections.emptyList();
    }

    public String toString() {
        return DeclarationDescriptorImpl.toString(this);
    }
}

