/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.DeclarationDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.SourceElement;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.SupertypeLoopChecker;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.TypeParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.annotations.Annotations;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.AbstractTypeParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.name.Name;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.DescriptorUtils;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.descriptorUtil.DescriptorUtilsKt;
import me.eugeniomarletti.kotlin.metadata.shadow.storage.LockBasedStorageManager;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinTypeKt;
import me.eugeniomarletti.kotlin.metadata.shadow.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeParameterDescriptorImpl
extends AbstractTypeParameterDescriptor {
    @Nullable
    private final Function1<KotlinType, Void> reportCycleError;
    private final List<KotlinType> upperBounds = new ArrayList<KotlinType>(1);
    private boolean initialized = false;

    @NotNull
    public static TypeParameterDescriptor createWithDefaultBound(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean reified, @NotNull Variance variance, @NotNull Name name, int index) {
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, annotations2, reified, variance, name, index, SourceElement.NO_SOURCE);
        typeParameterDescriptor.addUpperBound(DescriptorUtilsKt.getBuiltIns(containingDeclaration).getDefaultBound());
        typeParameterDescriptor.setInitialized();
        return typeParameterDescriptor;
    }

    public static TypeParameterDescriptorImpl createForFurtherModification(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean reified, @NotNull Variance variance, @NotNull Name name, int index, @NotNull SourceElement source) {
        return TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, annotations2, reified, variance, name, index, source, null, SupertypeLoopChecker.EMPTY.INSTANCE);
    }

    public static TypeParameterDescriptorImpl createForFurtherModification(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean reified, @NotNull Variance variance, @NotNull Name name, int index, @NotNull SourceElement source, @Nullable Function1<KotlinType, Void> reportCycleError, @NotNull SupertypeLoopChecker supertypeLoopsResolver) {
        return new TypeParameterDescriptorImpl(containingDeclaration, annotations2, reified, variance, name, index, source, reportCycleError, supertypeLoopsResolver);
    }

    private TypeParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean reified, @NotNull Variance variance, @NotNull Name name, int index, @NotNull SourceElement source, @Nullable Function1<KotlinType, Void> reportCycleError, @NotNull SupertypeLoopChecker supertypeLoopsChecker) {
        super(LockBasedStorageManager.NO_LOCKS, containingDeclaration, annotations2, name, variance, reified, index, source, supertypeLoopsChecker);
        this.reportCycleError = reportCycleError;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Type parameter descriptor is not initialized: " + this.nameForAssertions());
        }
    }

    private void checkUninitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Type parameter descriptor is already initialized: " + this.nameForAssertions());
        }
    }

    private String nameForAssertions() {
        return this.getName() + " declared in " + DescriptorUtils.getFqName(this.getContainingDeclaration());
    }

    public void setInitialized() {
        this.checkUninitialized();
        this.initialized = true;
    }

    public void addUpperBound(@NotNull KotlinType bound) {
        this.checkUninitialized();
        this.doAddUpperBound(bound);
    }

    private void doAddUpperBound(KotlinType bound) {
        if (KotlinTypeKt.isError(bound)) {
            return;
        }
        this.upperBounds.add(bound);
    }

    public void addDefaultUpperBound() {
        this.checkUninitialized();
        if (this.upperBounds.isEmpty()) {
            this.doAddUpperBound(DescriptorUtilsKt.getBuiltIns(this.getContainingDeclaration()).getDefaultBound());
        }
    }

    @Override
    protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
        if (this.reportCycleError == null) {
            return;
        }
        this.reportCycleError.invoke((Object)type2);
    }

    @Override
    @NotNull
    protected List<KotlinType> resolveUpperBounds() {
        this.checkInitialized();
        return this.upperBounds;
    }
}

