/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.load.java.components;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.CallableMemberDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassConstructorDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ValueParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.load.java.structure.JavaClass;
import me.eugeniomarletti.kotlin.metadata.shadow.load.java.structure.JavaClassifier;
import me.eugeniomarletti.kotlin.metadata.shadow.load.java.structure.JavaClassifierType;
import me.eugeniomarletti.kotlin.metadata.shadow.load.java.structure.JavaMember;
import me.eugeniomarletti.kotlin.metadata.shadow.load.java.structure.JavaMethod;
import me.eugeniomarletti.kotlin.metadata.shadow.load.java.structure.JavaType;
import me.eugeniomarletti.kotlin.metadata.shadow.load.java.structure.JavaValueParameter;
import me.eugeniomarletti.kotlin.metadata.shadow.name.FqName;
import me.eugeniomarletti.kotlin.metadata.shadow.name.Name;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.NonReportingOverrideStrategy;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.OverridingUtil;
import me.eugeniomarletti.kotlin.metadata.shadow.serialization.deserialization.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorResolverUtils {
    private DescriptorResolverUtils() {
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> resolveOverridesForNonStaticMembers(@NotNull Name name, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor, @NotNull ErrorReporter errorReporter) {
        return DescriptorResolverUtils.resolveOverrides(name, membersFromSupertypes, membersFromCurrent, classDescriptor, errorReporter, false);
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> resolveOverridesForStaticMembers(@NotNull Name name, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor, @NotNull ErrorReporter errorReporter) {
        return DescriptorResolverUtils.resolveOverrides(name, membersFromSupertypes, membersFromCurrent, classDescriptor, errorReporter, true);
    }

    @NotNull
    private static <D extends CallableMemberDescriptor> Collection<D> resolveOverrides(@NotNull Name name, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor, final @NotNull ErrorReporter errorReporter, final boolean isStaticContext) {
        final LinkedHashSet result = new LinkedHashSet();
        OverridingUtil.generateOverridesInFunctionGroup(name, membersFromSupertypes, membersFromCurrent, classDescriptor, new NonReportingOverrideStrategy(){

            @Override
            public void addFakeOverride(@NotNull CallableMemberDescriptor fakeOverride) {
                OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, new Function1<CallableMemberDescriptor, Unit>(){

                    public Unit invoke(@NotNull CallableMemberDescriptor descriptor2) {
                        errorReporter.reportCannotInferVisibility(descriptor2);
                        return Unit.INSTANCE;
                    }
                });
                result.add(fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
            }

            @Override
            public void setOverriddenDescriptors(@NotNull CallableMemberDescriptor member, @NotNull Collection<? extends CallableMemberDescriptor> overridden) {
                if (isStaticContext && member.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    return;
                }
                super.setOverriddenDescriptors(member, overridden);
            }
        });
        return result;
    }

    @Nullable
    public static ValueParameterDescriptor getAnnotationParameterByName(@NotNull Name name, @NotNull ClassDescriptor annotationClass) {
        Collection<ClassConstructorDescriptor> constructors2 = annotationClass.getConstructors();
        if (constructors2.size() != 1) {
            return null;
        }
        for (ValueParameterDescriptor parameter : constructors2.iterator().next().getValueParameters()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public static boolean isObjectMethodInInterface(@NotNull JavaMember member) {
        return member.getContainingClass().isInterface() && member instanceof JavaMethod && DescriptorResolverUtils.isObjectMethod((JavaMethod)member);
    }

    public static boolean isObjectMethod(@NotNull JavaMethod method) {
        String name = method.getName().asString();
        if (name.equals("toString") || name.equals("hashCode")) {
            return method.getValueParameters().isEmpty();
        }
        if (name.equals("equals")) {
            return DescriptorResolverUtils.isMethodWithOneParameterWithFqName(method, "java.lang.Object");
        }
        return false;
    }

    private static boolean isMethodWithOneParameterWithFqName(@NotNull JavaMethod method, @NotNull String fqName2) {
        JavaClassifier classifier;
        JavaType type2;
        List<JavaValueParameter> parameters2 = method.getValueParameters();
        if (parameters2.size() == 1 && (type2 = parameters2.get(0).getType()) instanceof JavaClassifierType && (classifier = ((JavaClassifierType)type2).getClassifier()) instanceof JavaClass) {
            FqName classFqName = ((JavaClass)classifier).getFqName();
            return classFqName != null && classFqName.asString().equals(fqName2);
        }
        return false;
    }
}

