/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.resolve;

import java.util.Collections;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.CallableDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.CallableMemberDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.Modality;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.PropertyDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ReceiverParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.SimpleFunctionDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.SourceElement;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ValueParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.Visibilities;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.Visibility;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.annotations.Annotations;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.ClassConstructorDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.PropertyGetterDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.PropertySetterDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.ReceiverParameterDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.SimpleFunctionDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.ValueParameterDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.name.Name;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.DescriptorUtils;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.descriptorUtil.DescriptorUtilsKt;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.receivers.ExtensionReceiver;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DescriptorFactory {
    private DescriptorFactory() {
    }

    @NotNull
    public static PropertySetterDescriptorImpl createDefaultSetter(@NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2) {
        return DescriptorFactory.createSetter(propertyDescriptor, annotations2, true, false, false, propertyDescriptor.getSource());
    }

    @NotNull
    public static PropertySetterDescriptorImpl createSetter(@NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2, boolean isDefault, boolean isExternal, boolean isInline, @NotNull SourceElement sourceElement) {
        return DescriptorFactory.createSetter(propertyDescriptor, annotations2, isDefault, isExternal, isInline, propertyDescriptor.getVisibility(), sourceElement);
    }

    @NotNull
    public static PropertySetterDescriptorImpl createSetter(@NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2, boolean isDefault, boolean isExternal, boolean isInline, @NotNull Visibility visibility, @NotNull SourceElement sourceElement) {
        PropertySetterDescriptorImpl setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, propertyDescriptor.getModality(), visibility, isDefault, isExternal, isInline, CallableMemberDescriptor.Kind.DECLARATION, null, sourceElement);
        setterDescriptor.initializeDefault();
        return setterDescriptor;
    }

    @NotNull
    public static PropertyGetterDescriptorImpl createDefaultGetter(@NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2) {
        return DescriptorFactory.createGetter(propertyDescriptor, annotations2, true, false, false);
    }

    @NotNull
    public static PropertyGetterDescriptorImpl createGetter(@NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2, boolean isDefault, boolean isExternal, boolean isInline) {
        return DescriptorFactory.createGetter(propertyDescriptor, annotations2, isDefault, isExternal, isInline, propertyDescriptor.getSource());
    }

    @NotNull
    public static PropertyGetterDescriptorImpl createGetter(@NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2, boolean isDefault, boolean isExternal, boolean isInline, @NotNull SourceElement sourceElement) {
        return new PropertyGetterDescriptorImpl(propertyDescriptor, annotations2, propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), isDefault, isExternal, isInline, CallableMemberDescriptor.Kind.DECLARATION, null, sourceElement);
    }

    @NotNull
    public static ClassConstructorDescriptorImpl createPrimaryConstructorForObject(@NotNull ClassDescriptor containingClass, @NotNull SourceElement source) {
        return new DefaultClassConstructorDescriptor(containingClass, source);
    }

    @NotNull
    public static SimpleFunctionDescriptor createEnumValuesMethod(@NotNull ClassDescriptor enumClass) {
        SimpleFunctionDescriptorImpl values = SimpleFunctionDescriptorImpl.create(enumClass, Annotations.Companion.getEMPTY(), DescriptorUtils.ENUM_VALUES, CallableMemberDescriptor.Kind.SYNTHESIZED, enumClass.getSource());
        return values.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), (KotlinType)DescriptorUtilsKt.getBuiltIns(enumClass).getArrayType(Variance.INVARIANT, enumClass.getDefaultType()), Modality.FINAL, Visibilities.PUBLIC);
    }

    @NotNull
    public static SimpleFunctionDescriptor createEnumValueOfMethod(@NotNull ClassDescriptor enumClass) {
        SimpleFunctionDescriptorImpl valueOf = SimpleFunctionDescriptorImpl.create(enumClass, Annotations.Companion.getEMPTY(), DescriptorUtils.ENUM_VALUE_OF, CallableMemberDescriptor.Kind.SYNTHESIZED, enumClass.getSource());
        ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(valueOf, null, 0, Annotations.Companion.getEMPTY(), Name.identifier("value"), DescriptorUtilsKt.getBuiltIns(enumClass).getStringType(), false, false, false, null, enumClass.getSource());
        return valueOf.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.singletonList(parameterDescriptor), (KotlinType)enumClass.getDefaultType(), Modality.FINAL, Visibilities.PUBLIC);
    }

    @Nullable
    public static ReceiverParameterDescriptor createExtensionReceiverParameterForCallable(@NotNull CallableDescriptor owner, @Nullable KotlinType receiverParameterType) {
        return receiverParameterType == null ? null : new ReceiverParameterDescriptorImpl(owner, new ExtensionReceiver(owner, receiverParameterType));
    }

    private static class DefaultClassConstructorDescriptor
    extends ClassConstructorDescriptorImpl {
        public DefaultClassConstructorDescriptor(@NotNull ClassDescriptor containingClass, @NotNull SourceElement source) {
            super(containingClass, null, Annotations.Companion.getEMPTY(), true, CallableMemberDescriptor.Kind.DECLARATION, source);
            this.initialize(Collections.<ValueParameterDescriptor>emptyList(), DescriptorUtils.getDefaultConstructorVisibility(containingClass));
        }
    }
}

