/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import me.eugeniomarletti.kotlin.metadata.shadow.builtins.DefaultBuiltIns;
import me.eugeniomarletti.kotlin.metadata.shadow.builtins.KotlinBuiltIns;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.CallableDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.CallableMemberDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassKind;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassifierDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.DeclarationDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.DeclarationDescriptorVisitor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.DescriptorWithDeprecation;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.FunctionDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.InvalidModuleException;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.Modality;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ModuleDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.PackageViewDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.PropertyDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ReceiverParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.SimpleFunctionDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.SourceElement;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.TypeParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ValueParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.Visibilities;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.annotations.Annotations;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.ClassConstructorDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.ClassDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.impl.PropertyDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.incremental.components.LookupLocation;
import me.eugeniomarletti.kotlin.metadata.shadow.name.FqName;
import me.eugeniomarletti.kotlin.metadata.shadow.name.Name;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.descriptorUtil.DescriptorUtilsKt;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.DescriptorKindFilter;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.MemberScope;
import me.eugeniomarletti.kotlin.metadata.shadow.types.ErrorType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinTypeKt;
import me.eugeniomarletti.kotlin.metadata.shadow.types.SimpleType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeConstructor;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeProjection;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeSubstitution;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeSubstitutor;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeUtils;
import me.eugeniomarletti.kotlin.metadata.shadow.types.UnresolvedType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.UnwrappedType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.error.ErrorSimpleFunctionDescriptorImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.utils.Printer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorUtils {
    private static final ModuleDescriptor ERROR_MODULE = new ModuleDescriptor(){

        @Override
        @Nullable
        public <T> T getCapability(@NotNull ModuleDescriptor.Capability<T> capability) {
            return null;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            return Annotations.Companion.getEMPTY();
        }

        @Override
        @NotNull
        public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter) {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public Name getName() {
            return Name.special("<ERROR MODULE>");
        }

        @Override
        @NotNull
        public PackageViewDescriptor getPackage(@NotNull FqName fqName2) {
            throw new IllegalStateException("Should not be called!");
        }

        @Override
        @NotNull
        public List<ModuleDescriptor> getAllDependencyModules() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public List<ModuleDescriptor> getExpectedByModules() {
            return CollectionsKt.emptyList();
        }

        @Override
        public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor, D data) {
            return null;
        }

        @Override
        public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        }

        @Override
        public boolean shouldSeeInternalsOf(@NotNull ModuleDescriptor targetModule) {
            return false;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getOriginal() {
            return this;
        }

        @Override
        @Nullable
        public DeclarationDescriptor getContainingDeclaration() {
            return null;
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            return DefaultBuiltIns.getInstance();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void assertValid() {
            throw new InvalidModuleException("ERROR_MODULE is not a valid module");
        }
    };
    private static final ErrorClassDescriptor ERROR_CLASS = new ErrorClassDescriptor(Name.special("<ERROR CLASS>"));
    public static final SimpleType ERROR_TYPE_FOR_LOOP_IN_SUPERTYPES = ErrorUtils.createErrorType("<LOOP IN SUPERTYPES>");
    private static final KotlinType ERROR_PROPERTY_TYPE = ErrorUtils.createErrorType("<ERROR PROPERTY TYPE>");
    private static final PropertyDescriptor ERROR_PROPERTY = ErrorUtils.createErrorProperty();
    private static final Set<PropertyDescriptor> ERROR_PROPERTY_GROUP = Collections.singleton(ERROR_PROPERTY);

    public static boolean containsErrorType(@NotNull CallableDescriptor callableDescriptor) {
        if (callableDescriptor instanceof FunctionDescriptor) {
            return ErrorUtils.containsErrorType((FunctionDescriptor)callableDescriptor);
        }
        return ErrorUtils.containsErrorType(callableDescriptor.getReturnType());
    }

    public static boolean containsErrorType(@NotNull FunctionDescriptor function) {
        if (ErrorUtils.containsErrorType(function.getReturnType())) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameter = function.getExtensionReceiverParameter();
        if (receiverParameter != null && ErrorUtils.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            if (!ErrorUtils.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function.getTypeParameters()) {
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!ErrorUtils.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static ClassDescriptor createErrorClass(@NotNull String debugMessage) {
        return new ErrorClassDescriptor(Name.special("<ERROR CLASS: " + debugMessage + ">"));
    }

    @NotNull
    public static MemberScope createErrorScope(@NotNull String debugMessage) {
        return ErrorUtils.createErrorScope(debugMessage, false);
    }

    @NotNull
    public static MemberScope createErrorScope(@NotNull String debugMessage, boolean throwExceptions) {
        if (throwExceptions) {
            return new ThrowingScope(debugMessage);
        }
        return new ErrorScope(debugMessage);
    }

    @NotNull
    private static PropertyDescriptorImpl createErrorProperty() {
        PropertyDescriptorImpl descriptor2 = PropertyDescriptorImpl.create(ERROR_CLASS, Annotations.Companion.getEMPTY(), Modality.OPEN, Visibilities.PUBLIC, true, Name.special("<ERROR PROPERTY>"), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE, false, false, false, false, false, false);
        descriptor2.setType(ERROR_PROPERTY_TYPE, Collections.emptyList(), null, (KotlinType)null);
        return descriptor2;
    }

    @NotNull
    private static SimpleFunctionDescriptor createErrorFunction(@NotNull ErrorScope ownerScope) {
        ErrorSimpleFunctionDescriptorImpl function = new ErrorSimpleFunctionDescriptorImpl(ERROR_CLASS, ownerScope);
        function.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), (KotlinType)ErrorUtils.createErrorType("<ERROR FUNCTION RETURN TYPE>"), Modality.OPEN, Visibilities.PUBLIC);
        return function;
    }

    @NotNull
    public static SimpleType createErrorType(@NotNull String debugMessage) {
        return ErrorUtils.createErrorTypeWithArguments(debugMessage, Collections.<TypeProjection>emptyList());
    }

    @NotNull
    public static SimpleType createErrorTypeWithCustomDebugName(@NotNull String debugName) {
        return ErrorUtils.createErrorTypeWithCustomConstructor(debugName, ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName));
    }

    @NotNull
    public static SimpleType createErrorTypeWithCustomConstructor(@NotNull String debugName, @NotNull TypeConstructor typeConstructor2) {
        return new ErrorType(typeConstructor2, ErrorUtils.createErrorScope(debugName));
    }

    @NotNull
    public static SimpleType createErrorTypeWithArguments(@NotNull String debugMessage, @NotNull List<TypeProjection> arguments) {
        return new ErrorType(ErrorUtils.createErrorTypeConstructor(debugMessage), ErrorUtils.createErrorScope(debugMessage), arguments, false);
    }

    @NotNull
    public static SimpleType createUnresolvedType(@NotNull String presentableName, @NotNull List<TypeProjection> arguments) {
        return new UnresolvedType(presentableName, ErrorUtils.createErrorTypeConstructor(presentableName), ErrorUtils.createErrorScope(presentableName), arguments, false);
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructor(@NotNull String debugMessage) {
        return ErrorUtils.createErrorTypeConstructorWithCustomDebugName("[ERROR : " + debugMessage + "]", ERROR_CLASS);
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructorWithCustomDebugName(@NotNull String debugName) {
        return ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName, ERROR_CLASS);
    }

    @NotNull
    private static TypeConstructor createErrorTypeConstructorWithCustomDebugName(final @NotNull String debugName, final @NotNull ErrorClassDescriptor errorClass) {
        return new TypeConstructor(){

            @Override
            @NotNull
            public List<TypeParameterDescriptor> getParameters() {
                return CollectionsKt.emptyList();
            }

            @Override
            @NotNull
            public Collection<KotlinType> getSupertypes() {
                return CollectionsKt.emptyList();
            }

            @Override
            public boolean isFinal() {
                return false;
            }

            @Override
            public boolean isDenotable() {
                return false;
            }

            @Override
            @Nullable
            public ClassifierDescriptor getDeclarationDescriptor() {
                return errorClass;
            }

            @Override
            @NotNull
            public KotlinBuiltIns getBuiltIns() {
                return DefaultBuiltIns.getInstance();
            }

            public String toString() {
                return debugName;
            }
        };
    }

    public static boolean containsErrorType(@Nullable KotlinType type2) {
        if (type2 == null) {
            return false;
        }
        if (KotlinTypeKt.isError(type2)) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !ErrorUtils.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(@Nullable DeclarationDescriptor candidate) {
        if (candidate == null) {
            return false;
        }
        return ErrorUtils.isErrorClass(candidate) || ErrorUtils.isErrorClass(candidate.getContainingDeclaration()) || candidate == ERROR_MODULE;
    }

    private static boolean isErrorClass(@Nullable DeclarationDescriptor candidate) {
        return candidate instanceof ErrorClassDescriptor;
    }

    @NotNull
    public static ModuleDescriptor getErrorModule() {
        return ERROR_MODULE;
    }

    public static boolean isUninferredParameter(@Nullable KotlinType type2) {
        return type2 != null && type2.getConstructor() instanceof UninferredParameterTypeConstructor;
    }

    public static boolean containsUninferredParameter(@Nullable KotlinType type2) {
        return TypeUtils.contains(type2, new Function1<UnwrappedType, Boolean>(){

            public Boolean invoke(UnwrappedType argumentType) {
                return ErrorUtils.isUninferredParameter(argumentType);
            }
        });
    }

    @NotNull
    public static KotlinType createUninferredParameterType(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        return ErrorUtils.createErrorTypeWithCustomConstructor("Scope for error type for not inferred parameter: " + typeParameterDescriptor.getName(), new UninferredParameterTypeConstructor(typeParameterDescriptor));
    }

    private ErrorUtils() {
    }

    public static class UninferredParameterTypeConstructor
    implements TypeConstructor {
        private final TypeParameterDescriptor typeParameterDescriptor;
        private final TypeConstructor errorTypeConstructor;

        private UninferredParameterTypeConstructor(@NotNull TypeParameterDescriptor descriptor2) {
            this.typeParameterDescriptor = descriptor2;
            this.errorTypeConstructor = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("CANT_INFER_TYPE_PARAMETER: " + descriptor2.getName());
        }

        @NotNull
        public TypeParameterDescriptor getTypeParameterDescriptor() {
            return this.typeParameterDescriptor;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return this.errorTypeConstructor.getParameters();
        }

        @Override
        @NotNull
        public Collection<KotlinType> getSupertypes() {
            return this.errorTypeConstructor.getSupertypes();
        }

        @Override
        public boolean isFinal() {
            return this.errorTypeConstructor.isFinal();
        }

        @Override
        public boolean isDenotable() {
            return this.errorTypeConstructor.isDenotable();
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return this.errorTypeConstructor.getDeclarationDescriptor();
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            return DescriptorUtilsKt.getBuiltIns(this.typeParameterDescriptor);
        }
    }

    private static class ErrorClassDescriptor
    extends ClassDescriptorImpl {
        public ErrorClassDescriptor(@NotNull Name name) {
            super(ErrorUtils.getErrorModule(), name, Modality.OPEN, ClassKind.CLASS, Collections.<KotlinType>emptyList(), SourceElement.NO_SOURCE, false);
            ClassConstructorDescriptorImpl errorConstructor = ClassConstructorDescriptorImpl.create(this, Annotations.Companion.getEMPTY(), true, SourceElement.NO_SOURCE);
            errorConstructor.initialize(Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL);
            MemberScope memberScope2 = ErrorUtils.createErrorScope(this.getName().asString());
            errorConstructor.setReturnType(new ErrorType(ErrorUtils.createErrorTypeConstructorWithCustomDebugName("<ERROR>", this), memberScope2));
            this.initialize(memberScope2, Collections.singleton(errorConstructor), errorConstructor);
        }

        @Override
        @NotNull
        public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
            return this;
        }

        @Override
        public String toString() {
            return this.getName().asString();
        }

        @Override
        @NotNull
        public MemberScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
            return ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeArguments);
        }

        @Override
        @NotNull
        public MemberScope getMemberScope(@NotNull TypeSubstitution typeSubstitution) {
            return ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeSubstitution);
        }
    }

    private static class ThrowingScope
    implements MemberScope {
        private final String debugMessage;

        private ThrowingScope(@NotNull String message) {
            this.debugMessage = message;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
            throw new IllegalStateException(this.debugMessage + ", required name: " + name);
        }

        @Override
        @Nullable
        public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location) {
            throw new IllegalStateException(this.debugMessage + ", required name: " + name);
        }

        @NotNull
        public Collection getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
            throw new IllegalStateException(this.debugMessage + ", required name: " + name);
        }

        @NotNull
        public Collection getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
            throw new IllegalStateException(this.debugMessage + ", required name: " + name);
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
            throw new IllegalStateException(this.debugMessage);
        }

        @Override
        @NotNull
        public Set<Name> getFunctionNames() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Set<Name> getVariableNames() {
            throw new IllegalStateException();
        }

        @Override
        public Set<Name> getClassifierNames() {
            throw new IllegalStateException();
        }

        @Override
        public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
            throw new IllegalStateException();
        }

        @Override
        public boolean definitelyDoesNotContainName(@NotNull Name name) {
            return false;
        }

        public String toString() {
            return "ThrowingScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }

    public static class ErrorScope
    implements MemberScope {
        private final String debugMessage;

        private ErrorScope(@NotNull String debugMessage) {
            this.debugMessage = debugMessage;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
            return ErrorUtils.createErrorClass(name.asString());
        }

        @Override
        @Nullable
        public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location) {
            return null;
        }

        @NotNull
        public Set getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
            return ERROR_PROPERTY_GROUP;
        }

        @NotNull
        public Set getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
            return Collections.singleton(ErrorUtils.createErrorFunction(this));
        }

        @Override
        @NotNull
        public Set<Name> getFunctionNames() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<Name> getVariableNames() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<Name> getClassifierNames() {
            return Collections.emptySet();
        }

        @Override
        public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
            return Collections.emptyList();
        }

        @Override
        public boolean definitelyDoesNotContainName(@NotNull Name name) {
            return false;
        }

        public String toString() {
            return "ErrorScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }
}

