/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import me.eugeniomarletti.kotlin.metadata.shadow.builtins.KotlinBuiltIns;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassifierDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.TypeParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.MemberScope;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.TypeIntersectionScope;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeConstructor;
import org.jetbrains.annotations.NotNull;

public class IntersectionTypeConstructor
implements TypeConstructor {
    private final Set<KotlinType> intersectedTypes;
    private final int hashCode;

    public IntersectionTypeConstructor(Collection<KotlinType> typesToIntersect) {
        assert (!typesToIntersect.isEmpty()) : "Attempt to create an empty intersection";
        this.intersectedTypes = new LinkedHashSet<KotlinType>(typesToIntersect);
        this.hashCode = this.intersectedTypes.hashCode();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.intersectedTypes;
    }

    public MemberScope createScopeForKotlinType() {
        return TypeIntersectionScope.create("member scope for intersection type " + this, this.intersectedTypes);
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.intersectedTypes.iterator().next().getConstructor().getBuiltIns();
    }

    public String toString() {
        return IntersectionTypeConstructor.makeDebugNameForIntersectionType(this.intersectedTypes);
    }

    private static String makeDebugNameForIntersectionType(Iterable<KotlinType> resultingTypes) {
        StringBuilder debugName = new StringBuilder("{");
        Iterator<KotlinType> iterator2 = resultingTypes.iterator();
        while (iterator2.hasNext()) {
            KotlinType type2 = iterator2.next();
            debugName.append(type2.toString());
            if (!iterator2.hasNext()) continue;
            debugName.append(" & ");
        }
        debugName.append("}");
        return debugName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntersectionTypeConstructor that = (IntersectionTypeConstructor)o;
        return !(this.intersectedTypes != null ? !this.intersectedTypes.equals(that.intersectedTypes) : that.intersectedTypes != null);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

