/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import me.eugeniomarletti.kotlin.metadata.shadow.builtins.KotlinBuiltIns;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ClassifierDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.TypeParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.annotations.Annotations;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.constants.IntegerValueTypeConstructor;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.scopes.MemberScope;
import me.eugeniomarletti.kotlin.metadata.shadow.types.DefinitelyNotNullType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.DelegatingSimpleType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.ErrorUtils;
import me.eugeniomarletti.kotlin.metadata.shadow.types.FlexibleType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.FlexibleTypesKt;
import me.eugeniomarletti.kotlin.metadata.shadow.types.IntersectionTypeConstructor;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinTypeFactory;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinTypeKt;
import me.eugeniomarletti.kotlin.metadata.shadow.types.SimpleType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.StarProjectionImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeConstructor;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeProjection;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeProjectionImpl;
import me.eugeniomarletti.kotlin.metadata.shadow.types.TypeSubstitutor;
import me.eugeniomarletti.kotlin.metadata.shadow.types.UnwrappedType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.Variance;
import me.eugeniomarletti.kotlin.metadata.shadow.types.checker.KotlinTypeChecker;
import me.eugeniomarletti.kotlin.metadata.shadow.types.checker.NewTypeVariableConstructor;
import me.eugeniomarletti.kotlin.metadata.shadow.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    public static final SimpleType DONT_CARE = ErrorUtils.createErrorTypeWithCustomDebugName("DONT_CARE");
    public static final SimpleType CANT_INFER_FUNCTION_PARAM_TYPE = ErrorUtils.createErrorType("Cannot be inferred");
    @NotNull
    public static final SimpleType NO_EXPECTED_TYPE = new SpecialType("NO_EXPECTED_TYPE");
    public static final SimpleType UNIT_EXPECTED_TYPE = new SpecialType("UNIT_EXPECTED_TYPE");

    public static boolean noExpectedType(@NotNull KotlinType type2) {
        return type2 == NO_EXPECTED_TYPE || type2 == UNIT_EXPECTED_TYPE;
    }

    public static boolean isDontCarePlaceholder(@Nullable KotlinType type2) {
        return type2 != null && type2.getConstructor() == DONT_CARE.getConstructor();
    }

    @NotNull
    public static KotlinType makeNullable(@NotNull KotlinType type2) {
        return TypeUtils.makeNullableAsSpecified(type2, true);
    }

    @NotNull
    public static KotlinType makeNotNullable(@NotNull KotlinType type2) {
        return TypeUtils.makeNullableAsSpecified(type2, false);
    }

    @NotNull
    public static KotlinType makeNullableAsSpecified(@NotNull KotlinType type2, boolean nullable) {
        return type2.unwrap().makeNullableAsSpecified(nullable);
    }

    @NotNull
    public static SimpleType makeNullableIfNeeded(@NotNull SimpleType type2, boolean nullable) {
        if (nullable) {
            return type2.makeNullableAsSpecified(true);
        }
        return type2;
    }

    @NotNull
    public static KotlinType makeNullableIfNeeded(@NotNull KotlinType type2, boolean nullable) {
        if (nullable) {
            return TypeUtils.makeNullable(type2);
        }
        return type2;
    }

    public static boolean canHaveSubtypes(KotlinTypeChecker typeChecker, @NotNull KotlinType type2) {
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (!type2.getConstructor().isFinal()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments = type2.getArguments();
        int parametersSize = parameters2.size();
        block10: for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters2.get(i);
            TypeProjection typeProjection = arguments.get(i);
            if (typeProjection.isStarProjection()) {
                return true;
            }
            Variance projectionKind = typeProjection.getProjectionKind();
            KotlinType argument = typeProjection.getType();
            switch (parameterDescriptor.getVariance()) {
                case INVARIANT: {
                    switch (projectionKind) {
                        case INVARIANT: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) && !TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                        case IN_VARIANCE: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor)) break;
                            return true;
                        }
                        case OUT_VARIANCE: {
                            if (!TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                    }
                    continue block10;
                }
                case IN_VARIANCE: {
                    if (!(projectionKind != Variance.OUT_VARIANCE ? TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) : TypeUtils.canHaveSubtypes(typeChecker, argument))) continue block10;
                    return true;
                }
                case OUT_VARIANCE: {
                    if (!(projectionKind != Variance.IN_VARIANCE ? TypeUtils.canHaveSubtypes(typeChecker, argument) : TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor))) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean lowerThanBound(KotlinTypeChecker typeChecker, KotlinType argument, TypeParameterDescriptor parameterDescriptor) {
        for (KotlinType bound : parameterDescriptor.getUpperBounds()) {
            if (!typeChecker.isSubtypeOf(argument, bound) || argument.getConstructor().equals(bound.getConstructor())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SimpleType makeUnsubstitutedType(ClassifierDescriptor classifierDescriptor, MemberScope unsubstitutedMemberScope) {
        if (ErrorUtils.isError(classifierDescriptor)) {
            return ErrorUtils.createErrorType("Unsubstituted type for " + classifierDescriptor);
        }
        TypeConstructor typeConstructor2 = classifierDescriptor.getTypeConstructor();
        List<TypeProjection> arguments = TypeUtils.getDefaultTypeProjections(typeConstructor2.getParameters());
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(Annotations.Companion.getEMPTY(), typeConstructor2, arguments, false, unsubstitutedMemberScope);
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(@NotNull List<TypeParameterDescriptor> parameters2) {
        ArrayList<TypeProjectionImpl> result = new ArrayList<TypeProjectionImpl>(parameters2.size());
        for (TypeParameterDescriptor parameterDescriptor : parameters2) {
            result.add(new TypeProjectionImpl(parameterDescriptor.getDefaultType()));
        }
        return kotlin.collections.CollectionsKt.toList(result);
    }

    @NotNull
    public static List<KotlinType> getImmediateSupertypes(@NotNull KotlinType type2) {
        TypeSubstitutor substitutor = TypeSubstitutor.create(type2);
        Collection<KotlinType> originalSupertypes = type2.getConstructor().getSupertypes();
        ArrayList<KotlinType> result = new ArrayList<KotlinType>(originalSupertypes.size());
        for (KotlinType supertype : originalSupertypes) {
            KotlinType substitutedType = TypeUtils.createSubstitutedSupertype(type2, supertype, substitutor);
            if (substitutedType == null) continue;
            result.add(substitutedType);
        }
        return result;
    }

    @Nullable
    public static KotlinType createSubstitutedSupertype(@NotNull KotlinType subType, @NotNull KotlinType superType, @NotNull TypeSubstitutor substitutor) {
        KotlinType substitutedType = substitutor.substitute(superType, Variance.INVARIANT);
        if (substitutedType != null) {
            return TypeUtils.makeNullableIfNeeded(substitutedType, subType.isMarkedNullable());
        }
        return null;
    }

    private static void collectAllSupertypes(@NotNull KotlinType type2, @NotNull Set<KotlinType> result) {
        List<KotlinType> immediateSupertypes = TypeUtils.getImmediateSupertypes(type2);
        result.addAll(immediateSupertypes);
        for (KotlinType supertype : immediateSupertypes) {
            TypeUtils.collectAllSupertypes(supertype, result);
        }
    }

    @NotNull
    public static Set<KotlinType> getAllSupertypes(@NotNull KotlinType type2) {
        LinkedHashSet<KotlinType> result = new LinkedHashSet<KotlinType>(15);
        TypeUtils.collectAllSupertypes(type2, result);
        return result;
    }

    public static boolean isNullableType(@NotNull KotlinType type2) {
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (FlexibleTypesKt.isFlexible(type2) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type2).getUpperBound())) {
            return true;
        }
        if (TypeUtils.isTypeParameter(type2)) {
            return TypeUtils.hasNullableSuperType(type2);
        }
        return false;
    }

    public static boolean acceptsNullable(@NotNull KotlinType type2) {
        if (type2.isMarkedNullable()) {
            return true;
        }
        return FlexibleTypesKt.isFlexible(type2) && TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType(type2).getUpperBound());
    }

    public static boolean hasNullableSuperType(@NotNull KotlinType type2) {
        if (type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (KotlinType supertype : TypeUtils.getImmediateSupertypes(type2)) {
            if (!TypeUtils.isNullableType(supertype)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull KotlinType type2) {
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    @NotNull
    public static KotlinType substituteParameters(@NotNull ClassDescriptor clazz, @NotNull List<KotlinType> typeArguments) {
        List projections = kotlin.collections.CollectionsKt.map(typeArguments, (Function1)new Function1<KotlinType, TypeProjection>(){

            public TypeProjection invoke(KotlinType type2) {
                return new TypeProjectionImpl(type2);
            }
        });
        return TypeUtils.substituteProjectionsForParameters(clazz, projections);
    }

    @NotNull
    public static KotlinType substituteProjectionsForParameters(@NotNull ClassDescriptor clazz, @NotNull List<TypeProjection> projections) {
        List<TypeParameterDescriptor> clazzTypeParameters = clazz.getTypeConstructor().getParameters();
        if (clazzTypeParameters.size() != projections.size()) {
            throw new IllegalArgumentException("type parameter counts do not match: " + clazz + ", " + projections);
        }
        HashMap<TypeConstructor, TypeProjection> substitutions = CollectionsKt.newHashMapWithExpectedSize(clazzTypeParameters.size());
        for (int i = 0; i < clazzTypeParameters.size(); ++i) {
            TypeConstructor typeConstructor2 = clazzTypeParameters.get(i).getTypeConstructor();
            substitutions.put(typeConstructor2, projections.get(i));
        }
        return TypeSubstitutor.create(substitutions).substitute(clazz.getDefaultType(), Variance.INVARIANT);
    }

    public static boolean equalTypes(@NotNull KotlinType a, @NotNull KotlinType b) {
        return KotlinTypeChecker.DEFAULT.equalTypes(a, b);
    }

    public static boolean dependsOnTypeParameters(@NotNull KotlinType type2, @NotNull Collection<TypeParameterDescriptor> typeParameters) {
        return TypeUtils.dependsOnTypeConstructors(type2, kotlin.collections.CollectionsKt.map(typeParameters, (Function1)new Function1<TypeParameterDescriptor, TypeConstructor>(){

            public TypeConstructor invoke(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                return typeParameterDescriptor.getTypeConstructor();
            }
        }));
    }

    public static boolean dependsOnTypeConstructors(@NotNull KotlinType type2, @NotNull Collection<TypeConstructor> typeParameterConstructors) {
        if (typeParameterConstructors.contains(type2.getConstructor())) {
            return true;
        }
        for (TypeProjection typeProjection : type2.getArguments()) {
            if (typeProjection.isStarProjection() || !TypeUtils.dependsOnTypeConstructors(typeProjection.getType(), typeParameterConstructors)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable KotlinType type2, final @NotNull KotlinType specialType) {
        return TypeUtils.contains(type2, new Function1<UnwrappedType, Boolean>(){

            public Boolean invoke(UnwrappedType type2) {
                return specialType.equals(type2);
            }
        });
    }

    public static boolean contains(@Nullable KotlinType type2, @NotNull Function1<UnwrappedType, Boolean> isSpecialType) {
        FlexibleType flexibleType;
        if (type2 == null) {
            return false;
        }
        UnwrappedType unwrappedType = type2.unwrap();
        if (((Boolean)isSpecialType.invoke((Object)unwrappedType)).booleanValue()) {
            return true;
        }
        FlexibleType flexibleType2 = flexibleType = unwrappedType instanceof FlexibleType ? (FlexibleType)unwrappedType : null;
        if (flexibleType != null && (TypeUtils.contains((KotlinType)flexibleType.getLowerBound(), isSpecialType) || TypeUtils.contains((KotlinType)flexibleType.getUpperBound(), isSpecialType))) {
            return true;
        }
        if (unwrappedType instanceof DefinitelyNotNullType && TypeUtils.contains((KotlinType)((DefinitelyNotNullType)unwrappedType).getOriginal(), isSpecialType)) {
            return true;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            IntersectionTypeConstructor intersectionTypeConstructor = (IntersectionTypeConstructor)typeConstructor2;
            for (KotlinType supertype : intersectionTypeConstructor.getSupertypes()) {
                if (!TypeUtils.contains(supertype, isSpecialType)) continue;
                return true;
            }
            return false;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !TypeUtils.contains(projection.getType(), isSpecialType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        return new StarProjectionImpl(parameterDescriptor);
    }

    @NotNull
    public static KotlinType getDefaultPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor) {
        KotlinType type2 = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor.getSupertypes());
        assert (type2 != null) : "Strange number value type constructor: " + numberValueTypeConstructor + ". Super types doesn't contain double, int or long: " + numberValueTypeConstructor.getSupertypes();
        return type2;
    }

    @Nullable
    public static KotlinType getDefaultPrimitiveNumberType(@NotNull Collection<KotlinType> supertypes2) {
        if (supertypes2.isEmpty()) {
            return null;
        }
        KotlinBuiltIns builtIns = supertypes2.iterator().next().getConstructor().getBuiltIns();
        SimpleType doubleType = builtIns.getDoubleType();
        if (supertypes2.contains(doubleType)) {
            return doubleType;
        }
        SimpleType intType = builtIns.getIntType();
        if (supertypes2.contains(intType)) {
            return intType;
        }
        SimpleType longType = builtIns.getLongType();
        if (supertypes2.contains(longType)) {
            return longType;
        }
        return null;
    }

    @NotNull
    public static KotlinType getPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor, @NotNull KotlinType expectedType) {
        if (TypeUtils.noExpectedType(expectedType) || KotlinTypeKt.isError(expectedType)) {
            return TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
        }
        for (KotlinType primitiveNumberType : numberValueTypeConstructor.getSupertypes()) {
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(primitiveNumberType, expectedType)) continue;
            return primitiveNumberType;
        }
        return TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
    }

    public static boolean isTypeParameter(@NotNull KotlinType type2) {
        return TypeUtils.getTypeParameterDescriptorOrNull(type2) != null || type2.getConstructor() instanceof NewTypeVariableConstructor;
    }

    public static boolean isReifiedTypeParameter(@NotNull KotlinType type2) {
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        return typeParameterDescriptor != null && typeParameterDescriptor.isReified();
    }

    public static boolean isNonReifiedTypeParameter(@NotNull KotlinType type2) {
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        return typeParameterDescriptor != null && !typeParameterDescriptor.isReified();
    }

    @Nullable
    public static TypeParameterDescriptor getTypeParameterDescriptorOrNull(@NotNull KotlinType type2) {
        if (type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return (TypeParameterDescriptor)type2.getConstructor().getDeclarationDescriptor();
        }
        return null;
    }

    public static class SpecialType
    extends DelegatingSimpleType {
        private final String name;

        public SpecialType(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        protected SimpleType getDelegate() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public SimpleType replaceAnnotations(@NotNull Annotations newAnnotations) {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public SimpleType makeNullableAsSpecified(boolean newNullability) {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public String toString() {
            return this.name;
        }
    }
}

