/*
 * Decompiled with CFR 0.152.
 */
package me.eugeniomarletti.kotlin.metadata.shadow.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.eugeniomarletti.kotlin.metadata.shadow.builtins.ReflectionTypes;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.FunctionDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.descriptors.ValueParameterDescriptor;
import me.eugeniomarletti.kotlin.metadata.shadow.resolve.descriptorUtil.DescriptorUtilsKt;
import me.eugeniomarletti.kotlin.metadata.shadow.types.KotlinType;
import me.eugeniomarletti.kotlin.metadata.shadow.types.typeUtil.TypeUtilsKt;
import me.eugeniomarletti.kotlin.metadata.shadow.util.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lme/eugeniomarletti/kotlin/metadata/shadow/util/IsKPropertyCheck;", "Lme/eugeniomarletti/kotlin/metadata/shadow/util/Check;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "check", "", "functionDescriptor", "Lme/eugeniomarletti/kotlin/metadata/shadow/descriptors/FunctionDescriptor;", "descriptors"})
final class IsKPropertyCheck
implements Check {
    @NotNull
    private static final String description = "second parameter must be of type KProperty<*> or its supertype";
    public static final IsKPropertyCheck INSTANCE;

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        ValueParameterDescriptor secondParameter;
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        ValueParameterDescriptor valueParameterDescriptor = secondParameter = functionDescriptor.getValueParameters().get(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"secondParameter");
        KotlinType kotlinType = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(valueParameterDescriptor));
        if (kotlinType != null) {
            KotlinType kotlinType2 = secondParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"secondParameter.type");
            KotlinType kotlinType3 = TypeUtilsKt.makeNotNullable(kotlinType2);
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"secondParameter.type.makeNotNullable()");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, kotlinType3);
        } else {
            bl = false;
        }
        return bl;
    }

    private IsKPropertyCheck() {
    }

    static {
        IsKPropertyCheck isKPropertyCheck;
        INSTANCE = isKPropertyCheck = new IsKPropertyCheck();
        description = description;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }
}

