/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.List;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.ConsoleReporter;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

public class ConsoleTreeReporter
extends ConsoleReporter {
    private static final String TEST_SET_STARTING_PREFIX = "+-- ";

    public ConsoleTreeReporter(ConsoleLogger logger, boolean usePhrasedClassNameInRunning, boolean usePhrasedClassNameInTestCaseSummary) {
        super(logger, usePhrasedClassNameInRunning, usePhrasedClassNameInTestCaseSummary);
    }

    public void testSetStarting(TestSetReportEntry report) {
        this.getConsoleLogger().info("|");
        MessageBuilder builder = MessageUtils.buffer().a((CharSequence)TEST_SET_STARTING_PREFIX);
        String runningTestCase = TestSetStats.concatenateWithTestGroup((MessageBuilder)builder, (ReportEntry)report, (!StringUtils.isBlank((String)report.getReportNameWithGroup()) ? 1 : 0) != 0);
        this.getConsoleLogger().info(runningTestCase);
    }

    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        for (WrappedReportEntry testResult : testSetStats.getReportEntries()) {
            MessageBuilder builder = MessageUtils.buffer().a((CharSequence)"| +-- ");
            if (testResult.isErrorOrFailure()) {
                this.println(builder.failure((Object)("[XX] " + testResult.getReportName())).a((CharSequence)(" - " + testResult.elapsedTimeAsString() + "s")).toString());
                continue;
            }
            if (testResult.isSkipped()) {
                if (!StringUtils.isBlank((String)testResult.getReportName())) {
                    builder.warning((Object)("[??] " + testResult.getReportName()));
                } else {
                    builder.warning((Object)("[??] " + testResult.getReportSourceName()));
                }
                if (!StringUtils.isBlank((String)testResult.getMessage())) {
                    builder.warning((Object)(" (" + testResult.getMessage() + ")"));
                }
                this.println(builder.a((CharSequence)(" - " + testResult.elapsedTimeAsString() + "s")).toString());
                continue;
            }
            if (!testResult.isSucceeded()) continue;
            this.println(builder.success((Object)("[OK] " + testResult.getReportName())).a((CharSequence)(" - " + testResult.elapsedTimeAsString() + "s")).toString());
        }
    }

    private void println(String message) {
        this.getConsoleLogger().info(message);
    }
}

