/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.TextFormatter;
import org.apache.maven.plugin.surefire.report.Theme;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

public class TreePrinter {
    private final ConsoleLogger consoleLogger;
    private final List<String> sourceNames;
    private final Set<String> distinctSourceName;
    private final TestSetStats testSetStats;
    private final Theme theme;
    private static final int $ = 36;

    public TreePrinter(ConsoleLogger consoleLogger, TestSetStats testSetStats, Theme theme) {
        this.consoleLogger = consoleLogger;
        this.sourceNames = this.getSourceNames(testSetStats);
        this.distinctSourceName = this.getDistinctSourceNames(testSetStats);
        this.testSetStats = testSetStats;
        this.theme = theme;
    }

    public TreePrinter(ConsoleLogger consoleLogger, TestSetStats testSetStats) {
        this(consoleLogger, testSetStats, Theme.ASCII);
    }

    private List<String> getSourceNames(TestSetStats testSetStats) {
        return testSetStats.getReportEntries().stream().map(WrappedReportEntry::getSourceName).collect(Collectors.toList());
    }

    private Set<String> getDistinctSourceNames(TestSetStats testSetStats) {
        return testSetStats.getReportEntries().stream().map(WrappedReportEntry::getSourceName).collect(Collectors.toSet());
    }

    public void printTests() {
        this.testSetStats.getReportEntries().stream().map(x$0 -> new TestPrinter((WrappedReportEntry)x$0)).forEach(rec$ -> ((TestPrinter)rec$).printTest());
    }

    private class TestPrinter {
        private final WrappedReportEntry testResult;
        private final long treeLength;

        public TestPrinter(WrappedReportEntry testResult) {
            this.testResult = testResult;
            this.treeLength = this.getTreeLength();
        }

        private void printTest() {
            this.printClass();
            if (this.testResult.isErrorOrFailure()) {
                this.printFailure();
            } else if (this.testResult.isSkipped()) {
                this.printSkipped();
            } else if (this.testResult.isSucceeded()) {
                this.printSuccess();
            }
        }

        private void printSuccess() {
            this.println(MessageUtils.buffer().success((Object)(TreePrinter.this.theme.successful() + TextFormatter.abbreviateName(this.testResult.getReportName()))));
        }

        private void printSkipped() {
            this.println(MessageUtils.buffer().warning((Object)(TreePrinter.this.theme.skipped() + this.getSkippedReport())).warning((Object)this.getSkippedMessage()));
        }

        private String getSkippedReport() {
            if (!StringUtils.isBlank((String)this.testResult.getReportName())) {
                return TextFormatter.abbreviateName(this.testResult.getReportName());
            }
            return this.testResult.getReportSourceName();
        }

        private String getSkippedMessage() {
            if (!StringUtils.isBlank((String)this.testResult.getMessage())) {
                return " (" + this.testResult.getMessage() + ")";
            }
            return "";
        }

        private void printFailure() {
            this.println(MessageUtils.buffer().failure((Object)(TreePrinter.this.theme.failed() + TextFormatter.abbreviateName(this.testResult.getReportName()))));
        }

        private void printClass() {
            if (!TreePrinter.this.distinctSourceName.contains(this.testResult.getSourceName())) {
                return;
            }
            TreePrinter.this.distinctSourceName.remove(this.testResult.getSourceName());
            MessageBuilder builder = MessageUtils.buffer();
            if (this.treeLength > 0L) {
                if (this.treeLength > 1L) {
                    builder.a((CharSequence)TreePrinter.this.theme.pipe());
                    LongStream.rangeClosed(0L, this.treeLength - 3L).forEach(i -> builder.a((CharSequence)TreePrinter.this.theme.blank()));
                    builder.a((CharSequence)TreePrinter.this.theme.end());
                } else {
                    builder.a((CharSequence)TreePrinter.this.theme.entry());
                }
                if (TreePrinter.this.sourceNames.stream().distinct().count() > 1L) {
                    builder.a((CharSequence)TreePrinter.this.theme.down());
                } else {
                    builder.a((CharSequence)TreePrinter.this.theme.dash());
                }
            } else {
                builder.a((CharSequence)TreePrinter.this.theme.entry());
            }
            this.println(TestSetStats.concatenateWithTestGroup((MessageBuilder)builder, (ReportEntry)this.testResult, (!StringUtils.isBlank((String)this.testResult.getReportNameWithGroup()) ? 1 : 0) != 0));
        }

        private MessageBuilder getTestPrefix() {
            MessageBuilder builder = MessageUtils.buffer().a((CharSequence)TreePrinter.this.theme.pipe());
            if (this.treeLength > 0L) {
                LongStream.rangeClosed(0L, this.treeLength - 2L).forEach(i -> builder.a((CharSequence)TreePrinter.this.theme.blank()));
                if (TreePrinter.this.sourceNames.stream().distinct().count() > 1L) {
                    builder.a((CharSequence)TreePrinter.this.theme.pipe());
                } else {
                    builder.a((CharSequence)TreePrinter.this.theme.blank());
                }
            }
            TreePrinter.this.sourceNames.remove(this.testResult.getSourceName());
            if (TreePrinter.this.sourceNames.contains(this.testResult.getSourceName())) {
                builder.a((CharSequence)TreePrinter.this.theme.entry());
            } else {
                builder.a((CharSequence)TreePrinter.this.theme.end());
            }
            return builder;
        }

        private long getTreeLength() {
            return this.testResult.getSourceName().chars().filter(c -> c == 36).count();
        }

        private void println(MessageBuilder builder) {
            this.println(this.getTestPrefix().a((Object)builder).a((CharSequence)(" - " + this.testResult.elapsedTimeAsString() + "s")).toString());
        }

        private void println(String message) {
            TreePrinter.this.consoleLogger.info(message);
        }
    }
}

