/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.extensions.junit5;

import org.apache.maven.plugin.surefire.extensions.junit5.JUnit5StatelessTestsetInfoReporter;
import org.apache.maven.plugin.surefire.loader.SurefireClassLoaderModifier;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.ConsoleTreeReporter;
import org.apache.maven.plugin.surefire.report.ReporterOptions;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.Theme;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoConsoleReportEventListener;

public class JUnit5StatelessTestsetInfoTreeReporter
extends JUnit5StatelessTestsetInfoReporter {
    private boolean printStacktraceOnError;
    private boolean printStacktraceOnFailure;
    private boolean printStderrOnError;
    private boolean printStderrOnFailure;
    private boolean printStderrOnSuccess;
    private boolean printStdoutOnError;
    private boolean printStdoutOnFailure;
    private boolean printStdoutOnSuccess;
    private Theme theme = Theme.ASCII;

    public Object clone(ClassLoader target) {
        try {
            new SurefireClassLoaderModifier(target).addThisToSurefireClassLoader();
            Object clone = super.clone(target);
            Class<?> cls = clone.getClass();
            Class<?> themeClass = target.loadClass(Theme.class.getName());
            Object clonedTheme = Enum.valueOf(themeClass, this.getTheme().name());
            cls.getMethod("setPrintStacktraceOnError", Boolean.TYPE).invoke(clone, this.isPrintStacktraceOnError());
            cls.getMethod("setPrintStacktraceOnFailure", Boolean.TYPE).invoke(clone, this.isPrintStacktraceOnFailure());
            cls.getMethod("setPrintStderrOnError", Boolean.TYPE).invoke(clone, this.isPrintStderrOnError());
            cls.getMethod("setPrintStderrOnFailure", Boolean.TYPE).invoke(clone, this.isPrintStderrOnFailure());
            cls.getMethod("setPrintStderrOnSuccess", Boolean.TYPE).invoke(clone, this.isPrintStderrOnSuccess());
            cls.getMethod("setPrintStdoutOnError", Boolean.TYPE).invoke(clone, this.isPrintStdoutOnError());
            cls.getMethod("setPrintStdoutOnFailure", Boolean.TYPE).invoke(clone, this.isPrintStdoutOnFailure());
            cls.getMethod("setPrintStdoutOnSuccess", Boolean.TYPE).invoke(clone, this.isPrintStdoutOnSuccess());
            cls.getMethod("setTheme", themeClass).invoke(clone, clonedTheme);
            return clone;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    public StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> createListener(ConsoleLogger logger) {
        return new ConsoleTreeReporter(logger, this.newReporterOptions());
    }

    public Theme getTheme() {
        return this.theme;
    }

    public boolean isPrintStacktraceOnError() {
        return this.printStacktraceOnError;
    }

    public boolean isPrintStacktraceOnFailure() {
        return this.printStacktraceOnFailure;
    }

    public boolean isPrintStderrOnError() {
        return this.printStderrOnError;
    }

    public boolean isPrintStderrOnFailure() {
        return this.printStderrOnFailure;
    }

    public boolean isPrintStderrOnSuccess() {
        return this.printStderrOnSuccess;
    }

    public boolean isPrintStdoutOnError() {
        return this.printStdoutOnError;
    }

    public boolean isPrintStdoutOnFailure() {
        return this.printStdoutOnFailure;
    }

    public boolean isPrintStdoutOnSuccess() {
        return this.printStdoutOnSuccess;
    }

    public void setPrintStacktraceOnError(boolean printStacktraceOnError) {
        this.printStacktraceOnError = printStacktraceOnError;
    }

    public void setPrintStacktraceOnFailure(boolean printStacktraceOnFailure) {
        this.printStacktraceOnFailure = printStacktraceOnFailure;
    }

    public void setPrintStderrOnError(boolean printStderrOnError) {
        this.printStderrOnError = printStderrOnError;
    }

    public void setPrintStderrOnFailure(boolean printStderrOnFailure) {
        this.printStderrOnFailure = printStderrOnFailure;
    }

    public void setPrintStderrOnSuccess(boolean printStderrOnSuccess) {
        this.printStderrOnSuccess = printStderrOnSuccess;
    }

    public void setPrintStdoutOnError(boolean printStdoutOnError) {
        this.printStdoutOnError = printStdoutOnError;
    }

    public void setPrintStdoutOnFailure(boolean printStdoutOnFailure) {
        this.printStdoutOnFailure = printStdoutOnFailure;
    }

    public void setPrintStdoutOnSuccess(boolean printStdoutOnSuccess) {
        this.printStdoutOnSuccess = printStdoutOnSuccess;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{disable=" + this.isDisable() + ", usePhrasedFileName=" + this.isUsePhrasedFileName() + ", usePhrasedClassNameInRunning=" + this.isUsePhrasedClassNameInRunning() + ", usePhrasedClassNameInTestCaseSummary=" + this.isUsePhrasedClassNameInTestCaseSummary() + "}";
    }

    private ReporterOptions newReporterOptions() {
        return ReporterOptions.builder().printStacktraceOnError(this.isPrintStacktraceOnError()).printStacktraceOnFailure(this.isPrintStacktraceOnFailure()).printStderrOnError(this.isPrintStderrOnError()).printStderrOnFailure(this.isPrintStderrOnFailure()).printStderrOnSuccess(this.isPrintStderrOnSuccess()).printStdoutOnError(this.isPrintStdoutOnError()).printStdoutOnFailure(this.isPrintStdoutOnFailure()).printStdoutOnSuccess(this.isPrintStdoutOnSuccess()).usePhrasedClassNameInRunning(this.isUsePhrasedClassNameInRunning()).usePhrasedClassNameInTestCaseSummary(this.isUsePhrasedClassNameInTestCaseSummary()).theme(this.getTheme()).build();
    }
}

