/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.LongStream;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.Node;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.ReporterOptions;
import org.apache.maven.plugin.surefire.report.TextFormatter;
import org.apache.maven.plugin.surefire.report.Theme;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.shared.lang3.StringUtils;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

public class ActualTreePrinter {
    private final Theme theme;
    private final Node tree;
    private final ConsoleLogger consoleLogger;
    private final ReporterOptions options;

    public ActualTreePrinter(Node node, ConsoleLogger consoleLogger, ReporterOptions options) {
        this.tree = node;
        this.consoleLogger = consoleLogger;
        this.options = options;
        this.theme = options.getTheme();
    }

    public void print() {
        if (this.options.isPrintBlankLineBetweenTests()) {
            this.println("");
        }
        this.print(this.tree.branches.get(0));
        Node.clearTree();
    }

    private void print(Node node) {
        this.printClass(node);
        node.wrappedReportEntries.forEach(i -> this.printTestFormated(node, (WrappedReportEntry)i));
        node.branches.forEach(this::print);
    }

    private void printTestFormated(Node node, WrappedReportEntry testResult) {
        if (testResult.isErrorOrFailure()) {
            this.printFailure(node, testResult);
        } else if (testResult.isSkipped()) {
            this.printSkipped(node, testResult);
        } else if (this.isSuccessPrintAllowed() && testResult.isSucceeded()) {
            this.printSuccess(node, testResult);
        }
        this.printDetails(testResult);
    }

    private boolean isSuccessPrintAllowed() {
        return !this.options.isHideResultsOnSuccess();
    }

    private void printSuccess(Node node, WrappedReportEntry testResult) {
        this.printTestResult(MessageUtils.buffer().success((Object)(this.theme.successful() + TextFormatter.abbreviateName(testResult.getReportName()))), node, testResult);
    }

    private void printTestResult(MessageBuilder builder, Node node, WrappedReportEntry testResult) {
        this.println(this.getTestPrefix(node, testResult).a((Object)builder).a((CharSequence)(" - " + testResult.elapsedTimeAsString())).toString());
    }

    private void println(String message) {
        this.consoleLogger.info(message);
    }

    private boolean isLastMissingBranch(Node node) {
        Node rootChild = this.tree.branches.get(0);
        if (rootChild.hasBranches()) {
            Node rootChildLastChild = ActualTreePrinter.getLastItem(rootChild.branches);
            return node.getParent(rootChildLastChild.getName()).isPresent() || node == rootChildLastChild;
        }
        return true;
    }

    private static <T> T getLastItem(List<T> list) {
        return list.get(list.size() - 1);
    }

    private MessageBuilder getTestPrefix(Node node, WrappedReportEntry testResult) {
        MessageBuilder builder = MessageUtils.buffer();
        if (this.isLastMissingBranch(node)) {
            builder.a((CharSequence)this.theme.blank());
        } else {
            builder.a((CharSequence)this.theme.pipe());
        }
        if (node.getDepth() > 1) {
            LongStream.rangeClosed(0L, node.getDepth() - 3).forEach(i -> builder.a((CharSequence)this.theme.blank()));
            if (node.getParent().hasBranches() && node.hasBranches()) {
                builder.a((CharSequence)this.theme.pipe());
            } else {
                builder.a((CharSequence)this.theme.blank());
            }
        }
        if (ActualTreePrinter.isLastTestToBeEval(node, testResult)) {
            builder.a((CharSequence)this.theme.entry());
        } else {
            builder.a((CharSequence)this.theme.end());
        }
        return builder;
    }

    private static boolean isLastTestToBeEval(Node node, WrappedReportEntry testResult) {
        return node.wrappedReportEntries.indexOf(testResult) + 1 != node.wrappedReportEntries.size();
    }

    private void printClass(Node node) {
        MessageBuilder builder = MessageUtils.buffer();
        if (node.getDepth() > 1) {
            if (node.getDepth() > 2) {
                if (this.isLastMissingBranch(node)) {
                    builder.a((CharSequence)this.theme.blank());
                } else {
                    builder.a((CharSequence)this.theme.pipe());
                }
                LongStream.rangeClosed(0L, node.getDepth() - 4).forEach(i -> builder.a((CharSequence)this.theme.blank()));
                builder.a((CharSequence)this.theme.end());
            } else if (this.isLastMissingBranch(node)) {
                builder.a((CharSequence)this.theme.end());
            } else {
                builder.a((CharSequence)this.theme.entry());
            }
        }
        if (node.hasBranches()) {
            builder.a((CharSequence)this.theme.down());
        } else {
            builder.a((CharSequence)this.theme.dash());
        }
        builder.strong((Object)this.cleanReportName(node));
        builder.a((CharSequence)(" - " + node.getClassReportEntry().elapsedTimeAsString()));
        this.println(builder.toString());
    }

    private String cleanReportName(Node node) {
        if (node.getParent().getClassReportEntry() != null) {
            int stringSizeToRemove = node.getParent().getClassReportEntry().getReportNameWithGroup().length() + 1;
            return node.getClassReportEntry().getReportNameWithGroup().substring(stringSizeToRemove);
        }
        return node.getClassReportEntry().getReportNameWithGroup();
    }

    private void printDetails(WrappedReportEntry testResult) {
        boolean printStdErr;
        boolean isSuccess = testResult.getReportEntryType() == ReportEntryType.SUCCESS;
        boolean isError = testResult.getReportEntryType() == ReportEntryType.ERROR;
        boolean isFailure = testResult.getReportEntryType() == ReportEntryType.FAILURE;
        boolean printStackTrace = this.options.isPrintStacktraceOnError() && isError || this.options.isPrintStacktraceOnFailure() && isFailure;
        boolean printStdOut = this.options.isPrintStdoutOnSuccess() && isSuccess || this.options.isPrintStdoutOnError() && isError || this.options.isPrintStdoutOnFailure() && isFailure;
        boolean bl = printStdErr = this.options.isPrintStderrOnSuccess() && isSuccess || this.options.isPrintStderrOnError() && isError || this.options.isPrintStderrOnFailure() && isFailure;
        if (printStackTrace || printStdOut || printStdErr) {
            this.printPreambleDetails(testResult);
            if (printStackTrace) {
                this.printStackTrace(testResult);
            }
            if (printStdOut) {
                this.printStdOut(testResult);
            }
            if (printStdErr) {
                this.printStdErr(testResult);
            }
        }
    }

    private void printSkipped(Node node, WrappedReportEntry testResult) {
        this.printTestResult(MessageUtils.buffer().warning((Object)(this.theme.skipped() + this.getSkippedReport(testResult))).warning((Object)this.getSkippedMessage(testResult)), node, testResult);
    }

    private String getSkippedReport(WrappedReportEntry testResult) {
        if (!org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)testResult.getReportName())) {
            return TextFormatter.abbreviateName(testResult.getReportName());
        }
        return testResult.getReportSourceName();
    }

    private String getSkippedMessage(WrappedReportEntry testResult) {
        if (!org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)testResult.getMessage())) {
            return " (" + testResult.getMessage() + ")";
        }
        return "";
    }

    private void printPreambleDetails(WrappedReportEntry testResult) {
        if (testResult.isSucceeded()) {
            this.println(MessageUtils.buffer().success((Object)this.theme.details()).success((Object)TextFormatter.abbreviateName(testResult.getReportName())).toString());
        } else {
            this.println(MessageUtils.buffer().failure((Object)this.theme.details()).failure((Object)TextFormatter.abbreviateName(testResult.getReportName())).toString());
        }
    }

    private void printStdOut(WrappedReportEntry testResult) {
        this.println("");
        this.println(MessageUtils.buffer().strong((Object)"Standard out").toString());
        try {
            testResult.getStdout().writeTo((OutputStream)System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printStdErr(WrappedReportEntry testResult) {
        this.println("");
        this.println(MessageUtils.buffer().strong((Object)"Standard error").toString());
        try {
            testResult.getStdErr().writeTo((OutputStream)System.err);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printStackTrace(WrappedReportEntry testResult) {
        this.println("");
        this.println(MessageUtils.buffer().strong((Object)"Stack trace").toString());
        String stackTrace = testResult.getStackTrace(false);
        if (stackTrace != null && !StringUtils.isBlank((CharSequence)stackTrace)) {
            this.println(testResult.getStackTrace(false));
        } else {
            this.println("[No stack trace available]");
        }
    }

    private void printFailure(Node node, WrappedReportEntry testResult) {
        this.printTestResult(MessageUtils.buffer().failure((Object)(this.theme.failed() + TextFormatter.abbreviateName(testResult.getReportName()))), node, testResult);
    }
}

