/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;

public class Node {
    private static final Node ROOT = new Node("ROOT", 0);
    final List<Node> branches = new ArrayList<Node>();
    private final Node parent;
    private final String name;
    private final int depth;
    public final List<WrappedReportEntry> wrappedReportEntries = new ArrayList<WrappedReportEntry>();
    private WrappedReportEntry classReportEntry;

    public static void clearTree() {
        Node.ROOT.branches.clear();
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    public static Node getRoot() {
        return ROOT;
    }

    public boolean hasBranches() {
        return !this.branches.isEmpty();
    }

    private Node(String name, int nestLevel) {
        this(name, nestLevel, null);
    }

    private Node(String name, int depth, Node parent) {
        this.name = name;
        this.depth = depth;
        this.parent = parent;
    }

    Node(String name, Node parent) {
        this.name = name;
        this.depth = parent.depth + 1;
        this.parent = parent;
    }

    public Node addNode(ReportEntry reportEntry) {
        String[] nodes = reportEntry.getSourceName().split("\\$", -1);
        return this.addChildren(nodes);
    }

    protected Node addChildren(String ... nodes) {
        return this.addChildren(Arrays.stream(nodes).collect(Collectors.toList()));
    }

    protected Node addChildren(List<String> nodes) {
        if (nodes.isEmpty()) {
            return this;
        }
        return this.getBranchNode(nodes.get(0)).orElseGet(() -> this.generateBranch((String)nodes.get(0))).addChildren(this.removeFirst(nodes));
    }

    private Node generateBranch(String name) {
        Node branch = new Node(name, this);
        this.branches.add(branch);
        return branch;
    }

    private <T> List<T> removeFirst(List<T> list) {
        return list.subList(1, list.size());
    }

    boolean containsBranch(String reportName) {
        return this.branches.stream().anyMatch(item -> item.name.equals(reportName));
    }

    Optional<Node> getBranchNode(String reportName) {
        return this.branches.stream().filter(item -> item.name.equals(reportName)).findFirst();
    }

    Optional<Node> getBranchNode(List<String> nodePath) {
        return Node.getBranchNode(this, nodePath);
    }

    static Optional<Node> getBranchNode(Node node, List<String> nodePath) {
        if (nodePath.size() == 1) {
            return node.getBranchNode(nodePath.get(0));
        }
        if (node.getBranchNode(nodePath.get(0)).isPresent()) {
            return Node.getBranchNode(node.getBranchNode(nodePath.get(0)).get(), nodePath.subList(1, nodePath.size()));
        }
        return Optional.empty();
    }

    public Optional<Node> getParent(String parentName) {
        if (this.parent == null) {
            return Optional.empty();
        }
        if (this.parent.getName().equals(parentName)) {
            return Optional.of(this.parent);
        }
        return this.parent.getParent(parentName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            return ((Node)obj).name.equals(this.name);
        }
        return false;
    }

    public Node getParent() {
        return this.parent;
    }

    public WrappedReportEntry getClassReportEntry() {
        return this.classReportEntry;
    }

    public void setClassReportEntry(WrappedReportEntry classReportEntry) {
        this.classReportEntry = classReportEntry;
    }
}

