/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.loader;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.stream.Stream;

public class SurefireClassLoaderModifier {
    private final ClassLoader surefireClassLoader;
    private final Method addUrlMethod;
    public static final String MAVEN_SUREFIRE_JUNIT_5_TREE_REPORTER = "maven-surefire-junit5-tree-reporter";
    public static final String ADD_URL_METHOD = "addURL";

    public SurefireClassLoaderModifier(ClassLoader surefireClassLoader) throws NoSuchMethodException {
        this.surefireClassLoader = surefireClassLoader;
        this.addUrlMethod = surefireClassLoader.getClass().getDeclaredMethod(ADD_URL_METHOD, URL.class);
        this.addUrlMethod.setAccessible(true);
    }

    public void addThisToSurefireClassLoader() throws ReflectiveOperationException {
        this.addUrlMethod.invoke((Object)this.surefireClassLoader, this.getJarUrl());
    }

    private URL getJarUrl() throws ReflectiveOperationException {
        return this.getThreadContextClassLoaderURLs().filter(this::isMavenSurefireTreeReporterJar).findFirst().orElseThrow(ReflectiveOperationException::new);
    }

    private Stream<URL> getThreadContextClassLoaderURLs() {
        return Stream.of(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs());
    }

    private boolean isMavenSurefireTreeReporterJar(URL url) {
        return url.getFile().contains(MAVEN_SUREFIRE_JUNIT_5_TREE_REPORTER);
    }
}

