/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.hl7.fhir.instance.client.EFhirClientException;
import org.hl7.fhir.instance.client.FeedFormat;
import org.hl7.fhir.instance.client.ResourceAddress;
import org.hl7.fhir.instance.client.ResourceFormat;
import org.hl7.fhir.instance.client.ResourceRequest;
import org.hl7.fhir.instance.client.TagListRequest;
import org.hl7.fhir.instance.client.TagParser;
import org.hl7.fhir.instance.formats.ComposerBase;
import org.hl7.fhir.instance.formats.JsonComposer;
import org.hl7.fhir.instance.formats.JsonParser;
import org.hl7.fhir.instance.formats.Parser;
import org.hl7.fhir.instance.formats.ResourceOrFeed;
import org.hl7.fhir.instance.formats.XmlComposer;
import org.hl7.fhir.instance.formats.XmlParser;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.ResourceUtilities;

public class ClientUtils {
    public static String DEFAULT_CHARSET = "UTF-8";
    public static final String HEADER_LOCATION = "location";

    public static <T extends Resource> ResourceRequest<T> issueOptionsRequest(URI uRI, String string, HttpHost httpHost) {
        HttpOptions httpOptions = new HttpOptions(uRI);
        return ClientUtils.issueResourceRequest(string, (HttpUriRequest)httpOptions, httpHost);
    }

    public static <T extends Resource> ResourceRequest<T> issueGetResourceRequest(URI uRI, String string, HttpHost httpHost) {
        HttpGet httpGet = new HttpGet(uRI);
        return ClientUtils.issueResourceRequest(string, (HttpUriRequest)httpGet, httpHost);
    }

    public static <T extends Resource> ResourceRequest<T> issuePutRequest(URI uRI, byte[] byArray, String string, List<Header> list, HttpHost httpHost) {
        HttpPut httpPut = new HttpPut(uRI);
        return ClientUtils.issueResourceRequest(string, (HttpUriRequest)httpPut, byArray, list, httpHost);
    }

    public static <T extends Resource> ResourceRequest<T> issuePutRequest(URI uRI, byte[] byArray, String string, HttpHost httpHost) {
        HttpPut httpPut = new HttpPut(uRI);
        return ClientUtils.issueResourceRequest(string, (HttpUriRequest)httpPut, byArray, null, httpHost);
    }

    public static <T extends Resource> ResourceRequest<T> issuePostRequest(URI uRI, byte[] byArray, String string, List<Header> list, HttpHost httpHost) {
        HttpPost httpPost = new HttpPost(uRI);
        return ClientUtils.issueResourceRequest(string, (HttpUriRequest)httpPost, byArray, list, httpHost);
    }

    public static TagListRequest issueGetRequestForTagList(URI uRI, String string, List<Header> list, HttpHost httpHost) {
        HttpGet httpGet = new HttpGet(uRI);
        ClientUtils.configureFhirRequest((HttpRequest)httpGet, string);
        return ClientUtils.issueTagListRequest(string, (HttpUriRequest)httpGet, null, list, httpHost);
    }

    public static TagListRequest issuePostRequestForTagList(URI uRI, byte[] byArray, String string, List<Header> list, HttpHost httpHost) {
        HttpPost httpPost = new HttpPost(uRI);
        return ClientUtils.issueTagListRequest(string, (HttpUriRequest)httpPost, byArray, list, httpHost);
    }

    public static <T extends Resource> ResourceRequest<T> issuePostRequest(URI uRI, byte[] byArray, String string, HttpHost httpHost) {
        return ClientUtils.issuePostRequest(uRI, byArray, string, null, httpHost);
    }

    public static AtomFeed issueGetFeedRequest(URI uRI, String string, HttpHost httpHost) {
        HttpGet httpGet = new HttpGet(uRI);
        ClientUtils.configureFhirRequest((HttpRequest)httpGet, string);
        HttpResponse httpResponse = ClientUtils.sendRequest((HttpUriRequest)httpGet, httpHost);
        return ClientUtils.unmarshalFeed(httpResponse, string);
    }

    public static AtomFeed postBatchRequest(URI uRI, byte[] byArray, String string, HttpHost httpHost) {
        HttpPost httpPost = new HttpPost(uRI);
        ClientUtils.configureFhirRequest((HttpRequest)httpPost, string);
        HttpResponse httpResponse = ClientUtils.sendPayload((HttpEntityEnclosingRequestBase)httpPost, byArray, httpHost);
        return ClientUtils.unmarshalFeed(httpResponse, string);
    }

    public static boolean issueDeleteRequest(URI uRI, HttpHost httpHost) {
        HttpDelete httpDelete = new HttpDelete(uRI);
        HttpResponse httpResponse = ClientUtils.sendRequest((HttpUriRequest)httpDelete, httpHost);
        int n = httpResponse.getStatusLine().getStatusCode();
        boolean bl = false;
        if (n == 204) {
            bl = true;
        }
        return bl;
    }

    protected static <T extends Resource> ResourceRequest<T> issueResourceRequest(String string, HttpUriRequest httpUriRequest, HttpHost httpHost) {
        return ClientUtils.issueResourceRequest(string, httpUriRequest, null, httpHost);
    }

    protected static <T extends Resource> ResourceRequest<T> issueResourceRequest(String string, HttpUriRequest httpUriRequest, byte[] byArray, HttpHost httpHost) {
        return ClientUtils.issueResourceRequest(string, httpUriRequest, byArray, null, httpHost);
    }

    protected static <T extends Resource> ResourceRequest<T> issueResourceRequest(String string, HttpUriRequest httpUriRequest, byte[] byArray, List<Header> list, HttpHost httpHost) {
        ClientUtils.configureFhirRequest((HttpRequest)httpUriRequest, string, list);
        HttpResponse httpResponse = null;
        if (httpUriRequest instanceof HttpEntityEnclosingRequest && byArray != null) {
            httpResponse = ClientUtils.sendPayload((HttpEntityEnclosingRequestBase)httpUriRequest, byArray, httpHost);
        } else {
            if (httpUriRequest instanceof HttpEntityEnclosingRequest && byArray == null) {
                throw new EFhirClientException("PUT and POST requests require a non-null payload");
            }
            httpResponse = ClientUtils.sendRequest(httpUriRequest, httpHost);
        }
        T t = ClientUtils.unmarshalResource(httpResponse, string);
        AtomEntry<T> atomEntry = ClientUtils.buildAtomEntry(httpResponse, t);
        return new ResourceRequest<T>(atomEntry, httpResponse.getStatusLine().getStatusCode());
    }

    protected static TagListRequest issueTagListRequest(String string, HttpUriRequest httpUriRequest, byte[] byArray, List<Header> list, HttpHost httpHost) {
        ClientUtils.configureFhirRequest((HttpRequest)httpUriRequest, string, list);
        HttpResponse httpResponse = null;
        if (httpUriRequest instanceof HttpEntityEnclosingRequest && byArray != null) {
            httpResponse = ClientUtils.sendPayload((HttpEntityEnclosingRequestBase)httpUriRequest, byArray, httpHost);
        } else {
            if (httpUriRequest instanceof HttpEntityEnclosingRequest && byArray == null) {
                throw new EFhirClientException("PUT and POST requests require a non-null payload");
            }
            httpResponse = ClientUtils.sendRequest(httpUriRequest, httpHost);
        }
        List<AtomCategory> list2 = ClientUtils.unmarshalTagList(httpResponse, string);
        return new TagListRequest(list2, httpResponse.getStatusLine().getStatusCode());
    }

    protected static void configureFhirRequest(HttpRequest httpRequest, String string) {
        ClientUtils.configureFhirRequest(httpRequest, string, null);
    }

    protected static void configureFhirRequest(HttpRequest httpRequest, String string, List<Header> list) {
        httpRequest.addHeader("User-Agent", "Java FHIR Client for FHIR");
        if (string != null) {
            httpRequest.addHeader("Accept", string);
            httpRequest.addHeader("Content-Type", string + ";charset=" + DEFAULT_CHARSET);
        }
        httpRequest.addHeader("Accept-Charset", DEFAULT_CHARSET);
        if (list != null) {
            for (Header header : list) {
                httpRequest.addHeader(header);
            }
        }
    }

    protected static HttpResponse sendPayload(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, byte[] byArray, HttpHost httpHost) {
        HttpResponse httpResponse = null;
        try {
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            if (httpHost != null) {
                defaultHttpClient.getParams().setParameter("http.route.default-proxy", (Object)httpHost);
            }
            httpEntityEnclosingRequestBase.setEntity((HttpEntity)new ByteArrayEntity(byArray));
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpEntityEnclosingRequestBase);
        }
        catch (IOException iOException) {
            throw new EFhirClientException("Error sending HTTP Post/Put Payload", iOException);
        }
        return httpResponse;
    }

    protected static HttpResponse sendRequest(HttpUriRequest httpUriRequest, HttpHost httpHost) {
        HttpResponse httpResponse = null;
        try {
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            if (httpHost != null) {
                defaultHttpClient.getParams().setParameter("http.route.default-proxy", (Object)httpHost);
            }
            httpResponse = defaultHttpClient.execute(httpUriRequest);
        }
        catch (IOException iOException) {
            throw new EFhirClientException("Error sending Http Request", iOException);
        }
        return httpResponse;
    }

    protected static <T extends Resource> T unmarshalResource(HttpResponse httpResponse, String string) {
        Resource resource = null;
        OperationOutcome operationOutcome = null;
        InputStream inputStream = null;
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null && httpEntity.getContentLength() > 0L) {
            try {
                inputStream = httpEntity.getContent();
                resource = ClientUtils.getParser(string).parse(inputStream);
                if (resource instanceof OperationOutcome && ClientUtils.hasError((OperationOutcome)resource)) {
                    operationOutcome = (OperationOutcome)resource;
                }
            }
            catch (IOException iOException) {
                throw new EFhirClientException("Error unmarshalling entity from Http Response", iOException);
            }
            catch (Exception exception) {
                throw new EFhirClientException("Error parsing response message", exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (operationOutcome != null) {
            throw new EFhirClientException("Error unmarshalling resource: " + ResourceUtilities.getErrorDescription(operationOutcome), operationOutcome);
        }
        return (T)resource;
    }

    protected static List<AtomCategory> unmarshalTagList(HttpResponse httpResponse, String string) {
        ResourceOrFeed resourceOrFeed;
        OperationOutcome operationOutcome;
        block13: {
            InputStream inputStream = null;
            operationOutcome = null;
            resourceOrFeed = null;
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null && httpEntity.getContentLength() > 0L) {
                try {
                    inputStream = httpEntity.getContent();
                    resourceOrFeed = ClientUtils.getParser(string).parseGeneral(inputStream);
                    if (resourceOrFeed.getResource() == null) break block13;
                    if (resourceOrFeed.getResource() instanceof OperationOutcome && ClientUtils.hasError((OperationOutcome)resourceOrFeed.getResource())) {
                        operationOutcome = (OperationOutcome)resourceOrFeed.getResource();
                        break block13;
                    }
                    throw new EFhirClientException("Error unmarshalling tag list from Http Response: a resource was returned instead");
                }
                catch (IOException iOException) {
                    throw new EFhirClientException("Error unmarshalling entity from Http Response", iOException);
                }
                catch (Exception exception) {
                    throw new EFhirClientException("Error parsing response message", exception);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (operationOutcome != null) {
            throw new EFhirClientException("Error unmarshalling taglists: " + ResourceUtilities.getErrorDescription(operationOutcome), operationOutcome);
        }
        return resourceOrFeed.getTaglist();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static AtomFeed unmarshalFeed(HttpResponse httpResponse, String string) {
        AtomFeed atomFeed = null;
        InputStream inputStream = null;
        HttpEntity httpEntity = httpResponse.getEntity();
        String string2 = httpResponse.getHeaders("Content-Type")[0].getValue();
        OperationOutcome operationOutcome = null;
        try {
            if (httpEntity != null) {
                inputStream = httpEntity.getContent();
                if (string2.contains(ResourceFormat.RESOURCE_XML.getHeader()) || string2.contains("text/xml+fhir")) {
                    operationOutcome = (OperationOutcome)ClientUtils.getParser(ResourceFormat.RESOURCE_XML.getHeader()).parseGeneral(inputStream).getResource();
                } else {
                    ResourceOrFeed resourceOrFeed = ClientUtils.getParser(string).parseGeneral(inputStream);
                    if (resourceOrFeed.getResource() != null) {
                        if (!(resourceOrFeed.getResource() instanceof OperationOutcome) || !ClientUtils.hasError((OperationOutcome)resourceOrFeed.getResource())) throw new EFhirClientException("Error unmarshalling feed from Http Response: a resource was returned instead");
                        operationOutcome = (OperationOutcome)resourceOrFeed.getResource();
                    } else {
                        atomFeed = resourceOrFeed.getFeed();
                    }
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new EFhirClientException("Error unmarshalling feed from Http Response", iOException);
        }
        catch (Exception exception) {
            throw new EFhirClientException("Error parsing response message", exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (operationOutcome == null) return atomFeed;
        throw new EFhirClientException("Error unmarshalling feed: " + ResourceUtilities.getErrorDescription(operationOutcome), operationOutcome);
    }

    private static boolean hasError(OperationOutcome operationOutcome) {
        for (OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent : operationOutcome.getIssue()) {
            if (operationOutcomeIssueComponent.getSeveritySimple() != OperationOutcome.IssueSeverity.error && operationOutcomeIssueComponent.getSeveritySimple() != OperationOutcome.IssueSeverity.fatal) continue;
            return true;
        }
        return false;
    }

    protected static <T extends Resource> AtomEntry<T> buildAtomEntry(HttpResponse httpResponse, T t) {
        AtomEntry<T> atomEntry = new AtomEntry<T>();
        String string = null;
        if (httpResponse.getHeaders(HEADER_LOCATION).length > 0) {
            string = httpResponse.getHeaders(HEADER_LOCATION)[0].getValue();
        } else if (httpResponse.getHeaders("content-location").length > 0) {
            string = httpResponse.getHeaders("content-location")[0].getValue();
        }
        if (string != null) {
            atomEntry.getLinks().put("self", string);
        }
        List<AtomCategory> list = ClientUtils.parseTags(httpResponse);
        atomEntry.getTags().addAll(list);
        atomEntry.setResource(t);
        return atomEntry;
    }

    protected static List<AtomCategory> parseTags(HttpResponse httpResponse) {
        Header[] headerArray;
        ArrayList<AtomCategory> arrayList = new ArrayList<AtomCategory>();
        for (Header header : headerArray = httpResponse.getHeaders("Category")) {
            if (header == null || header.getValue().trim().isEmpty()) continue;
            List<AtomCategory> list = new TagParser().parse(header.getValue());
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static HttpURLConnection buildConnection(URI uRI, String string) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.resolve(string).toURL().openConnection();
            return httpURLConnection;
        }
        catch (MalformedURLException malformedURLException) {
            throw new EFhirClientException("Invalid Service URL", malformedURLException);
        }
        catch (IOException iOException) {
            throw new EFhirClientException("Unable to establish connection to server: " + uRI.toString() + string, iOException);
        }
    }

    public static HttpURLConnection buildConnection(URI uRI, ResourceType resourceType, String string) {
        return ClientUtils.buildConnection(uRI, ResourceAddress.buildRelativePathFromResourceType(resourceType, string));
    }

    public static <T extends Resource> byte[] getTagListAsByteArray(List<AtomCategory> list, boolean bl, boolean bl2) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ComposerBase composerBase = null;
            composerBase = bl2 ? new JsonComposer() : new XmlComposer();
            composerBase.compose((OutputStream)byteArrayOutputStream, list, bl);
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception2) {
                throw new EFhirClientException("Error closing output stream", exception2);
            }
            throw new EFhirClientException("Error converting output stream to byte array", exception);
        }
        return byArray;
    }

    public static <T extends Resource> byte[] getResourceAsByteArray(T t, boolean bl, boolean bl2) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ComposerBase composerBase = null;
            composerBase = bl2 ? new JsonComposer() : new XmlComposer();
            composerBase.compose((OutputStream)byteArrayOutputStream, t, bl);
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception2) {
                throw new EFhirClientException("Error closing output stream", exception2);
            }
            throw new EFhirClientException("Error converting output stream to byte array", exception);
        }
        return byArray;
    }

    public static byte[] getFeedAsByteArray(AtomFeed atomFeed, boolean bl, boolean bl2) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ComposerBase composerBase = null;
            composerBase = bl2 ? new JsonComposer() : new XmlComposer();
            composerBase.compose((OutputStream)byteArrayOutputStream, atomFeed, bl);
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception2) {
                throw new EFhirClientException("Error closing output stream", exception2);
            }
            throw new EFhirClientException("Error converting output stream to byte array", exception);
        }
        return byArray;
    }

    public static Calendar getLastModifiedResponseHeaderAsCalendarObject(URLConnection uRLConnection) {
        String string = null;
        try {
            string = uRLConnection.getHeaderField("Last-Modified");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            Date date = simpleDateFormat.parse(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException parseException) {
            throw new EFhirClientException("Error parsing Last-Modified response header " + string, parseException);
        }
    }

    protected static Parser getParser(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            string = ResourceFormat.RESOURCE_XML.getHeader();
        }
        if (string.equalsIgnoreCase("json") || string.equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader()) || string.equalsIgnoreCase(FeedFormat.FEED_JSON.getHeader())) {
            return new JsonParser();
        }
        if (string.equalsIgnoreCase("xml") || string.equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader()) || string.equalsIgnoreCase(FeedFormat.FEED_XML.getHeader())) {
            return new XmlParser();
        }
        throw new EFhirClientException("Invalid format: " + string);
    }

    protected static String writeInputStreamAsString(InputStream inputStream) {
        String string = null;
        try {
            string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            System.out.println(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static AtomFeed issuePostFeedRequest(URI uRI, Map<String, String> map, String string, Resource resource, String string2) throws Exception {
        HttpPost httpPost = new HttpPost(uRI);
        String string3 = "----WebKitFormBoundarykbMUo6H8QaUnYtRy";
        httpPost.addHeader("Content-Type", "multipart/form-data; boundary=" + string3);
        httpPost.addHeader("Accept", string2);
        ClientUtils.configureFhirRequest((HttpRequest)httpPost, null);
        HttpResponse httpResponse = ClientUtils.sendPayload((HttpEntityEnclosingRequestBase)httpPost, ClientUtils.encodeFormSubmission(map, string, resource, string3));
        return ClientUtils.unmarshalFeed(httpResponse, string2);
    }

    private static byte[] encodeFormSubmission(Map<String, String> map, String string, Resource resource, String string2) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        for (String string3 : map.keySet()) {
            outputStreamWriter.write("--");
            outputStreamWriter.write(string2);
            outputStreamWriter.write("\r\nContent-Disposition: form-data; name=\"" + string3 + "\"\r\n\r\n");
            outputStreamWriter.write(map.get(string3) + "\r\n");
        }
        outputStreamWriter.write("--");
        outputStreamWriter.write(string2);
        outputStreamWriter.write("\r\nContent-Disposition: form-data; name=\"" + string + "\"\r\n\r\n");
        outputStreamWriter.close();
        new JsonComposer().compose((OutputStream)byteArrayOutputStream, resource, false);
        outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        outputStreamWriter.write("\r\n--");
        outputStreamWriter.write(string2);
        outputStreamWriter.write("--");
        outputStreamWriter.close();
        return byteArrayOutputStream.toByteArray();
    }

    protected static HttpResponse sendPayload(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, byte[] byArray) {
        HttpResponse httpResponse = null;
        try {
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            httpEntityEnclosingRequestBase.setEntity((HttpEntity)new ByteArrayEntity(byArray));
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpEntityEnclosingRequestBase);
        }
        catch (IOException iOException) {
            throw new EFhirClientException("Error sending HTTP Post/Put Payload: " + iOException.getMessage(), iOException);
        }
        return httpResponse;
    }
}

