/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.client;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.OperationOutcome;

public class EFhirClientException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private List<OperationOutcome> errors = new ArrayList<OperationOutcome>();

    public EFhirClientException(String string) {
        super(string);
    }

    public EFhirClientException(String string, List<OperationOutcome> list) {
        super(string);
        if (list != null && list.size() > 0) {
            this.errors.addAll(list);
        }
    }

    public EFhirClientException(Exception exception) {
        super(exception);
    }

    public EFhirClientException(String string, Exception exception) {
        super(string, exception);
    }

    public EFhirClientException(String string, OperationOutcome operationOutcome) {
        super(string);
        if (operationOutcome != null) {
            this.errors.add(operationOutcome);
        }
    }

    public EFhirClientException(OperationOutcome operationOutcome) {
        super("Error on the server: " + operationOutcome.getText().getDiv().allText() + ". Refer to e.getServerErrors() for additional details.");
        if (operationOutcome != null) {
            this.errors.add(operationOutcome);
        }
    }

    public List<OperationOutcome> getServerErrors() {
        return this.errors;
    }

    public boolean hasServerErrors() {
        return this.errors.size() > 0;
    }
}

