/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.client;

import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.client.FeedFormat;
import org.hl7.fhir.instance.client.ResourceFormat;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Resource;

public interface FHIRClient {
    public VersionInfo getVersions();

    public FHIRClient initialize(String var1) throws URISyntaxException;

    public void initialize(String var1, int var2) throws URISyntaxException;

    public void setPreferredResourceFormat(ResourceFormat var1);

    public String getPreferredResourceFormat();

    public void setPreferredFeedFormat(FeedFormat var1);

    public String getPreferredFeedFormat();

    public int getMaximumRecordCount();

    public void setMaximumRecordCount(int var1);

    public Conformance getConformanceStatement();

    public Conformance getConformanceStatement(boolean var1);

    public <T extends Resource> AtomEntry<T> read(Class<T> var1, String var2);

    public <T extends Resource> AtomEntry<T> vread(Class<T> var1, String var2, String var3);

    public <T extends Resource> AtomEntry<T> update(Class<T> var1, T var2, String var3);

    public <T extends Resource> AtomEntry<T> update(Class<T> var1, T var2, String var3, List<AtomCategory> var4);

    public <T extends Resource> boolean delete(Class<T> var1, String var2);

    public <T extends Resource> AtomEntry<OperationOutcome> create(Class<T> var1, T var2);

    public <T extends Resource> AtomEntry<OperationOutcome> create(Class<T> var1, T var2, List<AtomCategory> var3);

    public <T extends Resource> AtomFeed history(Calendar var1, Class<T> var2, String var3);

    public <T extends Resource> AtomFeed history(DateAndTime var1, Class<T> var2, String var3);

    public <T extends Resource> AtomFeed history(Class<T> var1, String var2);

    public <T extends Resource> AtomFeed history(Calendar var1, Class<T> var2);

    public <T extends Resource> AtomFeed history(DateAndTime var1, Class<T> var2);

    public <T extends Resource> AtomFeed history(Class<T> var1);

    public <T extends Resource> AtomFeed history(Calendar var1);

    public <T extends Resource> AtomFeed history(DateAndTime var1);

    public <T extends Resource> AtomFeed history();

    public <T extends Resource> AtomEntry<OperationOutcome> validate(Class<T> var1, T var2, String var3);

    public <T extends Resource> AtomFeed search(Class<T> var1, Map<String, String> var2);

    public <T extends Resource> AtomFeed searchPost(Class<T> var1, T var2, Map<String, String> var3);

    public AtomFeed transaction(AtomFeed var1);

    public List<AtomCategory> getAllTags();

    public <T extends Resource> List<AtomCategory> getAllTagsForResourceType(Class<T> var1);

    public <T extends Resource> List<AtomCategory> getTagsForResource(Class<T> var1, String var2);

    public <T extends Resource> List<AtomCategory> getTagsForResourceVersion(Class<T> var1, String var2, String var3);

    public <T extends Resource> List<AtomCategory> deleteTags(List<AtomCategory> var1, Class<T> var2, String var3, String var4);

    public <T extends Resource> List<AtomCategory> createTags(List<AtomCategory> var1, Class<T> var2, String var3);

    public <T extends Resource> List<AtomCategory> createTags(List<AtomCategory> var1, Class<T> var2, String var3, String var4);

    public AtomFeed fetchFeed(String var1);

    public static interface VersionInfo {
        public String getClientJavaLibVersion();

        public String getFhirJavaLibVersion();

        public String getFhirJavaLibRevision();

        public String getFhirServerVersion();

        public String getFhirServerSoftware();
    }
}

