/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.hl7.fhir.instance.client.ClientUtils;
import org.hl7.fhir.instance.client.EFhirClientException;
import org.hl7.fhir.instance.client.FHIRClient;
import org.hl7.fhir.instance.client.FeedFormat;
import org.hl7.fhir.instance.client.ResourceAddress;
import org.hl7.fhir.instance.client.ResourceFormat;
import org.hl7.fhir.instance.client.ResourceRequest;
import org.hl7.fhir.instance.client.TagListRequest;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Resource;

public class FHIRSimpleClient
implements FHIRClient {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssK";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private ResourceAddress resourceAddress;
    private ResourceFormat preferredResourceFormat = ResourceFormat.RESOURCE_XML;
    private FeedFormat preferredFeedFormat = FeedFormat.FEED_XML;
    private HttpHost proxy;
    private int maxResultSetSize = -1;

    public void configureProxy(String string, int n) {
        this.proxy = new HttpHost(string, n);
    }

    @Override
    public FHIRClient initialize(String string) throws URISyntaxException {
        this.initialize(string, -1);
        return this;
    }

    @Override
    public void initialize(String string, int n) throws URISyntaxException {
        this.resourceAddress = new ResourceAddress(string);
        this.maxResultSetSize = n;
    }

    @Override
    public void setPreferredResourceFormat(ResourceFormat resourceFormat) {
        this.preferredResourceFormat = resourceFormat;
    }

    @Override
    public String getPreferredResourceFormat() {
        return this.preferredResourceFormat.getHeader();
    }

    @Override
    public void setPreferredFeedFormat(FeedFormat feedFormat) {
        this.preferredFeedFormat = feedFormat;
    }

    @Override
    public String getPreferredFeedFormat() {
        return this.preferredFeedFormat.getHeader();
    }

    @Override
    public int getMaximumRecordCount() {
        return this.maxResultSetSize;
    }

    @Override
    public void setMaximumRecordCount(int n) {
        this.maxResultSetSize = n;
    }

    @Override
    public Conformance getConformanceStatement() throws EFhirClientException {
        return this.getConformanceStatement(false);
    }

    @Override
    public Conformance getConformanceStatement(boolean bl) {
        Conformance conformance = null;
        try {
            conformance = bl ? (Conformance)ClientUtils.issueOptionsRequest(this.resourceAddress.getBaseServiceUri(), this.getPreferredResourceFormat(), this.proxy).getResource() : (Conformance)ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(), this.getPreferredResourceFormat(), this.proxy).getResource();
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to fetch the server's conformance statement", exception);
        }
        return conformance;
    }

    @Override
    public <T extends Resource> AtomEntry<T> read(Class<T> clazz, String string) {
        ResourceRequest resourceRequest = null;
        try {
            resourceRequest = ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(clazz, string), this.getPreferredResourceFormat(), this.proxy);
            resourceRequest.addErrorStatus(410);
            resourceRequest.addErrorStatus(404);
            resourceRequest.addSuccessStatus(200);
            if (resourceRequest.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + resourceRequest.getHttpStatus(), (OperationOutcome)resourceRequest.getPayload().getResource());
            }
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to read this resource", exception);
        }
        return resourceRequest.getPayload();
    }

    @Override
    public <T extends Resource> AtomEntry<T> vread(Class<T> clazz, String string, String string2) {
        ResourceRequest resourceRequest = null;
        try {
            resourceRequest = ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndIdAndVersion(clazz, string, string2), this.getPreferredResourceFormat(), this.proxy);
            resourceRequest.addErrorStatus(410);
            resourceRequest.addErrorStatus(404);
            resourceRequest.addErrorStatus(405);
            resourceRequest.addSuccessStatus(200);
            if (resourceRequest.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + resourceRequest.getHttpStatus(), (OperationOutcome)resourceRequest.getPayload().getResource());
            }
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to read this version of the resource", exception);
        }
        return resourceRequest.getPayload();
    }

    @Override
    public <T extends Resource> AtomEntry<T> update(Class<T> clazz, T t, String string) {
        return this.update(clazz, t, string, null);
    }

    @Override
    public <T extends Resource> AtomEntry<T> update(Class<T> clazz, T t, String string, List<AtomCategory> list) {
        ResourceRequest resourceRequest = null;
        try {
            List<Header> list2 = null;
            if (list != null && list.size() > 0) {
                list2 = this.buildCategoryHeader(list);
            }
            resourceRequest = ClientUtils.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(clazz, string), ClientUtils.getResourceAsByteArray(t, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), list2, this.proxy);
            resourceRequest.addErrorStatus(410);
            resourceRequest.addErrorStatus(404);
            resourceRequest.addErrorStatus(405);
            resourceRequest.addErrorStatus(422);
            resourceRequest.addSuccessStatus(200);
            resourceRequest.addSuccessStatus(201);
            if (resourceRequest.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + resourceRequest.getHttpStatus(), (OperationOutcome)resourceRequest.getPayload().getResource());
            }
        }
        catch (Exception exception) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", exception);
        }
        return resourceRequest.getPayload();
    }

    @Override
    public <T extends Resource> boolean delete(Class<T> clazz, String string) {
        try {
            return ClientUtils.issueDeleteRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(clazz, string), this.proxy);
        }
        catch (Exception exception) {
            throw new EFhirClientException("An error has occurred while trying to delete this resource", exception);
        }
    }

    @Override
    public <T extends Resource> AtomEntry<OperationOutcome> create(Class<T> clazz, T t) {
        return this.create(clazz, t, null);
    }

    @Override
    public <T extends Resource> AtomEntry<OperationOutcome> create(Class<T> clazz, T t, List<AtomCategory> list) {
        ResourceRequest resourceRequest = null;
        try {
            List<Header> list2 = null;
            if (list != null && list.size() > 0) {
                list2 = this.buildCategoryHeader(list);
            }
            resourceRequest = ClientUtils.issuePostRequest(this.resourceAddress.resolveGetUriFromResourceClass(clazz), ClientUtils.getResourceAsByteArray(t, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), list2, this.proxy);
            resourceRequest.addSuccessStatus(201);
            if (resourceRequest.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server responded with HTTP error code " + resourceRequest.getHttpStatus(), (OperationOutcome)resourceRequest.getPayload().getResource());
            }
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to create this resource", exception);
        }
        return resourceRequest.getPayload();
    }

    @Override
    public <T extends Resource> AtomFeed history(Calendar calendar, Class<T> clazz, String string) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForResourceId(clazz, string, calendar, this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history information for this resource", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed history(DateAndTime dateAndTime, Class<T> clazz, String string) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForResourceId(clazz, string, dateAndTime, this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history information for this resource", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed history(Calendar calendar, Class<T> clazz) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForResourceType(clazz, calendar, this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history information for this resource type", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed history(DateAndTime dateAndTime, Class<T> clazz) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForResourceType(clazz, dateAndTime, this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history information for this resource type", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed history(Class<T> clazz) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForResourceType(clazz, this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history information for this resource type", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed history(Class<T> clazz, String string) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForResourceId(clazz, string, this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history information for this resource", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed history(DateAndTime dateAndTime) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForAllResources(dateAndTime, this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history since last update", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed history(Calendar calendar) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForAllResources(calendar, this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history since last update", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed history() {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveGetHistoryForAllResources(this.maxResultSetSize), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history since last update", exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed search(Class<T> clazz, Map<String, String> map) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(this.resourceAddress.resolveSearchUri(clazz, map), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("Error performing search with parameters " + map, exception);
        }
        return atomFeed;
    }

    @Override
    public <T extends Resource> AtomFeed searchPost(Class<T> clazz, T t, Map<String, String> map) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issuePostFeedRequest(this.resourceAddress.resolveSearchUri(clazz, new HashMap<String, String>()), map, "src", t, this.getPreferredFeedFormat());
        }
        catch (Exception exception) {
            this.handleException("Error performing search with parameters " + map, exception);
        }
        return atomFeed;
    }

    @Override
    public AtomFeed transaction(AtomFeed atomFeed) {
        AtomFeed atomFeed2 = null;
        try {
            atomFeed2 = ClientUtils.postBatchRequest(this.resourceAddress.getBaseServiceUri(), ClientUtils.getFeedAsByteArray(atomFeed, false, this.isJson(this.getPreferredFeedFormat())), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error occurred trying to process this transaction request", exception);
        }
        return atomFeed2;
    }

    @Override
    public <T extends Resource> AtomEntry<OperationOutcome> validate(Class<T> clazz, T t, String string) {
        ResourceRequest resourceRequest = null;
        try {
            resourceRequest = ClientUtils.issuePostRequest(this.resourceAddress.resolveValidateUri(clazz, string), ClientUtils.getResourceAsByteArray(t, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), this.proxy);
            resourceRequest.addErrorStatus(400);
            resourceRequest.addErrorStatus(422);
            resourceRequest.addSuccessStatus(200);
            if (resourceRequest.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + resourceRequest.getHttpStatus(), (OperationOutcome)resourceRequest.getPayload().getResource());
            }
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to validate this resource", exception);
        }
        return resourceRequest.getPayload();
    }

    @Override
    public List<AtomCategory> getAllTags() {
        TagListRequest tagListRequest = null;
        try {
            tagListRequest = ClientUtils.issueGetRequestForTagList(this.resourceAddress.resolveGetAllTags(), this.getPreferredResourceFormat(), null, this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve all tags", exception);
        }
        return tagListRequest.getPayload();
    }

    @Override
    public <T extends Resource> List<AtomCategory> getAllTagsForResourceType(Class<T> clazz) {
        TagListRequest tagListRequest = null;
        try {
            tagListRequest = ClientUtils.issueGetRequestForTagList(this.resourceAddress.resolveGetAllTagsForResourceType(clazz), this.getPreferredResourceFormat(), null, this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve tags for this resource type", exception);
        }
        return tagListRequest.getPayload();
    }

    @Override
    public <T extends Resource> List<AtomCategory> getTagsForResource(Class<T> clazz, String string) {
        TagListRequest tagListRequest = null;
        try {
            tagListRequest = ClientUtils.issueGetRequestForTagList(this.resourceAddress.resolveGetTagsForResource(clazz, string), this.getPreferredResourceFormat(), null, this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve tags for this resource", exception);
        }
        return tagListRequest.getPayload();
    }

    @Override
    public <T extends Resource> List<AtomCategory> getTagsForResourceVersion(Class<T> clazz, String string, String string2) {
        TagListRequest tagListRequest = null;
        try {
            tagListRequest = ClientUtils.issueGetRequestForTagList(this.resourceAddress.resolveGetTagsForResourceVersion(clazz, string, string2), this.getPreferredResourceFormat(), null, this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve tags for this resource version", exception);
        }
        return tagListRequest.getPayload();
    }

    @Override
    public <T extends Resource> List<AtomCategory> createTags(List<AtomCategory> list, Class<T> clazz, String string) {
        TagListRequest tagListRequest = null;
        try {
            tagListRequest = ClientUtils.issuePostRequestForTagList(this.resourceAddress.resolveGetTagsForResource(clazz, string), ClientUtils.getTagListAsByteArray(list, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), null, this.proxy);
            tagListRequest.addSuccessStatus(201);
            tagListRequest.addSuccessStatus(200);
            if (tagListRequest.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server responded with HTTP error code " + tagListRequest.getHttpStatus());
            }
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to set tags for this resource", exception);
        }
        return tagListRequest.getPayload();
    }

    @Override
    public <T extends Resource> List<AtomCategory> createTags(List<AtomCategory> list, Class<T> clazz, String string, String string2) {
        TagListRequest tagListRequest = null;
        try {
            tagListRequest = ClientUtils.issuePostRequestForTagList(this.resourceAddress.resolveGetTagsForResourceVersion(clazz, string, string2), ClientUtils.getTagListAsByteArray(list, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), null, this.proxy);
            tagListRequest.addSuccessStatus(201);
            tagListRequest.addSuccessStatus(200);
            if (tagListRequest.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server responded with HTTP error code " + tagListRequest.getHttpStatus());
            }
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to set the tags for this resource version", exception);
        }
        return tagListRequest.getPayload();
    }

    @Override
    public <T extends Resource> List<AtomCategory> deleteTags(List<AtomCategory> list, Class<T> clazz, String string, String string2) {
        TagListRequest tagListRequest = null;
        try {
            tagListRequest = ClientUtils.issuePostRequestForTagList(this.resourceAddress.resolveDeleteTagsForResourceVersion(clazz, string, string2), ClientUtils.getTagListAsByteArray(list, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), null, this.proxy);
            tagListRequest.addSuccessStatus(201);
            tagListRequest.addSuccessStatus(200);
            if (tagListRequest.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server responded with HTTP error code " + tagListRequest.getHttpStatus());
            }
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to delete the tags for this resource version", exception);
        }
        return tagListRequest.getPayload();
    }

    protected void handleException(String string, Exception exception) throws EFhirClientException {
        if (exception instanceof EFhirClientException) {
            throw (EFhirClientException)exception;
        }
        throw new EFhirClientException(string, exception);
    }

    protected boolean isJson(String string) {
        boolean bl = false;
        if (string.toLowerCase().contains("json")) {
            bl = true;
        }
        return bl;
    }

    protected List<Header> buildCategoryHeader(List<AtomCategory> list) {
        ArrayList<Header> arrayList = new ArrayList<Header>();
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            AtomCategory atomCategory = list.get(i);
            string = string + atomCategory.getTerm() + ";scheme=\"" + atomCategory.getScheme() + "\";label=\"" + atomCategory.getLabel() + "\"";
            if (i >= list.size() - 1) continue;
            string = string + ",";
        }
        arrayList.add((Header)new BasicHeader("Category", string));
        return arrayList;
    }

    @Override
    public AtomFeed fetchFeed(String string) {
        AtomFeed atomFeed = null;
        try {
            atomFeed = ClientUtils.issueGetFeedRequest(new URI(string), this.getPreferredFeedFormat(), this.proxy);
        }
        catch (Exception exception) {
            this.handleException("An error has occurred while trying to retrieve history since last update", exception);
        }
        return atomFeed;
    }

    @Override
    public FHIRClient.VersionInfo getVersions() {
        SimpleVersionInfo simpleVersionInfo = new SimpleVersionInfo("0.81", "0.0.82", "????");
        Conformance conformance = this.getConformanceStatement();
        simpleVersionInfo.fhirServerVersion = conformance.getFhirVersionSimple();
        if (conformance.getSoftware() != null) {
            simpleVersionInfo.fhirServerSoftware = conformance.getSoftware().getVersionSimple();
        }
        return simpleVersionInfo;
    }

    private class SimpleVersionInfo
    implements FHIRClient.VersionInfo {
        private String clientJavaLibVersion;
        private String fhirJavaLibVersion;
        private String fhirJavaLibRevision;
        private String fhirServerVersion;
        private String fhirServerSoftware;

        private SimpleVersionInfo(String string, String string2, String string3) {
            this.clientJavaLibVersion = string;
            this.fhirJavaLibVersion = string2;
            this.fhirJavaLibRevision = string3;
        }

        @Override
        public String getClientJavaLibVersion() {
            return this.clientJavaLibVersion;
        }

        @Override
        public String getFhirJavaLibVersion() {
            return this.fhirJavaLibVersion;
        }

        @Override
        public String getFhirJavaLibRevision() {
            return this.fhirJavaLibRevision;
        }

        @Override
        public String getFhirServerVersion() {
            return this.fhirServerVersion;
        }

        @Override
        public String getFhirServerSoftware() {
            return this.fhirServerSoftware;
        }
    }
}

