/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.hl7.fhir.instance.client.EFhirClientException;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;

public class ResourceAddress {
    public static final String REGEX_ID_WITH_HISTORY = "(.*)(/)([a-zA-Z]*)(/)(\\d+)(/_history/)(\\d+)$";
    private URI baseServiceUri;

    public ResourceAddress(String string) throws URISyntaxException {
        this.baseServiceUri = ResourceAddress.buildAbsoluteURI(string);
    }

    public ResourceAddress(URI uRI) {
        this.baseServiceUri = uRI;
    }

    public URI getBaseServiceUri() {
        return this.baseServiceUri;
    }

    public <T extends Resource> URI resolveSearchUri(Class<T> clazz, Map<String, String> map) {
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClass(clazz) + "/_search"), map);
    }

    public <T extends Resource> URI resolveValidateUri(Class<T> clazz, String string) {
        return this.baseServiceUri.resolve(this.nameForClass(clazz) + "/_validate/" + string);
    }

    public <T extends Resource> URI resolveGetUriFromResourceClass(Class<T> clazz) {
        return this.baseServiceUri.resolve(this.nameForClass(clazz));
    }

    public <T extends Resource> URI resolveGetUriFromResourceClassAndId(Class<T> clazz, String string) {
        return this.baseServiceUri.resolve(this.nameForClass(clazz) + "/" + string);
    }

    public <T extends Resource> URI resolveGetUriFromResourceClassAndIdAndVersion(Class<T> clazz, String string, String string2) {
        return this.baseServiceUri.resolve(this.nameForClass(clazz) + "/" + string + "/_history/" + string2);
    }

    public URI resolveGetHistoryForAllResources(int n) {
        if (n > 0) {
            return ResourceAddress.appendHttpParameter(this.baseServiceUri.resolve("_history"), "_count", "" + n);
        }
        return this.baseServiceUri.resolve("_history");
    }

    public <T extends Resource> URI resolveGetHistoryForResourceId(Class<T> clazz, String string, int n) {
        return this.resolveGetHistoryUriForResourceId(clazz, string, null, n);
    }

    protected <T extends Resource> URI resolveGetHistoryUriForResourceId(Class<T> clazz, String string, Object object, int n) {
        Map<String, String> map = this.getHistoryParameters(object, n);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClass(clazz) + "/" + string + "/_history"), map);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceType(Class<T> clazz, int n) {
        Map<String, String> map = this.getHistoryParameters(null, n);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClass(clazz) + "/_history"), map);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceType(Class<T> clazz, Object object, int n) {
        Map<String, String> map = this.getHistoryParameters(object, n);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClass(clazz) + "/_history"), map);
    }

    public URI resolveGetHistoryForAllResources(Calendar calendar, int n) {
        Map<String, String> map = this.getHistoryParameters(calendar, n);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve("_history"), map);
    }

    public URI resolveGetHistoryForAllResources(DateAndTime dateAndTime, int n) {
        Map<String, String> map = this.getHistoryParameters(dateAndTime, n);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve("_history"), map);
    }

    public Map<String, String> getHistoryParameters(Object object, int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (object != null) {
            hashMap.put("_since", object.toString());
        }
        if (n > 0) {
            hashMap.put("_count", "" + n);
        }
        return hashMap;
    }

    public <T extends Resource> URI resolveGetHistoryForResourceId(Class<T> clazz, String string, Calendar calendar, int n) {
        return this.resolveGetHistoryUriForResourceId(clazz, string, calendar, n);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceId(Class<T> clazz, String string, DateAndTime dateAndTime, int n) {
        return this.resolveGetHistoryUriForResourceId(clazz, string, dateAndTime, n);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceType(Class<T> clazz, Calendar calendar, int n) {
        return this.resolveGetHistoryForResourceType(clazz, ResourceAddress.getCalendarDateInIsoTimeFormat(calendar), n);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceType(Class<T> clazz, DateAndTime dateAndTime, int n) {
        return this.resolveGetHistoryForResourceType(clazz, dateAndTime.toString(), n);
    }

    public <T extends Resource> URI resolveGetAllTags() {
        return this.baseServiceUri.resolve("_tags");
    }

    public <T extends Resource> URI resolveGetAllTagsForResourceType(Class<T> clazz) {
        return this.baseServiceUri.resolve(this.nameForClass(clazz) + "/_tags");
    }

    public <T extends Resource> URI resolveGetTagsForResource(Class<T> clazz, String string) {
        return this.baseServiceUri.resolve(this.nameForClass(clazz) + "/" + string + "/_tags");
    }

    public <T extends Resource> URI resolveGetTagsForResourceVersion(Class<T> clazz, String string, String string2) {
        return this.baseServiceUri.resolve(this.nameForClass(clazz) + "/" + string + "/_history/" + string2 + "/_tags");
    }

    public <T extends Resource> URI resolveDeleteTagsForResourceVersion(Class<T> clazz, String string, String string2) {
        return this.baseServiceUri.resolve(this.nameForClass(clazz) + "/" + string + "/_history/" + string2 + "/_tags/_delete");
    }

    public <T extends Resource> String nameForClass(Class<T> clazz) {
        String string = clazz.getSimpleName();
        if (string.equals("List_")) {
            return "List";
        }
        return string;
    }

    public URI resolveMetadataUri() {
        return this.baseServiceUri.resolve("metadata");
    }

    public static ResourceVersionedIdentifier parseCreateLocation(String string) {
        Pattern pattern = Pattern.compile(REGEX_ID_WITH_HISTORY);
        Matcher matcher = pattern.matcher(string);
        ResourceVersionedIdentifier resourceVersionedIdentifier = null;
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(3);
            String string4 = matcher.group(5);
            String string5 = matcher.group(7);
            resourceVersionedIdentifier = new ResourceVersionedIdentifier(string2, string3, string4, string5);
        }
        return resourceVersionedIdentifier;
    }

    public static URI buildAbsoluteURI(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new EFhirClientException("Invalid URI", new URISyntaxException(string, "URI/URL cannot be blank"));
        }
        String string2 = ResourceAddress.appendForwardSlashToPath(string);
        return ResourceAddress.buildEndpointUriFromString(string2);
    }

    public static String appendForwardSlashToPath(String string) {
        if (string.lastIndexOf(47) != string.length() - 1) {
            string = string + "/";
        }
        return string;
    }

    public static URI buildEndpointUriFromString(String string) {
        URI uRI = null;
        try {
            URIBuilder uRIBuilder = new URIBuilder(string);
            uRI = uRIBuilder.build();
            String string2 = uRI.getScheme();
            String string3 = uRI.getHost();
            if (!string2.equalsIgnoreCase("http") && !string2.equalsIgnoreCase("https")) {
                throw new EFhirClientException("Scheme must be 'http' or 'https': " + uRI);
            }
            if (StringUtils.isBlank((CharSequence)string3)) {
                throw new EFhirClientException("host cannot be blank: " + uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new EFhirClientException("Invalid URI", uRISyntaxException);
        }
        return uRI;
    }

    public static URI appendQueryStringToUri(URI uRI, String string, String string2) {
        URI uRI2 = null;
        try {
            URIBuilder uRIBuilder = new URIBuilder(uRI);
            uRIBuilder.setQuery(string + "=" + string2);
            uRI2 = uRIBuilder.build();
        }
        catch (Exception exception) {
            throw new EFhirClientException("Unable to append query parameter '" + string + "=" + string2 + " to URI " + uRI, exception);
        }
        return uRI2;
    }

    public static String buildRelativePathFromResourceType(ResourceType resourceType) {
        return resourceType.toString() + "/";
    }

    public static String buildRelativePathFromResourceType(ResourceType resourceType, String string) {
        return ResourceAddress.buildRelativePathFromResourceType(resourceType) + "@" + string;
    }

    public static String buildRelativePathFromResource(Resource resource) {
        return ResourceAddress.buildRelativePathFromResourceType(resource.getResourceType());
    }

    public static String buildRelativePathFromResource(Resource resource, String string) {
        return ResourceAddress.buildRelativePathFromResourceType(resource.getResourceType(), string);
    }

    public static String getCalendarDateInIsoTimeFormat(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("YYYY-MM-dd'T'hh:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(calendar.getTime());
    }

    public static URI appendHttpParameter(URI uRI, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string, string2);
        return ResourceAddress.appendHttpParameters(uRI, hashMap);
    }

    public static URI appendHttpParameters(URI uRI, Map<String, String> map) {
        try {
            Set<String> set = map.keySet();
            String string = uRI.getQuery();
            for (String string2 : set) {
                string = string != null ? string + "&" : "";
                string = string + string2 + "=" + map.get(string2);
            }
            return new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), string, uRI.getFragment());
        }
        catch (Exception exception) {
            throw new EFhirClientException("Error appending http parameter", exception);
        }
    }

    public static class ResourceVersionedIdentifier {
        private String serviceRoot;
        private String resourceType;
        private String id;
        private String version;
        private URI resourceLocation;

        public ResourceVersionedIdentifier(String string, String string2, String string3, String string4, URI uRI) {
            this.serviceRoot = string;
            this.resourceType = string2;
            this.id = string3;
            this.version = string4;
            this.resourceLocation = uRI;
        }

        public ResourceVersionedIdentifier(String string, String string2, String string3, URI uRI) {
            this(null, string, string2, string3, uRI);
        }

        public ResourceVersionedIdentifier(String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, null);
        }

        public ResourceVersionedIdentifier(String string, String string2, String string3) {
            this(null, string, string2, string3, null);
        }

        public ResourceVersionedIdentifier(String string, String string2) {
            this.id = string2;
        }

        public String getId() {
            return this.id;
        }

        protected void setId(String string) {
            this.id = string;
        }

        public String getVersionId() {
            return this.version;
        }

        protected void setVersionId(String string) {
            this.version = string;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String string) {
            this.resourceType = string;
        }

        public String getServiceRoot() {
            return this.serviceRoot;
        }

        public void setServiceRoot(String string) {
            this.serviceRoot = string;
        }

        public String getResourcePath() {
            return this.serviceRoot + "/" + this.resourceType + "/" + this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public URI getResourceLocation() {
            return this.resourceLocation;
        }

        public void setResourceLocation(URI uRI) {
            this.resourceLocation = uRI;
        }
    }
}

