/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.client;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.Resource;

public class ResourceRequest<T extends Resource> {
    private AtomEntry<T> payload;
    private int httpStatus = -1;
    private List<Integer> successfulStatuses = new ArrayList<Integer>();
    private List<Integer> errorStatuses = new ArrayList<Integer>();

    public ResourceRequest(AtomEntry<T> atomEntry, int n, List<Integer> list, List<Integer> list2) {
        this.payload = atomEntry;
        this.httpStatus = n;
        if (list != null) {
            this.successfulStatuses.addAll(list);
        }
        if (list2 != null) {
            this.errorStatuses.addAll(list2);
        }
    }

    public ResourceRequest(AtomEntry<T> atomEntry, int n) {
        this.payload = atomEntry;
        this.httpStatus = n;
    }

    public ResourceRequest(AtomEntry<T> atomEntry, int n, int n2) {
        this.payload = atomEntry;
        this.httpStatus = n;
        this.successfulStatuses.add(n2);
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public AtomEntry<T> getPayload() {
        return this.payload;
    }

    public T getResource() {
        T t = null;
        if (this.payload != null) {
            t = this.payload.getResource();
        }
        return t;
    }

    public boolean isSuccessfulRequest() {
        return this.successfulStatuses.contains(this.httpStatus) && !this.errorStatuses.contains(this.httpStatus) && this.httpStatus > 0;
    }

    public boolean isUnsuccessfulRequest() {
        return !this.isSuccessfulRequest();
    }

    public void addSuccessStatus(int n) {
        this.successfulStatuses.add(n);
    }

    public void addErrorStatus(int n) {
        this.errorStatuses.add(n);
    }
}

