/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.client;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.AtomCategory;

public class TagListRequest {
    private List<AtomCategory> payload;
    private int httpStatus = -1;
    private List<Integer> successfulStatuses = new ArrayList<Integer>();
    private List<Integer> errorStatuses = new ArrayList<Integer>();

    public TagListRequest(List<AtomCategory> list, int n, List<Integer> list2, List<Integer> list3) {
        this.payload = list;
        this.httpStatus = n;
        if (list2 != null) {
            this.successfulStatuses.addAll(list2);
        }
        if (list3 != null) {
            this.errorStatuses.addAll(list3);
        }
    }

    public TagListRequest(List<AtomCategory> list, int n) {
        this.payload = list;
        this.httpStatus = n;
    }

    public TagListRequest(List<AtomCategory> list, int n, int n2) {
        this.payload = list;
        this.httpStatus = n;
        this.successfulStatuses.add(n2);
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public List<AtomCategory> getPayload() {
        return this.payload;
    }

    public boolean isSuccessfulRequest() {
        return this.successfulStatuses.contains(this.httpStatus) && !this.errorStatuses.contains(this.httpStatus) && this.httpStatus > 0;
    }

    public boolean isUnsuccessfulRequest() {
        return !this.isSuccessfulRequest();
    }

    public void addSuccessStatus(int n) {
        this.successfulStatuses.add(n);
    }

    public void addErrorStatus(int n) {
        this.errorStatuses.add(n);
    }
}

