/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.client;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hl7.fhir.instance.model.AtomCategory;

public class TagParser {
    public static final String LABEL = "label";
    public static final String SCHEME = "scheme";
    public static final String REGEX_CATEGORY = "((.+?)([;,]))";

    public List<AtomCategory> parse(String string) {
        Object object;
        ArrayList<AtomCategory> arrayList = new ArrayList<AtomCategory>();
        Matcher matcher = this.loadRegexMatcher(string);
        int n = -1;
        String[] stringArray = new String[3];
        while (matcher.find()) {
            object = matcher.group().trim();
            boolean bl = this.lastIsComma((String)object);
            object = this.stripPunctuation((String)object);
            this.handleSentence((String)object, stringArray);
            if (n < matcher.end()) {
                n = matcher.end();
            }
            if (!bl) continue;
            AtomCategory atomCategory = new AtomCategory(stringArray[0], stringArray[1], stringArray[2]);
            arrayList.add(atomCategory);
            stringArray = new String[3];
        }
        if (n < string.length()) {
            this.handleSentence(string.substring(n).trim(), stringArray);
        }
        object = new AtomCategory(stringArray[0], stringArray[1], stringArray[2]);
        arrayList.add((AtomCategory)object);
        return arrayList;
    }

    protected Matcher loadRegexMatcher(String string) {
        Pattern pattern = Pattern.compile(REGEX_CATEGORY);
        return pattern.matcher(string);
    }

    protected void handleSentence(String string, String[] stringArray) {
        if (this.isLabel(string)) {
            stringArray[2] = this.getLabel(string);
        } else if (this.isScheme(string)) {
            stringArray[0] = this.getScheme(string);
        } else {
            stringArray[1] = string;
        }
    }

    protected boolean lastIsComma(String string) {
        return string.substring(string.length() - 1).equals(",");
    }

    protected boolean isLabel(String string) {
        return string.startsWith(LABEL);
    }

    protected String getLabel(String string) {
        return string.substring(string.indexOf(61) + 1);
    }

    protected String getScheme(String string) {
        return string.substring(string.indexOf(61) + 1);
    }

    protected boolean isScheme(String string) {
        return string.startsWith(SCHEME);
    }

    protected String stripPunctuation(String string) {
        if (this.lastCharacterIsPunctuation(string)) {
            return this.stripLastCharacter(string);
        }
        return string;
    }

    protected boolean lastCharacterIsPunctuation(String string) {
        boolean bl = false;
        if (string.lastIndexOf(59) == string.length() - 1) {
            bl = true;
        } else if (string.lastIndexOf(44) == string.length() - 1) {
            bl = true;
        }
        return bl;
    }

    protected String stripLastCharacter(String string) {
        return string.substring(0, string.length() - 1);
    }
}

