/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.hl7.fhir.instance.formats.Composer;
import org.hl7.fhir.instance.formats.FormatUtilities;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Resource;

public abstract class ComposerBase
extends FormatUtilities
implements Composer {
    protected String xhtmlMessage;

    @Override
    public void setSuppressXhtml(String string) {
        this.xhtmlMessage = string;
    }

    public String composeString(Resource resource, boolean bl) throws Exception {
        return new String(this.composeBytes(resource, bl));
    }

    public String composeString(AtomFeed atomFeed, boolean bl) throws Exception {
        return new String(this.composeBytes(atomFeed, bl));
    }

    public String composeString(List<AtomCategory> list, boolean bl) throws Exception {
        return new String(this.composeBytes(list, bl));
    }

    public byte[] composeBytes(Resource resource, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.compose((OutputStream)byteArrayOutputStream, resource, true);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] composeBytes(AtomFeed atomFeed, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.compose((OutputStream)byteArrayOutputStream, atomFeed, true);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] composeBytes(List<AtomCategory> list, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.compose((OutputStream)byteArrayOutputStream, list, true);
        return byteArrayOutputStream.toByteArray();
    }
}

