/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import org.hl7.fhir.instance.formats.JsonComposerBase;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.AdverseReaction;
import org.hl7.fhir.instance.model.Age;
import org.hl7.fhir.instance.model.Alert;
import org.hl7.fhir.instance.model.AllergyIntolerance;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.Binary;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CarePlan;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Composition;
import org.hl7.fhir.instance.model.ConceptMap;
import org.hl7.fhir.instance.model.Condition;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.Count;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.DeviceObservationReport;
import org.hl7.fhir.instance.model.DiagnosticOrder;
import org.hl7.fhir.instance.model.DiagnosticReport;
import org.hl7.fhir.instance.model.Distance;
import org.hl7.fhir.instance.model.DocumentManifest;
import org.hl7.fhir.instance.model.DocumentReference;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.FamilyHistory;
import org.hl7.fhir.instance.model.Group;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.ImagingStudy;
import org.hl7.fhir.instance.model.Immunization;
import org.hl7.fhir.instance.model.ImmunizationRecommendation;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.List_;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Media;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.MedicationAdministration;
import org.hl7.fhir.instance.model.MedicationDispense;
import org.hl7.fhir.instance.model.MedicationPrescription;
import org.hl7.fhir.instance.model.MedicationStatement;
import org.hl7.fhir.instance.model.MessageHeader;
import org.hl7.fhir.instance.model.Money;
import org.hl7.fhir.instance.model.Narrative;
import org.hl7.fhir.instance.model.Observation;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Order;
import org.hl7.fhir.instance.model.OrderResponse;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Other;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Procedure;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Provenance;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Query;
import org.hl7.fhir.instance.model.Questionnaire;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.RelatedPerson;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.SampledData;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.SecurityEvent;
import org.hl7.fhir.instance.model.Specimen;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Substance;
import org.hl7.fhir.instance.model.Supply;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.UuidType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

public class JsonComposer
extends JsonComposerBase {
    private void composeElement(Element element) throws Exception {
        if (element.getXmlId() != null) {
            this.prop("id", element.getXmlId());
        }
        if (element.getExtensions().size() > 0) {
            this.openArray("extension");
            for (Extension extension : element.getExtensions()) {
                this.composeExtension(null, extension);
            }
            this.closeArray();
        }
    }

    private void composeBackbone(BackboneElement backboneElement) throws Exception {
        this.composeElement(backboneElement);
        if (backboneElement.getModifierExtensions().size() > 0) {
            this.openArray("modifierExtension");
            for (Extension extension : backboneElement.getModifierExtensions()) {
                this.composeExtension(null, extension);
            }
            this.closeArray();
        }
    }

    private <E extends Enum<E>> void composeEnumerationCore(String string, Enumeration<E> enumeration, EnumFactory enumFactory, boolean bl) throws Exception {
        if (enumeration != null && enumeration.getValue() != null) {
            this.prop(string, enumFactory.toCode((Enum<?>)enumeration.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private <E extends Enum<E>> void composeEnumerationExtras(String string, Enumeration<E> enumeration, EnumFactory enumFactory, boolean bl) throws Exception {
        if (enumeration != null && (!Utilities.noString(enumeration.getXmlId()) || enumeration.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(enumeration);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeIdCore(String string, IdType idType, boolean bl) throws Exception {
        if (idType != null && !Utilities.noString(idType.getValue())) {
            this.prop(string, this.toString(idType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeIdExtras(String string, IdType idType, boolean bl) throws Exception {
        if (idType != null && (!Utilities.noString(idType.getXmlId()) || idType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(idType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeBase64BinaryCore(String string, Base64BinaryType base64BinaryType, boolean bl) throws Exception {
        if (base64BinaryType != null && base64BinaryType.getValue() != null) {
            this.prop(string, JsonComposer.toString(base64BinaryType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeBase64BinaryExtras(String string, Base64BinaryType base64BinaryType, boolean bl) throws Exception {
        if (base64BinaryType != null && (!Utilities.noString(base64BinaryType.getXmlId()) || base64BinaryType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(base64BinaryType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeDateTimeCore(String string, DateTimeType dateTimeType, boolean bl) throws Exception {
        if (dateTimeType != null && dateTimeType.getValue() != null) {
            this.prop(string, this.toString(dateTimeType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeDateTimeExtras(String string, DateTimeType dateTimeType, boolean bl) throws Exception {
        if (dateTimeType != null && (!Utilities.noString(dateTimeType.getXmlId()) || dateTimeType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(dateTimeType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeIntegerCore(String string, IntegerType integerType, boolean bl) throws Exception {
        if (integerType != null) {
            this.prop(string, integerType.getValue());
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeIntegerExtras(String string, IntegerType integerType, boolean bl) throws Exception {
        if (integerType != null && (!Utilities.noString(integerType.getXmlId()) || integerType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(integerType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeOidCore(String string, OidType oidType, boolean bl) throws Exception {
        if (oidType != null && !Utilities.noString(oidType.getValue())) {
            this.prop(string, this.toString(oidType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeOidExtras(String string, OidType oidType, boolean bl) throws Exception {
        if (oidType != null && (!Utilities.noString(oidType.getXmlId()) || oidType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(oidType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeStringCore(String string, StringType stringType, boolean bl) throws Exception {
        if (stringType != null && !Utilities.noString(stringType.getValue())) {
            this.prop(string, this.toString(stringType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeStringExtras(String string, StringType stringType, boolean bl) throws Exception {
        if (stringType != null && (!Utilities.noString(stringType.getXmlId()) || stringType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(stringType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeBooleanCore(String string, BooleanType booleanType, boolean bl) throws Exception {
        if (booleanType != null) {
            this.prop(string, booleanType.getValue());
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeBooleanExtras(String string, BooleanType booleanType, boolean bl) throws Exception {
        if (booleanType != null && (!Utilities.noString(booleanType.getXmlId()) || booleanType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(booleanType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeUuidCore(String string, UuidType uuidType, boolean bl) throws Exception {
        if (uuidType != null && !Utilities.noString(uuidType.getValue())) {
            this.prop(string, this.toString(uuidType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeUuidExtras(String string, UuidType uuidType, boolean bl) throws Exception {
        if (uuidType != null && (!Utilities.noString(uuidType.getXmlId()) || uuidType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(uuidType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeCodeCore(String string, CodeType codeType, boolean bl) throws Exception {
        if (codeType != null && !Utilities.noString(codeType.getValue())) {
            this.prop(string, this.toString(codeType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeCodeExtras(String string, CodeType codeType, boolean bl) throws Exception {
        if (codeType != null && (!Utilities.noString(codeType.getXmlId()) || codeType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(codeType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeDateCore(String string, DateType dateType, boolean bl) throws Exception {
        if (dateType != null && dateType.getValue() != null) {
            this.prop(string, this.toString(dateType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeDateExtras(String string, DateType dateType, boolean bl) throws Exception {
        if (dateType != null && (!Utilities.noString(dateType.getXmlId()) || dateType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(dateType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeUriCore(String string, UriType uriType, boolean bl) throws Exception {
        if (uriType != null && uriType.getValue() != null) {
            this.prop(string, this.toString(uriType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeUriExtras(String string, UriType uriType, boolean bl) throws Exception {
        if (uriType != null && (!Utilities.noString(uriType.getXmlId()) || uriType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(uriType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeInstantCore(String string, InstantType instantType, boolean bl) throws Exception {
        if (instantType != null && instantType.getValue() != null) {
            this.prop(string, this.toString(instantType.getValue()));
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeInstantExtras(String string, InstantType instantType, boolean bl) throws Exception {
        if (instantType != null && (!Utilities.noString(instantType.getXmlId()) || instantType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(instantType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeDecimalCore(String string, DecimalType decimalType, boolean bl) throws Exception {
        if (decimalType != null && decimalType.getValue() != null) {
            this.prop(string, decimalType.getValue());
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeDecimalExtras(String string, DecimalType decimalType, boolean bl) throws Exception {
        if (decimalType != null && (!Utilities.noString(decimalType.getXmlId()) || decimalType.hasExtensions())) {
            this.open(bl ? null : "_" + string);
            this.composeElement(decimalType);
            this.close();
        } else if (bl) {
            this.writeNull(string);
        }
    }

    private void composeExtension(String string, Extension extension) throws Exception {
        if (extension != null) {
            this.open(string);
            this.composeElement(extension);
            this.composeUriCore("url", extension.getUrl(), false);
            this.composeUriExtras("url", extension.getUrl(), false);
            this.composeType("value", extension.getValue());
            this.close();
        }
    }

    private void composeNarrative(String string, Narrative narrative) throws Exception {
        if (narrative != null) {
            this.open(string);
            this.composeElement(narrative);
            if (narrative.getStatus() != null) {
                this.composeEnumerationCore("status", narrative.getStatus(), new Narrative.NarrativeStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", narrative.getStatus(), new Narrative.NarrativeStatusEnumFactory(), false);
            }
            this.composeXhtml("div", narrative.getDiv());
            this.close();
        }
    }

    private void composePeriod(String string, Period period) throws Exception {
        if (period != null) {
            this.open(string);
            this.composeElement(period);
            this.composeDateTimeCore("start", period.getStart(), false);
            this.composeDateTimeExtras("start", period.getStart(), false);
            this.composeDateTimeCore("end", period.getEnd(), false);
            this.composeDateTimeExtras("end", period.getEnd(), false);
            this.close();
        }
    }

    private void composeCoding(String string, Coding coding) throws Exception {
        if (coding != null) {
            this.open(string);
            this.composeElement(coding);
            this.composeUriCore("system", coding.getSystem(), false);
            this.composeUriExtras("system", coding.getSystem(), false);
            this.composeStringCore("version", coding.getVersion(), false);
            this.composeStringExtras("version", coding.getVersion(), false);
            this.composeCodeCore("code", coding.getCode(), false);
            this.composeCodeExtras("code", coding.getCode(), false);
            this.composeStringCore("display", coding.getDisplay(), false);
            this.composeStringExtras("display", coding.getDisplay(), false);
            this.composeBooleanCore("primary", coding.getPrimary(), false);
            this.composeBooleanExtras("primary", coding.getPrimary(), false);
            this.composeResourceReference("valueSet", coding.getValueSet());
            this.close();
        }
    }

    private void composeRange(String string, Range range) throws Exception {
        if (range != null) {
            this.open(string);
            this.composeElement(range);
            this.composeQuantity("low", range.getLow());
            this.composeQuantity("high", range.getHigh());
            this.close();
        }
    }

    private void composeQuantity(String string, Quantity quantity) throws Exception {
        if (quantity != null) {
            this.open(string);
            this.composeElement(quantity);
            this.composeDecimalCore("value", quantity.getValue(), false);
            this.composeDecimalExtras("value", quantity.getValue(), false);
            if (quantity.getComparator() != null) {
                this.composeEnumerationCore("comparator", quantity.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
                this.composeEnumerationExtras("comparator", quantity.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
            }
            this.composeStringCore("units", quantity.getUnits(), false);
            this.composeStringExtras("units", quantity.getUnits(), false);
            this.composeUriCore("system", quantity.getSystem(), false);
            this.composeUriExtras("system", quantity.getSystem(), false);
            this.composeCodeCore("code", quantity.getCode(), false);
            this.composeCodeExtras("code", quantity.getCode(), false);
            this.close();
        }
    }

    private void composeAttachment(String string, Attachment attachment) throws Exception {
        if (attachment != null) {
            this.open(string);
            this.composeElement(attachment);
            this.composeCodeCore("contentType", attachment.getContentType(), false);
            this.composeCodeExtras("contentType", attachment.getContentType(), false);
            this.composeCodeCore("language", attachment.getLanguage(), false);
            this.composeCodeExtras("language", attachment.getLanguage(), false);
            this.composeBase64BinaryCore("data", attachment.getData(), false);
            this.composeBase64BinaryExtras("data", attachment.getData(), false);
            this.composeUriCore("url", attachment.getUrl(), false);
            this.composeUriExtras("url", attachment.getUrl(), false);
            this.composeIntegerCore("size", attachment.getSize(), false);
            this.composeIntegerExtras("size", attachment.getSize(), false);
            this.composeBase64BinaryCore("hash", attachment.getHash(), false);
            this.composeBase64BinaryExtras("hash", attachment.getHash(), false);
            this.composeStringCore("title", attachment.getTitle(), false);
            this.composeStringExtras("title", attachment.getTitle(), false);
            this.close();
        }
    }

    private void composeRatio(String string, Ratio ratio) throws Exception {
        if (ratio != null) {
            this.open(string);
            this.composeElement(ratio);
            this.composeQuantity("numerator", ratio.getNumerator());
            this.composeQuantity("denominator", ratio.getDenominator());
            this.close();
        }
    }

    private void composeSampledData(String string, SampledData sampledData) throws Exception {
        if (sampledData != null) {
            this.open(string);
            this.composeElement(sampledData);
            this.composeQuantity("origin", sampledData.getOrigin());
            this.composeDecimalCore("period", sampledData.getPeriod(), false);
            this.composeDecimalExtras("period", sampledData.getPeriod(), false);
            this.composeDecimalCore("factor", sampledData.getFactor(), false);
            this.composeDecimalExtras("factor", sampledData.getFactor(), false);
            this.composeDecimalCore("lowerLimit", sampledData.getLowerLimit(), false);
            this.composeDecimalExtras("lowerLimit", sampledData.getLowerLimit(), false);
            this.composeDecimalCore("upperLimit", sampledData.getUpperLimit(), false);
            this.composeDecimalExtras("upperLimit", sampledData.getUpperLimit(), false);
            this.composeIntegerCore("dimensions", sampledData.getDimensions(), false);
            this.composeIntegerExtras("dimensions", sampledData.getDimensions(), false);
            this.composeStringCore("data", sampledData.getData(), false);
            this.composeStringExtras("data", sampledData.getData(), false);
            this.close();
        }
    }

    private void composeResourceReference(String string, ResourceReference resourceReference) throws Exception {
        if (resourceReference != null) {
            this.open(string);
            this.composeElement(resourceReference);
            this.composeStringCore("reference", resourceReference.getReference(), false);
            this.composeStringExtras("reference", resourceReference.getReference(), false);
            this.composeStringCore("display", resourceReference.getDisplay(), false);
            this.composeStringExtras("display", resourceReference.getDisplay(), false);
            this.close();
        }
    }

    private void composeCodeableConcept(String string, CodeableConcept codeableConcept) throws Exception {
        if (codeableConcept != null) {
            this.open(string);
            this.composeElement(codeableConcept);
            if (codeableConcept.getCoding().size() > 0) {
                this.openArray("coding");
                for (Coding coding : codeableConcept.getCoding()) {
                    this.composeCoding(null, coding);
                }
                this.closeArray();
            }
            this.composeStringCore("text", codeableConcept.getText(), false);
            this.composeStringExtras("text", codeableConcept.getText(), false);
            this.close();
        }
    }

    private void composeIdentifier(String string, Identifier identifier) throws Exception {
        if (identifier != null) {
            this.open(string);
            this.composeElement(identifier);
            if (identifier.getUse() != null) {
                this.composeEnumerationCore("use", identifier.getUse(), new Identifier.IdentifierUseEnumFactory(), false);
                this.composeEnumerationExtras("use", identifier.getUse(), new Identifier.IdentifierUseEnumFactory(), false);
            }
            this.composeStringCore("label", identifier.getLabel(), false);
            this.composeStringExtras("label", identifier.getLabel(), false);
            this.composeUriCore("system", identifier.getSystem(), false);
            this.composeUriExtras("system", identifier.getSystem(), false);
            this.composeStringCore("value", identifier.getValue(), false);
            this.composeStringExtras("value", identifier.getValue(), false);
            this.composePeriod("period", identifier.getPeriod());
            this.composeResourceReference("assigner", identifier.getAssigner());
            this.close();
        }
    }

    private void composeAge(String string, Age age) throws Exception {
        if (age != null) {
            this.open(string);
            this.composeElement(age);
            this.composeDecimalCore("value", age.getValue(), false);
            this.composeDecimalExtras("value", age.getValue(), false);
            if (age.getComparator() != null) {
                this.composeEnumerationCore("comparator", age.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
                this.composeEnumerationExtras("comparator", age.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
            }
            this.composeStringCore("units", age.getUnits(), false);
            this.composeStringExtras("units", age.getUnits(), false);
            this.composeUriCore("system", age.getSystem(), false);
            this.composeUriExtras("system", age.getSystem(), false);
            this.composeCodeCore("code", age.getCode(), false);
            this.composeCodeExtras("code", age.getCode(), false);
            this.close();
        }
    }

    private void composeCount(String string, Count count) throws Exception {
        if (count != null) {
            this.open(string);
            this.composeElement(count);
            this.composeDecimalCore("value", count.getValue(), false);
            this.composeDecimalExtras("value", count.getValue(), false);
            if (count.getComparator() != null) {
                this.composeEnumerationCore("comparator", count.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
                this.composeEnumerationExtras("comparator", count.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
            }
            this.composeStringCore("units", count.getUnits(), false);
            this.composeStringExtras("units", count.getUnits(), false);
            this.composeUriCore("system", count.getSystem(), false);
            this.composeUriExtras("system", count.getSystem(), false);
            this.composeCodeCore("code", count.getCode(), false);
            this.composeCodeExtras("code", count.getCode(), false);
            this.close();
        }
    }

    private void composeMoney(String string, Money money) throws Exception {
        if (money != null) {
            this.open(string);
            this.composeElement(money);
            this.composeDecimalCore("value", money.getValue(), false);
            this.composeDecimalExtras("value", money.getValue(), false);
            if (money.getComparator() != null) {
                this.composeEnumerationCore("comparator", money.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
                this.composeEnumerationExtras("comparator", money.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
            }
            this.composeStringCore("units", money.getUnits(), false);
            this.composeStringExtras("units", money.getUnits(), false);
            this.composeUriCore("system", money.getSystem(), false);
            this.composeUriExtras("system", money.getSystem(), false);
            this.composeCodeCore("code", money.getCode(), false);
            this.composeCodeExtras("code", money.getCode(), false);
            this.close();
        }
    }

    private void composeDistance(String string, Distance distance) throws Exception {
        if (distance != null) {
            this.open(string);
            this.composeElement(distance);
            this.composeDecimalCore("value", distance.getValue(), false);
            this.composeDecimalExtras("value", distance.getValue(), false);
            if (distance.getComparator() != null) {
                this.composeEnumerationCore("comparator", distance.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
                this.composeEnumerationExtras("comparator", distance.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
            }
            this.composeStringCore("units", distance.getUnits(), false);
            this.composeStringExtras("units", distance.getUnits(), false);
            this.composeUriCore("system", distance.getSystem(), false);
            this.composeUriExtras("system", distance.getSystem(), false);
            this.composeCodeCore("code", distance.getCode(), false);
            this.composeCodeExtras("code", distance.getCode(), false);
            this.close();
        }
    }

    private void composeDuration(String string, Duration duration) throws Exception {
        if (duration != null) {
            this.open(string);
            this.composeElement(duration);
            this.composeDecimalCore("value", duration.getValue(), false);
            this.composeDecimalExtras("value", duration.getValue(), false);
            if (duration.getComparator() != null) {
                this.composeEnumerationCore("comparator", duration.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
                this.composeEnumerationExtras("comparator", duration.getComparator(), new Quantity.QuantityComparatorEnumFactory(), false);
            }
            this.composeStringCore("units", duration.getUnits(), false);
            this.composeStringExtras("units", duration.getUnits(), false);
            this.composeUriCore("system", duration.getSystem(), false);
            this.composeUriExtras("system", duration.getSystem(), false);
            this.composeCodeCore("code", duration.getCode(), false);
            this.composeCodeExtras("code", duration.getCode(), false);
            this.close();
        }
    }

    private void composeSchedule(String string, Schedule schedule) throws Exception {
        if (schedule != null) {
            this.open(string);
            this.composeElement(schedule);
            if (schedule.getEvent().size() > 0) {
                this.openArray("event");
                for (Period period : schedule.getEvent()) {
                    this.composePeriod(null, period);
                }
                this.closeArray();
            }
            this.composeScheduleScheduleRepeatComponent("repeat", schedule.getRepeat());
            this.close();
        }
    }

    private void composeScheduleScheduleRepeatComponent(String string, Schedule.ScheduleRepeatComponent scheduleRepeatComponent) throws Exception {
        if (scheduleRepeatComponent != null) {
            this.open(string);
            this.composeElement(scheduleRepeatComponent);
            this.composeIntegerCore("frequency", scheduleRepeatComponent.getFrequency(), false);
            this.composeIntegerExtras("frequency", scheduleRepeatComponent.getFrequency(), false);
            if (scheduleRepeatComponent.getWhen() != null) {
                this.composeEnumerationCore("when", scheduleRepeatComponent.getWhen(), new Schedule.EventTimingEnumFactory(), false);
                this.composeEnumerationExtras("when", scheduleRepeatComponent.getWhen(), new Schedule.EventTimingEnumFactory(), false);
            }
            this.composeDecimalCore("duration", scheduleRepeatComponent.getDuration(), false);
            this.composeDecimalExtras("duration", scheduleRepeatComponent.getDuration(), false);
            if (scheduleRepeatComponent.getUnits() != null) {
                this.composeEnumerationCore("units", scheduleRepeatComponent.getUnits(), new Schedule.UnitsOfTimeEnumFactory(), false);
                this.composeEnumerationExtras("units", scheduleRepeatComponent.getUnits(), new Schedule.UnitsOfTimeEnumFactory(), false);
            }
            this.composeIntegerCore("count", scheduleRepeatComponent.getCount(), false);
            this.composeIntegerExtras("count", scheduleRepeatComponent.getCount(), false);
            this.composeDateTimeCore("end", scheduleRepeatComponent.getEnd(), false);
            this.composeDateTimeExtras("end", scheduleRepeatComponent.getEnd(), false);
            this.close();
        }
    }

    private void composeContact(String string, Contact contact) throws Exception {
        if (contact != null) {
            this.open(string);
            this.composeElement(contact);
            if (contact.getSystem() != null) {
                this.composeEnumerationCore("system", contact.getSystem(), new Contact.ContactSystemEnumFactory(), false);
                this.composeEnumerationExtras("system", contact.getSystem(), new Contact.ContactSystemEnumFactory(), false);
            }
            this.composeStringCore("value", contact.getValue(), false);
            this.composeStringExtras("value", contact.getValue(), false);
            if (contact.getUse() != null) {
                this.composeEnumerationCore("use", contact.getUse(), new Contact.ContactUseEnumFactory(), false);
                this.composeEnumerationExtras("use", contact.getUse(), new Contact.ContactUseEnumFactory(), false);
            }
            this.composePeriod("period", contact.getPeriod());
            this.close();
        }
    }

    private void composeAddress(String string, Address address) throws Exception {
        if (address != null) {
            this.open(string);
            this.composeElement(address);
            if (address.getUse() != null) {
                this.composeEnumerationCore("use", address.getUse(), new Address.AddressUseEnumFactory(), false);
                this.composeEnumerationExtras("use", address.getUse(), new Address.AddressUseEnumFactory(), false);
            }
            this.composeStringCore("text", address.getText(), false);
            this.composeStringExtras("text", address.getText(), false);
            if (address.getLine().size() > 0) {
                this.openArray("line");
                for (StringType stringType : address.getLine()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(address.getLine())) {
                    this.openArray("_line");
                    for (StringType stringType : address.getLine()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            this.composeStringCore("city", address.getCity(), false);
            this.composeStringExtras("city", address.getCity(), false);
            this.composeStringCore("state", address.getState(), false);
            this.composeStringExtras("state", address.getState(), false);
            this.composeStringCore("zip", address.getZip(), false);
            this.composeStringExtras("zip", address.getZip(), false);
            this.composeStringCore("country", address.getCountry(), false);
            this.composeStringExtras("country", address.getCountry(), false);
            this.composePeriod("period", address.getPeriod());
            this.close();
        }
    }

    private void composeHumanName(String string, HumanName humanName) throws Exception {
        if (humanName != null) {
            this.open(string);
            this.composeElement(humanName);
            if (humanName.getUse() != null) {
                this.composeEnumerationCore("use", humanName.getUse(), new HumanName.NameUseEnumFactory(), false);
                this.composeEnumerationExtras("use", humanName.getUse(), new HumanName.NameUseEnumFactory(), false);
            }
            this.composeStringCore("text", humanName.getText(), false);
            this.composeStringExtras("text", humanName.getText(), false);
            if (humanName.getFamily().size() > 0) {
                this.openArray("family");
                for (StringType stringType : humanName.getFamily()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(humanName.getFamily())) {
                    this.openArray("_family");
                    for (StringType stringType : humanName.getFamily()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            if (humanName.getGiven().size() > 0) {
                this.openArray("given");
                for (StringType stringType : humanName.getGiven()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(humanName.getGiven())) {
                    this.openArray("_given");
                    for (StringType stringType : humanName.getGiven()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            if (humanName.getPrefix().size() > 0) {
                this.openArray("prefix");
                for (StringType stringType : humanName.getPrefix()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(humanName.getPrefix())) {
                    this.openArray("_prefix");
                    for (StringType stringType : humanName.getPrefix()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            if (humanName.getSuffix().size() > 0) {
                this.openArray("suffix");
                for (StringType stringType : humanName.getSuffix()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(humanName.getSuffix())) {
                    this.openArray("_suffix");
                    for (StringType stringType : humanName.getSuffix()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            this.composePeriod("period", humanName.getPeriod());
            this.close();
        }
    }

    private void composeResourceElements(Resource resource) throws Exception {
        this.composeBackbone(resource);
        if (resource.getText() != null) {
            this.composeNarrative("text", resource.getText());
        }
        if (resource.getContained().size() > 0) {
            this.openArray("contained");
            for (Resource resource2 : resource.getContained()) {
                if (resource2.getXmlId() == null) {
                    throw new Exception("Contained Resource has no id - one must be assigned");
                }
                this.open(null);
                this.composeResource(resource2);
                this.close();
            }
            this.closeArray();
        }
    }

    private void composeAdverseReaction(String string, AdverseReaction adverseReaction) throws Exception {
        if (adverseReaction != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(adverseReaction);
            if (adverseReaction.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : adverseReaction.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeDateTimeCore("date", adverseReaction.getDate(), false);
            this.composeDateTimeExtras("date", adverseReaction.getDate(), false);
            this.composeResourceReference("subject", adverseReaction.getSubject());
            this.composeBooleanCore("didNotOccurFlag", adverseReaction.getDidNotOccurFlag(), false);
            this.composeBooleanExtras("didNotOccurFlag", adverseReaction.getDidNotOccurFlag(), false);
            this.composeResourceReference("recorder", adverseReaction.getRecorder());
            if (adverseReaction.getSymptom().size() > 0) {
                this.openArray("symptom");
                for (AdverseReaction.AdverseReactionSymptomComponent adverseReactionSymptomComponent : adverseReaction.getSymptom()) {
                    this.composeAdverseReactionAdverseReactionSymptomComponent(null, adverseReactionSymptomComponent);
                }
                this.closeArray();
            }
            if (adverseReaction.getExposure().size() > 0) {
                this.openArray("exposure");
                for (AdverseReaction.AdverseReactionExposureComponent adverseReactionExposureComponent : adverseReaction.getExposure()) {
                    this.composeAdverseReactionAdverseReactionExposureComponent(null, adverseReactionExposureComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeAdverseReactionAdverseReactionSymptomComponent(String string, AdverseReaction.AdverseReactionSymptomComponent adverseReactionSymptomComponent) throws Exception {
        if (adverseReactionSymptomComponent != null) {
            this.open(string);
            this.composeBackbone(adverseReactionSymptomComponent);
            this.composeCodeableConcept("code", adverseReactionSymptomComponent.getCode());
            if (adverseReactionSymptomComponent.getSeverity() != null) {
                this.composeEnumerationCore("severity", adverseReactionSymptomComponent.getSeverity(), new AdverseReaction.ReactionSeverityEnumFactory(), false);
                this.composeEnumerationExtras("severity", adverseReactionSymptomComponent.getSeverity(), new AdverseReaction.ReactionSeverityEnumFactory(), false);
            }
            this.close();
        }
    }

    private void composeAdverseReactionAdverseReactionExposureComponent(String string, AdverseReaction.AdverseReactionExposureComponent adverseReactionExposureComponent) throws Exception {
        if (adverseReactionExposureComponent != null) {
            this.open(string);
            this.composeBackbone(adverseReactionExposureComponent);
            this.composeDateTimeCore("date", adverseReactionExposureComponent.getDate(), false);
            this.composeDateTimeExtras("date", adverseReactionExposureComponent.getDate(), false);
            if (adverseReactionExposureComponent.getType() != null) {
                this.composeEnumerationCore("type", adverseReactionExposureComponent.getType(), new AdverseReaction.ExposureTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", adverseReactionExposureComponent.getType(), new AdverseReaction.ExposureTypeEnumFactory(), false);
            }
            if (adverseReactionExposureComponent.getCausalityExpectation() != null) {
                this.composeEnumerationCore("causalityExpectation", adverseReactionExposureComponent.getCausalityExpectation(), new AdverseReaction.CausalityExpectationEnumFactory(), false);
                this.composeEnumerationExtras("causalityExpectation", adverseReactionExposureComponent.getCausalityExpectation(), new AdverseReaction.CausalityExpectationEnumFactory(), false);
            }
            this.composeResourceReference("substance", adverseReactionExposureComponent.getSubstance());
            this.close();
        }
    }

    private void composeAlert(String string, Alert alert) throws Exception {
        if (alert != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(alert);
            if (alert.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier identifier : alert.getIdentifier()) {
                    this.composeIdentifier(null, identifier);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("category", alert.getCategory());
            if (alert.getStatus() != null) {
                this.composeEnumerationCore("status", alert.getStatus(), new Alert.AlertStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", alert.getStatus(), new Alert.AlertStatusEnumFactory(), false);
            }
            this.composeResourceReference("subject", alert.getSubject());
            this.composeResourceReference("author", alert.getAuthor());
            this.composeStringCore("note", alert.getNote(), false);
            this.composeStringExtras("note", alert.getNote(), false);
        }
    }

    private void composeAllergyIntolerance(String string, AllergyIntolerance allergyIntolerance) throws Exception {
        if (allergyIntolerance != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(allergyIntolerance);
            if (allergyIntolerance.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier type : allergyIntolerance.getIdentifier()) {
                    this.composeIdentifier(null, type);
                }
                this.closeArray();
            }
            if (allergyIntolerance.getCriticality() != null) {
                this.composeEnumerationCore("criticality", allergyIntolerance.getCriticality(), new AllergyIntolerance.CriticalityEnumFactory(), false);
                this.composeEnumerationExtras("criticality", allergyIntolerance.getCriticality(), new AllergyIntolerance.CriticalityEnumFactory(), false);
            }
            if (allergyIntolerance.getSensitivityType() != null) {
                this.composeEnumerationCore("sensitivityType", allergyIntolerance.getSensitivityType(), new AllergyIntolerance.SensitivitytypeEnumFactory(), false);
                this.composeEnumerationExtras("sensitivityType", allergyIntolerance.getSensitivityType(), new AllergyIntolerance.SensitivitytypeEnumFactory(), false);
            }
            this.composeDateTimeCore("recordedDate", allergyIntolerance.getRecordedDate(), false);
            this.composeDateTimeExtras("recordedDate", allergyIntolerance.getRecordedDate(), false);
            if (allergyIntolerance.getStatus() != null) {
                this.composeEnumerationCore("status", allergyIntolerance.getStatus(), new AllergyIntolerance.SensitivitystatusEnumFactory(), false);
                this.composeEnumerationExtras("status", allergyIntolerance.getStatus(), new AllergyIntolerance.SensitivitystatusEnumFactory(), false);
            }
            this.composeResourceReference("subject", allergyIntolerance.getSubject());
            this.composeResourceReference("recorder", allergyIntolerance.getRecorder());
            this.composeResourceReference("substance", allergyIntolerance.getSubstance());
            if (allergyIntolerance.getReaction().size() > 0) {
                this.openArray("reaction");
                for (ResourceReference resourceReference : allergyIntolerance.getReaction()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (allergyIntolerance.getSensitivityTest().size() > 0) {
                this.openArray("sensitivityTest");
                for (ResourceReference resourceReference : allergyIntolerance.getSensitivityTest()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
        }
    }

    private void composeCarePlan(String string, CarePlan carePlan) throws Exception {
        if (carePlan != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(carePlan);
            if (carePlan.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : carePlan.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("patient", carePlan.getPatient());
            if (carePlan.getStatus() != null) {
                this.composeEnumerationCore("status", carePlan.getStatus(), new CarePlan.CarePlanStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", carePlan.getStatus(), new CarePlan.CarePlanStatusEnumFactory(), false);
            }
            this.composePeriod("period", carePlan.getPeriod());
            this.composeDateTimeCore("modified", carePlan.getModified(), false);
            this.composeDateTimeExtras("modified", carePlan.getModified(), false);
            if (carePlan.getConcern().size() > 0) {
                this.openArray("concern");
                for (ResourceReference resourceReference : carePlan.getConcern()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (carePlan.getParticipant().size() > 0) {
                this.openArray("participant");
                for (CarePlan.CarePlanParticipantComponent carePlanParticipantComponent : carePlan.getParticipant()) {
                    this.composeCarePlanCarePlanParticipantComponent(null, carePlanParticipantComponent);
                }
                this.closeArray();
            }
            if (carePlan.getGoal().size() > 0) {
                this.openArray("goal");
                for (CarePlan.CarePlanGoalComponent carePlanGoalComponent : carePlan.getGoal()) {
                    this.composeCarePlanCarePlanGoalComponent(null, carePlanGoalComponent);
                }
                this.closeArray();
            }
            if (carePlan.getActivity().size() > 0) {
                this.openArray("activity");
                for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : carePlan.getActivity()) {
                    this.composeCarePlanCarePlanActivityComponent(null, carePlanActivityComponent);
                }
                this.closeArray();
            }
            this.composeStringCore("notes", carePlan.getNotes(), false);
            this.composeStringExtras("notes", carePlan.getNotes(), false);
        }
    }

    private void composeCarePlanCarePlanParticipantComponent(String string, CarePlan.CarePlanParticipantComponent carePlanParticipantComponent) throws Exception {
        if (carePlanParticipantComponent != null) {
            this.open(string);
            this.composeBackbone(carePlanParticipantComponent);
            this.composeCodeableConcept("role", carePlanParticipantComponent.getRole());
            this.composeResourceReference("member", carePlanParticipantComponent.getMember());
            this.close();
        }
    }

    private void composeCarePlanCarePlanGoalComponent(String string, CarePlan.CarePlanGoalComponent carePlanGoalComponent) throws Exception {
        if (carePlanGoalComponent != null) {
            this.open(string);
            this.composeBackbone(carePlanGoalComponent);
            this.composeStringCore("description", carePlanGoalComponent.getDescription(), false);
            this.composeStringExtras("description", carePlanGoalComponent.getDescription(), false);
            if (carePlanGoalComponent.getStatus() != null) {
                this.composeEnumerationCore("status", carePlanGoalComponent.getStatus(), new CarePlan.CarePlanGoalStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", carePlanGoalComponent.getStatus(), new CarePlan.CarePlanGoalStatusEnumFactory(), false);
            }
            this.composeStringCore("notes", carePlanGoalComponent.getNotes(), false);
            this.composeStringExtras("notes", carePlanGoalComponent.getNotes(), false);
            if (carePlanGoalComponent.getConcern().size() > 0) {
                this.openArray("concern");
                for (ResourceReference resourceReference : carePlanGoalComponent.getConcern()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeCarePlanCarePlanActivityComponent(String string, CarePlan.CarePlanActivityComponent carePlanActivityComponent) throws Exception {
        if (carePlanActivityComponent != null) {
            this.open(string);
            this.composeBackbone(carePlanActivityComponent);
            if (carePlanActivityComponent.getGoal().size() > 0) {
                this.openArray("goal");
                for (StringType type : carePlanActivityComponent.getGoal()) {
                    this.composeStringCore(null, type, true);
                }
                this.closeArray();
                if (this.anyHasExtras(carePlanActivityComponent.getGoal())) {
                    this.openArray("_goal");
                    for (StringType stringType : carePlanActivityComponent.getGoal()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            if (carePlanActivityComponent.getStatus() != null) {
                this.composeEnumerationCore("status", carePlanActivityComponent.getStatus(), new CarePlan.CarePlanActivityStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", carePlanActivityComponent.getStatus(), new CarePlan.CarePlanActivityStatusEnumFactory(), false);
            }
            this.composeBooleanCore("prohibited", carePlanActivityComponent.getProhibited(), false);
            this.composeBooleanExtras("prohibited", carePlanActivityComponent.getProhibited(), false);
            if (carePlanActivityComponent.getActionResulting().size() > 0) {
                this.openArray("actionResulting");
                for (ResourceReference resourceReference : carePlanActivityComponent.getActionResulting()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.composeStringCore("notes", carePlanActivityComponent.getNotes(), false);
            this.composeStringExtras("notes", carePlanActivityComponent.getNotes(), false);
            this.composeResourceReference("detail", carePlanActivityComponent.getDetail());
            this.composeCarePlanCarePlanActivitySimpleComponent("simple", carePlanActivityComponent.getSimple());
            this.close();
        }
    }

    private void composeCarePlanCarePlanActivitySimpleComponent(String string, CarePlan.CarePlanActivitySimpleComponent carePlanActivitySimpleComponent) throws Exception {
        if (carePlanActivitySimpleComponent != null) {
            this.open(string);
            this.composeBackbone(carePlanActivitySimpleComponent);
            if (carePlanActivitySimpleComponent.getCategory() != null) {
                this.composeEnumerationCore("category", carePlanActivitySimpleComponent.getCategory(), new CarePlan.CarePlanActivityCategoryEnumFactory(), false);
                this.composeEnumerationExtras("category", carePlanActivitySimpleComponent.getCategory(), new CarePlan.CarePlanActivityCategoryEnumFactory(), false);
            }
            this.composeCodeableConcept("code", carePlanActivitySimpleComponent.getCode());
            this.composeType("timing", carePlanActivitySimpleComponent.getTiming());
            this.composeResourceReference("location", carePlanActivitySimpleComponent.getLocation());
            if (carePlanActivitySimpleComponent.getPerformer().size() > 0) {
                this.openArray("performer");
                for (ResourceReference resourceReference : carePlanActivitySimpleComponent.getPerformer()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.composeResourceReference("product", carePlanActivitySimpleComponent.getProduct());
            this.composeQuantity("dailyAmount", carePlanActivitySimpleComponent.getDailyAmount());
            this.composeQuantity("quantity", carePlanActivitySimpleComponent.getQuantity());
            this.composeStringCore("details", carePlanActivitySimpleComponent.getDetails(), false);
            this.composeStringExtras("details", carePlanActivitySimpleComponent.getDetails(), false);
            this.close();
        }
    }

    private void composeComposition(String string, Composition composition) throws Exception {
        if (composition != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(composition);
            this.composeIdentifier("identifier", composition.getIdentifier());
            this.composeDateTimeCore("date", composition.getDate(), false);
            this.composeDateTimeExtras("date", composition.getDate(), false);
            this.composeCodeableConcept("type", composition.getType());
            this.composeCodeableConcept("class", composition.getClass_());
            this.composeStringCore("title", composition.getTitle(), false);
            this.composeStringExtras("title", composition.getTitle(), false);
            if (composition.getStatus() != null) {
                this.composeEnumerationCore("status", composition.getStatus(), new Composition.CompositionStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", composition.getStatus(), new Composition.CompositionStatusEnumFactory(), false);
            }
            this.composeCoding("confidentiality", composition.getConfidentiality());
            this.composeResourceReference("subject", composition.getSubject());
            if (composition.getAuthor().size() > 0) {
                this.openArray("author");
                for (ResourceReference element : composition.getAuthor()) {
                    this.composeResourceReference(null, element);
                }
                this.closeArray();
            }
            if (composition.getAttester().size() > 0) {
                this.openArray("attester");
                for (Composition.CompositionAttesterComponent compositionAttesterComponent : composition.getAttester()) {
                    this.composeCompositionCompositionAttesterComponent(null, compositionAttesterComponent);
                }
                this.closeArray();
            }
            this.composeResourceReference("custodian", composition.getCustodian());
            this.composeCompositionCompositionEventComponent("event", composition.getEvent());
            this.composeResourceReference("encounter", composition.getEncounter());
            if (composition.getSection().size() > 0) {
                this.openArray("section");
                for (Composition.SectionComponent sectionComponent : composition.getSection()) {
                    this.composeCompositionSectionComponent(null, sectionComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeCompositionCompositionAttesterComponent(String string, Composition.CompositionAttesterComponent compositionAttesterComponent) throws Exception {
        if (compositionAttesterComponent != null) {
            this.open(string);
            this.composeBackbone(compositionAttesterComponent);
            if (compositionAttesterComponent.getMode().size() > 0) {
                this.openArray("mode");
                for (Enumeration<Composition.CompositionAttestationMode> enumeration : compositionAttesterComponent.getMode()) {
                    this.composeEnumerationCore(null, enumeration, new Composition.CompositionAttestationModeEnumFactory(), true);
                }
                this.closeArray();
                if (this.anyHasExtras(compositionAttesterComponent.getMode())) {
                    this.openArray("_mode");
                    for (Enumeration<Composition.CompositionAttestationMode> enumeration : compositionAttesterComponent.getMode()) {
                        this.composeEnumerationExtras(null, enumeration, new Composition.CompositionAttestationModeEnumFactory(), true);
                    }
                    this.closeArray();
                }
            }
            this.composeDateTimeCore("time", compositionAttesterComponent.getTime(), false);
            this.composeDateTimeExtras("time", compositionAttesterComponent.getTime(), false);
            this.composeResourceReference("party", compositionAttesterComponent.getParty());
            this.close();
        }
    }

    private void composeCompositionCompositionEventComponent(String string, Composition.CompositionEventComponent compositionEventComponent) throws Exception {
        if (compositionEventComponent != null) {
            this.open(string);
            this.composeBackbone(compositionEventComponent);
            if (compositionEventComponent.getCode().size() > 0) {
                this.openArray("code");
                for (CodeableConcept type : compositionEventComponent.getCode()) {
                    this.composeCodeableConcept(null, type);
                }
                this.closeArray();
            }
            this.composePeriod("period", compositionEventComponent.getPeriod());
            if (compositionEventComponent.getDetail().size() > 0) {
                this.openArray("detail");
                for (ResourceReference resourceReference : compositionEventComponent.getDetail()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeCompositionSectionComponent(String string, Composition.SectionComponent sectionComponent) throws Exception {
        if (sectionComponent != null) {
            this.open(string);
            this.composeBackbone(sectionComponent);
            this.composeStringCore("title", sectionComponent.getTitle(), false);
            this.composeStringExtras("title", sectionComponent.getTitle(), false);
            this.composeCodeableConcept("code", sectionComponent.getCode());
            this.composeResourceReference("subject", sectionComponent.getSubject());
            this.composeResourceReference("content", sectionComponent.getContent());
            if (sectionComponent.getSection().size() > 0) {
                this.openArray("section");
                for (Composition.SectionComponent sectionComponent2 : sectionComponent.getSection()) {
                    this.composeCompositionSectionComponent(null, sectionComponent2);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeConceptMap(String string, ConceptMap conceptMap) throws Exception {
        if (conceptMap != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(conceptMap);
            this.composeStringCore("identifier", conceptMap.getIdentifier(), false);
            this.composeStringExtras("identifier", conceptMap.getIdentifier(), false);
            this.composeStringCore("version", conceptMap.getVersion(), false);
            this.composeStringExtras("version", conceptMap.getVersion(), false);
            this.composeStringCore("name", conceptMap.getName(), false);
            this.composeStringExtras("name", conceptMap.getName(), false);
            this.composeStringCore("publisher", conceptMap.getPublisher(), false);
            this.composeStringExtras("publisher", conceptMap.getPublisher(), false);
            if (conceptMap.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact element : conceptMap.getTelecom()) {
                    this.composeContact(null, element);
                }
                this.closeArray();
            }
            this.composeStringCore("description", conceptMap.getDescription(), false);
            this.composeStringExtras("description", conceptMap.getDescription(), false);
            this.composeStringCore("copyright", conceptMap.getCopyright(), false);
            this.composeStringExtras("copyright", conceptMap.getCopyright(), false);
            if (conceptMap.getStatus() != null) {
                this.composeEnumerationCore("status", conceptMap.getStatus(), new ConceptMap.ValuesetStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", conceptMap.getStatus(), new ConceptMap.ValuesetStatusEnumFactory(), false);
            }
            this.composeBooleanCore("experimental", conceptMap.getExperimental(), false);
            this.composeBooleanExtras("experimental", conceptMap.getExperimental(), false);
            this.composeDateTimeCore("date", conceptMap.getDate(), false);
            this.composeDateTimeExtras("date", conceptMap.getDate(), false);
            this.composeResourceReference("source", conceptMap.getSource());
            this.composeResourceReference("target", conceptMap.getTarget());
            if (conceptMap.getConcept().size() > 0) {
                this.openArray("concept");
                for (ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent : conceptMap.getConcept()) {
                    this.composeConceptMapConceptMapConceptComponent(null, conceptMapConceptComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeConceptMapConceptMapConceptComponent(String string, ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent) throws Exception {
        if (conceptMapConceptComponent != null) {
            this.open(string);
            this.composeBackbone(conceptMapConceptComponent);
            this.composeUriCore("system", conceptMapConceptComponent.getSystem(), false);
            this.composeUriExtras("system", conceptMapConceptComponent.getSystem(), false);
            this.composeCodeCore("code", conceptMapConceptComponent.getCode(), false);
            this.composeCodeExtras("code", conceptMapConceptComponent.getCode(), false);
            if (conceptMapConceptComponent.getDependsOn().size() > 0) {
                this.openArray("dependsOn");
                for (ConceptMap.OtherConceptComponent backboneElement : conceptMapConceptComponent.getDependsOn()) {
                    this.composeConceptMapOtherConceptComponent(null, backboneElement);
                }
                this.closeArray();
            }
            if (conceptMapConceptComponent.getMap().size() > 0) {
                this.openArray("map");
                for (ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent : conceptMapConceptComponent.getMap()) {
                    this.composeConceptMapConceptMapConceptMapComponent(null, conceptMapConceptMapComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeConceptMapOtherConceptComponent(String string, ConceptMap.OtherConceptComponent otherConceptComponent) throws Exception {
        if (otherConceptComponent != null) {
            this.open(string);
            this.composeBackbone(otherConceptComponent);
            this.composeUriCore("concept", otherConceptComponent.getConcept(), false);
            this.composeUriExtras("concept", otherConceptComponent.getConcept(), false);
            this.composeUriCore("system", otherConceptComponent.getSystem(), false);
            this.composeUriExtras("system", otherConceptComponent.getSystem(), false);
            this.composeCodeCore("code", otherConceptComponent.getCode(), false);
            this.composeCodeExtras("code", otherConceptComponent.getCode(), false);
            this.close();
        }
    }

    private void composeConceptMapConceptMapConceptMapComponent(String string, ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent) throws Exception {
        if (conceptMapConceptMapComponent != null) {
            this.open(string);
            this.composeBackbone(conceptMapConceptMapComponent);
            this.composeUriCore("system", conceptMapConceptMapComponent.getSystem(), false);
            this.composeUriExtras("system", conceptMapConceptMapComponent.getSystem(), false);
            this.composeCodeCore("code", conceptMapConceptMapComponent.getCode(), false);
            this.composeCodeExtras("code", conceptMapConceptMapComponent.getCode(), false);
            if (conceptMapConceptMapComponent.getEquivalence() != null) {
                this.composeEnumerationCore("equivalence", conceptMapConceptMapComponent.getEquivalence(), new ConceptMap.ConceptEquivalenceEnumFactory(), false);
                this.composeEnumerationExtras("equivalence", conceptMapConceptMapComponent.getEquivalence(), new ConceptMap.ConceptEquivalenceEnumFactory(), false);
            }
            this.composeStringCore("comments", conceptMapConceptMapComponent.getComments(), false);
            this.composeStringExtras("comments", conceptMapConceptMapComponent.getComments(), false);
            if (conceptMapConceptMapComponent.getProduct().size() > 0) {
                this.openArray("product");
                for (ConceptMap.OtherConceptComponent otherConceptComponent : conceptMapConceptMapComponent.getProduct()) {
                    this.composeConceptMapOtherConceptComponent(null, otherConceptComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeCondition(String string, Condition condition) throws Exception {
        if (condition != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(condition);
            if (condition.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : condition.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("subject", condition.getSubject());
            this.composeResourceReference("encounter", condition.getEncounter());
            this.composeResourceReference("asserter", condition.getAsserter());
            this.composeDateCore("dateAsserted", condition.getDateAsserted(), false);
            this.composeDateExtras("dateAsserted", condition.getDateAsserted(), false);
            this.composeCodeableConcept("code", condition.getCode());
            this.composeCodeableConcept("category", condition.getCategory());
            if (condition.getStatus() != null) {
                this.composeEnumerationCore("status", condition.getStatus(), new Condition.ConditionStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", condition.getStatus(), new Condition.ConditionStatusEnumFactory(), false);
            }
            this.composeCodeableConcept("certainty", condition.getCertainty());
            this.composeCodeableConcept("severity", condition.getSeverity());
            this.composeType("onset", condition.getOnset());
            this.composeType("abatement", condition.getAbatement());
            this.composeConditionConditionStageComponent("stage", condition.getStage());
            if (condition.getEvidence().size() > 0) {
                this.openArray("evidence");
                for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : condition.getEvidence()) {
                    this.composeConditionConditionEvidenceComponent(null, conditionEvidenceComponent);
                }
                this.closeArray();
            }
            if (condition.getLocation().size() > 0) {
                this.openArray("location");
                for (Condition.ConditionLocationComponent conditionLocationComponent : condition.getLocation()) {
                    this.composeConditionConditionLocationComponent(null, conditionLocationComponent);
                }
                this.closeArray();
            }
            if (condition.getRelatedItem().size() > 0) {
                this.openArray("relatedItem");
                for (Condition.ConditionRelatedItemComponent conditionRelatedItemComponent : condition.getRelatedItem()) {
                    this.composeConditionConditionRelatedItemComponent(null, conditionRelatedItemComponent);
                }
                this.closeArray();
            }
            this.composeStringCore("notes", condition.getNotes(), false);
            this.composeStringExtras("notes", condition.getNotes(), false);
        }
    }

    private void composeConditionConditionStageComponent(String string, Condition.ConditionStageComponent conditionStageComponent) throws Exception {
        if (conditionStageComponent != null) {
            this.open(string);
            this.composeBackbone(conditionStageComponent);
            this.composeCodeableConcept("summary", conditionStageComponent.getSummary());
            if (conditionStageComponent.getAssessment().size() > 0) {
                this.openArray("assessment");
                for (ResourceReference resourceReference : conditionStageComponent.getAssessment()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeConditionConditionEvidenceComponent(String string, Condition.ConditionEvidenceComponent conditionEvidenceComponent) throws Exception {
        if (conditionEvidenceComponent != null) {
            this.open(string);
            this.composeBackbone(conditionEvidenceComponent);
            this.composeCodeableConcept("code", conditionEvidenceComponent.getCode());
            if (conditionEvidenceComponent.getDetail().size() > 0) {
                this.openArray("detail");
                for (ResourceReference resourceReference : conditionEvidenceComponent.getDetail()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeConditionConditionLocationComponent(String string, Condition.ConditionLocationComponent conditionLocationComponent) throws Exception {
        if (conditionLocationComponent != null) {
            this.open(string);
            this.composeBackbone(conditionLocationComponent);
            this.composeCodeableConcept("code", conditionLocationComponent.getCode());
            this.composeStringCore("detail", conditionLocationComponent.getDetail(), false);
            this.composeStringExtras("detail", conditionLocationComponent.getDetail(), false);
            this.close();
        }
    }

    private void composeConditionConditionRelatedItemComponent(String string, Condition.ConditionRelatedItemComponent conditionRelatedItemComponent) throws Exception {
        if (conditionRelatedItemComponent != null) {
            this.open(string);
            this.composeBackbone(conditionRelatedItemComponent);
            if (conditionRelatedItemComponent.getType() != null) {
                this.composeEnumerationCore("type", conditionRelatedItemComponent.getType(), new Condition.ConditionRelationshipTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", conditionRelatedItemComponent.getType(), new Condition.ConditionRelationshipTypeEnumFactory(), false);
            }
            this.composeCodeableConcept("code", conditionRelatedItemComponent.getCode());
            this.composeResourceReference("target", conditionRelatedItemComponent.getTarget());
            this.close();
        }
    }

    private void composeConformance(String string, Conformance conformance) throws Exception {
        if (conformance != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(conformance);
            this.composeStringCore("identifier", conformance.getIdentifier(), false);
            this.composeStringExtras("identifier", conformance.getIdentifier(), false);
            this.composeStringCore("version", conformance.getVersion(), false);
            this.composeStringExtras("version", conformance.getVersion(), false);
            this.composeStringCore("name", conformance.getName(), false);
            this.composeStringExtras("name", conformance.getName(), false);
            this.composeStringCore("publisher", conformance.getPublisher(), false);
            this.composeStringExtras("publisher", conformance.getPublisher(), false);
            if (conformance.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact element : conformance.getTelecom()) {
                    this.composeContact(null, element);
                }
                this.closeArray();
            }
            this.composeStringCore("description", conformance.getDescription(), false);
            this.composeStringExtras("description", conformance.getDescription(), false);
            if (conformance.getStatus() != null) {
                this.composeEnumerationCore("status", conformance.getStatus(), new Conformance.ConformanceStatementStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", conformance.getStatus(), new Conformance.ConformanceStatementStatusEnumFactory(), false);
            }
            this.composeBooleanCore("experimental", conformance.getExperimental(), false);
            this.composeBooleanExtras("experimental", conformance.getExperimental(), false);
            this.composeDateTimeCore("date", conformance.getDate(), false);
            this.composeDateTimeExtras("date", conformance.getDate(), false);
            this.composeConformanceConformanceSoftwareComponent("software", conformance.getSoftware());
            this.composeConformanceConformanceImplementationComponent("implementation", conformance.getImplementation());
            this.composeIdCore("fhirVersion", conformance.getFhirVersion(), false);
            this.composeIdExtras("fhirVersion", conformance.getFhirVersion(), false);
            this.composeBooleanCore("acceptUnknown", conformance.getAcceptUnknown(), false);
            this.composeBooleanExtras("acceptUnknown", conformance.getAcceptUnknown(), false);
            if (conformance.getFormat().size() > 0) {
                this.openArray("format");
                for (CodeType codeType : conformance.getFormat()) {
                    this.composeCodeCore(null, codeType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(conformance.getFormat())) {
                    this.openArray("_format");
                    for (CodeType codeType : conformance.getFormat()) {
                        this.composeCodeExtras(null, codeType, true);
                    }
                    this.closeArray();
                }
            }
            if (conformance.getProfile().size() > 0) {
                this.openArray("profile");
                for (ResourceReference resourceReference : conformance.getProfile()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (conformance.getRest().size() > 0) {
                this.openArray("rest");
                for (Conformance.ConformanceRestComponent conformanceRestComponent : conformance.getRest()) {
                    this.composeConformanceConformanceRestComponent(null, conformanceRestComponent);
                }
                this.closeArray();
            }
            if (conformance.getMessaging().size() > 0) {
                this.openArray("messaging");
                for (Conformance.ConformanceMessagingComponent conformanceMessagingComponent : conformance.getMessaging()) {
                    this.composeConformanceConformanceMessagingComponent(null, conformanceMessagingComponent);
                }
                this.closeArray();
            }
            if (conformance.getDocument().size() > 0) {
                this.openArray("document");
                for (Conformance.ConformanceDocumentComponent conformanceDocumentComponent : conformance.getDocument()) {
                    this.composeConformanceConformanceDocumentComponent(null, conformanceDocumentComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeConformanceConformanceSoftwareComponent(String string, Conformance.ConformanceSoftwareComponent conformanceSoftwareComponent) throws Exception {
        if (conformanceSoftwareComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceSoftwareComponent);
            this.composeStringCore("name", conformanceSoftwareComponent.getName(), false);
            this.composeStringExtras("name", conformanceSoftwareComponent.getName(), false);
            this.composeStringCore("version", conformanceSoftwareComponent.getVersion(), false);
            this.composeStringExtras("version", conformanceSoftwareComponent.getVersion(), false);
            this.composeDateTimeCore("releaseDate", conformanceSoftwareComponent.getReleaseDate(), false);
            this.composeDateTimeExtras("releaseDate", conformanceSoftwareComponent.getReleaseDate(), false);
            this.close();
        }
    }

    private void composeConformanceConformanceImplementationComponent(String string, Conformance.ConformanceImplementationComponent conformanceImplementationComponent) throws Exception {
        if (conformanceImplementationComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceImplementationComponent);
            this.composeStringCore("description", conformanceImplementationComponent.getDescription(), false);
            this.composeStringExtras("description", conformanceImplementationComponent.getDescription(), false);
            this.composeUriCore("url", conformanceImplementationComponent.getUrl(), false);
            this.composeUriExtras("url", conformanceImplementationComponent.getUrl(), false);
            this.close();
        }
    }

    private void composeConformanceConformanceRestComponent(String string, Conformance.ConformanceRestComponent conformanceRestComponent) throws Exception {
        if (conformanceRestComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceRestComponent);
            if (conformanceRestComponent.getMode() != null) {
                this.composeEnumerationCore("mode", conformanceRestComponent.getMode(), new Conformance.RestfulConformanceModeEnumFactory(), false);
                this.composeEnumerationExtras("mode", conformanceRestComponent.getMode(), new Conformance.RestfulConformanceModeEnumFactory(), false);
            }
            this.composeStringCore("documentation", conformanceRestComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", conformanceRestComponent.getDocumentation(), false);
            this.composeConformanceConformanceRestSecurityComponent("security", conformanceRestComponent.getSecurity());
            if (conformanceRestComponent.getResource().size() > 0) {
                this.openArray("resource");
                for (Conformance.ConformanceRestResourceComponent element : conformanceRestComponent.getResource()) {
                    this.composeConformanceConformanceRestResourceComponent(null, element);
                }
                this.closeArray();
            }
            if (conformanceRestComponent.getOperation().size() > 0) {
                this.openArray("operation");
                for (Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent : conformanceRestComponent.getOperation()) {
                    this.composeConformanceConformanceRestOperationComponent(null, conformanceRestOperationComponent);
                }
                this.closeArray();
            }
            if (conformanceRestComponent.getQuery().size() > 0) {
                this.openArray("query");
                for (Conformance.ConformanceRestQueryComponent conformanceRestQueryComponent : conformanceRestComponent.getQuery()) {
                    this.composeConformanceConformanceRestQueryComponent(null, conformanceRestQueryComponent);
                }
                this.closeArray();
            }
            if (conformanceRestComponent.getDocumentMailbox().size() > 0) {
                this.openArray("documentMailbox");
                for (UriType uriType : conformanceRestComponent.getDocumentMailbox()) {
                    this.composeUriCore(null, uriType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(conformanceRestComponent.getDocumentMailbox())) {
                    this.openArray("_documentMailbox");
                    for (UriType uriType : conformanceRestComponent.getDocumentMailbox()) {
                        this.composeUriExtras(null, uriType, true);
                    }
                    this.closeArray();
                }
            }
            this.close();
        }
    }

    private void composeConformanceConformanceRestSecurityComponent(String string, Conformance.ConformanceRestSecurityComponent conformanceRestSecurityComponent) throws Exception {
        if (conformanceRestSecurityComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceRestSecurityComponent);
            this.composeBooleanCore("cors", conformanceRestSecurityComponent.getCors(), false);
            this.composeBooleanExtras("cors", conformanceRestSecurityComponent.getCors(), false);
            if (conformanceRestSecurityComponent.getService().size() > 0) {
                this.openArray("service");
                for (CodeableConcept element : conformanceRestSecurityComponent.getService()) {
                    this.composeCodeableConcept(null, element);
                }
                this.closeArray();
            }
            this.composeStringCore("description", conformanceRestSecurityComponent.getDescription(), false);
            this.composeStringExtras("description", conformanceRestSecurityComponent.getDescription(), false);
            if (conformanceRestSecurityComponent.getCertificate().size() > 0) {
                this.openArray("certificate");
                for (Conformance.ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent : conformanceRestSecurityComponent.getCertificate()) {
                    this.composeConformanceConformanceRestSecurityCertificateComponent(null, conformanceRestSecurityCertificateComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeConformanceConformanceRestSecurityCertificateComponent(String string, Conformance.ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent) throws Exception {
        if (conformanceRestSecurityCertificateComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceRestSecurityCertificateComponent);
            this.composeCodeCore("type", conformanceRestSecurityCertificateComponent.getType(), false);
            this.composeCodeExtras("type", conformanceRestSecurityCertificateComponent.getType(), false);
            this.composeBase64BinaryCore("blob", conformanceRestSecurityCertificateComponent.getBlob(), false);
            this.composeBase64BinaryExtras("blob", conformanceRestSecurityCertificateComponent.getBlob(), false);
            this.close();
        }
    }

    private void composeConformanceConformanceRestResourceComponent(String string, Conformance.ConformanceRestResourceComponent conformanceRestResourceComponent) throws Exception {
        if (conformanceRestResourceComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceRestResourceComponent);
            this.composeCodeCore("type", conformanceRestResourceComponent.getType(), false);
            this.composeCodeExtras("type", conformanceRestResourceComponent.getType(), false);
            this.composeResourceReference("profile", conformanceRestResourceComponent.getProfile());
            if (conformanceRestResourceComponent.getOperation().size() > 0) {
                this.openArray("operation");
                for (Conformance.ConformanceRestResourceOperationComponent element : conformanceRestResourceComponent.getOperation()) {
                    this.composeConformanceConformanceRestResourceOperationComponent(null, element);
                }
                this.closeArray();
            }
            this.composeBooleanCore("readHistory", conformanceRestResourceComponent.getReadHistory(), false);
            this.composeBooleanExtras("readHistory", conformanceRestResourceComponent.getReadHistory(), false);
            this.composeBooleanCore("updateCreate", conformanceRestResourceComponent.getUpdateCreate(), false);
            this.composeBooleanExtras("updateCreate", conformanceRestResourceComponent.getUpdateCreate(), false);
            if (conformanceRestResourceComponent.getSearchInclude().size() > 0) {
                this.openArray("searchInclude");
                for (StringType stringType : conformanceRestResourceComponent.getSearchInclude()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(conformanceRestResourceComponent.getSearchInclude())) {
                    this.openArray("_searchInclude");
                    for (StringType stringType : conformanceRestResourceComponent.getSearchInclude()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            if (conformanceRestResourceComponent.getSearchParam().size() > 0) {
                this.openArray("searchParam");
                for (Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : conformanceRestResourceComponent.getSearchParam()) {
                    this.composeConformanceConformanceRestResourceSearchParamComponent(null, conformanceRestResourceSearchParamComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeConformanceConformanceRestResourceOperationComponent(String string, Conformance.ConformanceRestResourceOperationComponent conformanceRestResourceOperationComponent) throws Exception {
        if (conformanceRestResourceOperationComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceRestResourceOperationComponent);
            if (conformanceRestResourceOperationComponent.getCode() != null) {
                this.composeEnumerationCore("code", conformanceRestResourceOperationComponent.getCode(), new Conformance.TypeRestfulOperationEnumFactory(), false);
                this.composeEnumerationExtras("code", conformanceRestResourceOperationComponent.getCode(), new Conformance.TypeRestfulOperationEnumFactory(), false);
            }
            this.composeStringCore("documentation", conformanceRestResourceOperationComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", conformanceRestResourceOperationComponent.getDocumentation(), false);
            this.close();
        }
    }

    private void composeConformanceConformanceRestResourceSearchParamComponent(String string, Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent) throws Exception {
        if (conformanceRestResourceSearchParamComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceRestResourceSearchParamComponent);
            this.composeStringCore("name", conformanceRestResourceSearchParamComponent.getName(), false);
            this.composeStringExtras("name", conformanceRestResourceSearchParamComponent.getName(), false);
            this.composeUriCore("definition", conformanceRestResourceSearchParamComponent.getDefinition(), false);
            this.composeUriExtras("definition", conformanceRestResourceSearchParamComponent.getDefinition(), false);
            if (conformanceRestResourceSearchParamComponent.getType() != null) {
                this.composeEnumerationCore("type", conformanceRestResourceSearchParamComponent.getType(), new Conformance.SearchParamTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", conformanceRestResourceSearchParamComponent.getType(), new Conformance.SearchParamTypeEnumFactory(), false);
            }
            this.composeStringCore("documentation", conformanceRestResourceSearchParamComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", conformanceRestResourceSearchParamComponent.getDocumentation(), false);
            if (conformanceRestResourceSearchParamComponent.getTarget().size() > 0) {
                this.openArray("target");
                for (CodeType primitiveType : conformanceRestResourceSearchParamComponent.getTarget()) {
                    this.composeCodeCore(null, primitiveType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(conformanceRestResourceSearchParamComponent.getTarget())) {
                    this.openArray("_target");
                    for (CodeType codeType : conformanceRestResourceSearchParamComponent.getTarget()) {
                        this.composeCodeExtras(null, codeType, true);
                    }
                    this.closeArray();
                }
            }
            if (conformanceRestResourceSearchParamComponent.getChain().size() > 0) {
                this.openArray("chain");
                for (StringType stringType : conformanceRestResourceSearchParamComponent.getChain()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(conformanceRestResourceSearchParamComponent.getChain())) {
                    this.openArray("_chain");
                    for (StringType stringType : conformanceRestResourceSearchParamComponent.getChain()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            this.close();
        }
    }

    private void composeConformanceConformanceRestOperationComponent(String string, Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent) throws Exception {
        if (conformanceRestOperationComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceRestOperationComponent);
            if (conformanceRestOperationComponent.getCode() != null) {
                this.composeEnumerationCore("code", conformanceRestOperationComponent.getCode(), new Conformance.SystemRestfulOperationEnumFactory(), false);
                this.composeEnumerationExtras("code", conformanceRestOperationComponent.getCode(), new Conformance.SystemRestfulOperationEnumFactory(), false);
            }
            this.composeStringCore("documentation", conformanceRestOperationComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", conformanceRestOperationComponent.getDocumentation(), false);
            this.close();
        }
    }

    private void composeConformanceConformanceRestQueryComponent(String string, Conformance.ConformanceRestQueryComponent conformanceRestQueryComponent) throws Exception {
        if (conformanceRestQueryComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceRestQueryComponent);
            this.composeStringCore("name", conformanceRestQueryComponent.getName(), false);
            this.composeStringExtras("name", conformanceRestQueryComponent.getName(), false);
            this.composeUriCore("definition", conformanceRestQueryComponent.getDefinition(), false);
            this.composeUriExtras("definition", conformanceRestQueryComponent.getDefinition(), false);
            this.composeStringCore("documentation", conformanceRestQueryComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", conformanceRestQueryComponent.getDocumentation(), false);
            if (conformanceRestQueryComponent.getParameter().size() > 0) {
                this.openArray("parameter");
                for (Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : conformanceRestQueryComponent.getParameter()) {
                    this.composeConformanceConformanceRestResourceSearchParamComponent(null, conformanceRestResourceSearchParamComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeConformanceConformanceMessagingComponent(String string, Conformance.ConformanceMessagingComponent conformanceMessagingComponent) throws Exception {
        if (conformanceMessagingComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceMessagingComponent);
            this.composeUriCore("endpoint", conformanceMessagingComponent.getEndpoint(), false);
            this.composeUriExtras("endpoint", conformanceMessagingComponent.getEndpoint(), false);
            this.composeIntegerCore("reliableCache", conformanceMessagingComponent.getReliableCache(), false);
            this.composeIntegerExtras("reliableCache", conformanceMessagingComponent.getReliableCache(), false);
            this.composeStringCore("documentation", conformanceMessagingComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", conformanceMessagingComponent.getDocumentation(), false);
            if (conformanceMessagingComponent.getEvent().size() > 0) {
                this.openArray("event");
                for (Conformance.ConformanceMessagingEventComponent conformanceMessagingEventComponent : conformanceMessagingComponent.getEvent()) {
                    this.composeConformanceConformanceMessagingEventComponent(null, conformanceMessagingEventComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeConformanceConformanceMessagingEventComponent(String string, Conformance.ConformanceMessagingEventComponent conformanceMessagingEventComponent) throws Exception {
        if (conformanceMessagingEventComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceMessagingEventComponent);
            this.composeCoding("code", conformanceMessagingEventComponent.getCode());
            if (conformanceMessagingEventComponent.getCategory() != null) {
                this.composeEnumerationCore("category", conformanceMessagingEventComponent.getCategory(), new Conformance.MessageSignificanceCategoryEnumFactory(), false);
                this.composeEnumerationExtras("category", conformanceMessagingEventComponent.getCategory(), new Conformance.MessageSignificanceCategoryEnumFactory(), false);
            }
            if (conformanceMessagingEventComponent.getMode() != null) {
                this.composeEnumerationCore("mode", conformanceMessagingEventComponent.getMode(), new Conformance.MessageConformanceEventModeEnumFactory(), false);
                this.composeEnumerationExtras("mode", conformanceMessagingEventComponent.getMode(), new Conformance.MessageConformanceEventModeEnumFactory(), false);
            }
            if (conformanceMessagingEventComponent.getProtocol().size() > 0) {
                this.openArray("protocol");
                for (Coding coding : conformanceMessagingEventComponent.getProtocol()) {
                    this.composeCoding(null, coding);
                }
                this.closeArray();
            }
            this.composeCodeCore("focus", conformanceMessagingEventComponent.getFocus(), false);
            this.composeCodeExtras("focus", conformanceMessagingEventComponent.getFocus(), false);
            this.composeResourceReference("request", conformanceMessagingEventComponent.getRequest());
            this.composeResourceReference("response", conformanceMessagingEventComponent.getResponse());
            this.composeStringCore("documentation", conformanceMessagingEventComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", conformanceMessagingEventComponent.getDocumentation(), false);
            this.close();
        }
    }

    private void composeConformanceConformanceDocumentComponent(String string, Conformance.ConformanceDocumentComponent conformanceDocumentComponent) throws Exception {
        if (conformanceDocumentComponent != null) {
            this.open(string);
            this.composeBackbone(conformanceDocumentComponent);
            if (conformanceDocumentComponent.getMode() != null) {
                this.composeEnumerationCore("mode", conformanceDocumentComponent.getMode(), new Conformance.DocumentModeEnumFactory(), false);
                this.composeEnumerationExtras("mode", conformanceDocumentComponent.getMode(), new Conformance.DocumentModeEnumFactory(), false);
            }
            this.composeStringCore("documentation", conformanceDocumentComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", conformanceDocumentComponent.getDocumentation(), false);
            this.composeResourceReference("profile", conformanceDocumentComponent.getProfile());
            this.close();
        }
    }

    private void composeDevice(String string, Device device) throws Exception {
        if (device != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(device);
            if (device.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier type : device.getIdentifier()) {
                    this.composeIdentifier(null, type);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("type", device.getType());
            this.composeStringCore("manufacturer", device.getManufacturer(), false);
            this.composeStringExtras("manufacturer", device.getManufacturer(), false);
            this.composeStringCore("model", device.getModel(), false);
            this.composeStringExtras("model", device.getModel(), false);
            this.composeStringCore("version", device.getVersion(), false);
            this.composeStringExtras("version", device.getVersion(), false);
            this.composeDateCore("expiry", device.getExpiry(), false);
            this.composeDateExtras("expiry", device.getExpiry(), false);
            this.composeStringCore("udi", device.getUdi(), false);
            this.composeStringExtras("udi", device.getUdi(), false);
            this.composeStringCore("lotNumber", device.getLotNumber(), false);
            this.composeStringExtras("lotNumber", device.getLotNumber(), false);
            this.composeResourceReference("owner", device.getOwner());
            this.composeResourceReference("location", device.getLocation());
            this.composeResourceReference("patient", device.getPatient());
            if (device.getContact().size() > 0) {
                this.openArray("contact");
                for (Contact contact : device.getContact()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            this.composeUriCore("url", device.getUrl(), false);
            this.composeUriExtras("url", device.getUrl(), false);
        }
    }

    private void composeDeviceObservationReport(String string, DeviceObservationReport deviceObservationReport) throws Exception {
        if (deviceObservationReport != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(deviceObservationReport);
            this.composeInstantCore("instant", deviceObservationReport.getInstant(), false);
            this.composeInstantExtras("instant", deviceObservationReport.getInstant(), false);
            this.composeIdentifier("identifier", deviceObservationReport.getIdentifier());
            this.composeResourceReference("source", deviceObservationReport.getSource());
            this.composeResourceReference("subject", deviceObservationReport.getSubject());
            if (deviceObservationReport.getVirtualDevice().size() > 0) {
                this.openArray("virtualDevice");
                for (DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent : deviceObservationReport.getVirtualDevice()) {
                    this.composeDeviceObservationReportDeviceObservationReportVirtualDeviceComponent(null, deviceObservationReportVirtualDeviceComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeDeviceObservationReportDeviceObservationReportVirtualDeviceComponent(String string, DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent) throws Exception {
        if (deviceObservationReportVirtualDeviceComponent != null) {
            this.open(string);
            this.composeBackbone(deviceObservationReportVirtualDeviceComponent);
            this.composeCodeableConcept("code", deviceObservationReportVirtualDeviceComponent.getCode());
            if (deviceObservationReportVirtualDeviceComponent.getChannel().size() > 0) {
                this.openArray("channel");
                for (DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent : deviceObservationReportVirtualDeviceComponent.getChannel()) {
                    this.composeDeviceObservationReportDeviceObservationReportVirtualDeviceChannelComponent(null, deviceObservationReportVirtualDeviceChannelComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeDeviceObservationReportDeviceObservationReportVirtualDeviceChannelComponent(String string, DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent) throws Exception {
        if (deviceObservationReportVirtualDeviceChannelComponent != null) {
            this.open(string);
            this.composeBackbone(deviceObservationReportVirtualDeviceChannelComponent);
            this.composeCodeableConcept("code", deviceObservationReportVirtualDeviceChannelComponent.getCode());
            if (deviceObservationReportVirtualDeviceChannelComponent.getMetric().size() > 0) {
                this.openArray("metric");
                for (DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent : deviceObservationReportVirtualDeviceChannelComponent.getMetric()) {
                    this.composeDeviceObservationReportDeviceObservationReportVirtualDeviceChannelMetricComponent(null, deviceObservationReportVirtualDeviceChannelMetricComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeDeviceObservationReportDeviceObservationReportVirtualDeviceChannelMetricComponent(String string, DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent) throws Exception {
        if (deviceObservationReportVirtualDeviceChannelMetricComponent != null) {
            this.open(string);
            this.composeBackbone(deviceObservationReportVirtualDeviceChannelMetricComponent);
            this.composeResourceReference("observation", deviceObservationReportVirtualDeviceChannelMetricComponent.getObservation());
            this.close();
        }
    }

    private void composeDiagnosticOrder(String string, DiagnosticOrder diagnosticOrder) throws Exception {
        if (diagnosticOrder != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(diagnosticOrder);
            this.composeResourceReference("subject", diagnosticOrder.getSubject());
            this.composeResourceReference("orderer", diagnosticOrder.getOrderer());
            if (diagnosticOrder.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : diagnosticOrder.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("encounter", diagnosticOrder.getEncounter());
            this.composeStringCore("clinicalNotes", diagnosticOrder.getClinicalNotes(), false);
            this.composeStringExtras("clinicalNotes", diagnosticOrder.getClinicalNotes(), false);
            if (diagnosticOrder.getSpecimen().size() > 0) {
                this.openArray("specimen");
                for (ResourceReference resourceReference : diagnosticOrder.getSpecimen()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (diagnosticOrder.getStatus() != null) {
                this.composeEnumerationCore("status", diagnosticOrder.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", diagnosticOrder.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
            }
            if (diagnosticOrder.getPriority() != null) {
                this.composeEnumerationCore("priority", diagnosticOrder.getPriority(), new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory(), false);
                this.composeEnumerationExtras("priority", diagnosticOrder.getPriority(), new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory(), false);
            }
            if (diagnosticOrder.getEvent().size() > 0) {
                this.openArray("event");
                for (DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent : diagnosticOrder.getEvent()) {
                    this.composeDiagnosticOrderDiagnosticOrderEventComponent(null, diagnosticOrderEventComponent);
                }
                this.closeArray();
            }
            if (diagnosticOrder.getItem().size() > 0) {
                this.openArray("item");
                for (DiagnosticOrder.DiagnosticOrderItemComponent diagnosticOrderItemComponent : diagnosticOrder.getItem()) {
                    this.composeDiagnosticOrderDiagnosticOrderItemComponent(null, diagnosticOrderItemComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeDiagnosticOrderDiagnosticOrderEventComponent(String string, DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent) throws Exception {
        if (diagnosticOrderEventComponent != null) {
            this.open(string);
            this.composeBackbone(diagnosticOrderEventComponent);
            if (diagnosticOrderEventComponent.getStatus() != null) {
                this.composeEnumerationCore("status", diagnosticOrderEventComponent.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", diagnosticOrderEventComponent.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
            }
            this.composeCodeableConcept("description", diagnosticOrderEventComponent.getDescription());
            this.composeDateTimeCore("dateTime", diagnosticOrderEventComponent.getDateTime(), false);
            this.composeDateTimeExtras("dateTime", diagnosticOrderEventComponent.getDateTime(), false);
            this.composeResourceReference("actor", diagnosticOrderEventComponent.getActor());
            this.close();
        }
    }

    private void composeDiagnosticOrderDiagnosticOrderItemComponent(String string, DiagnosticOrder.DiagnosticOrderItemComponent diagnosticOrderItemComponent) throws Exception {
        if (diagnosticOrderItemComponent != null) {
            this.open(string);
            this.composeBackbone(diagnosticOrderItemComponent);
            this.composeCodeableConcept("code", diagnosticOrderItemComponent.getCode());
            if (diagnosticOrderItemComponent.getSpecimen().size() > 0) {
                this.openArray("specimen");
                for (ResourceReference element : diagnosticOrderItemComponent.getSpecimen()) {
                    this.composeResourceReference(null, element);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("bodySite", diagnosticOrderItemComponent.getBodySite());
            if (diagnosticOrderItemComponent.getStatus() != null) {
                this.composeEnumerationCore("status", diagnosticOrderItemComponent.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", diagnosticOrderItemComponent.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
            }
            if (diagnosticOrderItemComponent.getEvent().size() > 0) {
                this.openArray("event");
                for (DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent : diagnosticOrderItemComponent.getEvent()) {
                    this.composeDiagnosticOrderDiagnosticOrderEventComponent(null, diagnosticOrderEventComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeDiagnosticReport(String string, DiagnosticReport diagnosticReport) throws Exception {
        if (diagnosticReport != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(diagnosticReport);
            this.composeCodeableConcept("name", diagnosticReport.getName());
            if (diagnosticReport.getStatus() != null) {
                this.composeEnumerationCore("status", diagnosticReport.getStatus(), new DiagnosticReport.DiagnosticReportStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", diagnosticReport.getStatus(), new DiagnosticReport.DiagnosticReportStatusEnumFactory(), false);
            }
            this.composeDateTimeCore("issued", diagnosticReport.getIssued(), false);
            this.composeDateTimeExtras("issued", diagnosticReport.getIssued(), false);
            this.composeResourceReference("subject", diagnosticReport.getSubject());
            this.composeResourceReference("performer", diagnosticReport.getPerformer());
            this.composeIdentifier("identifier", diagnosticReport.getIdentifier());
            if (diagnosticReport.getRequestDetail().size() > 0) {
                this.openArray("requestDetail");
                for (ResourceReference element : diagnosticReport.getRequestDetail()) {
                    this.composeResourceReference(null, element);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("serviceCategory", diagnosticReport.getServiceCategory());
            this.composeType("diagnostic", diagnosticReport.getDiagnostic());
            if (diagnosticReport.getSpecimen().size() > 0) {
                this.openArray("specimen");
                for (ResourceReference resourceReference : diagnosticReport.getSpecimen()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (diagnosticReport.getResult().size() > 0) {
                this.openArray("result");
                for (ResourceReference resourceReference : diagnosticReport.getResult()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (diagnosticReport.getImagingStudy().size() > 0) {
                this.openArray("imagingStudy");
                for (ResourceReference resourceReference : diagnosticReport.getImagingStudy()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (diagnosticReport.getImage().size() > 0) {
                this.openArray("image");
                for (DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent : diagnosticReport.getImage()) {
                    this.composeDiagnosticReportDiagnosticReportImageComponent(null, diagnosticReportImageComponent);
                }
                this.closeArray();
            }
            this.composeStringCore("conclusion", diagnosticReport.getConclusion(), false);
            this.composeStringExtras("conclusion", diagnosticReport.getConclusion(), false);
            if (diagnosticReport.getCodedDiagnosis().size() > 0) {
                this.openArray("codedDiagnosis");
                for (CodeableConcept codeableConcept : diagnosticReport.getCodedDiagnosis()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            if (diagnosticReport.getPresentedForm().size() > 0) {
                this.openArray("presentedForm");
                for (Attachment attachment : diagnosticReport.getPresentedForm()) {
                    this.composeAttachment(null, attachment);
                }
                this.closeArray();
            }
        }
    }

    private void composeDiagnosticReportDiagnosticReportImageComponent(String string, DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent) throws Exception {
        if (diagnosticReportImageComponent != null) {
            this.open(string);
            this.composeBackbone(diagnosticReportImageComponent);
            this.composeStringCore("comment", diagnosticReportImageComponent.getComment(), false);
            this.composeStringExtras("comment", diagnosticReportImageComponent.getComment(), false);
            this.composeResourceReference("link", diagnosticReportImageComponent.getLink());
            this.close();
        }
    }

    private void composeDocumentManifest(String string, DocumentManifest documentManifest) throws Exception {
        if (documentManifest != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(documentManifest);
            this.composeIdentifier("masterIdentifier", documentManifest.getMasterIdentifier());
            if (documentManifest.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier type : documentManifest.getIdentifier()) {
                    this.composeIdentifier(null, type);
                }
                this.closeArray();
            }
            if (documentManifest.getSubject().size() > 0) {
                this.openArray("subject");
                for (ResourceReference resourceReference : documentManifest.getSubject()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (documentManifest.getRecipient().size() > 0) {
                this.openArray("recipient");
                for (ResourceReference resourceReference : documentManifest.getRecipient()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("type", documentManifest.getType());
            if (documentManifest.getAuthor().size() > 0) {
                this.openArray("author");
                for (ResourceReference resourceReference : documentManifest.getAuthor()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.composeDateTimeCore("created", documentManifest.getCreated(), false);
            this.composeDateTimeExtras("created", documentManifest.getCreated(), false);
            this.composeUriCore("source", documentManifest.getSource(), false);
            this.composeUriExtras("source", documentManifest.getSource(), false);
            if (documentManifest.getStatus() != null) {
                this.composeEnumerationCore("status", documentManifest.getStatus(), new DocumentManifest.DocumentReferenceStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", documentManifest.getStatus(), new DocumentManifest.DocumentReferenceStatusEnumFactory(), false);
            }
            this.composeResourceReference("supercedes", documentManifest.getSupercedes());
            this.composeStringCore("description", documentManifest.getDescription(), false);
            this.composeStringExtras("description", documentManifest.getDescription(), false);
            this.composeCodeableConcept("confidentiality", documentManifest.getConfidentiality());
            if (documentManifest.getContent().size() > 0) {
                this.openArray("content");
                for (ResourceReference resourceReference : documentManifest.getContent()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
        }
    }

    private void composeDocumentReference(String string, DocumentReference documentReference) throws Exception {
        if (documentReference != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(documentReference);
            this.composeIdentifier("masterIdentifier", documentReference.getMasterIdentifier());
            if (documentReference.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : documentReference.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("subject", documentReference.getSubject());
            this.composeCodeableConcept("type", documentReference.getType());
            this.composeCodeableConcept("class", documentReference.getClass_());
            if (documentReference.getAuthor().size() > 0) {
                this.openArray("author");
                for (ResourceReference resourceReference : documentReference.getAuthor()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.composeResourceReference("custodian", documentReference.getCustodian());
            this.composeUriCore("policyManager", documentReference.getPolicyManager(), false);
            this.composeUriExtras("policyManager", documentReference.getPolicyManager(), false);
            this.composeResourceReference("authenticator", documentReference.getAuthenticator());
            this.composeDateTimeCore("created", documentReference.getCreated(), false);
            this.composeDateTimeExtras("created", documentReference.getCreated(), false);
            this.composeInstantCore("indexed", documentReference.getIndexed(), false);
            this.composeInstantExtras("indexed", documentReference.getIndexed(), false);
            if (documentReference.getStatus() != null) {
                this.composeEnumerationCore("status", documentReference.getStatus(), new DocumentReference.DocumentReferenceStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", documentReference.getStatus(), new DocumentReference.DocumentReferenceStatusEnumFactory(), false);
            }
            this.composeCodeableConcept("docStatus", documentReference.getDocStatus());
            if (documentReference.getRelatesTo().size() > 0) {
                this.openArray("relatesTo");
                for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : documentReference.getRelatesTo()) {
                    this.composeDocumentReferenceDocumentReferenceRelatesToComponent(null, documentReferenceRelatesToComponent);
                }
                this.closeArray();
            }
            this.composeStringCore("description", documentReference.getDescription(), false);
            this.composeStringExtras("description", documentReference.getDescription(), false);
            if (documentReference.getConfidentiality().size() > 0) {
                this.openArray("confidentiality");
                for (CodeableConcept codeableConcept : documentReference.getConfidentiality()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composeCodeCore("primaryLanguage", documentReference.getPrimaryLanguage(), false);
            this.composeCodeExtras("primaryLanguage", documentReference.getPrimaryLanguage(), false);
            this.composeCodeCore("mimeType", documentReference.getMimeType(), false);
            this.composeCodeExtras("mimeType", documentReference.getMimeType(), false);
            if (documentReference.getFormat().size() > 0) {
                this.openArray("format");
                for (UriType uriType : documentReference.getFormat()) {
                    this.composeUriCore(null, uriType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(documentReference.getFormat())) {
                    this.openArray("_format");
                    for (UriType uriType : documentReference.getFormat()) {
                        this.composeUriExtras(null, uriType, true);
                    }
                    this.closeArray();
                }
            }
            this.composeIntegerCore("size", documentReference.getSize(), false);
            this.composeIntegerExtras("size", documentReference.getSize(), false);
            this.composeStringCore("hash", documentReference.getHash(), false);
            this.composeStringExtras("hash", documentReference.getHash(), false);
            this.composeUriCore("location", documentReference.getLocation(), false);
            this.composeUriExtras("location", documentReference.getLocation(), false);
            this.composeDocumentReferenceDocumentReferenceServiceComponent("service", documentReference.getService());
            this.composeDocumentReferenceDocumentReferenceContextComponent("context", documentReference.getContext());
        }
    }

    private void composeDocumentReferenceDocumentReferenceRelatesToComponent(String string, DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent) throws Exception {
        if (documentReferenceRelatesToComponent != null) {
            this.open(string);
            this.composeBackbone(documentReferenceRelatesToComponent);
            if (documentReferenceRelatesToComponent.getCode() != null) {
                this.composeEnumerationCore("code", documentReferenceRelatesToComponent.getCode(), new DocumentReference.DocumentRelationshipTypeEnumFactory(), false);
                this.composeEnumerationExtras("code", documentReferenceRelatesToComponent.getCode(), new DocumentReference.DocumentRelationshipTypeEnumFactory(), false);
            }
            this.composeResourceReference("target", documentReferenceRelatesToComponent.getTarget());
            this.close();
        }
    }

    private void composeDocumentReferenceDocumentReferenceServiceComponent(String string, DocumentReference.DocumentReferenceServiceComponent documentReferenceServiceComponent) throws Exception {
        if (documentReferenceServiceComponent != null) {
            this.open(string);
            this.composeBackbone(documentReferenceServiceComponent);
            this.composeCodeableConcept("type", documentReferenceServiceComponent.getType());
            this.composeStringCore("address", documentReferenceServiceComponent.getAddress(), false);
            this.composeStringExtras("address", documentReferenceServiceComponent.getAddress(), false);
            if (documentReferenceServiceComponent.getParameter().size() > 0) {
                this.openArray("parameter");
                for (DocumentReference.DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent : documentReferenceServiceComponent.getParameter()) {
                    this.composeDocumentReferenceDocumentReferenceServiceParameterComponent(null, documentReferenceServiceParameterComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeDocumentReferenceDocumentReferenceServiceParameterComponent(String string, DocumentReference.DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent) throws Exception {
        if (documentReferenceServiceParameterComponent != null) {
            this.open(string);
            this.composeBackbone(documentReferenceServiceParameterComponent);
            this.composeStringCore("name", documentReferenceServiceParameterComponent.getName(), false);
            this.composeStringExtras("name", documentReferenceServiceParameterComponent.getName(), false);
            this.composeStringCore("value", documentReferenceServiceParameterComponent.getValue(), false);
            this.composeStringExtras("value", documentReferenceServiceParameterComponent.getValue(), false);
            this.close();
        }
    }

    private void composeDocumentReferenceDocumentReferenceContextComponent(String string, DocumentReference.DocumentReferenceContextComponent documentReferenceContextComponent) throws Exception {
        if (documentReferenceContextComponent != null) {
            this.open(string);
            this.composeBackbone(documentReferenceContextComponent);
            if (documentReferenceContextComponent.getEvent().size() > 0) {
                this.openArray("event");
                for (CodeableConcept codeableConcept : documentReferenceContextComponent.getEvent()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composePeriod("period", documentReferenceContextComponent.getPeriod());
            this.composeCodeableConcept("facilityType", documentReferenceContextComponent.getFacilityType());
            this.close();
        }
    }

    private void composeEncounter(String string, Encounter encounter) throws Exception {
        if (encounter != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(encounter);
            if (encounter.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : encounter.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            if (encounter.getStatus() != null) {
                this.composeEnumerationCore("status", encounter.getStatus(), new Encounter.EncounterStateEnumFactory(), false);
                this.composeEnumerationExtras("status", encounter.getStatus(), new Encounter.EncounterStateEnumFactory(), false);
            }
            if (encounter.getClass() != null) {
                this.composeEnumerationCore("class", encounter.getClass_(), new Encounter.EncounterClassEnumFactory(), false);
                this.composeEnumerationExtras("class", encounter.getClass_(), new Encounter.EncounterClassEnumFactory(), false);
            }
            if (encounter.getType().size() > 0) {
                this.openArray("type");
                for (CodeableConcept codeableConcept : encounter.getType()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composeResourceReference("subject", encounter.getSubject());
            if (encounter.getParticipant().size() > 0) {
                this.openArray("participant");
                for (Encounter.EncounterParticipantComponent encounterParticipantComponent : encounter.getParticipant()) {
                    this.composeEncounterEncounterParticipantComponent(null, encounterParticipantComponent);
                }
                this.closeArray();
            }
            this.composePeriod("period", encounter.getPeriod());
            this.composeDuration("length", encounter.getLength());
            this.composeCodeableConcept("reason", encounter.getReason());
            this.composeResourceReference("indication", encounter.getIndication());
            this.composeCodeableConcept("priority", encounter.getPriority());
            this.composeEncounterEncounterHospitalizationComponent("hospitalization", encounter.getHospitalization());
            if (encounter.getLocation().size() > 0) {
                this.openArray("location");
                for (Encounter.EncounterLocationComponent encounterLocationComponent : encounter.getLocation()) {
                    this.composeEncounterEncounterLocationComponent(null, encounterLocationComponent);
                }
                this.closeArray();
            }
            this.composeResourceReference("serviceProvider", encounter.getServiceProvider());
            this.composeResourceReference("partOf", encounter.getPartOf());
        }
    }

    private void composeEncounterEncounterParticipantComponent(String string, Encounter.EncounterParticipantComponent encounterParticipantComponent) throws Exception {
        if (encounterParticipantComponent != null) {
            this.open(string);
            this.composeBackbone(encounterParticipantComponent);
            if (encounterParticipantComponent.getType().size() > 0) {
                this.openArray("type");
                for (CodeableConcept codeableConcept : encounterParticipantComponent.getType()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composeResourceReference("individual", encounterParticipantComponent.getIndividual());
            this.close();
        }
    }

    private void composeEncounterEncounterHospitalizationComponent(String string, Encounter.EncounterHospitalizationComponent encounterHospitalizationComponent) throws Exception {
        if (encounterHospitalizationComponent != null) {
            this.open(string);
            this.composeBackbone(encounterHospitalizationComponent);
            this.composeIdentifier("preAdmissionIdentifier", encounterHospitalizationComponent.getPreAdmissionIdentifier());
            this.composeResourceReference("origin", encounterHospitalizationComponent.getOrigin());
            this.composeCodeableConcept("admitSource", encounterHospitalizationComponent.getAdmitSource());
            this.composePeriod("period", encounterHospitalizationComponent.getPeriod());
            if (encounterHospitalizationComponent.getAccomodation().size() > 0) {
                this.openArray("accomodation");
                for (Encounter.EncounterHospitalizationAccomodationComponent element : encounterHospitalizationComponent.getAccomodation()) {
                    this.composeEncounterEncounterHospitalizationAccomodationComponent(null, element);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("diet", encounterHospitalizationComponent.getDiet());
            if (encounterHospitalizationComponent.getSpecialCourtesy().size() > 0) {
                this.openArray("specialCourtesy");
                for (CodeableConcept codeableConcept : encounterHospitalizationComponent.getSpecialCourtesy()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            if (encounterHospitalizationComponent.getSpecialArrangement().size() > 0) {
                this.openArray("specialArrangement");
                for (CodeableConcept codeableConcept : encounterHospitalizationComponent.getSpecialArrangement()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composeResourceReference("destination", encounterHospitalizationComponent.getDestination());
            this.composeCodeableConcept("dischargeDisposition", encounterHospitalizationComponent.getDischargeDisposition());
            this.composeResourceReference("dischargeDiagnosis", encounterHospitalizationComponent.getDischargeDiagnosis());
            this.composeBooleanCore("reAdmission", encounterHospitalizationComponent.getReAdmission(), false);
            this.composeBooleanExtras("reAdmission", encounterHospitalizationComponent.getReAdmission(), false);
            this.close();
        }
    }

    private void composeEncounterEncounterHospitalizationAccomodationComponent(String string, Encounter.EncounterHospitalizationAccomodationComponent encounterHospitalizationAccomodationComponent) throws Exception {
        if (encounterHospitalizationAccomodationComponent != null) {
            this.open(string);
            this.composeBackbone(encounterHospitalizationAccomodationComponent);
            this.composeResourceReference("bed", encounterHospitalizationAccomodationComponent.getBed());
            this.composePeriod("period", encounterHospitalizationAccomodationComponent.getPeriod());
            this.close();
        }
    }

    private void composeEncounterEncounterLocationComponent(String string, Encounter.EncounterLocationComponent encounterLocationComponent) throws Exception {
        if (encounterLocationComponent != null) {
            this.open(string);
            this.composeBackbone(encounterLocationComponent);
            this.composeResourceReference("location", encounterLocationComponent.getLocation());
            this.composePeriod("period", encounterLocationComponent.getPeriod());
            this.close();
        }
    }

    private void composeFamilyHistory(String string, FamilyHistory familyHistory) throws Exception {
        if (familyHistory != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(familyHistory);
            if (familyHistory.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : familyHistory.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("subject", familyHistory.getSubject());
            this.composeStringCore("note", familyHistory.getNote(), false);
            this.composeStringExtras("note", familyHistory.getNote(), false);
            if (familyHistory.getRelation().size() > 0) {
                this.openArray("relation");
                for (FamilyHistory.FamilyHistoryRelationComponent familyHistoryRelationComponent : familyHistory.getRelation()) {
                    this.composeFamilyHistoryFamilyHistoryRelationComponent(null, familyHistoryRelationComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeFamilyHistoryFamilyHistoryRelationComponent(String string, FamilyHistory.FamilyHistoryRelationComponent familyHistoryRelationComponent) throws Exception {
        if (familyHistoryRelationComponent != null) {
            this.open(string);
            this.composeBackbone(familyHistoryRelationComponent);
            this.composeStringCore("name", familyHistoryRelationComponent.getName(), false);
            this.composeStringExtras("name", familyHistoryRelationComponent.getName(), false);
            this.composeCodeableConcept("relationship", familyHistoryRelationComponent.getRelationship());
            this.composeType("born", familyHistoryRelationComponent.getBorn());
            this.composeType("deceased", familyHistoryRelationComponent.getDeceased());
            this.composeStringCore("note", familyHistoryRelationComponent.getNote(), false);
            this.composeStringExtras("note", familyHistoryRelationComponent.getNote(), false);
            if (familyHistoryRelationComponent.getCondition().size() > 0) {
                this.openArray("condition");
                for (FamilyHistory.FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent : familyHistoryRelationComponent.getCondition()) {
                    this.composeFamilyHistoryFamilyHistoryRelationConditionComponent(null, familyHistoryRelationConditionComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeFamilyHistoryFamilyHistoryRelationConditionComponent(String string, FamilyHistory.FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent) throws Exception {
        if (familyHistoryRelationConditionComponent != null) {
            this.open(string);
            this.composeBackbone(familyHistoryRelationConditionComponent);
            this.composeCodeableConcept("type", familyHistoryRelationConditionComponent.getType());
            this.composeCodeableConcept("outcome", familyHistoryRelationConditionComponent.getOutcome());
            this.composeType("onset", familyHistoryRelationConditionComponent.getOnset());
            this.composeStringCore("note", familyHistoryRelationConditionComponent.getNote(), false);
            this.composeStringExtras("note", familyHistoryRelationConditionComponent.getNote(), false);
            this.close();
        }
    }

    private void composeGroup(String string, Group group) throws Exception {
        if (group != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(group);
            this.composeIdentifier("identifier", group.getIdentifier());
            if (group.getType() != null) {
                this.composeEnumerationCore("type", group.getType(), new Group.GroupTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", group.getType(), new Group.GroupTypeEnumFactory(), false);
            }
            this.composeBooleanCore("actual", group.getActual(), false);
            this.composeBooleanExtras("actual", group.getActual(), false);
            this.composeCodeableConcept("code", group.getCode());
            this.composeStringCore("name", group.getName(), false);
            this.composeStringExtras("name", group.getName(), false);
            this.composeIntegerCore("quantity", group.getQuantity(), false);
            this.composeIntegerExtras("quantity", group.getQuantity(), false);
            if (group.getCharacteristic().size() > 0) {
                this.openArray("characteristic");
                for (Group.GroupCharacteristicComponent element : group.getCharacteristic()) {
                    this.composeGroupGroupCharacteristicComponent(null, element);
                }
                this.closeArray();
            }
            if (group.getMember().size() > 0) {
                this.openArray("member");
                for (ResourceReference resourceReference : group.getMember()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
        }
    }

    private void composeGroupGroupCharacteristicComponent(String string, Group.GroupCharacteristicComponent groupCharacteristicComponent) throws Exception {
        if (groupCharacteristicComponent != null) {
            this.open(string);
            this.composeBackbone(groupCharacteristicComponent);
            this.composeCodeableConcept("code", groupCharacteristicComponent.getCode());
            this.composeType("value", groupCharacteristicComponent.getValue());
            this.composeBooleanCore("exclude", groupCharacteristicComponent.getExclude(), false);
            this.composeBooleanExtras("exclude", groupCharacteristicComponent.getExclude(), false);
            this.close();
        }
    }

    private void composeImagingStudy(String string, ImagingStudy imagingStudy) throws Exception {
        if (imagingStudy != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(imagingStudy);
            this.composeDateTimeCore("dateTime", imagingStudy.getDateTime(), false);
            this.composeDateTimeExtras("dateTime", imagingStudy.getDateTime(), false);
            this.composeResourceReference("subject", imagingStudy.getSubject());
            this.composeOidCore("uid", imagingStudy.getUid(), false);
            this.composeOidExtras("uid", imagingStudy.getUid(), false);
            this.composeIdentifier("accessionNo", imagingStudy.getAccessionNo());
            if (imagingStudy.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : imagingStudy.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            if (imagingStudy.getOrder().size() > 0) {
                this.openArray("order");
                for (ResourceReference resourceReference : imagingStudy.getOrder()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (imagingStudy.getModality().size() > 0) {
                this.openArray("modality");
                for (Enumeration enumeration : imagingStudy.getModality()) {
                    this.composeEnumerationCore(null, enumeration, new ImagingStudy.ImagingModalityEnumFactory(), true);
                }
                this.closeArray();
                if (this.anyHasExtras(imagingStudy.getModality())) {
                    this.openArray("_modality");
                    for (Enumeration enumeration : imagingStudy.getModality()) {
                        this.composeEnumerationExtras(null, enumeration, new ImagingStudy.ImagingModalityEnumFactory(), true);
                    }
                    this.closeArray();
                }
            }
            this.composeResourceReference("referrer", imagingStudy.getReferrer());
            if (imagingStudy.getAvailability() != null) {
                this.composeEnumerationCore("availability", imagingStudy.getAvailability(), new ImagingStudy.InstanceAvailabilityEnumFactory(), false);
                this.composeEnumerationExtras("availability", imagingStudy.getAvailability(), new ImagingStudy.InstanceAvailabilityEnumFactory(), false);
            }
            this.composeUriCore("url", imagingStudy.getUrl(), false);
            this.composeUriExtras("url", imagingStudy.getUrl(), false);
            this.composeIntegerCore("numberOfSeries", imagingStudy.getNumberOfSeries(), false);
            this.composeIntegerExtras("numberOfSeries", imagingStudy.getNumberOfSeries(), false);
            this.composeIntegerCore("numberOfInstances", imagingStudy.getNumberOfInstances(), false);
            this.composeIntegerExtras("numberOfInstances", imagingStudy.getNumberOfInstances(), false);
            this.composeStringCore("clinicalInformation", imagingStudy.getClinicalInformation(), false);
            this.composeStringExtras("clinicalInformation", imagingStudy.getClinicalInformation(), false);
            if (imagingStudy.getProcedure().size() > 0) {
                this.openArray("procedure");
                for (Coding coding : imagingStudy.getProcedure()) {
                    this.composeCoding(null, coding);
                }
                this.closeArray();
            }
            this.composeResourceReference("interpreter", imagingStudy.getInterpreter());
            this.composeStringCore("description", imagingStudy.getDescription(), false);
            this.composeStringExtras("description", imagingStudy.getDescription(), false);
            if (imagingStudy.getSeries().size() > 0) {
                this.openArray("series");
                for (ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent : imagingStudy.getSeries()) {
                    this.composeImagingStudyImagingStudySeriesComponent(null, imagingStudySeriesComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeImagingStudyImagingStudySeriesComponent(String string, ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent) throws Exception {
        if (imagingStudySeriesComponent != null) {
            this.open(string);
            this.composeBackbone(imagingStudySeriesComponent);
            this.composeIntegerCore("number", imagingStudySeriesComponent.getNumber(), false);
            this.composeIntegerExtras("number", imagingStudySeriesComponent.getNumber(), false);
            if (imagingStudySeriesComponent.getModality() != null) {
                this.composeEnumerationCore("modality", imagingStudySeriesComponent.getModality(), new ImagingStudy.ModalityEnumFactory(), false);
                this.composeEnumerationExtras("modality", imagingStudySeriesComponent.getModality(), new ImagingStudy.ModalityEnumFactory(), false);
            }
            this.composeOidCore("uid", imagingStudySeriesComponent.getUid(), false);
            this.composeOidExtras("uid", imagingStudySeriesComponent.getUid(), false);
            this.composeStringCore("description", imagingStudySeriesComponent.getDescription(), false);
            this.composeStringExtras("description", imagingStudySeriesComponent.getDescription(), false);
            this.composeIntegerCore("numberOfInstances", imagingStudySeriesComponent.getNumberOfInstances(), false);
            this.composeIntegerExtras("numberOfInstances", imagingStudySeriesComponent.getNumberOfInstances(), false);
            if (imagingStudySeriesComponent.getAvailability() != null) {
                this.composeEnumerationCore("availability", imagingStudySeriesComponent.getAvailability(), new ImagingStudy.InstanceAvailabilityEnumFactory(), false);
                this.composeEnumerationExtras("availability", imagingStudySeriesComponent.getAvailability(), new ImagingStudy.InstanceAvailabilityEnumFactory(), false);
            }
            this.composeUriCore("url", imagingStudySeriesComponent.getUrl(), false);
            this.composeUriExtras("url", imagingStudySeriesComponent.getUrl(), false);
            this.composeCoding("bodySite", imagingStudySeriesComponent.getBodySite());
            this.composeDateTimeCore("dateTime", imagingStudySeriesComponent.getDateTime(), false);
            this.composeDateTimeExtras("dateTime", imagingStudySeriesComponent.getDateTime(), false);
            if (imagingStudySeriesComponent.getInstance().size() > 0) {
                this.openArray("instance");
                for (ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : imagingStudySeriesComponent.getInstance()) {
                    this.composeImagingStudyImagingStudySeriesInstanceComponent(null, imagingStudySeriesInstanceComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeImagingStudyImagingStudySeriesInstanceComponent(String string, ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent) throws Exception {
        if (imagingStudySeriesInstanceComponent != null) {
            this.open(string);
            this.composeBackbone(imagingStudySeriesInstanceComponent);
            this.composeIntegerCore("number", imagingStudySeriesInstanceComponent.getNumber(), false);
            this.composeIntegerExtras("number", imagingStudySeriesInstanceComponent.getNumber(), false);
            this.composeOidCore("uid", imagingStudySeriesInstanceComponent.getUid(), false);
            this.composeOidExtras("uid", imagingStudySeriesInstanceComponent.getUid(), false);
            this.composeOidCore("sopclass", imagingStudySeriesInstanceComponent.getSopclass(), false);
            this.composeOidExtras("sopclass", imagingStudySeriesInstanceComponent.getSopclass(), false);
            this.composeStringCore("type", imagingStudySeriesInstanceComponent.getType(), false);
            this.composeStringExtras("type", imagingStudySeriesInstanceComponent.getType(), false);
            this.composeStringCore("title", imagingStudySeriesInstanceComponent.getTitle(), false);
            this.composeStringExtras("title", imagingStudySeriesInstanceComponent.getTitle(), false);
            this.composeUriCore("url", imagingStudySeriesInstanceComponent.getUrl(), false);
            this.composeUriExtras("url", imagingStudySeriesInstanceComponent.getUrl(), false);
            this.composeResourceReference("attachment", imagingStudySeriesInstanceComponent.getAttachment());
            this.close();
        }
    }

    private void composeImmunization(String string, Immunization immunization) throws Exception {
        if (immunization != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(immunization);
            if (immunization.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : immunization.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeDateTimeCore("date", immunization.getDate(), false);
            this.composeDateTimeExtras("date", immunization.getDate(), false);
            this.composeCodeableConcept("vaccineType", immunization.getVaccineType());
            this.composeResourceReference("subject", immunization.getSubject());
            this.composeBooleanCore("refusedIndicator", immunization.getRefusedIndicator(), false);
            this.composeBooleanExtras("refusedIndicator", immunization.getRefusedIndicator(), false);
            this.composeBooleanCore("reported", immunization.getReported(), false);
            this.composeBooleanExtras("reported", immunization.getReported(), false);
            this.composeResourceReference("performer", immunization.getPerformer());
            this.composeResourceReference("requester", immunization.getRequester());
            this.composeResourceReference("manufacturer", immunization.getManufacturer());
            this.composeResourceReference("location", immunization.getLocation());
            this.composeStringCore("lotNumber", immunization.getLotNumber(), false);
            this.composeStringExtras("lotNumber", immunization.getLotNumber(), false);
            this.composeDateCore("expirationDate", immunization.getExpirationDate(), false);
            this.composeDateExtras("expirationDate", immunization.getExpirationDate(), false);
            this.composeCodeableConcept("site", immunization.getSite());
            this.composeCodeableConcept("route", immunization.getRoute());
            this.composeQuantity("doseQuantity", immunization.getDoseQuantity());
            this.composeImmunizationImmunizationExplanationComponent("explanation", immunization.getExplanation());
            if (immunization.getReaction().size() > 0) {
                this.openArray("reaction");
                for (Immunization.ImmunizationReactionComponent immunizationReactionComponent : immunization.getReaction()) {
                    this.composeImmunizationImmunizationReactionComponent(null, immunizationReactionComponent);
                }
                this.closeArray();
            }
            if (immunization.getVaccinationProtocol().size() > 0) {
                this.openArray("vaccinationProtocol");
                for (Immunization.ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent : immunization.getVaccinationProtocol()) {
                    this.composeImmunizationImmunizationVaccinationProtocolComponent(null, immunizationVaccinationProtocolComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeImmunizationImmunizationExplanationComponent(String string, Immunization.ImmunizationExplanationComponent immunizationExplanationComponent) throws Exception {
        if (immunizationExplanationComponent != null) {
            this.open(string);
            this.composeBackbone(immunizationExplanationComponent);
            if (immunizationExplanationComponent.getReason().size() > 0) {
                this.openArray("reason");
                for (CodeableConcept codeableConcept : immunizationExplanationComponent.getReason()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            if (immunizationExplanationComponent.getRefusalReason().size() > 0) {
                this.openArray("refusalReason");
                for (CodeableConcept codeableConcept : immunizationExplanationComponent.getRefusalReason()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeImmunizationImmunizationReactionComponent(String string, Immunization.ImmunizationReactionComponent immunizationReactionComponent) throws Exception {
        if (immunizationReactionComponent != null) {
            this.open(string);
            this.composeBackbone(immunizationReactionComponent);
            this.composeDateTimeCore("date", immunizationReactionComponent.getDate(), false);
            this.composeDateTimeExtras("date", immunizationReactionComponent.getDate(), false);
            this.composeResourceReference("detail", immunizationReactionComponent.getDetail());
            this.composeBooleanCore("reported", immunizationReactionComponent.getReported(), false);
            this.composeBooleanExtras("reported", immunizationReactionComponent.getReported(), false);
            this.close();
        }
    }

    private void composeImmunizationImmunizationVaccinationProtocolComponent(String string, Immunization.ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent) throws Exception {
        if (immunizationVaccinationProtocolComponent != null) {
            this.open(string);
            this.composeBackbone(immunizationVaccinationProtocolComponent);
            this.composeIntegerCore("doseSequence", immunizationVaccinationProtocolComponent.getDoseSequence(), false);
            this.composeIntegerExtras("doseSequence", immunizationVaccinationProtocolComponent.getDoseSequence(), false);
            this.composeStringCore("description", immunizationVaccinationProtocolComponent.getDescription(), false);
            this.composeStringExtras("description", immunizationVaccinationProtocolComponent.getDescription(), false);
            this.composeResourceReference("authority", immunizationVaccinationProtocolComponent.getAuthority());
            this.composeStringCore("series", immunizationVaccinationProtocolComponent.getSeries(), false);
            this.composeStringExtras("series", immunizationVaccinationProtocolComponent.getSeries(), false);
            this.composeIntegerCore("seriesDoses", immunizationVaccinationProtocolComponent.getSeriesDoses(), false);
            this.composeIntegerExtras("seriesDoses", immunizationVaccinationProtocolComponent.getSeriesDoses(), false);
            this.composeCodeableConcept("doseTarget", immunizationVaccinationProtocolComponent.getDoseTarget());
            this.composeCodeableConcept("doseStatus", immunizationVaccinationProtocolComponent.getDoseStatus());
            this.composeCodeableConcept("doseStatusReason", immunizationVaccinationProtocolComponent.getDoseStatusReason());
            this.close();
        }
    }

    private void composeImmunizationRecommendation(String string, ImmunizationRecommendation immunizationRecommendation) throws Exception {
        if (immunizationRecommendation != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(immunizationRecommendation);
            if (immunizationRecommendation.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : immunizationRecommendation.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("subject", immunizationRecommendation.getSubject());
            if (immunizationRecommendation.getRecommendation().size() > 0) {
                this.openArray("recommendation");
                for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : immunizationRecommendation.getRecommendation()) {
                    this.composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(null, immunizationRecommendationRecommendationComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(String string, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent) throws Exception {
        if (immunizationRecommendationRecommendationComponent != null) {
            this.open(string);
            this.composeBackbone(immunizationRecommendationRecommendationComponent);
            this.composeDateTimeCore("date", immunizationRecommendationRecommendationComponent.getDate(), false);
            this.composeDateTimeExtras("date", immunizationRecommendationRecommendationComponent.getDate(), false);
            this.composeCodeableConcept("vaccineType", immunizationRecommendationRecommendationComponent.getVaccineType());
            this.composeIntegerCore("doseNumber", immunizationRecommendationRecommendationComponent.getDoseNumber(), false);
            this.composeIntegerExtras("doseNumber", immunizationRecommendationRecommendationComponent.getDoseNumber(), false);
            this.composeCodeableConcept("forecastStatus", immunizationRecommendationRecommendationComponent.getForecastStatus());
            if (immunizationRecommendationRecommendationComponent.getDateCriterion().size() > 0) {
                this.openArray("dateCriterion");
                for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element : immunizationRecommendationRecommendationComponent.getDateCriterion()) {
                    this.composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(null, element);
                }
                this.closeArray();
            }
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent("protocol", immunizationRecommendationRecommendationComponent.getProtocol());
            if (immunizationRecommendationRecommendationComponent.getSupportingImmunization().size() > 0) {
                this.openArray("supportingImmunization");
                for (ResourceReference resourceReference : immunizationRecommendationRecommendationComponent.getSupportingImmunization()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (immunizationRecommendationRecommendationComponent.getSupportingPatientInformation().size() > 0) {
                this.openArray("supportingPatientInformation");
                for (ResourceReference resourceReference : immunizationRecommendationRecommendationComponent.getSupportingPatientInformation()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(String string, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent) throws Exception {
        if (immunizationRecommendationRecommendationDateCriterionComponent != null) {
            this.open(string);
            this.composeBackbone(immunizationRecommendationRecommendationDateCriterionComponent);
            this.composeCodeableConcept("code", immunizationRecommendationRecommendationDateCriterionComponent.getCode());
            this.composeDateTimeCore("value", immunizationRecommendationRecommendationDateCriterionComponent.getValue(), false);
            this.composeDateTimeExtras("value", immunizationRecommendationRecommendationDateCriterionComponent.getValue(), false);
            this.close();
        }
    }

    private void composeImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(String string, ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent immunizationRecommendationRecommendationProtocolComponent) throws Exception {
        if (immunizationRecommendationRecommendationProtocolComponent != null) {
            this.open(string);
            this.composeBackbone(immunizationRecommendationRecommendationProtocolComponent);
            this.composeIntegerCore("doseSequence", immunizationRecommendationRecommendationProtocolComponent.getDoseSequence(), false);
            this.composeIntegerExtras("doseSequence", immunizationRecommendationRecommendationProtocolComponent.getDoseSequence(), false);
            this.composeStringCore("description", immunizationRecommendationRecommendationProtocolComponent.getDescription(), false);
            this.composeStringExtras("description", immunizationRecommendationRecommendationProtocolComponent.getDescription(), false);
            this.composeResourceReference("authority", immunizationRecommendationRecommendationProtocolComponent.getAuthority());
            this.composeStringCore("series", immunizationRecommendationRecommendationProtocolComponent.getSeries(), false);
            this.composeStringExtras("series", immunizationRecommendationRecommendationProtocolComponent.getSeries(), false);
            this.close();
        }
    }

    private void composeList_(String string, List_ list_) throws Exception {
        if (list_ != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(list_);
            if (list_.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : list_.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("code", list_.getCode());
            this.composeResourceReference("subject", list_.getSubject());
            this.composeResourceReference("source", list_.getSource());
            this.composeDateTimeCore("date", list_.getDate(), false);
            this.composeDateTimeExtras("date", list_.getDate(), false);
            this.composeBooleanCore("ordered", list_.getOrdered(), false);
            this.composeBooleanExtras("ordered", list_.getOrdered(), false);
            if (list_.getMode() != null) {
                this.composeEnumerationCore("mode", list_.getMode(), new List_.ListModeEnumFactory(), false);
                this.composeEnumerationExtras("mode", list_.getMode(), new List_.ListModeEnumFactory(), false);
            }
            if (list_.getEntry().size() > 0) {
                this.openArray("entry");
                for (List_.ListEntryComponent listEntryComponent : list_.getEntry()) {
                    this.composeList_ListEntryComponent(null, listEntryComponent);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("emptyReason", list_.getEmptyReason());
        }
    }

    private void composeList_ListEntryComponent(String string, List_.ListEntryComponent listEntryComponent) throws Exception {
        if (listEntryComponent != null) {
            this.open(string);
            this.composeBackbone(listEntryComponent);
            if (listEntryComponent.getFlag().size() > 0) {
                this.openArray("flag");
                for (CodeableConcept codeableConcept : listEntryComponent.getFlag()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composeBooleanCore("deleted", listEntryComponent.getDeleted(), false);
            this.composeBooleanExtras("deleted", listEntryComponent.getDeleted(), false);
            this.composeDateTimeCore("date", listEntryComponent.getDate(), false);
            this.composeDateTimeExtras("date", listEntryComponent.getDate(), false);
            this.composeResourceReference("item", listEntryComponent.getItem());
            this.close();
        }
    }

    private void composeLocation(String string, Location location) throws Exception {
        if (location != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(location);
            this.composeIdentifier("identifier", location.getIdentifier());
            this.composeStringCore("name", location.getName(), false);
            this.composeStringExtras("name", location.getName(), false);
            this.composeStringCore("description", location.getDescription(), false);
            this.composeStringExtras("description", location.getDescription(), false);
            this.composeCodeableConcept("type", location.getType());
            if (location.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact contact : location.getTelecom()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            this.composeAddress("address", location.getAddress());
            this.composeCodeableConcept("physicalType", location.getPhysicalType());
            this.composeLocationLocationPositionComponent("position", location.getPosition());
            this.composeResourceReference("managingOrganization", location.getManagingOrganization());
            if (location.getStatus() != null) {
                this.composeEnumerationCore("status", location.getStatus(), new Location.LocationStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", location.getStatus(), new Location.LocationStatusEnumFactory(), false);
            }
            this.composeResourceReference("partOf", location.getPartOf());
            if (location.getMode() != null) {
                this.composeEnumerationCore("mode", location.getMode(), new Location.LocationModeEnumFactory(), false);
                this.composeEnumerationExtras("mode", location.getMode(), new Location.LocationModeEnumFactory(), false);
            }
        }
    }

    private void composeLocationLocationPositionComponent(String string, Location.LocationPositionComponent locationPositionComponent) throws Exception {
        if (locationPositionComponent != null) {
            this.open(string);
            this.composeBackbone(locationPositionComponent);
            this.composeDecimalCore("longitude", locationPositionComponent.getLongitude(), false);
            this.composeDecimalExtras("longitude", locationPositionComponent.getLongitude(), false);
            this.composeDecimalCore("latitude", locationPositionComponent.getLatitude(), false);
            this.composeDecimalExtras("latitude", locationPositionComponent.getLatitude(), false);
            this.composeDecimalCore("altitude", locationPositionComponent.getAltitude(), false);
            this.composeDecimalExtras("altitude", locationPositionComponent.getAltitude(), false);
            this.close();
        }
    }

    private void composeMedia(String string, Media media) throws Exception {
        if (media != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(media);
            if (media.getType() != null) {
                this.composeEnumerationCore("type", media.getType(), new Media.MediaTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", media.getType(), new Media.MediaTypeEnumFactory(), false);
            }
            this.composeCodeableConcept("subtype", media.getSubtype());
            if (media.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier identifier : media.getIdentifier()) {
                    this.composeIdentifier(null, identifier);
                }
                this.closeArray();
            }
            this.composeDateTimeCore("dateTime", media.getDateTime(), false);
            this.composeDateTimeExtras("dateTime", media.getDateTime(), false);
            this.composeResourceReference("subject", media.getSubject());
            this.composeResourceReference("operator", media.getOperator());
            this.composeCodeableConcept("view", media.getView());
            this.composeStringCore("deviceName", media.getDeviceName(), false);
            this.composeStringExtras("deviceName", media.getDeviceName(), false);
            this.composeIntegerCore("height", media.getHeight(), false);
            this.composeIntegerExtras("height", media.getHeight(), false);
            this.composeIntegerCore("width", media.getWidth(), false);
            this.composeIntegerExtras("width", media.getWidth(), false);
            this.composeIntegerCore("frames", media.getFrames(), false);
            this.composeIntegerExtras("frames", media.getFrames(), false);
            this.composeIntegerCore("length", media.getLength(), false);
            this.composeIntegerExtras("length", media.getLength(), false);
            this.composeAttachment("content", media.getContent());
        }
    }

    private void composeMedication(String string, Medication medication) throws Exception {
        if (medication != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(medication);
            this.composeStringCore("name", medication.getName(), false);
            this.composeStringExtras("name", medication.getName(), false);
            this.composeCodeableConcept("code", medication.getCode());
            this.composeBooleanCore("isBrand", medication.getIsBrand(), false);
            this.composeBooleanExtras("isBrand", medication.getIsBrand(), false);
            this.composeResourceReference("manufacturer", medication.getManufacturer());
            if (medication.getKind() != null) {
                this.composeEnumerationCore("kind", medication.getKind(), new Medication.MedicationKindEnumFactory(), false);
                this.composeEnumerationExtras("kind", medication.getKind(), new Medication.MedicationKindEnumFactory(), false);
            }
            this.composeMedicationMedicationProductComponent("product", medication.getProduct());
            this.composeMedicationMedicationPackageComponent("package", medication.getPackage());
        }
    }

    private void composeMedicationMedicationProductComponent(String string, Medication.MedicationProductComponent medicationProductComponent) throws Exception {
        if (medicationProductComponent != null) {
            this.open(string);
            this.composeBackbone(medicationProductComponent);
            this.composeCodeableConcept("form", medicationProductComponent.getForm());
            if (medicationProductComponent.getIngredient().size() > 0) {
                this.openArray("ingredient");
                for (Medication.MedicationProductIngredientComponent medicationProductIngredientComponent : medicationProductComponent.getIngredient()) {
                    this.composeMedicationMedicationProductIngredientComponent(null, medicationProductIngredientComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeMedicationMedicationProductIngredientComponent(String string, Medication.MedicationProductIngredientComponent medicationProductIngredientComponent) throws Exception {
        if (medicationProductIngredientComponent != null) {
            this.open(string);
            this.composeBackbone(medicationProductIngredientComponent);
            this.composeResourceReference("item", medicationProductIngredientComponent.getItem());
            this.composeRatio("amount", medicationProductIngredientComponent.getAmount());
            this.close();
        }
    }

    private void composeMedicationMedicationPackageComponent(String string, Medication.MedicationPackageComponent medicationPackageComponent) throws Exception {
        if (medicationPackageComponent != null) {
            this.open(string);
            this.composeBackbone(medicationPackageComponent);
            this.composeCodeableConcept("container", medicationPackageComponent.getContainer());
            if (medicationPackageComponent.getContent().size() > 0) {
                this.openArray("content");
                for (Medication.MedicationPackageContentComponent medicationPackageContentComponent : medicationPackageComponent.getContent()) {
                    this.composeMedicationMedicationPackageContentComponent(null, medicationPackageContentComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeMedicationMedicationPackageContentComponent(String string, Medication.MedicationPackageContentComponent medicationPackageContentComponent) throws Exception {
        if (medicationPackageContentComponent != null) {
            this.open(string);
            this.composeBackbone(medicationPackageContentComponent);
            this.composeResourceReference("item", medicationPackageContentComponent.getItem());
            this.composeQuantity("amount", medicationPackageContentComponent.getAmount());
            this.close();
        }
    }

    private void composeMedicationAdministration(String string, MedicationAdministration medicationAdministration) throws Exception {
        if (medicationAdministration != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(medicationAdministration);
            if (medicationAdministration.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : medicationAdministration.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            if (medicationAdministration.getStatus() != null) {
                this.composeEnumerationCore("status", medicationAdministration.getStatus(), new MedicationAdministration.MedicationAdminStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", medicationAdministration.getStatus(), new MedicationAdministration.MedicationAdminStatusEnumFactory(), false);
            }
            this.composeResourceReference("patient", medicationAdministration.getPatient());
            this.composeResourceReference("practitioner", medicationAdministration.getPractitioner());
            this.composeResourceReference("encounter", medicationAdministration.getEncounter());
            this.composeResourceReference("prescription", medicationAdministration.getPrescription());
            this.composeBooleanCore("wasNotGiven", medicationAdministration.getWasNotGiven(), false);
            this.composeBooleanExtras("wasNotGiven", medicationAdministration.getWasNotGiven(), false);
            if (medicationAdministration.getReasonNotGiven().size() > 0) {
                this.openArray("reasonNotGiven");
                for (CodeableConcept codeableConcept : medicationAdministration.getReasonNotGiven()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composePeriod("whenGiven", medicationAdministration.getWhenGiven());
            this.composeResourceReference("medication", medicationAdministration.getMedication());
            if (medicationAdministration.getDevice().size() > 0) {
                this.openArray("device");
                for (ResourceReference resourceReference : medicationAdministration.getDevice()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (medicationAdministration.getDosage().size() > 0) {
                this.openArray("dosage");
                for (MedicationAdministration.MedicationAdministrationDosageComponent medicationAdministrationDosageComponent : medicationAdministration.getDosage()) {
                    this.composeMedicationAdministrationMedicationAdministrationDosageComponent(null, medicationAdministrationDosageComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeMedicationAdministrationMedicationAdministrationDosageComponent(String string, MedicationAdministration.MedicationAdministrationDosageComponent medicationAdministrationDosageComponent) throws Exception {
        if (medicationAdministrationDosageComponent != null) {
            this.open(string);
            this.composeBackbone(medicationAdministrationDosageComponent);
            this.composeType("timing", medicationAdministrationDosageComponent.getTiming());
            this.composeType("asNeeded", medicationAdministrationDosageComponent.getAsNeeded());
            this.composeCodeableConcept("site", medicationAdministrationDosageComponent.getSite());
            this.composeCodeableConcept("route", medicationAdministrationDosageComponent.getRoute());
            this.composeCodeableConcept("method", medicationAdministrationDosageComponent.getMethod());
            this.composeQuantity("quantity", medicationAdministrationDosageComponent.getQuantity());
            this.composeRatio("rate", medicationAdministrationDosageComponent.getRate());
            this.composeRatio("maxDosePerPeriod", medicationAdministrationDosageComponent.getMaxDosePerPeriod());
            this.close();
        }
    }

    private void composeMedicationDispense(String string, MedicationDispense medicationDispense) throws Exception {
        if (medicationDispense != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(medicationDispense);
            this.composeIdentifier("identifier", medicationDispense.getIdentifier());
            if (medicationDispense.getStatus() != null) {
                this.composeEnumerationCore("status", medicationDispense.getStatus(), new MedicationDispense.MedicationDispenseStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", medicationDispense.getStatus(), new MedicationDispense.MedicationDispenseStatusEnumFactory(), false);
            }
            this.composeResourceReference("patient", medicationDispense.getPatient());
            this.composeResourceReference("dispenser", medicationDispense.getDispenser());
            if (medicationDispense.getAuthorizingPrescription().size() > 0) {
                this.openArray("authorizingPrescription");
                for (ResourceReference element : medicationDispense.getAuthorizingPrescription()) {
                    this.composeResourceReference(null, element);
                }
                this.closeArray();
            }
            if (medicationDispense.getDispense().size() > 0) {
                this.openArray("dispense");
                for (MedicationDispense.MedicationDispenseDispenseComponent medicationDispenseDispenseComponent : medicationDispense.getDispense()) {
                    this.composeMedicationDispenseMedicationDispenseDispenseComponent(null, medicationDispenseDispenseComponent);
                }
                this.closeArray();
            }
            this.composeMedicationDispenseMedicationDispenseSubstitutionComponent("substitution", medicationDispense.getSubstitution());
        }
    }

    private void composeMedicationDispenseMedicationDispenseDispenseComponent(String string, MedicationDispense.MedicationDispenseDispenseComponent medicationDispenseDispenseComponent) throws Exception {
        if (medicationDispenseDispenseComponent != null) {
            this.open(string);
            this.composeBackbone(medicationDispenseDispenseComponent);
            this.composeIdentifier("identifier", medicationDispenseDispenseComponent.getIdentifier());
            if (medicationDispenseDispenseComponent.getStatus() != null) {
                this.composeEnumerationCore("status", medicationDispenseDispenseComponent.getStatus(), new MedicationDispense.MedicationDispenseStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", medicationDispenseDispenseComponent.getStatus(), new MedicationDispense.MedicationDispenseStatusEnumFactory(), false);
            }
            this.composeCodeableConcept("type", medicationDispenseDispenseComponent.getType());
            this.composeQuantity("quantity", medicationDispenseDispenseComponent.getQuantity());
            this.composeResourceReference("medication", medicationDispenseDispenseComponent.getMedication());
            this.composeDateTimeCore("whenPrepared", medicationDispenseDispenseComponent.getWhenPrepared(), false);
            this.composeDateTimeExtras("whenPrepared", medicationDispenseDispenseComponent.getWhenPrepared(), false);
            this.composeDateTimeCore("whenHandedOver", medicationDispenseDispenseComponent.getWhenHandedOver(), false);
            this.composeDateTimeExtras("whenHandedOver", medicationDispenseDispenseComponent.getWhenHandedOver(), false);
            this.composeResourceReference("destination", medicationDispenseDispenseComponent.getDestination());
            if (medicationDispenseDispenseComponent.getReceiver().size() > 0) {
                this.openArray("receiver");
                for (ResourceReference element : medicationDispenseDispenseComponent.getReceiver()) {
                    this.composeResourceReference(null, element);
                }
                this.closeArray();
            }
            if (medicationDispenseDispenseComponent.getDosage().size() > 0) {
                this.openArray("dosage");
                for (MedicationDispense.MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent : medicationDispenseDispenseComponent.getDosage()) {
                    this.composeMedicationDispenseMedicationDispenseDispenseDosageComponent(null, medicationDispenseDispenseDosageComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeMedicationDispenseMedicationDispenseDispenseDosageComponent(String string, MedicationDispense.MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent) throws Exception {
        if (medicationDispenseDispenseDosageComponent != null) {
            this.open(string);
            this.composeBackbone(medicationDispenseDispenseDosageComponent);
            this.composeCodeableConcept("additionalInstructions", medicationDispenseDispenseDosageComponent.getAdditionalInstructions());
            this.composeType("timing", medicationDispenseDispenseDosageComponent.getTiming());
            this.composeType("asNeeded", medicationDispenseDispenseDosageComponent.getAsNeeded());
            this.composeCodeableConcept("site", medicationDispenseDispenseDosageComponent.getSite());
            this.composeCodeableConcept("route", medicationDispenseDispenseDosageComponent.getRoute());
            this.composeCodeableConcept("method", medicationDispenseDispenseDosageComponent.getMethod());
            this.composeQuantity("quantity", medicationDispenseDispenseDosageComponent.getQuantity());
            this.composeRatio("rate", medicationDispenseDispenseDosageComponent.getRate());
            this.composeRatio("maxDosePerPeriod", medicationDispenseDispenseDosageComponent.getMaxDosePerPeriod());
            this.close();
        }
    }

    private void composeMedicationDispenseMedicationDispenseSubstitutionComponent(String string, MedicationDispense.MedicationDispenseSubstitutionComponent medicationDispenseSubstitutionComponent) throws Exception {
        if (medicationDispenseSubstitutionComponent != null) {
            this.open(string);
            this.composeBackbone(medicationDispenseSubstitutionComponent);
            this.composeCodeableConcept("type", medicationDispenseSubstitutionComponent.getType());
            if (medicationDispenseSubstitutionComponent.getReason().size() > 0) {
                this.openArray("reason");
                for (CodeableConcept type : medicationDispenseSubstitutionComponent.getReason()) {
                    this.composeCodeableConcept(null, type);
                }
                this.closeArray();
            }
            if (medicationDispenseSubstitutionComponent.getResponsibleParty().size() > 0) {
                this.openArray("responsibleParty");
                for (ResourceReference resourceReference : medicationDispenseSubstitutionComponent.getResponsibleParty()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeMedicationPrescription(String string, MedicationPrescription medicationPrescription) throws Exception {
        if (medicationPrescription != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(medicationPrescription);
            if (medicationPrescription.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : medicationPrescription.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeDateTimeCore("dateWritten", medicationPrescription.getDateWritten(), false);
            this.composeDateTimeExtras("dateWritten", medicationPrescription.getDateWritten(), false);
            if (medicationPrescription.getStatus() != null) {
                this.composeEnumerationCore("status", medicationPrescription.getStatus(), new MedicationPrescription.MedicationPrescriptionStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", medicationPrescription.getStatus(), new MedicationPrescription.MedicationPrescriptionStatusEnumFactory(), false);
            }
            this.composeResourceReference("patient", medicationPrescription.getPatient());
            this.composeResourceReference("prescriber", medicationPrescription.getPrescriber());
            this.composeResourceReference("encounter", medicationPrescription.getEncounter());
            this.composeType("reason", medicationPrescription.getReason());
            this.composeResourceReference("medication", medicationPrescription.getMedication());
            if (medicationPrescription.getDosageInstruction().size() > 0) {
                this.openArray("dosageInstruction");
                for (MedicationPrescription.MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent : medicationPrescription.getDosageInstruction()) {
                    this.composeMedicationPrescriptionMedicationPrescriptionDosageInstructionComponent(null, medicationPrescriptionDosageInstructionComponent);
                }
                this.closeArray();
            }
            this.composeMedicationPrescriptionMedicationPrescriptionDispenseComponent("dispense", medicationPrescription.getDispense());
            this.composeMedicationPrescriptionMedicationPrescriptionSubstitutionComponent("substitution", medicationPrescription.getSubstitution());
        }
    }

    private void composeMedicationPrescriptionMedicationPrescriptionDosageInstructionComponent(String string, MedicationPrescription.MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent) throws Exception {
        if (medicationPrescriptionDosageInstructionComponent != null) {
            this.open(string);
            this.composeBackbone(medicationPrescriptionDosageInstructionComponent);
            this.composeStringCore("text", medicationPrescriptionDosageInstructionComponent.getText(), false);
            this.composeStringExtras("text", medicationPrescriptionDosageInstructionComponent.getText(), false);
            this.composeCodeableConcept("additionalInstructions", medicationPrescriptionDosageInstructionComponent.getAdditionalInstructions());
            this.composeType("timing", medicationPrescriptionDosageInstructionComponent.getTiming());
            this.composeType("asNeeded", medicationPrescriptionDosageInstructionComponent.getAsNeeded());
            this.composeCodeableConcept("site", medicationPrescriptionDosageInstructionComponent.getSite());
            this.composeCodeableConcept("route", medicationPrescriptionDosageInstructionComponent.getRoute());
            this.composeCodeableConcept("method", medicationPrescriptionDosageInstructionComponent.getMethod());
            this.composeQuantity("doseQuantity", medicationPrescriptionDosageInstructionComponent.getDoseQuantity());
            this.composeRatio("rate", medicationPrescriptionDosageInstructionComponent.getRate());
            this.composeRatio("maxDosePerPeriod", medicationPrescriptionDosageInstructionComponent.getMaxDosePerPeriod());
            this.close();
        }
    }

    private void composeMedicationPrescriptionMedicationPrescriptionDispenseComponent(String string, MedicationPrescription.MedicationPrescriptionDispenseComponent medicationPrescriptionDispenseComponent) throws Exception {
        if (medicationPrescriptionDispenseComponent != null) {
            this.open(string);
            this.composeBackbone(medicationPrescriptionDispenseComponent);
            this.composeResourceReference("medication", medicationPrescriptionDispenseComponent.getMedication());
            this.composePeriod("validityPeriod", medicationPrescriptionDispenseComponent.getValidityPeriod());
            this.composeIntegerCore("numberOfRepeatsAllowed", medicationPrescriptionDispenseComponent.getNumberOfRepeatsAllowed(), false);
            this.composeIntegerExtras("numberOfRepeatsAllowed", medicationPrescriptionDispenseComponent.getNumberOfRepeatsAllowed(), false);
            this.composeQuantity("quantity", medicationPrescriptionDispenseComponent.getQuantity());
            this.composeDuration("expectedSupplyDuration", medicationPrescriptionDispenseComponent.getExpectedSupplyDuration());
            this.close();
        }
    }

    private void composeMedicationPrescriptionMedicationPrescriptionSubstitutionComponent(String string, MedicationPrescription.MedicationPrescriptionSubstitutionComponent medicationPrescriptionSubstitutionComponent) throws Exception {
        if (medicationPrescriptionSubstitutionComponent != null) {
            this.open(string);
            this.composeBackbone(medicationPrescriptionSubstitutionComponent);
            this.composeCodeableConcept("type", medicationPrescriptionSubstitutionComponent.getType());
            this.composeCodeableConcept("reason", medicationPrescriptionSubstitutionComponent.getReason());
            this.close();
        }
    }

    private void composeMedicationStatement(String string, MedicationStatement medicationStatement) throws Exception {
        if (medicationStatement != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(medicationStatement);
            if (medicationStatement.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : medicationStatement.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("patient", medicationStatement.getPatient());
            this.composeBooleanCore("wasNotGiven", medicationStatement.getWasNotGiven(), false);
            this.composeBooleanExtras("wasNotGiven", medicationStatement.getWasNotGiven(), false);
            if (medicationStatement.getReasonNotGiven().size() > 0) {
                this.openArray("reasonNotGiven");
                for (CodeableConcept codeableConcept : medicationStatement.getReasonNotGiven()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composePeriod("whenGiven", medicationStatement.getWhenGiven());
            this.composeResourceReference("medication", medicationStatement.getMedication());
            if (medicationStatement.getDevice().size() > 0) {
                this.openArray("device");
                for (ResourceReference resourceReference : medicationStatement.getDevice()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (medicationStatement.getDosage().size() > 0) {
                this.openArray("dosage");
                for (MedicationStatement.MedicationStatementDosageComponent medicationStatementDosageComponent : medicationStatement.getDosage()) {
                    this.composeMedicationStatementMedicationStatementDosageComponent(null, medicationStatementDosageComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeMedicationStatementMedicationStatementDosageComponent(String string, MedicationStatement.MedicationStatementDosageComponent medicationStatementDosageComponent) throws Exception {
        if (medicationStatementDosageComponent != null) {
            this.open(string);
            this.composeBackbone(medicationStatementDosageComponent);
            this.composeSchedule("timing", medicationStatementDosageComponent.getTiming());
            this.composeType("asNeeded", medicationStatementDosageComponent.getAsNeeded());
            this.composeCodeableConcept("site", medicationStatementDosageComponent.getSite());
            this.composeCodeableConcept("route", medicationStatementDosageComponent.getRoute());
            this.composeCodeableConcept("method", medicationStatementDosageComponent.getMethod());
            this.composeQuantity("quantity", medicationStatementDosageComponent.getQuantity());
            this.composeRatio("rate", medicationStatementDosageComponent.getRate());
            this.composeRatio("maxDosePerPeriod", medicationStatementDosageComponent.getMaxDosePerPeriod());
            this.close();
        }
    }

    private void composeMessageHeader(String string, MessageHeader messageHeader) throws Exception {
        if (messageHeader != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(messageHeader);
            this.composeIdCore("identifier", messageHeader.getIdentifier(), false);
            this.composeIdExtras("identifier", messageHeader.getIdentifier(), false);
            this.composeInstantCore("timestamp", messageHeader.getTimestamp(), false);
            this.composeInstantExtras("timestamp", messageHeader.getTimestamp(), false);
            this.composeCoding("event", messageHeader.getEvent());
            this.composeMessageHeaderMessageHeaderResponseComponent("response", messageHeader.getResponse());
            this.composeMessageHeaderMessageSourceComponent("source", messageHeader.getSource());
            if (messageHeader.getDestination().size() > 0) {
                this.openArray("destination");
                for (MessageHeader.MessageDestinationComponent element : messageHeader.getDestination()) {
                    this.composeMessageHeaderMessageDestinationComponent(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("enterer", messageHeader.getEnterer());
            this.composeResourceReference("author", messageHeader.getAuthor());
            this.composeResourceReference("receiver", messageHeader.getReceiver());
            this.composeResourceReference("responsible", messageHeader.getResponsible());
            this.composeCodeableConcept("reason", messageHeader.getReason());
            if (messageHeader.getData().size() > 0) {
                this.openArray("data");
                for (ResourceReference resourceReference : messageHeader.getData()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
        }
    }

    private void composeMessageHeaderMessageHeaderResponseComponent(String string, MessageHeader.MessageHeaderResponseComponent messageHeaderResponseComponent) throws Exception {
        if (messageHeaderResponseComponent != null) {
            this.open(string);
            this.composeBackbone(messageHeaderResponseComponent);
            this.composeIdCore("identifier", messageHeaderResponseComponent.getIdentifier(), false);
            this.composeIdExtras("identifier", messageHeaderResponseComponent.getIdentifier(), false);
            if (messageHeaderResponseComponent.getCode() != null) {
                this.composeEnumerationCore("code", messageHeaderResponseComponent.getCode(), new MessageHeader.ResponseCodeEnumFactory(), false);
                this.composeEnumerationExtras("code", messageHeaderResponseComponent.getCode(), new MessageHeader.ResponseCodeEnumFactory(), false);
            }
            this.composeResourceReference("details", messageHeaderResponseComponent.getDetails());
            this.close();
        }
    }

    private void composeMessageHeaderMessageSourceComponent(String string, MessageHeader.MessageSourceComponent messageSourceComponent) throws Exception {
        if (messageSourceComponent != null) {
            this.open(string);
            this.composeBackbone(messageSourceComponent);
            this.composeStringCore("name", messageSourceComponent.getName(), false);
            this.composeStringExtras("name", messageSourceComponent.getName(), false);
            this.composeStringCore("software", messageSourceComponent.getSoftware(), false);
            this.composeStringExtras("software", messageSourceComponent.getSoftware(), false);
            this.composeStringCore("version", messageSourceComponent.getVersion(), false);
            this.composeStringExtras("version", messageSourceComponent.getVersion(), false);
            this.composeContact("contact", messageSourceComponent.getContact());
            this.composeUriCore("endpoint", messageSourceComponent.getEndpoint(), false);
            this.composeUriExtras("endpoint", messageSourceComponent.getEndpoint(), false);
            this.close();
        }
    }

    private void composeMessageHeaderMessageDestinationComponent(String string, MessageHeader.MessageDestinationComponent messageDestinationComponent) throws Exception {
        if (messageDestinationComponent != null) {
            this.open(string);
            this.composeBackbone(messageDestinationComponent);
            this.composeStringCore("name", messageDestinationComponent.getName(), false);
            this.composeStringExtras("name", messageDestinationComponent.getName(), false);
            this.composeResourceReference("target", messageDestinationComponent.getTarget());
            this.composeUriCore("endpoint", messageDestinationComponent.getEndpoint(), false);
            this.composeUriExtras("endpoint", messageDestinationComponent.getEndpoint(), false);
            this.close();
        }
    }

    private void composeObservation(String string, Observation observation) throws Exception {
        if (observation != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(observation);
            this.composeCodeableConcept("name", observation.getName());
            this.composeType("value", observation.getValue());
            this.composeCodeableConcept("interpretation", observation.getInterpretation());
            this.composeStringCore("comments", observation.getComments(), false);
            this.composeStringExtras("comments", observation.getComments(), false);
            this.composeType("applies", observation.getApplies());
            this.composeInstantCore("issued", observation.getIssued(), false);
            this.composeInstantExtras("issued", observation.getIssued(), false);
            if (observation.getStatus() != null) {
                this.composeEnumerationCore("status", observation.getStatus(), new Observation.ObservationStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", observation.getStatus(), new Observation.ObservationStatusEnumFactory(), false);
            }
            if (observation.getReliability() != null) {
                this.composeEnumerationCore("reliability", observation.getReliability(), new Observation.ObservationReliabilityEnumFactory(), false);
                this.composeEnumerationExtras("reliability", observation.getReliability(), new Observation.ObservationReliabilityEnumFactory(), false);
            }
            this.composeCodeableConcept("bodySite", observation.getBodySite());
            this.composeCodeableConcept("method", observation.getMethod());
            this.composeIdentifier("identifier", observation.getIdentifier());
            this.composeResourceReference("subject", observation.getSubject());
            this.composeResourceReference("specimen", observation.getSpecimen());
            if (observation.getPerformer().size() > 0) {
                this.openArray("performer");
                for (ResourceReference element : observation.getPerformer()) {
                    this.composeResourceReference(null, element);
                }
                this.closeArray();
            }
            if (observation.getReferenceRange().size() > 0) {
                this.openArray("referenceRange");
                for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : observation.getReferenceRange()) {
                    this.composeObservationObservationReferenceRangeComponent(null, observationReferenceRangeComponent);
                }
                this.closeArray();
            }
            if (observation.getRelated().size() > 0) {
                this.openArray("related");
                for (Observation.ObservationRelatedComponent observationRelatedComponent : observation.getRelated()) {
                    this.composeObservationObservationRelatedComponent(null, observationRelatedComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeObservationObservationReferenceRangeComponent(String string, Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent) throws Exception {
        if (observationReferenceRangeComponent != null) {
            this.open(string);
            this.composeBackbone(observationReferenceRangeComponent);
            this.composeQuantity("low", observationReferenceRangeComponent.getLow());
            this.composeQuantity("high", observationReferenceRangeComponent.getHigh());
            this.composeCodeableConcept("meaning", observationReferenceRangeComponent.getMeaning());
            this.composeRange("age", observationReferenceRangeComponent.getAge());
            this.close();
        }
    }

    private void composeObservationObservationRelatedComponent(String string, Observation.ObservationRelatedComponent observationRelatedComponent) throws Exception {
        if (observationRelatedComponent != null) {
            this.open(string);
            this.composeBackbone(observationRelatedComponent);
            if (observationRelatedComponent.getType() != null) {
                this.composeEnumerationCore("type", observationRelatedComponent.getType(), new Observation.ObservationRelationshiptypesEnumFactory(), false);
                this.composeEnumerationExtras("type", observationRelatedComponent.getType(), new Observation.ObservationRelationshiptypesEnumFactory(), false);
            }
            this.composeResourceReference("target", observationRelatedComponent.getTarget());
            this.close();
        }
    }

    private void composeOperationOutcome(String string, OperationOutcome operationOutcome) throws Exception {
        if (operationOutcome != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(operationOutcome);
            if (operationOutcome.getIssue().size() > 0) {
                this.openArray("issue");
                for (OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent : operationOutcome.getIssue()) {
                    this.composeOperationOutcomeOperationOutcomeIssueComponent(null, operationOutcomeIssueComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeOperationOutcomeOperationOutcomeIssueComponent(String string, OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent) throws Exception {
        if (operationOutcomeIssueComponent != null) {
            this.open(string);
            this.composeBackbone(operationOutcomeIssueComponent);
            if (operationOutcomeIssueComponent.getSeverity() != null) {
                this.composeEnumerationCore("severity", operationOutcomeIssueComponent.getSeverity(), new OperationOutcome.IssueSeverityEnumFactory(), false);
                this.composeEnumerationExtras("severity", operationOutcomeIssueComponent.getSeverity(), new OperationOutcome.IssueSeverityEnumFactory(), false);
            }
            this.composeCoding("type", operationOutcomeIssueComponent.getType());
            this.composeStringCore("details", operationOutcomeIssueComponent.getDetails(), false);
            this.composeStringExtras("details", operationOutcomeIssueComponent.getDetails(), false);
            if (operationOutcomeIssueComponent.getLocation().size() > 0) {
                this.openArray("location");
                for (StringType stringType : operationOutcomeIssueComponent.getLocation()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(operationOutcomeIssueComponent.getLocation())) {
                    this.openArray("_location");
                    for (StringType stringType : operationOutcomeIssueComponent.getLocation()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            this.close();
        }
    }

    private void composeOrder(String string, Order order) throws Exception {
        if (order != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(order);
            if (order.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier type : order.getIdentifier()) {
                    this.composeIdentifier(null, type);
                }
                this.closeArray();
            }
            this.composeDateTimeCore("date", order.getDate(), false);
            this.composeDateTimeExtras("date", order.getDate(), false);
            this.composeResourceReference("subject", order.getSubject());
            this.composeResourceReference("source", order.getSource());
            this.composeResourceReference("target", order.getTarget());
            this.composeType("reason", order.getReason());
            this.composeResourceReference("authority", order.getAuthority());
            this.composeOrderOrderWhenComponent("when", order.getWhen());
            if (order.getDetail().size() > 0) {
                this.openArray("detail");
                for (ResourceReference resourceReference : order.getDetail()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
        }
    }

    private void composeOrderOrderWhenComponent(String string, Order.OrderWhenComponent orderWhenComponent) throws Exception {
        if (orderWhenComponent != null) {
            this.open(string);
            this.composeBackbone(orderWhenComponent);
            this.composeCodeableConcept("code", orderWhenComponent.getCode());
            this.composeSchedule("schedule", orderWhenComponent.getSchedule());
            this.close();
        }
    }

    private void composeOrderResponse(String string, OrderResponse orderResponse) throws Exception {
        if (orderResponse != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(orderResponse);
            if (orderResponse.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier type : orderResponse.getIdentifier()) {
                    this.composeIdentifier(null, type);
                }
                this.closeArray();
            }
            this.composeResourceReference("request", orderResponse.getRequest());
            this.composeDateTimeCore("date", orderResponse.getDate(), false);
            this.composeDateTimeExtras("date", orderResponse.getDate(), false);
            this.composeResourceReference("who", orderResponse.getWho());
            this.composeType("authority", orderResponse.getAuthority());
            if (orderResponse.getCode() != null) {
                this.composeEnumerationCore("code", orderResponse.getCode(), new OrderResponse.OrderOutcomeCodeEnumFactory(), false);
                this.composeEnumerationExtras("code", orderResponse.getCode(), new OrderResponse.OrderOutcomeCodeEnumFactory(), false);
            }
            this.composeStringCore("description", orderResponse.getDescription(), false);
            this.composeStringExtras("description", orderResponse.getDescription(), false);
            if (orderResponse.getFulfillment().size() > 0) {
                this.openArray("fulfillment");
                for (ResourceReference resourceReference : orderResponse.getFulfillment()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
        }
    }

    private void composeOrganization(String string, Organization organization) throws Exception {
        if (organization != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(organization);
            if (organization.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : organization.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeStringCore("name", organization.getName(), false);
            this.composeStringExtras("name", organization.getName(), false);
            this.composeCodeableConcept("type", organization.getType());
            if (organization.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact contact : organization.getTelecom()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            if (organization.getAddress().size() > 0) {
                this.openArray("address");
                for (Address address : organization.getAddress()) {
                    this.composeAddress(null, address);
                }
                this.closeArray();
            }
            this.composeResourceReference("partOf", organization.getPartOf());
            if (organization.getContact().size() > 0) {
                this.openArray("contact");
                for (Organization.OrganizationContactComponent organizationContactComponent : organization.getContact()) {
                    this.composeOrganizationOrganizationContactComponent(null, organizationContactComponent);
                }
                this.closeArray();
            }
            if (organization.getLocation().size() > 0) {
                this.openArray("location");
                for (ResourceReference resourceReference : organization.getLocation()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.composeBooleanCore("active", organization.getActive(), false);
            this.composeBooleanExtras("active", organization.getActive(), false);
        }
    }

    private void composeOrganizationOrganizationContactComponent(String string, Organization.OrganizationContactComponent organizationContactComponent) throws Exception {
        if (organizationContactComponent != null) {
            this.open(string);
            this.composeBackbone(organizationContactComponent);
            this.composeCodeableConcept("purpose", organizationContactComponent.getPurpose());
            this.composeHumanName("name", organizationContactComponent.getName());
            if (organizationContactComponent.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact contact : organizationContactComponent.getTelecom()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            this.composeAddress("address", organizationContactComponent.getAddress());
            this.composeCodeableConcept("gender", organizationContactComponent.getGender());
            this.close();
        }
    }

    private void composeOther(String string, Other other) throws Exception {
        if (other != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(other);
            if (other.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier identifier : other.getIdentifier()) {
                    this.composeIdentifier(null, identifier);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("code", other.getCode());
            this.composeResourceReference("subject", other.getSubject());
            this.composeResourceReference("author", other.getAuthor());
            this.composeDateCore("created", other.getCreated(), false);
            this.composeDateExtras("created", other.getCreated(), false);
        }
    }

    private void composePatient(String string, Patient patient) throws Exception {
        if (patient != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(patient);
            if (patient.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : patient.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            if (patient.getName().size() > 0) {
                this.openArray("name");
                for (HumanName humanName : patient.getName()) {
                    this.composeHumanName(null, humanName);
                }
                this.closeArray();
            }
            if (patient.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact contact : patient.getTelecom()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("gender", patient.getGender());
            this.composeDateTimeCore("birthDate", patient.getBirthDate(), false);
            this.composeDateTimeExtras("birthDate", patient.getBirthDate(), false);
            this.composeType("deceased", patient.getDeceased());
            if (patient.getAddress().size() > 0) {
                this.openArray("address");
                for (Address address : patient.getAddress()) {
                    this.composeAddress(null, address);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("maritalStatus", patient.getMaritalStatus());
            this.composeType("multipleBirth", patient.getMultipleBirth());
            if (patient.getPhoto().size() > 0) {
                this.openArray("photo");
                for (Attachment attachment : patient.getPhoto()) {
                    this.composeAttachment(null, attachment);
                }
                this.closeArray();
            }
            if (patient.getContact().size() > 0) {
                this.openArray("contact");
                for (Patient.ContactComponent contactComponent : patient.getContact()) {
                    this.composePatientContactComponent(null, contactComponent);
                }
                this.closeArray();
            }
            this.composePatientAnimalComponent("animal", patient.getAnimal());
            if (patient.getCommunication().size() > 0) {
                this.openArray("communication");
                for (CodeableConcept codeableConcept : patient.getCommunication()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            if (patient.getCareProvider().size() > 0) {
                this.openArray("careProvider");
                for (ResourceReference resourceReference : patient.getCareProvider()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.composeResourceReference("managingOrganization", patient.getManagingOrganization());
            if (patient.getLink().size() > 0) {
                this.openArray("link");
                for (Patient.PatientLinkComponent patientLinkComponent : patient.getLink()) {
                    this.composePatientPatientLinkComponent(null, patientLinkComponent);
                }
                this.closeArray();
            }
            this.composeBooleanCore("active", patient.getActive(), false);
            this.composeBooleanExtras("active", patient.getActive(), false);
        }
    }

    private void composePatientContactComponent(String string, Patient.ContactComponent contactComponent) throws Exception {
        if (contactComponent != null) {
            this.open(string);
            this.composeBackbone(contactComponent);
            if (contactComponent.getRelationship().size() > 0) {
                this.openArray("relationship");
                for (CodeableConcept type : contactComponent.getRelationship()) {
                    this.composeCodeableConcept(null, type);
                }
                this.closeArray();
            }
            this.composeHumanName("name", contactComponent.getName());
            if (contactComponent.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact contact : contactComponent.getTelecom()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            this.composeAddress("address", contactComponent.getAddress());
            this.composeCodeableConcept("gender", contactComponent.getGender());
            this.composeResourceReference("organization", contactComponent.getOrganization());
            this.close();
        }
    }

    private void composePatientAnimalComponent(String string, Patient.AnimalComponent animalComponent) throws Exception {
        if (animalComponent != null) {
            this.open(string);
            this.composeBackbone(animalComponent);
            this.composeCodeableConcept("species", animalComponent.getSpecies());
            this.composeCodeableConcept("breed", animalComponent.getBreed());
            this.composeCodeableConcept("genderStatus", animalComponent.getGenderStatus());
            this.close();
        }
    }

    private void composePatientPatientLinkComponent(String string, Patient.PatientLinkComponent patientLinkComponent) throws Exception {
        if (patientLinkComponent != null) {
            this.open(string);
            this.composeBackbone(patientLinkComponent);
            this.composeResourceReference("other", patientLinkComponent.getOther());
            if (patientLinkComponent.getType() != null) {
                this.composeEnumerationCore("type", patientLinkComponent.getType(), new Patient.LinkTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", patientLinkComponent.getType(), new Patient.LinkTypeEnumFactory(), false);
            }
            this.close();
        }
    }

    private void composePractitioner(String string, Practitioner practitioner) throws Exception {
        if (practitioner != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(practitioner);
            if (practitioner.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : practitioner.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeHumanName("name", practitioner.getName());
            if (practitioner.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact contact : practitioner.getTelecom()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            this.composeAddress("address", practitioner.getAddress());
            this.composeCodeableConcept("gender", practitioner.getGender());
            this.composeDateTimeCore("birthDate", practitioner.getBirthDate(), false);
            this.composeDateTimeExtras("birthDate", practitioner.getBirthDate(), false);
            if (practitioner.getPhoto().size() > 0) {
                this.openArray("photo");
                for (Attachment attachment : practitioner.getPhoto()) {
                    this.composeAttachment(null, attachment);
                }
                this.closeArray();
            }
            this.composeResourceReference("organization", practitioner.getOrganization());
            if (practitioner.getRole().size() > 0) {
                this.openArray("role");
                for (CodeableConcept codeableConcept : practitioner.getRole()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            if (practitioner.getSpecialty().size() > 0) {
                this.openArray("specialty");
                for (CodeableConcept codeableConcept : practitioner.getSpecialty()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composePeriod("period", practitioner.getPeriod());
            if (practitioner.getLocation().size() > 0) {
                this.openArray("location");
                for (ResourceReference resourceReference : practitioner.getLocation()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (practitioner.getQualification().size() > 0) {
                this.openArray("qualification");
                for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : practitioner.getQualification()) {
                    this.composePractitionerPractitionerQualificationComponent(null, practitionerQualificationComponent);
                }
                this.closeArray();
            }
            if (practitioner.getCommunication().size() > 0) {
                this.openArray("communication");
                for (CodeableConcept codeableConcept : practitioner.getCommunication()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
        }
    }

    private void composePractitionerPractitionerQualificationComponent(String string, Practitioner.PractitionerQualificationComponent practitionerQualificationComponent) throws Exception {
        if (practitionerQualificationComponent != null) {
            this.open(string);
            this.composeBackbone(practitionerQualificationComponent);
            this.composeCodeableConcept("code", practitionerQualificationComponent.getCode());
            this.composePeriod("period", practitionerQualificationComponent.getPeriod());
            this.composeResourceReference("issuer", practitionerQualificationComponent.getIssuer());
            this.close();
        }
    }

    private void composeProcedure(String string, Procedure procedure) throws Exception {
        if (procedure != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(procedure);
            if (procedure.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : procedure.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("subject", procedure.getSubject());
            this.composeCodeableConcept("type", procedure.getType());
            if (procedure.getBodySite().size() > 0) {
                this.openArray("bodySite");
                for (CodeableConcept codeableConcept : procedure.getBodySite()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            if (procedure.getIndication().size() > 0) {
                this.openArray("indication");
                for (CodeableConcept codeableConcept : procedure.getIndication()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            if (procedure.getPerformer().size() > 0) {
                this.openArray("performer");
                for (Procedure.ProcedurePerformerComponent procedurePerformerComponent : procedure.getPerformer()) {
                    this.composeProcedureProcedurePerformerComponent(null, procedurePerformerComponent);
                }
                this.closeArray();
            }
            this.composePeriod("date", procedure.getDate());
            this.composeResourceReference("encounter", procedure.getEncounter());
            this.composeStringCore("outcome", procedure.getOutcome(), false);
            this.composeStringExtras("outcome", procedure.getOutcome(), false);
            if (procedure.getReport().size() > 0) {
                this.openArray("report");
                for (ResourceReference resourceReference : procedure.getReport()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            if (procedure.getComplication().size() > 0) {
                this.openArray("complication");
                for (CodeableConcept codeableConcept : procedure.getComplication()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composeStringCore("followUp", procedure.getFollowUp(), false);
            this.composeStringExtras("followUp", procedure.getFollowUp(), false);
            if (procedure.getRelatedItem().size() > 0) {
                this.openArray("relatedItem");
                for (Procedure.ProcedureRelatedItemComponent procedureRelatedItemComponent : procedure.getRelatedItem()) {
                    this.composeProcedureProcedureRelatedItemComponent(null, procedureRelatedItemComponent);
                }
                this.closeArray();
            }
            this.composeStringCore("notes", procedure.getNotes(), false);
            this.composeStringExtras("notes", procedure.getNotes(), false);
        }
    }

    private void composeProcedureProcedurePerformerComponent(String string, Procedure.ProcedurePerformerComponent procedurePerformerComponent) throws Exception {
        if (procedurePerformerComponent != null) {
            this.open(string);
            this.composeBackbone(procedurePerformerComponent);
            this.composeResourceReference("person", procedurePerformerComponent.getPerson());
            this.composeCodeableConcept("role", procedurePerformerComponent.getRole());
            this.close();
        }
    }

    private void composeProcedureProcedureRelatedItemComponent(String string, Procedure.ProcedureRelatedItemComponent procedureRelatedItemComponent) throws Exception {
        if (procedureRelatedItemComponent != null) {
            this.open(string);
            this.composeBackbone(procedureRelatedItemComponent);
            if (procedureRelatedItemComponent.getType() != null) {
                this.composeEnumerationCore("type", procedureRelatedItemComponent.getType(), new Procedure.ProcedureRelationshipTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", procedureRelatedItemComponent.getType(), new Procedure.ProcedureRelationshipTypeEnumFactory(), false);
            }
            this.composeResourceReference("target", procedureRelatedItemComponent.getTarget());
            this.close();
        }
    }

    private void composeProfile(String string, Profile profile) throws Exception {
        if (profile != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(profile);
            this.composeStringCore("identifier", profile.getIdentifier(), false);
            this.composeStringExtras("identifier", profile.getIdentifier(), false);
            this.composeStringCore("version", profile.getVersion(), false);
            this.composeStringExtras("version", profile.getVersion(), false);
            this.composeStringCore("name", profile.getName(), false);
            this.composeStringExtras("name", profile.getName(), false);
            this.composeStringCore("publisher", profile.getPublisher(), false);
            this.composeStringExtras("publisher", profile.getPublisher(), false);
            if (profile.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact element : profile.getTelecom()) {
                    this.composeContact(null, element);
                }
                this.closeArray();
            }
            this.composeStringCore("description", profile.getDescription(), false);
            this.composeStringExtras("description", profile.getDescription(), false);
            if (profile.getCode().size() > 0) {
                this.openArray("code");
                for (Coding coding : profile.getCode()) {
                    this.composeCoding(null, coding);
                }
                this.closeArray();
            }
            if (profile.getStatus() != null) {
                this.composeEnumerationCore("status", profile.getStatus(), new Profile.ResourceProfileStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", profile.getStatus(), new Profile.ResourceProfileStatusEnumFactory(), false);
            }
            this.composeBooleanCore("experimental", profile.getExperimental(), false);
            this.composeBooleanExtras("experimental", profile.getExperimental(), false);
            this.composeDateTimeCore("date", profile.getDate(), false);
            this.composeDateTimeExtras("date", profile.getDate(), false);
            this.composeStringCore("requirements", profile.getRequirements(), false);
            this.composeStringExtras("requirements", profile.getRequirements(), false);
            this.composeIdCore("fhirVersion", profile.getFhirVersion(), false);
            this.composeIdExtras("fhirVersion", profile.getFhirVersion(), false);
            if (profile.getMapping().size() > 0) {
                this.openArray("mapping");
                for (Profile.ProfileMappingComponent profileMappingComponent : profile.getMapping()) {
                    this.composeProfileProfileMappingComponent(null, profileMappingComponent);
                }
                this.closeArray();
            }
            if (profile.getStructure().size() > 0) {
                this.openArray("structure");
                for (Profile.ProfileStructureComponent profileStructureComponent : profile.getStructure()) {
                    this.composeProfileProfileStructureComponent(null, profileStructureComponent);
                }
                this.closeArray();
            }
            if (profile.getExtensionDefn().size() > 0) {
                this.openArray("extensionDefn");
                for (Profile.ProfileExtensionDefnComponent profileExtensionDefnComponent : profile.getExtensionDefn()) {
                    this.composeProfileProfileExtensionDefnComponent(null, profileExtensionDefnComponent);
                }
                this.closeArray();
            }
            if (profile.getQuery().size() > 0) {
                this.openArray("query");
                for (Profile.ProfileQueryComponent profileQueryComponent : profile.getQuery()) {
                    this.composeProfileProfileQueryComponent(null, profileQueryComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeProfileProfileMappingComponent(String string, Profile.ProfileMappingComponent profileMappingComponent) throws Exception {
        if (profileMappingComponent != null) {
            this.open(string);
            this.composeBackbone(profileMappingComponent);
            this.composeIdCore("identity", profileMappingComponent.getIdentity(), false);
            this.composeIdExtras("identity", profileMappingComponent.getIdentity(), false);
            this.composeUriCore("uri", profileMappingComponent.getUri(), false);
            this.composeUriExtras("uri", profileMappingComponent.getUri(), false);
            this.composeStringCore("name", profileMappingComponent.getName(), false);
            this.composeStringExtras("name", profileMappingComponent.getName(), false);
            this.composeStringCore("comments", profileMappingComponent.getComments(), false);
            this.composeStringExtras("comments", profileMappingComponent.getComments(), false);
            this.close();
        }
    }

    private void composeProfileProfileStructureComponent(String string, Profile.ProfileStructureComponent profileStructureComponent) throws Exception {
        if (profileStructureComponent != null) {
            this.open(string);
            this.composeBackbone(profileStructureComponent);
            this.composeCodeCore("type", profileStructureComponent.getType(), false);
            this.composeCodeExtras("type", profileStructureComponent.getType(), false);
            this.composeStringCore("name", profileStructureComponent.getName(), false);
            this.composeStringExtras("name", profileStructureComponent.getName(), false);
            this.composeBooleanCore("publish", profileStructureComponent.getPublish(), false);
            this.composeBooleanExtras("publish", profileStructureComponent.getPublish(), false);
            this.composeStringCore("purpose", profileStructureComponent.getPurpose(), false);
            this.composeStringExtras("purpose", profileStructureComponent.getPurpose(), false);
            if (profileStructureComponent.getElement().size() > 0) {
                this.openArray("element");
                for (Profile.ElementComponent backboneElement : profileStructureComponent.getElement()) {
                    this.composeProfileElementComponent(null, backboneElement);
                }
                this.closeArray();
            }
            if (profileStructureComponent.getSearchParam().size() > 0) {
                this.openArray("searchParam");
                for (Profile.ProfileStructureSearchParamComponent profileStructureSearchParamComponent : profileStructureComponent.getSearchParam()) {
                    this.composeProfileProfileStructureSearchParamComponent(null, profileStructureSearchParamComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeProfileElementComponent(String string, Profile.ElementComponent elementComponent) throws Exception {
        if (elementComponent != null) {
            this.open(string);
            this.composeBackbone(elementComponent);
            this.composeStringCore("path", elementComponent.getPath(), false);
            this.composeStringExtras("path", elementComponent.getPath(), false);
            if (elementComponent.getRepresentation().size() > 0) {
                this.openArray("representation");
                for (Enumeration<Profile.PropertyRepresentation> enumeration : elementComponent.getRepresentation()) {
                    this.composeEnumerationCore(null, enumeration, new Profile.PropertyRepresentationEnumFactory(), true);
                }
                this.closeArray();
                if (this.anyHasExtras(elementComponent.getRepresentation())) {
                    this.openArray("_representation");
                    for (Enumeration<Profile.PropertyRepresentation> enumeration : elementComponent.getRepresentation()) {
                        this.composeEnumerationExtras(null, enumeration, new Profile.PropertyRepresentationEnumFactory(), true);
                    }
                    this.closeArray();
                }
            }
            this.composeStringCore("name", elementComponent.getName(), false);
            this.composeStringExtras("name", elementComponent.getName(), false);
            this.composeProfileElementSlicingComponent("slicing", elementComponent.getSlicing());
            this.composeProfileElementDefinitionComponent("definition", elementComponent.getDefinition());
            this.close();
        }
    }

    private void composeProfileElementSlicingComponent(String string, Profile.ElementSlicingComponent elementSlicingComponent) throws Exception {
        if (elementSlicingComponent != null) {
            this.open(string);
            this.composeBackbone(elementSlicingComponent);
            this.composeIdCore("discriminator", elementSlicingComponent.getDiscriminator(), false);
            this.composeIdExtras("discriminator", elementSlicingComponent.getDiscriminator(), false);
            this.composeBooleanCore("ordered", elementSlicingComponent.getOrdered(), false);
            this.composeBooleanExtras("ordered", elementSlicingComponent.getOrdered(), false);
            if (elementSlicingComponent.getRules() != null) {
                this.composeEnumerationCore("rules", elementSlicingComponent.getRules(), new Profile.ResourceSlicingRulesEnumFactory(), false);
                this.composeEnumerationExtras("rules", elementSlicingComponent.getRules(), new Profile.ResourceSlicingRulesEnumFactory(), false);
            }
            this.close();
        }
    }

    private void composeProfileElementDefinitionComponent(String string, Profile.ElementDefinitionComponent elementDefinitionComponent) throws Exception {
        if (elementDefinitionComponent != null) {
            this.open(string);
            this.composeBackbone(elementDefinitionComponent);
            this.composeStringCore("short", elementDefinitionComponent.getShort(), false);
            this.composeStringExtras("short", elementDefinitionComponent.getShort(), false);
            this.composeStringCore("formal", elementDefinitionComponent.getFormal(), false);
            this.composeStringExtras("formal", elementDefinitionComponent.getFormal(), false);
            this.composeStringCore("comments", elementDefinitionComponent.getComments(), false);
            this.composeStringExtras("comments", elementDefinitionComponent.getComments(), false);
            this.composeStringCore("requirements", elementDefinitionComponent.getRequirements(), false);
            this.composeStringExtras("requirements", elementDefinitionComponent.getRequirements(), false);
            if (elementDefinitionComponent.getSynonym().size() > 0) {
                this.openArray("synonym");
                for (StringType element : elementDefinitionComponent.getSynonym()) {
                    this.composeStringCore(null, element, true);
                }
                this.closeArray();
                if (this.anyHasExtras(elementDefinitionComponent.getSynonym())) {
                    this.openArray("_synonym");
                    for (StringType stringType : elementDefinitionComponent.getSynonym()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            this.composeIntegerCore("min", elementDefinitionComponent.getMin(), false);
            this.composeIntegerExtras("min", elementDefinitionComponent.getMin(), false);
            this.composeStringCore("max", elementDefinitionComponent.getMax(), false);
            this.composeStringExtras("max", elementDefinitionComponent.getMax(), false);
            if (elementDefinitionComponent.getType().size() > 0) {
                this.openArray("type");
                for (Profile.TypeRefComponent typeRefComponent : elementDefinitionComponent.getType()) {
                    this.composeProfileTypeRefComponent(null, typeRefComponent);
                }
                this.closeArray();
            }
            this.composeStringCore("nameReference", elementDefinitionComponent.getNameReference(), false);
            this.composeStringExtras("nameReference", elementDefinitionComponent.getNameReference(), false);
            this.composeType("value", elementDefinitionComponent.getValue());
            this.composeType("example", elementDefinitionComponent.getExample());
            this.composeIntegerCore("maxLength", elementDefinitionComponent.getMaxLength(), false);
            this.composeIntegerExtras("maxLength", elementDefinitionComponent.getMaxLength(), false);
            if (elementDefinitionComponent.getCondition().size() > 0) {
                this.openArray("condition");
                for (IdType idType : elementDefinitionComponent.getCondition()) {
                    this.composeIdCore(null, idType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(elementDefinitionComponent.getCondition())) {
                    this.openArray("_condition");
                    for (IdType idType : elementDefinitionComponent.getCondition()) {
                        this.composeIdExtras(null, idType, true);
                    }
                    this.closeArray();
                }
            }
            if (elementDefinitionComponent.getConstraint().size() > 0) {
                this.openArray("constraint");
                for (Profile.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : elementDefinitionComponent.getConstraint()) {
                    this.composeProfileElementDefinitionConstraintComponent(null, elementDefinitionConstraintComponent);
                }
                this.closeArray();
            }
            this.composeBooleanCore("mustSupport", elementDefinitionComponent.getMustSupport(), false);
            this.composeBooleanExtras("mustSupport", elementDefinitionComponent.getMustSupport(), false);
            this.composeBooleanCore("isModifier", elementDefinitionComponent.getIsModifier(), false);
            this.composeBooleanExtras("isModifier", elementDefinitionComponent.getIsModifier(), false);
            this.composeProfileElementDefinitionBindingComponent("binding", elementDefinitionComponent.getBinding());
            if (elementDefinitionComponent.getMapping().size() > 0) {
                this.openArray("mapping");
                for (Profile.ElementDefinitionMappingComponent elementDefinitionMappingComponent : elementDefinitionComponent.getMapping()) {
                    this.composeProfileElementDefinitionMappingComponent(null, elementDefinitionMappingComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeProfileTypeRefComponent(String string, Profile.TypeRefComponent typeRefComponent) throws Exception {
        if (typeRefComponent != null) {
            this.open(string);
            this.composeBackbone(typeRefComponent);
            this.composeCodeCore("code", typeRefComponent.getCode(), false);
            this.composeCodeExtras("code", typeRefComponent.getCode(), false);
            this.composeUriCore("profile", typeRefComponent.getProfile(), false);
            this.composeUriExtras("profile", typeRefComponent.getProfile(), false);
            if (typeRefComponent.getAggregation().size() > 0) {
                this.openArray("aggregation");
                for (Enumeration<Profile.ResourceAggregationMode> enumeration : typeRefComponent.getAggregation()) {
                    this.composeEnumerationCore(null, enumeration, new Profile.ResourceAggregationModeEnumFactory(), true);
                }
                this.closeArray();
                if (this.anyHasExtras(typeRefComponent.getAggregation())) {
                    this.openArray("_aggregation");
                    for (Enumeration<Profile.ResourceAggregationMode> enumeration : typeRefComponent.getAggregation()) {
                        this.composeEnumerationExtras(null, enumeration, new Profile.ResourceAggregationModeEnumFactory(), true);
                    }
                    this.closeArray();
                }
            }
            this.close();
        }
    }

    private void composeProfileElementDefinitionConstraintComponent(String string, Profile.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent) throws Exception {
        if (elementDefinitionConstraintComponent != null) {
            this.open(string);
            this.composeBackbone(elementDefinitionConstraintComponent);
            this.composeIdCore("key", elementDefinitionConstraintComponent.getKey(), false);
            this.composeIdExtras("key", elementDefinitionConstraintComponent.getKey(), false);
            this.composeStringCore("name", elementDefinitionConstraintComponent.getName(), false);
            this.composeStringExtras("name", elementDefinitionConstraintComponent.getName(), false);
            if (elementDefinitionConstraintComponent.getSeverity() != null) {
                this.composeEnumerationCore("severity", elementDefinitionConstraintComponent.getSeverity(), new Profile.ConstraintSeverityEnumFactory(), false);
                this.composeEnumerationExtras("severity", elementDefinitionConstraintComponent.getSeverity(), new Profile.ConstraintSeverityEnumFactory(), false);
            }
            this.composeStringCore("human", elementDefinitionConstraintComponent.getHuman(), false);
            this.composeStringExtras("human", elementDefinitionConstraintComponent.getHuman(), false);
            this.composeStringCore("xpath", elementDefinitionConstraintComponent.getXpath(), false);
            this.composeStringExtras("xpath", elementDefinitionConstraintComponent.getXpath(), false);
            this.close();
        }
    }

    private void composeProfileElementDefinitionBindingComponent(String string, Profile.ElementDefinitionBindingComponent elementDefinitionBindingComponent) throws Exception {
        if (elementDefinitionBindingComponent != null) {
            this.open(string);
            this.composeBackbone(elementDefinitionBindingComponent);
            this.composeStringCore("name", elementDefinitionBindingComponent.getName(), false);
            this.composeStringExtras("name", elementDefinitionBindingComponent.getName(), false);
            this.composeBooleanCore("isExtensible", elementDefinitionBindingComponent.getIsExtensible(), false);
            this.composeBooleanExtras("isExtensible", elementDefinitionBindingComponent.getIsExtensible(), false);
            if (elementDefinitionBindingComponent.getConformance() != null) {
                this.composeEnumerationCore("conformance", elementDefinitionBindingComponent.getConformance(), new Profile.BindingConformanceEnumFactory(), false);
                this.composeEnumerationExtras("conformance", elementDefinitionBindingComponent.getConformance(), new Profile.BindingConformanceEnumFactory(), false);
            }
            this.composeStringCore("description", elementDefinitionBindingComponent.getDescription(), false);
            this.composeStringExtras("description", elementDefinitionBindingComponent.getDescription(), false);
            this.composeType("reference", elementDefinitionBindingComponent.getReference());
            this.close();
        }
    }

    private void composeProfileElementDefinitionMappingComponent(String string, Profile.ElementDefinitionMappingComponent elementDefinitionMappingComponent) throws Exception {
        if (elementDefinitionMappingComponent != null) {
            this.open(string);
            this.composeBackbone(elementDefinitionMappingComponent);
            this.composeIdCore("identity", elementDefinitionMappingComponent.getIdentity(), false);
            this.composeIdExtras("identity", elementDefinitionMappingComponent.getIdentity(), false);
            this.composeStringCore("map", elementDefinitionMappingComponent.getMap(), false);
            this.composeStringExtras("map", elementDefinitionMappingComponent.getMap(), false);
            this.close();
        }
    }

    private void composeProfileProfileStructureSearchParamComponent(String string, Profile.ProfileStructureSearchParamComponent profileStructureSearchParamComponent) throws Exception {
        if (profileStructureSearchParamComponent != null) {
            this.open(string);
            this.composeBackbone(profileStructureSearchParamComponent);
            this.composeStringCore("name", profileStructureSearchParamComponent.getName(), false);
            this.composeStringExtras("name", profileStructureSearchParamComponent.getName(), false);
            if (profileStructureSearchParamComponent.getType() != null) {
                this.composeEnumerationCore("type", profileStructureSearchParamComponent.getType(), new Profile.SearchParamTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", profileStructureSearchParamComponent.getType(), new Profile.SearchParamTypeEnumFactory(), false);
            }
            this.composeStringCore("documentation", profileStructureSearchParamComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", profileStructureSearchParamComponent.getDocumentation(), false);
            this.composeStringCore("xpath", profileStructureSearchParamComponent.getXpath(), false);
            this.composeStringExtras("xpath", profileStructureSearchParamComponent.getXpath(), false);
            if (profileStructureSearchParamComponent.getTarget().size() > 0) {
                this.openArray("target");
                for (CodeType codeType : profileStructureSearchParamComponent.getTarget()) {
                    this.composeCodeCore(null, codeType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(profileStructureSearchParamComponent.getTarget())) {
                    this.openArray("_target");
                    for (CodeType codeType : profileStructureSearchParamComponent.getTarget()) {
                        this.composeCodeExtras(null, codeType, true);
                    }
                    this.closeArray();
                }
            }
            this.close();
        }
    }

    private void composeProfileProfileExtensionDefnComponent(String string, Profile.ProfileExtensionDefnComponent profileExtensionDefnComponent) throws Exception {
        if (profileExtensionDefnComponent != null) {
            this.open(string);
            this.composeBackbone(profileExtensionDefnComponent);
            this.composeCodeCore("code", profileExtensionDefnComponent.getCode(), false);
            this.composeCodeExtras("code", profileExtensionDefnComponent.getCode(), false);
            this.composeStringCore("display", profileExtensionDefnComponent.getDisplay(), false);
            this.composeStringExtras("display", profileExtensionDefnComponent.getDisplay(), false);
            if (profileExtensionDefnComponent.getContextType() != null) {
                this.composeEnumerationCore("contextType", profileExtensionDefnComponent.getContextType(), new Profile.ExtensionContextEnumFactory(), false);
                this.composeEnumerationExtras("contextType", profileExtensionDefnComponent.getContextType(), new Profile.ExtensionContextEnumFactory(), false);
            }
            if (profileExtensionDefnComponent.getContext().size() > 0) {
                this.openArray("context");
                for (StringType stringType : profileExtensionDefnComponent.getContext()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(profileExtensionDefnComponent.getContext())) {
                    this.openArray("_context");
                    for (StringType stringType : profileExtensionDefnComponent.getContext()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            this.composeProfileElementDefinitionComponent("definition", profileExtensionDefnComponent.getDefinition());
            this.close();
        }
    }

    private void composeProfileProfileQueryComponent(String string, Profile.ProfileQueryComponent profileQueryComponent) throws Exception {
        if (profileQueryComponent != null) {
            this.open(string);
            this.composeBackbone(profileQueryComponent);
            this.composeStringCore("name", profileQueryComponent.getName(), false);
            this.composeStringExtras("name", profileQueryComponent.getName(), false);
            this.composeStringCore("documentation", profileQueryComponent.getDocumentation(), false);
            this.composeStringExtras("documentation", profileQueryComponent.getDocumentation(), false);
            if (profileQueryComponent.getParameter().size() > 0) {
                this.openArray("parameter");
                for (Profile.ProfileStructureSearchParamComponent profileStructureSearchParamComponent : profileQueryComponent.getParameter()) {
                    this.composeProfileProfileStructureSearchParamComponent(null, profileStructureSearchParamComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeProvenance(String string, Provenance provenance) throws Exception {
        if (provenance != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(provenance);
            if (provenance.getTarget().size() > 0) {
                this.openArray("target");
                for (ResourceReference element : provenance.getTarget()) {
                    this.composeResourceReference(null, element);
                }
                this.closeArray();
            }
            this.composePeriod("period", provenance.getPeriod());
            this.composeInstantCore("recorded", provenance.getRecorded(), false);
            this.composeInstantExtras("recorded", provenance.getRecorded(), false);
            this.composeCodeableConcept("reason", provenance.getReason());
            this.composeResourceReference("location", provenance.getLocation());
            if (provenance.getPolicy().size() > 0) {
                this.openArray("policy");
                for (UriType uriType : provenance.getPolicy()) {
                    this.composeUriCore(null, uriType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(provenance.getPolicy())) {
                    this.openArray("_policy");
                    for (UriType uriType : provenance.getPolicy()) {
                        this.composeUriExtras(null, uriType, true);
                    }
                    this.closeArray();
                }
            }
            if (provenance.getAgent().size() > 0) {
                this.openArray("agent");
                for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : provenance.getAgent()) {
                    this.composeProvenanceProvenanceAgentComponent(null, provenanceAgentComponent);
                }
                this.closeArray();
            }
            if (provenance.getEntity().size() > 0) {
                this.openArray("entity");
                for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : provenance.getEntity()) {
                    this.composeProvenanceProvenanceEntityComponent(null, provenanceEntityComponent);
                }
                this.closeArray();
            }
            this.composeStringCore("integritySignature", provenance.getIntegritySignature(), false);
            this.composeStringExtras("integritySignature", provenance.getIntegritySignature(), false);
        }
    }

    private void composeProvenanceProvenanceAgentComponent(String string, Provenance.ProvenanceAgentComponent provenanceAgentComponent) throws Exception {
        if (provenanceAgentComponent != null) {
            this.open(string);
            this.composeBackbone(provenanceAgentComponent);
            this.composeCoding("role", provenanceAgentComponent.getRole());
            this.composeCoding("type", provenanceAgentComponent.getType());
            this.composeUriCore("reference", provenanceAgentComponent.getReference(), false);
            this.composeUriExtras("reference", provenanceAgentComponent.getReference(), false);
            this.composeStringCore("display", provenanceAgentComponent.getDisplay(), false);
            this.composeStringExtras("display", provenanceAgentComponent.getDisplay(), false);
            this.close();
        }
    }

    private void composeProvenanceProvenanceEntityComponent(String string, Provenance.ProvenanceEntityComponent provenanceEntityComponent) throws Exception {
        if (provenanceEntityComponent != null) {
            this.open(string);
            this.composeBackbone(provenanceEntityComponent);
            if (provenanceEntityComponent.getRole() != null) {
                this.composeEnumerationCore("role", provenanceEntityComponent.getRole(), new Provenance.ProvenanceEntityRoleEnumFactory(), false);
                this.composeEnumerationExtras("role", provenanceEntityComponent.getRole(), new Provenance.ProvenanceEntityRoleEnumFactory(), false);
            }
            this.composeCoding("type", provenanceEntityComponent.getType());
            this.composeUriCore("reference", provenanceEntityComponent.getReference(), false);
            this.composeUriExtras("reference", provenanceEntityComponent.getReference(), false);
            this.composeStringCore("display", provenanceEntityComponent.getDisplay(), false);
            this.composeStringExtras("display", provenanceEntityComponent.getDisplay(), false);
            this.composeProvenanceProvenanceAgentComponent("agent", provenanceEntityComponent.getAgent());
            this.close();
        }
    }

    private void composeQuery(String string, Query query) throws Exception {
        if (query != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(query);
            this.composeUriCore("identifier", query.getIdentifier(), false);
            this.composeUriExtras("identifier", query.getIdentifier(), false);
            if (query.getParameter().size() > 0) {
                this.openArray("parameter");
                for (Extension extension : query.getParameter()) {
                    this.composeExtension(null, extension);
                }
                this.closeArray();
            }
            this.composeQueryQueryResponseComponent("response", query.getResponse());
        }
    }

    private void composeQueryQueryResponseComponent(String string, Query.QueryResponseComponent queryResponseComponent) throws Exception {
        if (queryResponseComponent != null) {
            this.open(string);
            this.composeBackbone(queryResponseComponent);
            this.composeUriCore("identifier", queryResponseComponent.getIdentifier(), false);
            this.composeUriExtras("identifier", queryResponseComponent.getIdentifier(), false);
            if (queryResponseComponent.getOutcome() != null) {
                this.composeEnumerationCore("outcome", queryResponseComponent.getOutcome(), new Query.QueryOutcomeEnumFactory(), false);
                this.composeEnumerationExtras("outcome", queryResponseComponent.getOutcome(), new Query.QueryOutcomeEnumFactory(), false);
            }
            this.composeIntegerCore("total", queryResponseComponent.getTotal(), false);
            this.composeIntegerExtras("total", queryResponseComponent.getTotal(), false);
            if (queryResponseComponent.getParameter().size() > 0) {
                this.openArray("parameter");
                for (Extension element : queryResponseComponent.getParameter()) {
                    this.composeExtension(null, element);
                }
                this.closeArray();
            }
            if (queryResponseComponent.getFirst().size() > 0) {
                this.openArray("first");
                for (Extension extension : queryResponseComponent.getFirst()) {
                    this.composeExtension(null, extension);
                }
                this.closeArray();
            }
            if (queryResponseComponent.getPrevious().size() > 0) {
                this.openArray("previous");
                for (Extension extension : queryResponseComponent.getPrevious()) {
                    this.composeExtension(null, extension);
                }
                this.closeArray();
            }
            if (queryResponseComponent.getNext().size() > 0) {
                this.openArray("next");
                for (Extension extension : queryResponseComponent.getNext()) {
                    this.composeExtension(null, extension);
                }
                this.closeArray();
            }
            if (queryResponseComponent.getLast().size() > 0) {
                this.openArray("last");
                for (Extension extension : queryResponseComponent.getLast()) {
                    this.composeExtension(null, extension);
                }
                this.closeArray();
            }
            if (queryResponseComponent.getReference().size() > 0) {
                this.openArray("reference");
                for (ResourceReference resourceReference : queryResponseComponent.getReference()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeQuestionnaire(String string, Questionnaire questionnaire) throws Exception {
        if (questionnaire != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(questionnaire);
            if (questionnaire.getStatus() != null) {
                this.composeEnumerationCore("status", questionnaire.getStatus(), new Questionnaire.QuestionnaireStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", questionnaire.getStatus(), new Questionnaire.QuestionnaireStatusEnumFactory(), false);
            }
            this.composeDateTimeCore("authored", questionnaire.getAuthored(), false);
            this.composeDateTimeExtras("authored", questionnaire.getAuthored(), false);
            this.composeResourceReference("subject", questionnaire.getSubject());
            this.composeResourceReference("author", questionnaire.getAuthor());
            this.composeResourceReference("source", questionnaire.getSource());
            this.composeCodeableConcept("name", questionnaire.getName());
            if (questionnaire.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier identifier : questionnaire.getIdentifier()) {
                    this.composeIdentifier(null, identifier);
                }
                this.closeArray();
            }
            this.composeResourceReference("encounter", questionnaire.getEncounter());
            this.composeQuestionnaireGroupComponent("group", questionnaire.getGroup());
        }
    }

    private void composeQuestionnaireGroupComponent(String string, Questionnaire.GroupComponent groupComponent) throws Exception {
        if (groupComponent != null) {
            this.open(string);
            this.composeBackbone(groupComponent);
            this.composeCodeableConcept("name", groupComponent.getName());
            this.composeStringCore("header", groupComponent.getHeader(), false);
            this.composeStringExtras("header", groupComponent.getHeader(), false);
            this.composeStringCore("text", groupComponent.getText(), false);
            this.composeStringExtras("text", groupComponent.getText(), false);
            this.composeResourceReference("subject", groupComponent.getSubject());
            if (groupComponent.getGroup().size() > 0) {
                this.openArray("group");
                for (Questionnaire.GroupComponent backboneElement : groupComponent.getGroup()) {
                    this.composeQuestionnaireGroupComponent(null, backboneElement);
                }
                this.closeArray();
            }
            if (groupComponent.getQuestion().size() > 0) {
                this.openArray("question");
                for (Questionnaire.QuestionComponent questionComponent : groupComponent.getQuestion()) {
                    this.composeQuestionnaireQuestionComponent(null, questionComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeQuestionnaireQuestionComponent(String string, Questionnaire.QuestionComponent questionComponent) throws Exception {
        if (questionComponent != null) {
            this.open(string);
            this.composeBackbone(questionComponent);
            this.composeCodeableConcept("name", questionComponent.getName());
            this.composeStringCore("text", questionComponent.getText(), false);
            this.composeStringExtras("text", questionComponent.getText(), false);
            this.composeType("answer", questionComponent.getAnswer());
            if (questionComponent.getChoice().size() > 0) {
                this.openArray("choice");
                for (Coding element : questionComponent.getChoice()) {
                    this.composeCoding(null, element);
                }
                this.closeArray();
            }
            this.composeResourceReference("options", questionComponent.getOptions());
            this.composeType("data", questionComponent.getData());
            this.composeStringCore("remarks", questionComponent.getRemarks(), false);
            this.composeStringExtras("remarks", questionComponent.getRemarks(), false);
            if (questionComponent.getGroup().size() > 0) {
                this.openArray("group");
                for (Questionnaire.GroupComponent groupComponent : questionComponent.getGroup()) {
                    this.composeQuestionnaireGroupComponent(null, groupComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeRelatedPerson(String string, RelatedPerson relatedPerson) throws Exception {
        if (relatedPerson != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(relatedPerson);
            if (relatedPerson.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier type : relatedPerson.getIdentifier()) {
                    this.composeIdentifier(null, type);
                }
                this.closeArray();
            }
            this.composeResourceReference("patient", relatedPerson.getPatient());
            this.composeCodeableConcept("relationship", relatedPerson.getRelationship());
            this.composeHumanName("name", relatedPerson.getName());
            if (relatedPerson.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact contact : relatedPerson.getTelecom()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("gender", relatedPerson.getGender());
            this.composeAddress("address", relatedPerson.getAddress());
            if (relatedPerson.getPhoto().size() > 0) {
                this.openArray("photo");
                for (Attachment attachment : relatedPerson.getPhoto()) {
                    this.composeAttachment(null, attachment);
                }
                this.closeArray();
            }
        }
    }

    private void composeSecurityEvent(String string, SecurityEvent securityEvent) throws Exception {
        if (securityEvent != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(securityEvent);
            this.composeSecurityEventSecurityEventEventComponent("event", securityEvent.getEvent());
            if (securityEvent.getParticipant().size() > 0) {
                this.openArray("participant");
                for (SecurityEvent.SecurityEventParticipantComponent backboneElement : securityEvent.getParticipant()) {
                    this.composeSecurityEventSecurityEventParticipantComponent(null, backboneElement);
                }
                this.closeArray();
            }
            this.composeSecurityEventSecurityEventSourceComponent("source", securityEvent.getSource());
            if (securityEvent.getObject().size() > 0) {
                this.openArray("object");
                for (SecurityEvent.SecurityEventObjectComponent securityEventObjectComponent : securityEvent.getObject()) {
                    this.composeSecurityEventSecurityEventObjectComponent(null, securityEventObjectComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeSecurityEventSecurityEventEventComponent(String string, SecurityEvent.SecurityEventEventComponent securityEventEventComponent) throws Exception {
        if (securityEventEventComponent != null) {
            this.open(string);
            this.composeBackbone(securityEventEventComponent);
            this.composeCodeableConcept("type", securityEventEventComponent.getType());
            if (securityEventEventComponent.getSubtype().size() > 0) {
                this.openArray("subtype");
                for (CodeableConcept codeableConcept : securityEventEventComponent.getSubtype()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            if (securityEventEventComponent.getAction() != null) {
                this.composeEnumerationCore("action", securityEventEventComponent.getAction(), new SecurityEvent.SecurityEventActionEnumFactory(), false);
                this.composeEnumerationExtras("action", securityEventEventComponent.getAction(), new SecurityEvent.SecurityEventActionEnumFactory(), false);
            }
            this.composeInstantCore("dateTime", securityEventEventComponent.getDateTime(), false);
            this.composeInstantExtras("dateTime", securityEventEventComponent.getDateTime(), false);
            if (securityEventEventComponent.getOutcome() != null) {
                this.composeEnumerationCore("outcome", securityEventEventComponent.getOutcome(), new SecurityEvent.SecurityEventOutcomeEnumFactory(), false);
                this.composeEnumerationExtras("outcome", securityEventEventComponent.getOutcome(), new SecurityEvent.SecurityEventOutcomeEnumFactory(), false);
            }
            this.composeStringCore("outcomeDesc", securityEventEventComponent.getOutcomeDesc(), false);
            this.composeStringExtras("outcomeDesc", securityEventEventComponent.getOutcomeDesc(), false);
            this.close();
        }
    }

    private void composeSecurityEventSecurityEventParticipantComponent(String string, SecurityEvent.SecurityEventParticipantComponent securityEventParticipantComponent) throws Exception {
        if (securityEventParticipantComponent != null) {
            this.open(string);
            this.composeBackbone(securityEventParticipantComponent);
            if (securityEventParticipantComponent.getRole().size() > 0) {
                this.openArray("role");
                for (CodeableConcept codeableConcept : securityEventParticipantComponent.getRole()) {
                    this.composeCodeableConcept(null, codeableConcept);
                }
                this.closeArray();
            }
            this.composeResourceReference("reference", securityEventParticipantComponent.getReference());
            this.composeStringCore("userId", securityEventParticipantComponent.getUserId(), false);
            this.composeStringExtras("userId", securityEventParticipantComponent.getUserId(), false);
            this.composeStringCore("altId", securityEventParticipantComponent.getAltId(), false);
            this.composeStringExtras("altId", securityEventParticipantComponent.getAltId(), false);
            this.composeStringCore("name", securityEventParticipantComponent.getName(), false);
            this.composeStringExtras("name", securityEventParticipantComponent.getName(), false);
            this.composeBooleanCore("requestor", securityEventParticipantComponent.getRequestor(), false);
            this.composeBooleanExtras("requestor", securityEventParticipantComponent.getRequestor(), false);
            this.composeCoding("media", securityEventParticipantComponent.getMedia());
            this.composeSecurityEventSecurityEventParticipantNetworkComponent("network", securityEventParticipantComponent.getNetwork());
            this.close();
        }
    }

    private void composeSecurityEventSecurityEventParticipantNetworkComponent(String string, SecurityEvent.SecurityEventParticipantNetworkComponent securityEventParticipantNetworkComponent) throws Exception {
        if (securityEventParticipantNetworkComponent != null) {
            this.open(string);
            this.composeBackbone(securityEventParticipantNetworkComponent);
            this.composeStringCore("identifier", securityEventParticipantNetworkComponent.getIdentifier(), false);
            this.composeStringExtras("identifier", securityEventParticipantNetworkComponent.getIdentifier(), false);
            if (securityEventParticipantNetworkComponent.getType() != null) {
                this.composeEnumerationCore("type", securityEventParticipantNetworkComponent.getType(), new SecurityEvent.NetworkTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", securityEventParticipantNetworkComponent.getType(), new SecurityEvent.NetworkTypeEnumFactory(), false);
            }
            this.close();
        }
    }

    private void composeSecurityEventSecurityEventSourceComponent(String string, SecurityEvent.SecurityEventSourceComponent securityEventSourceComponent) throws Exception {
        if (securityEventSourceComponent != null) {
            this.open(string);
            this.composeBackbone(securityEventSourceComponent);
            this.composeStringCore("site", securityEventSourceComponent.getSite(), false);
            this.composeStringExtras("site", securityEventSourceComponent.getSite(), false);
            this.composeStringCore("identifier", securityEventSourceComponent.getIdentifier(), false);
            this.composeStringExtras("identifier", securityEventSourceComponent.getIdentifier(), false);
            if (securityEventSourceComponent.getType().size() > 0) {
                this.openArray("type");
                for (Coding coding : securityEventSourceComponent.getType()) {
                    this.composeCoding(null, coding);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeSecurityEventSecurityEventObjectComponent(String string, SecurityEvent.SecurityEventObjectComponent securityEventObjectComponent) throws Exception {
        if (securityEventObjectComponent != null) {
            this.open(string);
            this.composeBackbone(securityEventObjectComponent);
            this.composeIdentifier("identifier", securityEventObjectComponent.getIdentifier());
            this.composeResourceReference("reference", securityEventObjectComponent.getReference());
            if (securityEventObjectComponent.getType() != null) {
                this.composeEnumerationCore("type", securityEventObjectComponent.getType(), new SecurityEvent.ObjectTypeEnumFactory(), false);
                this.composeEnumerationExtras("type", securityEventObjectComponent.getType(), new SecurityEvent.ObjectTypeEnumFactory(), false);
            }
            if (securityEventObjectComponent.getRole() != null) {
                this.composeEnumerationCore("role", securityEventObjectComponent.getRole(), new SecurityEvent.ObjectRoleEnumFactory(), false);
                this.composeEnumerationExtras("role", securityEventObjectComponent.getRole(), new SecurityEvent.ObjectRoleEnumFactory(), false);
            }
            if (securityEventObjectComponent.getLifecycle() != null) {
                this.composeEnumerationCore("lifecycle", securityEventObjectComponent.getLifecycle(), new SecurityEvent.ObjectLifecycleEnumFactory(), false);
                this.composeEnumerationExtras("lifecycle", securityEventObjectComponent.getLifecycle(), new SecurityEvent.ObjectLifecycleEnumFactory(), false);
            }
            this.composeCodeableConcept("sensitivity", securityEventObjectComponent.getSensitivity());
            this.composeStringCore("name", securityEventObjectComponent.getName(), false);
            this.composeStringExtras("name", securityEventObjectComponent.getName(), false);
            this.composeStringCore("description", securityEventObjectComponent.getDescription(), false);
            this.composeStringExtras("description", securityEventObjectComponent.getDescription(), false);
            this.composeBase64BinaryCore("query", securityEventObjectComponent.getQuery(), false);
            this.composeBase64BinaryExtras("query", securityEventObjectComponent.getQuery(), false);
            if (securityEventObjectComponent.getDetail().size() > 0) {
                this.openArray("detail");
                for (SecurityEvent.SecurityEventObjectDetailComponent securityEventObjectDetailComponent : securityEventObjectComponent.getDetail()) {
                    this.composeSecurityEventSecurityEventObjectDetailComponent(null, securityEventObjectDetailComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeSecurityEventSecurityEventObjectDetailComponent(String string, SecurityEvent.SecurityEventObjectDetailComponent securityEventObjectDetailComponent) throws Exception {
        if (securityEventObjectDetailComponent != null) {
            this.open(string);
            this.composeBackbone(securityEventObjectDetailComponent);
            this.composeStringCore("type", securityEventObjectDetailComponent.getType(), false);
            this.composeStringExtras("type", securityEventObjectDetailComponent.getType(), false);
            this.composeBase64BinaryCore("value", securityEventObjectDetailComponent.getValue(), false);
            this.composeBase64BinaryExtras("value", securityEventObjectDetailComponent.getValue(), false);
            this.close();
        }
    }

    private void composeSpecimen(String string, Specimen specimen) throws Exception {
        if (specimen != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(specimen);
            if (specimen.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier element : specimen.getIdentifier()) {
                    this.composeIdentifier(null, element);
                }
                this.closeArray();
            }
            this.composeCodeableConcept("type", specimen.getType());
            if (specimen.getSource().size() > 0) {
                this.openArray("source");
                for (Specimen.SpecimenSourceComponent specimenSourceComponent : specimen.getSource()) {
                    this.composeSpecimenSpecimenSourceComponent(null, specimenSourceComponent);
                }
                this.closeArray();
            }
            this.composeResourceReference("subject", specimen.getSubject());
            this.composeIdentifier("accessionIdentifier", specimen.getAccessionIdentifier());
            this.composeDateTimeCore("receivedTime", specimen.getReceivedTime(), false);
            this.composeDateTimeExtras("receivedTime", specimen.getReceivedTime(), false);
            this.composeSpecimenSpecimenCollectionComponent("collection", specimen.getCollection());
            if (specimen.getTreatment().size() > 0) {
                this.openArray("treatment");
                for (Specimen.SpecimenTreatmentComponent specimenTreatmentComponent : specimen.getTreatment()) {
                    this.composeSpecimenSpecimenTreatmentComponent(null, specimenTreatmentComponent);
                }
                this.closeArray();
            }
            if (specimen.getContainer().size() > 0) {
                this.openArray("container");
                for (Specimen.SpecimenContainerComponent specimenContainerComponent : specimen.getContainer()) {
                    this.composeSpecimenSpecimenContainerComponent(null, specimenContainerComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeSpecimenSpecimenSourceComponent(String string, Specimen.SpecimenSourceComponent specimenSourceComponent) throws Exception {
        if (specimenSourceComponent != null) {
            this.open(string);
            this.composeBackbone(specimenSourceComponent);
            if (specimenSourceComponent.getRelationship() != null) {
                this.composeEnumerationCore("relationship", specimenSourceComponent.getRelationship(), new Specimen.HierarchicalRelationshipTypeEnumFactory(), false);
                this.composeEnumerationExtras("relationship", specimenSourceComponent.getRelationship(), new Specimen.HierarchicalRelationshipTypeEnumFactory(), false);
            }
            if (specimenSourceComponent.getTarget().size() > 0) {
                this.openArray("target");
                for (ResourceReference resourceReference : specimenSourceComponent.getTarget()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeSpecimenSpecimenCollectionComponent(String string, Specimen.SpecimenCollectionComponent specimenCollectionComponent) throws Exception {
        if (specimenCollectionComponent != null) {
            this.open(string);
            this.composeBackbone(specimenCollectionComponent);
            this.composeResourceReference("collector", specimenCollectionComponent.getCollector());
            if (specimenCollectionComponent.getComment().size() > 0) {
                this.openArray("comment");
                for (StringType stringType : specimenCollectionComponent.getComment()) {
                    this.composeStringCore(null, stringType, true);
                }
                this.closeArray();
                if (this.anyHasExtras(specimenCollectionComponent.getComment())) {
                    this.openArray("_comment");
                    for (StringType stringType : specimenCollectionComponent.getComment()) {
                        this.composeStringExtras(null, stringType, true);
                    }
                    this.closeArray();
                }
            }
            this.composeType("collected", specimenCollectionComponent.getCollected());
            this.composeQuantity("quantity", specimenCollectionComponent.getQuantity());
            this.composeCodeableConcept("method", specimenCollectionComponent.getMethod());
            this.composeCodeableConcept("sourceSite", specimenCollectionComponent.getSourceSite());
            this.close();
        }
    }

    private void composeSpecimenSpecimenTreatmentComponent(String string, Specimen.SpecimenTreatmentComponent specimenTreatmentComponent) throws Exception {
        if (specimenTreatmentComponent != null) {
            this.open(string);
            this.composeBackbone(specimenTreatmentComponent);
            this.composeStringCore("description", specimenTreatmentComponent.getDescription(), false);
            this.composeStringExtras("description", specimenTreatmentComponent.getDescription(), false);
            this.composeCodeableConcept("procedure", specimenTreatmentComponent.getProcedure());
            if (specimenTreatmentComponent.getAdditive().size() > 0) {
                this.openArray("additive");
                for (ResourceReference resourceReference : specimenTreatmentComponent.getAdditive()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeSpecimenSpecimenContainerComponent(String string, Specimen.SpecimenContainerComponent specimenContainerComponent) throws Exception {
        if (specimenContainerComponent != null) {
            this.open(string);
            this.composeBackbone(specimenContainerComponent);
            if (specimenContainerComponent.getIdentifier().size() > 0) {
                this.openArray("identifier");
                for (Identifier identifier : specimenContainerComponent.getIdentifier()) {
                    this.composeIdentifier(null, identifier);
                }
                this.closeArray();
            }
            this.composeStringCore("description", specimenContainerComponent.getDescription(), false);
            this.composeStringExtras("description", specimenContainerComponent.getDescription(), false);
            this.composeCodeableConcept("type", specimenContainerComponent.getType());
            this.composeQuantity("capacity", specimenContainerComponent.getCapacity());
            this.composeQuantity("specimenQuantity", specimenContainerComponent.getSpecimenQuantity());
            this.composeResourceReference("additive", specimenContainerComponent.getAdditive());
            this.close();
        }
    }

    private void composeSubstance(String string, Substance substance) throws Exception {
        if (substance != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(substance);
            this.composeCodeableConcept("type", substance.getType());
            this.composeStringCore("description", substance.getDescription(), false);
            this.composeStringExtras("description", substance.getDescription(), false);
            this.composeSubstanceSubstanceInstanceComponent("instance", substance.getInstance());
            if (substance.getIngredient().size() > 0) {
                this.openArray("ingredient");
                for (Substance.SubstanceIngredientComponent substanceIngredientComponent : substance.getIngredient()) {
                    this.composeSubstanceSubstanceIngredientComponent(null, substanceIngredientComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeSubstanceSubstanceInstanceComponent(String string, Substance.SubstanceInstanceComponent substanceInstanceComponent) throws Exception {
        if (substanceInstanceComponent != null) {
            this.open(string);
            this.composeBackbone(substanceInstanceComponent);
            this.composeIdentifier("identifier", substanceInstanceComponent.getIdentifier());
            this.composeDateTimeCore("expiry", substanceInstanceComponent.getExpiry(), false);
            this.composeDateTimeExtras("expiry", substanceInstanceComponent.getExpiry(), false);
            this.composeQuantity("quantity", substanceInstanceComponent.getQuantity());
            this.close();
        }
    }

    private void composeSubstanceSubstanceIngredientComponent(String string, Substance.SubstanceIngredientComponent substanceIngredientComponent) throws Exception {
        if (substanceIngredientComponent != null) {
            this.open(string);
            this.composeBackbone(substanceIngredientComponent);
            this.composeRatio("quantity", substanceIngredientComponent.getQuantity());
            this.composeResourceReference("substance", substanceIngredientComponent.getSubstance());
            this.close();
        }
    }

    private void composeSupply(String string, Supply supply) throws Exception {
        if (supply != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(supply);
            this.composeCodeableConcept("kind", supply.getKind());
            this.composeIdentifier("identifier", supply.getIdentifier());
            if (supply.getStatus() != null) {
                this.composeEnumerationCore("status", supply.getStatus(), new Supply.ValuesetSupplyStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", supply.getStatus(), new Supply.ValuesetSupplyStatusEnumFactory(), false);
            }
            this.composeResourceReference("orderedItem", supply.getOrderedItem());
            this.composeResourceReference("patient", supply.getPatient());
            if (supply.getDispense().size() > 0) {
                this.openArray("dispense");
                for (Supply.SupplyDispenseComponent supplyDispenseComponent : supply.getDispense()) {
                    this.composeSupplySupplyDispenseComponent(null, supplyDispenseComponent);
                }
                this.closeArray();
            }
        }
    }

    private void composeSupplySupplyDispenseComponent(String string, Supply.SupplyDispenseComponent supplyDispenseComponent) throws Exception {
        if (supplyDispenseComponent != null) {
            this.open(string);
            this.composeBackbone(supplyDispenseComponent);
            this.composeIdentifier("identifier", supplyDispenseComponent.getIdentifier());
            if (supplyDispenseComponent.getStatus() != null) {
                this.composeEnumerationCore("status", supplyDispenseComponent.getStatus(), new Supply.ValuesetSupplyDispenseStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", supplyDispenseComponent.getStatus(), new Supply.ValuesetSupplyDispenseStatusEnumFactory(), false);
            }
            this.composeCodeableConcept("type", supplyDispenseComponent.getType());
            this.composeQuantity("quantity", supplyDispenseComponent.getQuantity());
            this.composeResourceReference("suppliedItem", supplyDispenseComponent.getSuppliedItem());
            this.composeResourceReference("supplier", supplyDispenseComponent.getSupplier());
            this.composePeriod("whenPrepared", supplyDispenseComponent.getWhenPrepared());
            this.composePeriod("whenHandedOver", supplyDispenseComponent.getWhenHandedOver());
            this.composeResourceReference("destination", supplyDispenseComponent.getDestination());
            if (supplyDispenseComponent.getReceiver().size() > 0) {
                this.openArray("receiver");
                for (ResourceReference resourceReference : supplyDispenseComponent.getReceiver()) {
                    this.composeResourceReference(null, resourceReference);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeValueSet(String string, ValueSet valueSet) throws Exception {
        if (valueSet != null) {
            this.prop("resourceType", string);
            this.composeResourceElements(valueSet);
            this.composeStringCore("identifier", valueSet.getIdentifier(), false);
            this.composeStringExtras("identifier", valueSet.getIdentifier(), false);
            this.composeStringCore("version", valueSet.getVersion(), false);
            this.composeStringExtras("version", valueSet.getVersion(), false);
            this.composeStringCore("name", valueSet.getName(), false);
            this.composeStringExtras("name", valueSet.getName(), false);
            this.composeStringCore("publisher", valueSet.getPublisher(), false);
            this.composeStringExtras("publisher", valueSet.getPublisher(), false);
            if (valueSet.getTelecom().size() > 0) {
                this.openArray("telecom");
                for (Contact contact : valueSet.getTelecom()) {
                    this.composeContact(null, contact);
                }
                this.closeArray();
            }
            this.composeStringCore("description", valueSet.getDescription(), false);
            this.composeStringExtras("description", valueSet.getDescription(), false);
            this.composeStringCore("copyright", valueSet.getCopyright(), false);
            this.composeStringExtras("copyright", valueSet.getCopyright(), false);
            if (valueSet.getStatus() != null) {
                this.composeEnumerationCore("status", valueSet.getStatus(), new ValueSet.ValuesetStatusEnumFactory(), false);
                this.composeEnumerationExtras("status", valueSet.getStatus(), new ValueSet.ValuesetStatusEnumFactory(), false);
            }
            this.composeBooleanCore("experimental", valueSet.getExperimental(), false);
            this.composeBooleanExtras("experimental", valueSet.getExperimental(), false);
            this.composeBooleanCore("extensible", valueSet.getExtensible(), false);
            this.composeBooleanExtras("extensible", valueSet.getExtensible(), false);
            this.composeDateTimeCore("date", valueSet.getDate(), false);
            this.composeDateTimeExtras("date", valueSet.getDate(), false);
            this.composeValueSetValueSetDefineComponent("define", valueSet.getDefine());
            this.composeValueSetValueSetComposeComponent("compose", valueSet.getCompose());
            this.composeValueSetValueSetExpansionComponent("expansion", valueSet.getExpansion());
        }
    }

    private void composeValueSetValueSetDefineComponent(String string, ValueSet.ValueSetDefineComponent valueSetDefineComponent) throws Exception {
        if (valueSetDefineComponent != null) {
            this.open(string);
            this.composeBackbone(valueSetDefineComponent);
            this.composeUriCore("system", valueSetDefineComponent.getSystem(), false);
            this.composeUriExtras("system", valueSetDefineComponent.getSystem(), false);
            this.composeStringCore("version", valueSetDefineComponent.getVersion(), false);
            this.composeStringExtras("version", valueSetDefineComponent.getVersion(), false);
            this.composeBooleanCore("caseSensitive", valueSetDefineComponent.getCaseSensitive(), false);
            this.composeBooleanExtras("caseSensitive", valueSetDefineComponent.getCaseSensitive(), false);
            if (valueSetDefineComponent.getConcept().size() > 0) {
                this.openArray("concept");
                for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : valueSetDefineComponent.getConcept()) {
                    this.composeValueSetValueSetDefineConceptComponent(null, valueSetDefineConceptComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeValueSetValueSetDefineConceptComponent(String string, ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) throws Exception {
        if (valueSetDefineConceptComponent != null) {
            this.open(string);
            this.composeBackbone(valueSetDefineConceptComponent);
            this.composeCodeCore("code", valueSetDefineConceptComponent.getCode(), false);
            this.composeCodeExtras("code", valueSetDefineConceptComponent.getCode(), false);
            this.composeBooleanCore("abstract", valueSetDefineConceptComponent.getAbstract(), false);
            this.composeBooleanExtras("abstract", valueSetDefineConceptComponent.getAbstract(), false);
            this.composeStringCore("display", valueSetDefineConceptComponent.getDisplay(), false);
            this.composeStringExtras("display", valueSetDefineConceptComponent.getDisplay(), false);
            this.composeStringCore("definition", valueSetDefineConceptComponent.getDefinition(), false);
            this.composeStringExtras("definition", valueSetDefineConceptComponent.getDefinition(), false);
            if (valueSetDefineConceptComponent.getConcept().size() > 0) {
                this.openArray("concept");
                for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
                    this.composeValueSetValueSetDefineConceptComponent(null, valueSetDefineConceptComponent2);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeValueSetValueSetComposeComponent(String string, ValueSet.ValueSetComposeComponent valueSetComposeComponent) throws Exception {
        if (valueSetComposeComponent != null) {
            this.open(string);
            this.composeBackbone(valueSetComposeComponent);
            if (valueSetComposeComponent.getImport().size() > 0) {
                this.openArray("import");
                for (UriType element : valueSetComposeComponent.getImport()) {
                    this.composeUriCore(null, element, true);
                }
                this.closeArray();
                if (this.anyHasExtras(valueSetComposeComponent.getImport())) {
                    this.openArray("_import");
                    for (UriType uriType : valueSetComposeComponent.getImport()) {
                        this.composeUriExtras(null, uriType, true);
                    }
                    this.closeArray();
                }
            }
            if (valueSetComposeComponent.getInclude().size() > 0) {
                this.openArray("include");
                for (ValueSet.ConceptSetComponent conceptSetComponent : valueSetComposeComponent.getInclude()) {
                    this.composeValueSetConceptSetComponent(null, conceptSetComponent);
                }
                this.closeArray();
            }
            if (valueSetComposeComponent.getExclude().size() > 0) {
                this.openArray("exclude");
                for (ValueSet.ConceptSetComponent conceptSetComponent : valueSetComposeComponent.getExclude()) {
                    this.composeValueSetConceptSetComponent(null, conceptSetComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeValueSetConceptSetComponent(String string, ValueSet.ConceptSetComponent conceptSetComponent) throws Exception {
        if (conceptSetComponent != null) {
            this.open(string);
            this.composeBackbone(conceptSetComponent);
            this.composeUriCore("system", conceptSetComponent.getSystem(), false);
            this.composeUriExtras("system", conceptSetComponent.getSystem(), false);
            this.composeStringCore("version", conceptSetComponent.getVersion(), false);
            this.composeStringExtras("version", conceptSetComponent.getVersion(), false);
            if (conceptSetComponent.getCode().size() > 0) {
                this.openArray("code");
                for (CodeType element : conceptSetComponent.getCode()) {
                    this.composeCodeCore(null, element, true);
                }
                this.closeArray();
                if (this.anyHasExtras(conceptSetComponent.getCode())) {
                    this.openArray("_code");
                    for (CodeType codeType : conceptSetComponent.getCode()) {
                        this.composeCodeExtras(null, codeType, true);
                    }
                    this.closeArray();
                }
            }
            if (conceptSetComponent.getFilter().size() > 0) {
                this.openArray("filter");
                for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : conceptSetComponent.getFilter()) {
                    this.composeValueSetConceptSetFilterComponent(null, conceptSetFilterComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeValueSetConceptSetFilterComponent(String string, ValueSet.ConceptSetFilterComponent conceptSetFilterComponent) throws Exception {
        if (conceptSetFilterComponent != null) {
            this.open(string);
            this.composeBackbone(conceptSetFilterComponent);
            this.composeCodeCore("property", conceptSetFilterComponent.getProperty(), false);
            this.composeCodeExtras("property", conceptSetFilterComponent.getProperty(), false);
            if (conceptSetFilterComponent.getOp() != null) {
                this.composeEnumerationCore("op", conceptSetFilterComponent.getOp(), new ValueSet.FilterOperatorEnumFactory(), false);
                this.composeEnumerationExtras("op", conceptSetFilterComponent.getOp(), new ValueSet.FilterOperatorEnumFactory(), false);
            }
            this.composeCodeCore("value", conceptSetFilterComponent.getValue(), false);
            this.composeCodeExtras("value", conceptSetFilterComponent.getValue(), false);
            this.close();
        }
    }

    private void composeValueSetValueSetExpansionComponent(String string, ValueSet.ValueSetExpansionComponent valueSetExpansionComponent) throws Exception {
        if (valueSetExpansionComponent != null) {
            this.open(string);
            this.composeBackbone(valueSetExpansionComponent);
            this.composeIdentifier("identifier", valueSetExpansionComponent.getIdentifier());
            this.composeInstantCore("timestamp", valueSetExpansionComponent.getTimestamp(), false);
            this.composeInstantExtras("timestamp", valueSetExpansionComponent.getTimestamp(), false);
            if (valueSetExpansionComponent.getContains().size() > 0) {
                this.openArray("contains");
                for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : valueSetExpansionComponent.getContains()) {
                    this.composeValueSetValueSetExpansionContainsComponent(null, valueSetExpansionContainsComponent);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    private void composeValueSetValueSetExpansionContainsComponent(String string, ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent) throws Exception {
        if (valueSetExpansionContainsComponent != null) {
            this.open(string);
            this.composeBackbone(valueSetExpansionContainsComponent);
            this.composeUriCore("system", valueSetExpansionContainsComponent.getSystem(), false);
            this.composeUriExtras("system", valueSetExpansionContainsComponent.getSystem(), false);
            this.composeCodeCore("code", valueSetExpansionContainsComponent.getCode(), false);
            this.composeCodeExtras("code", valueSetExpansionContainsComponent.getCode(), false);
            this.composeStringCore("display", valueSetExpansionContainsComponent.getDisplay(), false);
            this.composeStringExtras("display", valueSetExpansionContainsComponent.getDisplay(), false);
            if (valueSetExpansionContainsComponent.getContains().size() > 0) {
                this.openArray("contains");
                for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent2 : valueSetExpansionContainsComponent.getContains()) {
                    this.composeValueSetValueSetExpansionContainsComponent(null, valueSetExpansionContainsComponent2);
                }
                this.closeArray();
            }
            this.close();
        }
    }

    @Override
    protected void composeResource(Resource resource) throws Exception {
        if (resource instanceof AdverseReaction) {
            this.composeAdverseReaction("AdverseReaction", (AdverseReaction)resource);
        } else if (resource instanceof Alert) {
            this.composeAlert("Alert", (Alert)resource);
        } else if (resource instanceof AllergyIntolerance) {
            this.composeAllergyIntolerance("AllergyIntolerance", (AllergyIntolerance)resource);
        } else if (resource instanceof CarePlan) {
            this.composeCarePlan("CarePlan", (CarePlan)resource);
        } else if (resource instanceof Composition) {
            this.composeComposition("Composition", (Composition)resource);
        } else if (resource instanceof ConceptMap) {
            this.composeConceptMap("ConceptMap", (ConceptMap)resource);
        } else if (resource instanceof Condition) {
            this.composeCondition("Condition", (Condition)resource);
        } else if (resource instanceof Conformance) {
            this.composeConformance("Conformance", (Conformance)resource);
        } else if (resource instanceof Device) {
            this.composeDevice("Device", (Device)resource);
        } else if (resource instanceof DeviceObservationReport) {
            this.composeDeviceObservationReport("DeviceObservationReport", (DeviceObservationReport)resource);
        } else if (resource instanceof DiagnosticOrder) {
            this.composeDiagnosticOrder("DiagnosticOrder", (DiagnosticOrder)resource);
        } else if (resource instanceof DiagnosticReport) {
            this.composeDiagnosticReport("DiagnosticReport", (DiagnosticReport)resource);
        } else if (resource instanceof DocumentManifest) {
            this.composeDocumentManifest("DocumentManifest", (DocumentManifest)resource);
        } else if (resource instanceof DocumentReference) {
            this.composeDocumentReference("DocumentReference", (DocumentReference)resource);
        } else if (resource instanceof Encounter) {
            this.composeEncounter("Encounter", (Encounter)resource);
        } else if (resource instanceof FamilyHistory) {
            this.composeFamilyHistory("FamilyHistory", (FamilyHistory)resource);
        } else if (resource instanceof Group) {
            this.composeGroup("Group", (Group)resource);
        } else if (resource instanceof ImagingStudy) {
            this.composeImagingStudy("ImagingStudy", (ImagingStudy)resource);
        } else if (resource instanceof Immunization) {
            this.composeImmunization("Immunization", (Immunization)resource);
        } else if (resource instanceof ImmunizationRecommendation) {
            this.composeImmunizationRecommendation("ImmunizationRecommendation", (ImmunizationRecommendation)resource);
        } else if (resource instanceof List_) {
            this.composeList_("List", (List_)resource);
        } else if (resource instanceof Location) {
            this.composeLocation("Location", (Location)resource);
        } else if (resource instanceof Media) {
            this.composeMedia("Media", (Media)resource);
        } else if (resource instanceof Medication) {
            this.composeMedication("Medication", (Medication)resource);
        } else if (resource instanceof MedicationAdministration) {
            this.composeMedicationAdministration("MedicationAdministration", (MedicationAdministration)resource);
        } else if (resource instanceof MedicationDispense) {
            this.composeMedicationDispense("MedicationDispense", (MedicationDispense)resource);
        } else if (resource instanceof MedicationPrescription) {
            this.composeMedicationPrescription("MedicationPrescription", (MedicationPrescription)resource);
        } else if (resource instanceof MedicationStatement) {
            this.composeMedicationStatement("MedicationStatement", (MedicationStatement)resource);
        } else if (resource instanceof MessageHeader) {
            this.composeMessageHeader("MessageHeader", (MessageHeader)resource);
        } else if (resource instanceof Observation) {
            this.composeObservation("Observation", (Observation)resource);
        } else if (resource instanceof OperationOutcome) {
            this.composeOperationOutcome("OperationOutcome", (OperationOutcome)resource);
        } else if (resource instanceof Order) {
            this.composeOrder("Order", (Order)resource);
        } else if (resource instanceof OrderResponse) {
            this.composeOrderResponse("OrderResponse", (OrderResponse)resource);
        } else if (resource instanceof Organization) {
            this.composeOrganization("Organization", (Organization)resource);
        } else if (resource instanceof Other) {
            this.composeOther("Other", (Other)resource);
        } else if (resource instanceof Patient) {
            this.composePatient("Patient", (Patient)resource);
        } else if (resource instanceof Practitioner) {
            this.composePractitioner("Practitioner", (Practitioner)resource);
        } else if (resource instanceof Procedure) {
            this.composeProcedure("Procedure", (Procedure)resource);
        } else if (resource instanceof Profile) {
            this.composeProfile("Profile", (Profile)resource);
        } else if (resource instanceof Provenance) {
            this.composeProvenance("Provenance", (Provenance)resource);
        } else if (resource instanceof Query) {
            this.composeQuery("Query", (Query)resource);
        } else if (resource instanceof Questionnaire) {
            this.composeQuestionnaire("Questionnaire", (Questionnaire)resource);
        } else if (resource instanceof RelatedPerson) {
            this.composeRelatedPerson("RelatedPerson", (RelatedPerson)resource);
        } else if (resource instanceof SecurityEvent) {
            this.composeSecurityEvent("SecurityEvent", (SecurityEvent)resource);
        } else if (resource instanceof Specimen) {
            this.composeSpecimen("Specimen", (Specimen)resource);
        } else if (resource instanceof Substance) {
            this.composeSubstance("Substance", (Substance)resource);
        } else if (resource instanceof Supply) {
            this.composeSupply("Supply", (Supply)resource);
        } else if (resource instanceof ValueSet) {
            this.composeValueSet("ValueSet", (ValueSet)resource);
        } else if (resource instanceof Binary) {
            this.composeBinary("Binary", (Binary)resource);
        } else {
            throw new Exception("Unhanded resource type " + resource.getClass().getName());
        }
    }

    protected void composeNamedResource(String string, Resource resource) throws Exception {
        if (resource instanceof AdverseReaction) {
            this.composeAdverseReaction(string, (AdverseReaction)resource);
        } else if (resource instanceof Alert) {
            this.composeAlert(string, (Alert)resource);
        } else if (resource instanceof AllergyIntolerance) {
            this.composeAllergyIntolerance(string, (AllergyIntolerance)resource);
        } else if (resource instanceof CarePlan) {
            this.composeCarePlan(string, (CarePlan)resource);
        } else if (resource instanceof Composition) {
            this.composeComposition(string, (Composition)resource);
        } else if (resource instanceof ConceptMap) {
            this.composeConceptMap(string, (ConceptMap)resource);
        } else if (resource instanceof Condition) {
            this.composeCondition(string, (Condition)resource);
        } else if (resource instanceof Conformance) {
            this.composeConformance(string, (Conformance)resource);
        } else if (resource instanceof Device) {
            this.composeDevice(string, (Device)resource);
        } else if (resource instanceof DeviceObservationReport) {
            this.composeDeviceObservationReport(string, (DeviceObservationReport)resource);
        } else if (resource instanceof DiagnosticOrder) {
            this.composeDiagnosticOrder(string, (DiagnosticOrder)resource);
        } else if (resource instanceof DiagnosticReport) {
            this.composeDiagnosticReport(string, (DiagnosticReport)resource);
        } else if (resource instanceof DocumentManifest) {
            this.composeDocumentManifest(string, (DocumentManifest)resource);
        } else if (resource instanceof DocumentReference) {
            this.composeDocumentReference(string, (DocumentReference)resource);
        } else if (resource instanceof Encounter) {
            this.composeEncounter(string, (Encounter)resource);
        } else if (resource instanceof FamilyHistory) {
            this.composeFamilyHistory(string, (FamilyHistory)resource);
        } else if (resource instanceof Group) {
            this.composeGroup(string, (Group)resource);
        } else if (resource instanceof ImagingStudy) {
            this.composeImagingStudy(string, (ImagingStudy)resource);
        } else if (resource instanceof Immunization) {
            this.composeImmunization(string, (Immunization)resource);
        } else if (resource instanceof ImmunizationRecommendation) {
            this.composeImmunizationRecommendation(string, (ImmunizationRecommendation)resource);
        } else if (resource instanceof List_) {
            this.composeList_(string, (List_)resource);
        } else if (resource instanceof Location) {
            this.composeLocation(string, (Location)resource);
        } else if (resource instanceof Media) {
            this.composeMedia(string, (Media)resource);
        } else if (resource instanceof Medication) {
            this.composeMedication(string, (Medication)resource);
        } else if (resource instanceof MedicationAdministration) {
            this.composeMedicationAdministration(string, (MedicationAdministration)resource);
        } else if (resource instanceof MedicationDispense) {
            this.composeMedicationDispense(string, (MedicationDispense)resource);
        } else if (resource instanceof MedicationPrescription) {
            this.composeMedicationPrescription(string, (MedicationPrescription)resource);
        } else if (resource instanceof MedicationStatement) {
            this.composeMedicationStatement(string, (MedicationStatement)resource);
        } else if (resource instanceof MessageHeader) {
            this.composeMessageHeader(string, (MessageHeader)resource);
        } else if (resource instanceof Observation) {
            this.composeObservation(string, (Observation)resource);
        } else if (resource instanceof OperationOutcome) {
            this.composeOperationOutcome(string, (OperationOutcome)resource);
        } else if (resource instanceof Order) {
            this.composeOrder(string, (Order)resource);
        } else if (resource instanceof OrderResponse) {
            this.composeOrderResponse(string, (OrderResponse)resource);
        } else if (resource instanceof Organization) {
            this.composeOrganization(string, (Organization)resource);
        } else if (resource instanceof Other) {
            this.composeOther(string, (Other)resource);
        } else if (resource instanceof Patient) {
            this.composePatient(string, (Patient)resource);
        } else if (resource instanceof Practitioner) {
            this.composePractitioner(string, (Practitioner)resource);
        } else if (resource instanceof Procedure) {
            this.composeProcedure(string, (Procedure)resource);
        } else if (resource instanceof Profile) {
            this.composeProfile(string, (Profile)resource);
        } else if (resource instanceof Provenance) {
            this.composeProvenance(string, (Provenance)resource);
        } else if (resource instanceof Query) {
            this.composeQuery(string, (Query)resource);
        } else if (resource instanceof Questionnaire) {
            this.composeQuestionnaire(string, (Questionnaire)resource);
        } else if (resource instanceof RelatedPerson) {
            this.composeRelatedPerson(string, (RelatedPerson)resource);
        } else if (resource instanceof SecurityEvent) {
            this.composeSecurityEvent(string, (SecurityEvent)resource);
        } else if (resource instanceof Specimen) {
            this.composeSpecimen(string, (Specimen)resource);
        } else if (resource instanceof Substance) {
            this.composeSubstance(string, (Substance)resource);
        } else if (resource instanceof Supply) {
            this.composeSupply(string, (Supply)resource);
        } else if (resource instanceof ValueSet) {
            this.composeValueSet(string, (ValueSet)resource);
        } else if (resource instanceof Binary) {
            this.composeBinary(string, (Binary)resource);
        } else {
            throw new Exception("Unhanded resource type " + resource.getClass().getName());
        }
    }

    protected void composeType(String string, Type type) throws Exception {
        if (type != null) {
            if (type instanceof Age) {
                this.composeAge(string + "Age", (Age)type);
            } else if (type instanceof Count) {
                this.composeCount(string + "Count", (Count)type);
            } else if (type instanceof Money) {
                this.composeMoney(string + "Money", (Money)type);
            } else if (type instanceof Distance) {
                this.composeDistance(string + "Distance", (Distance)type);
            } else if (type instanceof Duration) {
                this.composeDuration(string + "Duration", (Duration)type);
            } else if (type instanceof Period) {
                this.composePeriod(string + "Period", (Period)type);
            } else if (type instanceof Coding) {
                this.composeCoding(string + "Coding", (Coding)type);
            } else if (type instanceof Range) {
                this.composeRange(string + "Range", (Range)type);
            } else if (type instanceof Quantity) {
                this.composeQuantity(string + "Quantity", (Quantity)type);
            } else if (type instanceof Attachment) {
                this.composeAttachment(string + "Attachment", (Attachment)type);
            } else if (type instanceof Ratio) {
                this.composeRatio(string + "Ratio", (Ratio)type);
            } else if (type instanceof SampledData) {
                this.composeSampledData(string + "SampledData", (SampledData)type);
            } else if (type instanceof ResourceReference) {
                this.composeResourceReference(string + "Resource", (ResourceReference)type);
            } else if (type instanceof CodeableConcept) {
                this.composeCodeableConcept(string + "CodeableConcept", (CodeableConcept)type);
            } else if (type instanceof Identifier) {
                this.composeIdentifier(string + "Identifier", (Identifier)type);
            } else if (type instanceof Schedule) {
                this.composeSchedule(string + "Schedule", (Schedule)type);
            } else if (type instanceof Contact) {
                this.composeContact(string + "Contact", (Contact)type);
            } else if (type instanceof Address) {
                this.composeAddress(string + "Address", (Address)type);
            } else if (type instanceof HumanName) {
                this.composeHumanName(string + "HumanName", (HumanName)type);
            } else if (type instanceof IdType) {
                this.composeIdCore(string + "Id", (IdType)type, false);
                this.composeIdExtras(string + "Id", (IdType)type, false);
            } else if (type instanceof Base64BinaryType) {
                this.composeBase64BinaryCore(string + "Base64Binary", (Base64BinaryType)type, false);
                this.composeBase64BinaryExtras(string + "Base64Binary", (Base64BinaryType)type, false);
            } else if (type instanceof DateTimeType) {
                this.composeDateTimeCore(string + "DateTime", (DateTimeType)type, false);
                this.composeDateTimeExtras(string + "DateTime", (DateTimeType)type, false);
            } else if (type instanceof IntegerType) {
                this.composeIntegerCore(string + "Integer", (IntegerType)type, false);
                this.composeIntegerExtras(string + "Integer", (IntegerType)type, false);
            } else if (type instanceof OidType) {
                this.composeOidCore(string + "Oid", (OidType)type, false);
                this.composeOidExtras(string + "Oid", (OidType)type, false);
            } else if (type instanceof StringType) {
                this.composeStringCore(string + "String", (StringType)type, false);
                this.composeStringExtras(string + "String", (StringType)type, false);
            } else if (type instanceof BooleanType) {
                this.composeBooleanCore(string + "Boolean", (BooleanType)type, false);
                this.composeBooleanExtras(string + "Boolean", (BooleanType)type, false);
            } else if (type instanceof UuidType) {
                this.composeUuidCore(string + "Uuid", (UuidType)type, false);
                this.composeUuidExtras(string + "Uuid", (UuidType)type, false);
            } else if (type instanceof CodeType) {
                this.composeCodeCore(string + "Code", (CodeType)type, false);
                this.composeCodeExtras(string + "Code", (CodeType)type, false);
            } else if (type instanceof DateType) {
                this.composeDateCore(string + "Date", (DateType)type, false);
                this.composeDateExtras(string + "Date", (DateType)type, false);
            } else if (type instanceof UriType) {
                this.composeUriCore(string + "Uri", (UriType)type, false);
                this.composeUriExtras(string + "Uri", (UriType)type, false);
            } else if (type instanceof InstantType) {
                this.composeInstantCore(string + "Instant", (InstantType)type, false);
                this.composeInstantExtras(string + "Instant", (InstantType)type, false);
            } else if (type instanceof DecimalType) {
                this.composeDecimalCore(string + "Decimal", (DecimalType)type, false);
                this.composeDecimalExtras(string + "Decimal", (DecimalType)type, false);
            } else {
                throw new Exception("Unhanded type");
            }
        }
    }
}

