/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import com.google.gson.stream.JsonWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.instance.formats.ComposerBase;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Binary;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class JsonComposerBase
extends ComposerBase {
    protected JsonWriter json;
    private boolean htmlPretty;

    @Override
    public void compose(OutputStream outputStream, Resource resource, boolean bl) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        JsonWriter jsonWriter = new JsonWriter((Writer)outputStreamWriter);
        jsonWriter.setIndent(bl ? "  " : "");
        jsonWriter.beginObject();
        this.compose(jsonWriter, resource);
        jsonWriter.endObject();
        outputStreamWriter.flush();
    }

    @Override
    public void compose(OutputStream outputStream, AtomFeed atomFeed, boolean bl) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        JsonWriter jsonWriter = new JsonWriter((Writer)outputStreamWriter);
        jsonWriter.setIndent(bl ? "  " : "");
        jsonWriter.beginObject();
        this.compose(jsonWriter, atomFeed);
        jsonWriter.endObject();
        outputStreamWriter.flush();
    }

    public void compose(JsonWriter jsonWriter, Resource resource) throws Exception {
        this.json = jsonWriter;
        this.composeResource(resource);
    }

    public void compose(JsonWriter jsonWriter, AtomFeed atomFeed) throws Exception {
        this.json = jsonWriter;
        this.composeFeed(atomFeed);
    }

    @Override
    public void compose(OutputStream outputStream, List<AtomCategory> list, boolean bl) throws Exception {
    }

    private void composeFeed(AtomFeed atomFeed) throws Exception {
        this.prop("resourceType", "Bundle");
        this.prop("title", atomFeed.getTitle());
        this.prop("id", atomFeed.getId());
        if (atomFeed.getLinks().size() > 0) {
            this.openArray("link");
            for (String object : atomFeed.getLinks().keySet()) {
                this.json.beginObject();
                this.prop("rel", object);
                this.prop("href", atomFeed.getLinks().get(object));
                this.json.endObject();
            }
            this.closeArray();
        }
        if (atomFeed.getTotalResults() != null) {
            this.prop("totalResults", atomFeed.getTotalResults());
        }
        if (atomFeed.getUpdated() != null) {
            this.prop("updated", atomFeed.getUpdated().toString());
        }
        if (atomFeed.getTags().size() > 0) {
            this.openArray("category");
            for (AtomCategory atomCategory : atomFeed.getTags()) {
                this.json.beginObject();
                this.prop("scheme", atomCategory.getScheme());
                this.prop("term", atomCategory.getTerm());
                if (!Utilities.noString(atomCategory.getLabel())) {
                    this.prop("label", atomCategory.getLabel());
                }
                this.json.endObject();
            }
            this.closeArray();
        }
        if (atomFeed.getAuthorName() != null || atomFeed.getAuthorUri() != null) {
            this.openArray("author");
            this.json.beginObject();
            if (atomFeed.getAuthorName() != null) {
                this.prop("name", atomFeed.getAuthorName());
            }
            if (atomFeed.getAuthorUri() != null) {
                this.prop("uri", atomFeed.getAuthorUri());
            }
            this.json.endObject();
            this.closeArray();
        }
        if (atomFeed.getEntryList().size() > 0) {
            this.openArray("entry");
            for (AtomEntry atomEntry : atomFeed.getEntryList()) {
                this.composeEntry(atomEntry);
            }
            this.closeArray();
        }
    }

    private <T extends Resource> void composeEntry(AtomEntry<T> atomEntry) throws Exception {
        this.json.beginObject();
        this.prop("title", atomEntry.getTitle());
        this.prop("id", atomEntry.getId());
        if (atomEntry.getLinks().size() > 0) {
            this.openArray("link");
            for (String object : atomEntry.getLinks().keySet()) {
                this.json.beginObject();
                this.prop("rel", object);
                this.prop("href", atomEntry.getLinks().get(object));
                this.json.endObject();
            }
            this.closeArray();
        }
        if (atomEntry.getUpdated() != null) {
            this.prop("updated", atomEntry.getUpdated().toString());
        }
        if (atomEntry.getPublished() != null) {
            this.prop("published", atomEntry.getPublished().toString());
        }
        if (atomEntry.getAuthorName() != null || atomEntry.getAuthorUri() != null) {
            this.openArray("author");
            this.json.beginObject();
            if (atomEntry.getAuthorName() != null) {
                this.prop("name", atomEntry.getAuthorName());
            }
            if (atomEntry.getAuthorUri() != null) {
                this.prop("uri", atomEntry.getAuthorUri());
            }
            this.json.endObject();
            this.closeArray();
        }
        if (atomEntry.getTags().size() > 0) {
            this.openArray("category");
            for (AtomCategory atomCategory : atomEntry.getTags()) {
                this.json.beginObject();
                this.prop("scheme", atomCategory.getScheme());
                this.prop("term", atomCategory.getTerm());
                if (!Utilities.noString(atomCategory.getLabel())) {
                    this.prop("label", atomCategory.getLabel());
                }
                this.json.endObject();
            }
            this.closeArray();
        }
        this.open("content");
        this.composeResource((Resource)atomEntry.getResource());
        this.close();
        if (atomEntry.getSummary() != null) {
            this.composeXhtml("summary", atomEntry.getSummary());
        }
        this.json.endObject();
    }

    protected abstract void composeResource(Resource var1) throws Exception;

    protected void writeNull(String string) throws Exception {
        this.json.nullValue();
    }

    protected void prop(String string, String string2) throws Exception {
        if (string != null) {
            this.json.name(string);
        }
        this.json.value(string2);
    }

    protected void prop(String string, Boolean bl) throws Exception {
        if (string != null) {
            this.json.name(string);
        }
        this.json.value(bl.booleanValue());
    }

    protected void prop(String string, BigDecimal bigDecimal) throws Exception {
        if (string != null) {
            this.json.name(string);
        }
        this.json.value((Number)bigDecimal);
    }

    protected void prop(String string, Integer n) throws Exception {
        if (string != null) {
            this.json.name(string);
        }
        this.json.value((Number)n);
    }

    protected void composeXhtml(String string, XhtmlNode xhtmlNode) throws Exception {
        if (!Utilities.noString(this.xhtmlMessage)) {
            this.prop(string, "<div>!-- " + this.xhtmlMessage + " --></div>");
        } else {
            XhtmlComposer xhtmlComposer = new XhtmlComposer();
            xhtmlComposer.setPretty(this.htmlPretty);
            this.prop(string, xhtmlComposer.compose(xhtmlNode));
        }
    }

    protected void open(String string) throws Exception {
        if (string != null) {
            this.json.name(string);
        }
        this.json.beginObject();
    }

    protected void close() throws Exception {
        this.json.endObject();
    }

    protected void openArray(String string) throws Exception {
        if (string != null) {
            this.json.name(string);
        }
        this.json.beginArray();
    }

    protected void closeArray() throws Exception {
        this.json.endArray();
    }

    protected void openObject(String string) throws Exception {
        if (string != null) {
            this.json.name(string);
        }
        this.json.beginObject();
    }

    protected void closeObject() throws Exception {
        this.json.endObject();
    }

    protected void composeBinary(String string, Binary binary) throws Exception {
        if (binary != null) {
            this.prop("resourceType", "Binary");
            if (binary.getXmlId() != null) {
                this.prop("id", binary.getXmlId());
            }
            this.prop("contentType", binary.getContentType());
            this.prop("content", JsonComposerBase.toString(binary.getContent()));
        }
    }

    protected boolean anyHasExtras(List<? extends Element> list) {
        for (Element element : list) {
            if (!element.hasExtensions() && Utilities.noString(element.getXmlId())) continue;
            return true;
        }
        return false;
    }
}

