/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import org.hl7.fhir.instance.formats.JsonParserBase;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.AdverseReaction;
import org.hl7.fhir.instance.model.Age;
import org.hl7.fhir.instance.model.Alert;
import org.hl7.fhir.instance.model.AllergyIntolerance;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CarePlan;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Composition;
import org.hl7.fhir.instance.model.ConceptMap;
import org.hl7.fhir.instance.model.Condition;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.Count;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.DeviceObservationReport;
import org.hl7.fhir.instance.model.DiagnosticOrder;
import org.hl7.fhir.instance.model.DiagnosticReport;
import org.hl7.fhir.instance.model.Distance;
import org.hl7.fhir.instance.model.DocumentManifest;
import org.hl7.fhir.instance.model.DocumentReference;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.FamilyHistory;
import org.hl7.fhir.instance.model.Group;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.ImagingStudy;
import org.hl7.fhir.instance.model.Immunization;
import org.hl7.fhir.instance.model.ImmunizationRecommendation;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.List_;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Media;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.MedicationAdministration;
import org.hl7.fhir.instance.model.MedicationDispense;
import org.hl7.fhir.instance.model.MedicationPrescription;
import org.hl7.fhir.instance.model.MedicationStatement;
import org.hl7.fhir.instance.model.MessageHeader;
import org.hl7.fhir.instance.model.Money;
import org.hl7.fhir.instance.model.Narrative;
import org.hl7.fhir.instance.model.Observation;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Order;
import org.hl7.fhir.instance.model.OrderResponse;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Other;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Procedure;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Provenance;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Query;
import org.hl7.fhir.instance.model.Questionnaire;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.RelatedPerson;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.SampledData;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.SecurityEvent;
import org.hl7.fhir.instance.model.Specimen;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Substance;
import org.hl7.fhir.instance.model.Supply;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.UuidType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

public class JsonParser
extends JsonParserBase {
    @Override
    protected void parseElementProperties(JsonObject jsonObject, Element element) throws Exception {
        super.parseElementProperties(jsonObject, element);
        if (jsonObject != null && jsonObject.has("extension")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("extension");
            for (int i = 0; i < jsonArray.size(); ++i) {
                element.getExtensions().add(this.parseExtension(jsonArray.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseBackboneProperties(JsonObject jsonObject, BackboneElement backboneElement) throws Exception {
        this.parseElementProperties(jsonObject, backboneElement);
        if (jsonObject != null && jsonObject.has("modifierExtension")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("modifierExtension");
            for (int i = 0; i < jsonArray.size(); ++i) {
                backboneElement.getModifierExtensions().add(this.parseExtension(jsonArray.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseTypeProperties(JsonObject jsonObject, Element element) throws Exception {
        this.parseElementProperties(jsonObject, element);
    }

    private <E extends Enum<E>> Enumeration<E> parseEnumeration(String string, E e, EnumFactory enumFactory) throws Exception {
        Enumeration enumeration = new Enumeration();
        if (string != null) {
            enumeration.setValue(enumFactory.fromCode(string));
        }
        return enumeration;
    }

    private IdType parseId(String string) throws Exception {
        IdType idType = new IdType();
        if (string != null) {
            idType.setValue(this.parseIdPrimitive(string));
        }
        return idType;
    }

    private Base64BinaryType parseBase64Binary(String string) throws Exception {
        Base64BinaryType base64BinaryType = new Base64BinaryType();
        if (string != null) {
            base64BinaryType.setValue(this.parseBase64BinaryPrimitive(string));
        }
        return base64BinaryType;
    }

    private DateTimeType parseDateTime(String string) throws Exception {
        DateTimeType dateTimeType = new DateTimeType();
        if (string != null) {
            dateTimeType.setValue(this.parseDateTimePrimitive(string));
        }
        return dateTimeType;
    }

    private IntegerType parseInteger(Long l) throws Exception {
        IntegerType integerType = new IntegerType();
        if (l != null) {
            integerType.setValue(this.parseIntegerPrimitive(l));
        }
        return integerType;
    }

    private OidType parseOid(String string) throws Exception {
        OidType oidType = new OidType();
        if (string != null) {
            oidType.setValue(this.parseOidPrimitive(string));
        }
        return oidType;
    }

    private StringType parseString(String string) throws Exception {
        StringType stringType = new StringType();
        if (string != null) {
            stringType.setValue(this.parseStringPrimitive(string));
        }
        return stringType;
    }

    private BooleanType parseBoolean(Boolean bl) throws Exception {
        BooleanType booleanType = new BooleanType();
        if (bl != null) {
            booleanType.setValue(this.parseBooleanPrimitive(bl));
        }
        return booleanType;
    }

    private UuidType parseUuid(String string) throws Exception {
        UuidType uuidType = new UuidType();
        if (string != null) {
            uuidType.setValue(this.parseUuidPrimitive(string));
        }
        return uuidType;
    }

    private CodeType parseCode(String string) throws Exception {
        CodeType codeType = new CodeType();
        if (string != null) {
            codeType.setValue(this.parseCodePrimitive(string));
        }
        return codeType;
    }

    private DateType parseDate(String string) throws Exception {
        DateType dateType = new DateType();
        if (string != null) {
            dateType.setValue(this.parseDatePrimitive(string));
        }
        return dateType;
    }

    private UriType parseUri(String string) throws Exception {
        UriType uriType = new UriType();
        if (string != null) {
            uriType.setValue(this.parseUriPrimitive(string));
        }
        return uriType;
    }

    private InstantType parseInstant(String string) throws Exception {
        InstantType instantType = new InstantType();
        if (string != null) {
            instantType.setValue(this.parseInstantPrimitive(string));
        }
        return instantType;
    }

    private DecimalType parseDecimal(BigDecimal bigDecimal) throws Exception {
        DecimalType decimalType = new DecimalType();
        if (bigDecimal != null) {
            decimalType.setValue(this.parseDecimalPrimitive(bigDecimal));
        }
        return decimalType;
    }

    private Extension parseExtension(JsonObject jsonObject) throws Exception {
        Type type;
        Extension extension = new Extension();
        this.parseElementProperties(jsonObject, extension);
        if (jsonObject.has("url")) {
            extension.setUrl(this.parseUri(jsonObject.get("url").getAsString()));
        }
        if (jsonObject.has("_url")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_url"), extension.getUrl());
        }
        if ((type = this.parseType("value", jsonObject)) != null) {
            extension.setValue(type);
        }
        return extension;
    }

    private Narrative parseNarrative(JsonObject jsonObject) throws Exception {
        Narrative narrative = new Narrative();
        this.parseElementProperties(jsonObject, narrative);
        if (jsonObject.has("status")) {
            narrative.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Narrative.NarrativeStatus.Null, new Narrative.NarrativeStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), narrative.getStatus());
        }
        if (jsonObject.has("div")) {
            narrative.setDiv(this.parseXhtml(jsonObject.get("div").getAsString()));
        }
        return narrative;
    }

    private Period parsePeriod(JsonObject jsonObject) throws Exception {
        Period period = new Period();
        this.parseTypeProperties(jsonObject, period);
        if (jsonObject.has("start")) {
            period.setStart(this.parseDateTime(jsonObject.get("start").getAsString()));
        }
        if (jsonObject.has("_start")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_start"), period.getStart());
        }
        if (jsonObject.has("end")) {
            period.setEnd(this.parseDateTime(jsonObject.get("end").getAsString()));
        }
        if (jsonObject.has("_end")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_end"), period.getEnd());
        }
        return period;
    }

    private Coding parseCoding(JsonObject jsonObject) throws Exception {
        Coding coding = new Coding();
        this.parseTypeProperties(jsonObject, coding);
        if (jsonObject.has("system")) {
            coding.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), coding.getSystem());
        }
        if (jsonObject.has("version")) {
            coding.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), coding.getVersion());
        }
        if (jsonObject.has("code")) {
            coding.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), coding.getCode());
        }
        if (jsonObject.has("display")) {
            coding.setDisplay(this.parseString(jsonObject.get("display").getAsString()));
        }
        if (jsonObject.has("_display")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_display"), coding.getDisplay());
        }
        if (jsonObject.has("primary")) {
            coding.setPrimary(this.parseBoolean(jsonObject.get("primary").getAsBoolean()));
        }
        if (jsonObject.has("_primary")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_primary"), coding.getPrimary());
        }
        if (jsonObject.has("valueSet")) {
            coding.setValueSet(this.parseResourceReference(jsonObject.getAsJsonObject("valueSet")));
        }
        return coding;
    }

    private Range parseRange(JsonObject jsonObject) throws Exception {
        Range range = new Range();
        this.parseTypeProperties(jsonObject, range);
        if (jsonObject.has("low")) {
            range.setLow(this.parseQuantity(jsonObject.getAsJsonObject("low")));
        }
        if (jsonObject.has("high")) {
            range.setHigh(this.parseQuantity(jsonObject.getAsJsonObject("high")));
        }
        return range;
    }

    private Quantity parseQuantity(JsonObject jsonObject) throws Exception {
        Quantity quantity = new Quantity();
        this.parseTypeProperties(jsonObject, quantity);
        if (jsonObject.has("value")) {
            quantity.setValue(this.parseDecimal(jsonObject.get("value").getAsBigDecimal()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), quantity.getValue());
        }
        if (jsonObject.has("comparator")) {
            quantity.setComparator(this.parseEnumeration(jsonObject.get("comparator").getAsString(), Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (jsonObject.has("_comparator")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comparator"), quantity.getComparator());
        }
        if (jsonObject.has("units")) {
            quantity.setUnits(this.parseString(jsonObject.get("units").getAsString()));
        }
        if (jsonObject.has("_units")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_units"), quantity.getUnits());
        }
        if (jsonObject.has("system")) {
            quantity.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), quantity.getSystem());
        }
        if (jsonObject.has("code")) {
            quantity.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), quantity.getCode());
        }
        return quantity;
    }

    private Attachment parseAttachment(JsonObject jsonObject) throws Exception {
        Attachment attachment = new Attachment();
        this.parseTypeProperties(jsonObject, attachment);
        if (jsonObject.has("contentType")) {
            attachment.setContentType(this.parseCode(jsonObject.get("contentType").getAsString()));
        }
        if (jsonObject.has("_contentType")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_contentType"), attachment.getContentType());
        }
        if (jsonObject.has("language")) {
            attachment.setLanguage(this.parseCode(jsonObject.get("language").getAsString()));
        }
        if (jsonObject.has("_language")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_language"), attachment.getLanguage());
        }
        if (jsonObject.has("data")) {
            attachment.setData(this.parseBase64Binary(jsonObject.get("data").getAsString()));
        }
        if (jsonObject.has("_data")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_data"), attachment.getData());
        }
        if (jsonObject.has("url")) {
            attachment.setUrl(this.parseUri(jsonObject.get("url").getAsString()));
        }
        if (jsonObject.has("_url")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_url"), attachment.getUrl());
        }
        if (jsonObject.has("size")) {
            attachment.setSize(this.parseInteger(jsonObject.get("size").getAsLong()));
        }
        if (jsonObject.has("_size")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_size"), attachment.getSize());
        }
        if (jsonObject.has("hash")) {
            attachment.setHash(this.parseBase64Binary(jsonObject.get("hash").getAsString()));
        }
        if (jsonObject.has("_hash")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_hash"), attachment.getHash());
        }
        if (jsonObject.has("title")) {
            attachment.setTitle(this.parseString(jsonObject.get("title").getAsString()));
        }
        if (jsonObject.has("_title")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_title"), attachment.getTitle());
        }
        return attachment;
    }

    private Ratio parseRatio(JsonObject jsonObject) throws Exception {
        Ratio ratio = new Ratio();
        this.parseTypeProperties(jsonObject, ratio);
        if (jsonObject.has("numerator")) {
            ratio.setNumerator(this.parseQuantity(jsonObject.getAsJsonObject("numerator")));
        }
        if (jsonObject.has("denominator")) {
            ratio.setDenominator(this.parseQuantity(jsonObject.getAsJsonObject("denominator")));
        }
        return ratio;
    }

    private SampledData parseSampledData(JsonObject jsonObject) throws Exception {
        SampledData sampledData = new SampledData();
        this.parseTypeProperties(jsonObject, sampledData);
        if (jsonObject.has("origin")) {
            sampledData.setOrigin(this.parseQuantity(jsonObject.getAsJsonObject("origin")));
        }
        if (jsonObject.has("period")) {
            sampledData.setPeriod(this.parseDecimal(jsonObject.get("period").getAsBigDecimal()));
        }
        if (jsonObject.has("_period")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_period"), sampledData.getPeriod());
        }
        if (jsonObject.has("factor")) {
            sampledData.setFactor(this.parseDecimal(jsonObject.get("factor").getAsBigDecimal()));
        }
        if (jsonObject.has("_factor")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_factor"), sampledData.getFactor());
        }
        if (jsonObject.has("lowerLimit")) {
            sampledData.setLowerLimit(this.parseDecimal(jsonObject.get("lowerLimit").getAsBigDecimal()));
        }
        if (jsonObject.has("_lowerLimit")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_lowerLimit"), sampledData.getLowerLimit());
        }
        if (jsonObject.has("upperLimit")) {
            sampledData.setUpperLimit(this.parseDecimal(jsonObject.get("upperLimit").getAsBigDecimal()));
        }
        if (jsonObject.has("_upperLimit")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_upperLimit"), sampledData.getUpperLimit());
        }
        if (jsonObject.has("dimensions")) {
            sampledData.setDimensions(this.parseInteger(jsonObject.get("dimensions").getAsLong()));
        }
        if (jsonObject.has("_dimensions")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_dimensions"), sampledData.getDimensions());
        }
        if (jsonObject.has("data")) {
            sampledData.setData(this.parseString(jsonObject.get("data").getAsString()));
        }
        if (jsonObject.has("_data")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_data"), sampledData.getData());
        }
        return sampledData;
    }

    private ResourceReference parseResourceReference(JsonObject jsonObject) throws Exception {
        ResourceReference resourceReference = new ResourceReference();
        this.parseTypeProperties(jsonObject, resourceReference);
        if (jsonObject.has("reference")) {
            resourceReference.setReference(this.parseString(jsonObject.get("reference").getAsString()));
        }
        if (jsonObject.has("_reference")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_reference"), resourceReference.getReference());
        }
        if (jsonObject.has("display")) {
            resourceReference.setDisplay(this.parseString(jsonObject.get("display").getAsString()));
        }
        if (jsonObject.has("_display")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_display"), resourceReference.getDisplay());
        }
        return resourceReference;
    }

    private CodeableConcept parseCodeableConcept(JsonObject jsonObject) throws Exception {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.parseTypeProperties(jsonObject, codeableConcept);
        if (jsonObject.has("coding")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("coding");
            for (int i = 0; i < jsonArray.size(); ++i) {
                codeableConcept.getCoding().add(this.parseCoding(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("text")) {
            codeableConcept.setText(this.parseString(jsonObject.get("text").getAsString()));
        }
        if (jsonObject.has("_text")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_text"), codeableConcept.getText());
        }
        return codeableConcept;
    }

    private Identifier parseIdentifier(JsonObject jsonObject) throws Exception {
        Identifier identifier = new Identifier();
        this.parseTypeProperties(jsonObject, identifier);
        if (jsonObject.has("use")) {
            identifier.setUse(this.parseEnumeration(jsonObject.get("use").getAsString(), Identifier.IdentifierUse.Null, new Identifier.IdentifierUseEnumFactory()));
        }
        if (jsonObject.has("_use")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_use"), identifier.getUse());
        }
        if (jsonObject.has("label")) {
            identifier.setLabel(this.parseString(jsonObject.get("label").getAsString()));
        }
        if (jsonObject.has("_label")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_label"), identifier.getLabel());
        }
        if (jsonObject.has("system")) {
            identifier.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), identifier.getSystem());
        }
        if (jsonObject.has("value")) {
            identifier.setValue(this.parseString(jsonObject.get("value").getAsString()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), identifier.getValue());
        }
        if (jsonObject.has("period")) {
            identifier.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("assigner")) {
            identifier.setAssigner(this.parseResourceReference(jsonObject.getAsJsonObject("assigner")));
        }
        return identifier;
    }

    private Age parseAge(JsonObject jsonObject) throws Exception {
        Age age = new Age();
        this.parseElementProperties(jsonObject, age);
        if (jsonObject.has("value")) {
            age.setValue(this.parseDecimal(jsonObject.get("value").getAsBigDecimal()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), age.getValue());
        }
        if (jsonObject.has("comparator")) {
            age.setComparator(this.parseEnumeration(jsonObject.get("comparator").getAsString(), Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (jsonObject.has("_comparator")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comparator"), age.getComparator());
        }
        if (jsonObject.has("units")) {
            age.setUnits(this.parseString(jsonObject.get("units").getAsString()));
        }
        if (jsonObject.has("_units")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_units"), age.getUnits());
        }
        if (jsonObject.has("system")) {
            age.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), age.getSystem());
        }
        if (jsonObject.has("code")) {
            age.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), age.getCode());
        }
        return age;
    }

    private Count parseCount(JsonObject jsonObject) throws Exception {
        Count count = new Count();
        this.parseElementProperties(jsonObject, count);
        if (jsonObject.has("value")) {
            count.setValue(this.parseDecimal(jsonObject.get("value").getAsBigDecimal()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), count.getValue());
        }
        if (jsonObject.has("comparator")) {
            count.setComparator(this.parseEnumeration(jsonObject.get("comparator").getAsString(), Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (jsonObject.has("_comparator")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comparator"), count.getComparator());
        }
        if (jsonObject.has("units")) {
            count.setUnits(this.parseString(jsonObject.get("units").getAsString()));
        }
        if (jsonObject.has("_units")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_units"), count.getUnits());
        }
        if (jsonObject.has("system")) {
            count.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), count.getSystem());
        }
        if (jsonObject.has("code")) {
            count.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), count.getCode());
        }
        return count;
    }

    private Money parseMoney(JsonObject jsonObject) throws Exception {
        Money money = new Money();
        this.parseElementProperties(jsonObject, money);
        if (jsonObject.has("value")) {
            money.setValue(this.parseDecimal(jsonObject.get("value").getAsBigDecimal()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), money.getValue());
        }
        if (jsonObject.has("comparator")) {
            money.setComparator(this.parseEnumeration(jsonObject.get("comparator").getAsString(), Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (jsonObject.has("_comparator")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comparator"), money.getComparator());
        }
        if (jsonObject.has("units")) {
            money.setUnits(this.parseString(jsonObject.get("units").getAsString()));
        }
        if (jsonObject.has("_units")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_units"), money.getUnits());
        }
        if (jsonObject.has("system")) {
            money.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), money.getSystem());
        }
        if (jsonObject.has("code")) {
            money.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), money.getCode());
        }
        return money;
    }

    private Distance parseDistance(JsonObject jsonObject) throws Exception {
        Distance distance = new Distance();
        this.parseElementProperties(jsonObject, distance);
        if (jsonObject.has("value")) {
            distance.setValue(this.parseDecimal(jsonObject.get("value").getAsBigDecimal()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), distance.getValue());
        }
        if (jsonObject.has("comparator")) {
            distance.setComparator(this.parseEnumeration(jsonObject.get("comparator").getAsString(), Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (jsonObject.has("_comparator")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comparator"), distance.getComparator());
        }
        if (jsonObject.has("units")) {
            distance.setUnits(this.parseString(jsonObject.get("units").getAsString()));
        }
        if (jsonObject.has("_units")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_units"), distance.getUnits());
        }
        if (jsonObject.has("system")) {
            distance.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), distance.getSystem());
        }
        if (jsonObject.has("code")) {
            distance.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), distance.getCode());
        }
        return distance;
    }

    private Duration parseDuration(JsonObject jsonObject) throws Exception {
        Duration duration = new Duration();
        this.parseElementProperties(jsonObject, duration);
        if (jsonObject.has("value")) {
            duration.setValue(this.parseDecimal(jsonObject.get("value").getAsBigDecimal()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), duration.getValue());
        }
        if (jsonObject.has("comparator")) {
            duration.setComparator(this.parseEnumeration(jsonObject.get("comparator").getAsString(), Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (jsonObject.has("_comparator")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comparator"), duration.getComparator());
        }
        if (jsonObject.has("units")) {
            duration.setUnits(this.parseString(jsonObject.get("units").getAsString()));
        }
        if (jsonObject.has("_units")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_units"), duration.getUnits());
        }
        if (jsonObject.has("system")) {
            duration.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), duration.getSystem());
        }
        if (jsonObject.has("code")) {
            duration.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), duration.getCode());
        }
        return duration;
    }

    private Schedule parseSchedule(JsonObject jsonObject) throws Exception {
        Schedule schedule = new Schedule();
        this.parseElementProperties(jsonObject, schedule);
        if (jsonObject.has("event")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("event");
            for (int i = 0; i < jsonArray.size(); ++i) {
                schedule.getEvent().add(this.parsePeriod(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("repeat")) {
            schedule.setRepeat(this.parseScheduleScheduleRepeatComponent(jsonObject.getAsJsonObject("repeat"), schedule));
        }
        return schedule;
    }

    private Schedule.ScheduleRepeatComponent parseScheduleScheduleRepeatComponent(JsonObject jsonObject, Schedule schedule) throws Exception {
        Schedule.ScheduleRepeatComponent scheduleRepeatComponent = new Schedule.ScheduleRepeatComponent();
        this.parseElementProperties(jsonObject, scheduleRepeatComponent);
        if (jsonObject.has("frequency")) {
            scheduleRepeatComponent.setFrequency(this.parseInteger(jsonObject.get("frequency").getAsLong()));
        }
        if (jsonObject.has("_frequency")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_frequency"), scheduleRepeatComponent.getFrequency());
        }
        if (jsonObject.has("when")) {
            scheduleRepeatComponent.setWhen(this.parseEnumeration(jsonObject.get("when").getAsString(), Schedule.EventTiming.Null, new Schedule.EventTimingEnumFactory()));
        }
        if (jsonObject.has("_when")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_when"), scheduleRepeatComponent.getWhen());
        }
        if (jsonObject.has("duration")) {
            scheduleRepeatComponent.setDuration(this.parseDecimal(jsonObject.get("duration").getAsBigDecimal()));
        }
        if (jsonObject.has("_duration")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_duration"), scheduleRepeatComponent.getDuration());
        }
        if (jsonObject.has("units")) {
            scheduleRepeatComponent.setUnits(this.parseEnumeration(jsonObject.get("units").getAsString(), Schedule.UnitsOfTime.Null, new Schedule.UnitsOfTimeEnumFactory()));
        }
        if (jsonObject.has("_units")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_units"), scheduleRepeatComponent.getUnits());
        }
        if (jsonObject.has("count")) {
            scheduleRepeatComponent.setCount(this.parseInteger(jsonObject.get("count").getAsLong()));
        }
        if (jsonObject.has("_count")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_count"), scheduleRepeatComponent.getCount());
        }
        if (jsonObject.has("end")) {
            scheduleRepeatComponent.setEnd(this.parseDateTime(jsonObject.get("end").getAsString()));
        }
        if (jsonObject.has("_end")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_end"), scheduleRepeatComponent.getEnd());
        }
        return scheduleRepeatComponent;
    }

    private Contact parseContact(JsonObject jsonObject) throws Exception {
        Contact contact = new Contact();
        this.parseElementProperties(jsonObject, contact);
        if (jsonObject.has("system")) {
            contact.setSystem(this.parseEnumeration(jsonObject.get("system").getAsString(), Contact.ContactSystem.Null, new Contact.ContactSystemEnumFactory()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), contact.getSystem());
        }
        if (jsonObject.has("value")) {
            contact.setValue(this.parseString(jsonObject.get("value").getAsString()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), contact.getValue());
        }
        if (jsonObject.has("use")) {
            contact.setUse(this.parseEnumeration(jsonObject.get("use").getAsString(), Contact.ContactUse.Null, new Contact.ContactUseEnumFactory()));
        }
        if (jsonObject.has("_use")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_use"), contact.getUse());
        }
        if (jsonObject.has("period")) {
            contact.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        return contact;
    }

    private Address parseAddress(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Address address = new Address();
        this.parseElementProperties(jsonObject, address);
        if (jsonObject.has("use")) {
            address.setUse(this.parseEnumeration(jsonObject.get("use").getAsString(), Address.AddressUse.Null, new Address.AddressUseEnumFactory()));
        }
        if (jsonObject.has("_use")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_use"), address.getUse());
        }
        if (jsonObject.has("text")) {
            address.setText(this.parseString(jsonObject.get("text").getAsString()));
        }
        if (jsonObject.has("_text")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_text"), address.getText());
        }
        if (jsonObject.has("line")) {
            jsonArray = jsonObject.getAsJsonArray("line");
            for (n = 0; n < jsonArray.size(); ++n) {
                address.getLine().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_line")) {
            jsonArray = jsonObject.getAsJsonArray("_line");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == address.getLine().size()) {
                    address.getLine().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), address.getLine().get(n));
            }
        }
        if (jsonObject.has("city")) {
            address.setCity(this.parseString(jsonObject.get("city").getAsString()));
        }
        if (jsonObject.has("_city")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_city"), address.getCity());
        }
        if (jsonObject.has("state")) {
            address.setState(this.parseString(jsonObject.get("state").getAsString()));
        }
        if (jsonObject.has("_state")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_state"), address.getState());
        }
        if (jsonObject.has("zip")) {
            address.setZip(this.parseString(jsonObject.get("zip").getAsString()));
        }
        if (jsonObject.has("_zip")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_zip"), address.getZip());
        }
        if (jsonObject.has("country")) {
            address.setCountry(this.parseString(jsonObject.get("country").getAsString()));
        }
        if (jsonObject.has("_country")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_country"), address.getCountry());
        }
        if (jsonObject.has("period")) {
            address.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        return address;
    }

    private HumanName parseHumanName(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        HumanName humanName = new HumanName();
        this.parseElementProperties(jsonObject, humanName);
        if (jsonObject.has("use")) {
            humanName.setUse(this.parseEnumeration(jsonObject.get("use").getAsString(), HumanName.NameUse.Null, new HumanName.NameUseEnumFactory()));
        }
        if (jsonObject.has("_use")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_use"), humanName.getUse());
        }
        if (jsonObject.has("text")) {
            humanName.setText(this.parseString(jsonObject.get("text").getAsString()));
        }
        if (jsonObject.has("_text")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_text"), humanName.getText());
        }
        if (jsonObject.has("family")) {
            jsonArray = jsonObject.getAsJsonArray("family");
            for (n = 0; n < jsonArray.size(); ++n) {
                humanName.getFamily().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_family")) {
            jsonArray = jsonObject.getAsJsonArray("_family");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == humanName.getFamily().size()) {
                    humanName.getFamily().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), humanName.getFamily().get(n));
            }
        }
        if (jsonObject.has("given")) {
            jsonArray = jsonObject.getAsJsonArray("given");
            for (n = 0; n < jsonArray.size(); ++n) {
                humanName.getGiven().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_given")) {
            jsonArray = jsonObject.getAsJsonArray("_given");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == humanName.getGiven().size()) {
                    humanName.getGiven().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), humanName.getGiven().get(n));
            }
        }
        if (jsonObject.has("prefix")) {
            jsonArray = jsonObject.getAsJsonArray("prefix");
            for (n = 0; n < jsonArray.size(); ++n) {
                humanName.getPrefix().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_prefix")) {
            jsonArray = jsonObject.getAsJsonArray("_prefix");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == humanName.getPrefix().size()) {
                    humanName.getPrefix().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), humanName.getPrefix().get(n));
            }
        }
        if (jsonObject.has("suffix")) {
            jsonArray = jsonObject.getAsJsonArray("suffix");
            for (n = 0; n < jsonArray.size(); ++n) {
                humanName.getSuffix().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_suffix")) {
            jsonArray = jsonObject.getAsJsonArray("_suffix");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == humanName.getSuffix().size()) {
                    humanName.getSuffix().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), humanName.getSuffix().get(n));
            }
        }
        if (jsonObject.has("period")) {
            humanName.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        return humanName;
    }

    @Override
    protected void parseResourceProperties(JsonObject jsonObject, Resource resource) throws Exception {
        this.parseBackboneProperties(jsonObject, resource);
        if (jsonObject.has("language")) {
            resource.setLanguage(this.parseCode(jsonObject.get("language").getAsString()));
        }
        if (jsonObject.has("_language")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_language"), resource.getLanguage());
        }
        if (jsonObject.has("text")) {
            resource.setText(this.parseNarrative(jsonObject.getAsJsonObject("text")));
        }
        if (jsonObject.has("contained")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("contained");
            for (int i = 0; i < jsonArray.size(); ++i) {
                resource.getContained().add(this.parseResource(jsonArray.get(i).getAsJsonObject()));
            }
        }
    }

    private AdverseReaction parseAdverseReaction(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        AdverseReaction adverseReaction = new AdverseReaction();
        this.parseResourceProperties(jsonObject, adverseReaction);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                adverseReaction.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("date")) {
            adverseReaction.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), adverseReaction.getDate());
        }
        if (jsonObject.has("subject")) {
            adverseReaction.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("didNotOccurFlag")) {
            adverseReaction.setDidNotOccurFlag(this.parseBoolean(jsonObject.get("didNotOccurFlag").getAsBoolean()));
        }
        if (jsonObject.has("_didNotOccurFlag")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_didNotOccurFlag"), adverseReaction.getDidNotOccurFlag());
        }
        if (jsonObject.has("recorder")) {
            adverseReaction.setRecorder(this.parseResourceReference(jsonObject.getAsJsonObject("recorder")));
        }
        if (jsonObject.has("symptom")) {
            jsonArray = jsonObject.getAsJsonArray("symptom");
            for (n = 0; n < jsonArray.size(); ++n) {
                adverseReaction.getSymptom().add(this.parseAdverseReactionAdverseReactionSymptomComponent(jsonArray.get(n).getAsJsonObject(), adverseReaction));
            }
        }
        if (jsonObject.has("exposure")) {
            jsonArray = jsonObject.getAsJsonArray("exposure");
            for (n = 0; n < jsonArray.size(); ++n) {
                adverseReaction.getExposure().add(this.parseAdverseReactionAdverseReactionExposureComponent(jsonArray.get(n).getAsJsonObject(), adverseReaction));
            }
        }
        return adverseReaction;
    }

    private AdverseReaction.AdverseReactionSymptomComponent parseAdverseReactionAdverseReactionSymptomComponent(JsonObject jsonObject, AdverseReaction adverseReaction) throws Exception {
        AdverseReaction.AdverseReactionSymptomComponent adverseReactionSymptomComponent = new AdverseReaction.AdverseReactionSymptomComponent();
        this.parseBackboneProperties(jsonObject, adverseReactionSymptomComponent);
        if (jsonObject.has("code")) {
            adverseReactionSymptomComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("severity")) {
            adverseReactionSymptomComponent.setSeverity(this.parseEnumeration(jsonObject.get("severity").getAsString(), AdverseReaction.ReactionSeverity.Null, new AdverseReaction.ReactionSeverityEnumFactory()));
        }
        if (jsonObject.has("_severity")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_severity"), adverseReactionSymptomComponent.getSeverity());
        }
        return adverseReactionSymptomComponent;
    }

    private AdverseReaction.AdverseReactionExposureComponent parseAdverseReactionAdverseReactionExposureComponent(JsonObject jsonObject, AdverseReaction adverseReaction) throws Exception {
        AdverseReaction.AdverseReactionExposureComponent adverseReactionExposureComponent = new AdverseReaction.AdverseReactionExposureComponent();
        this.parseBackboneProperties(jsonObject, adverseReactionExposureComponent);
        if (jsonObject.has("date")) {
            adverseReactionExposureComponent.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), adverseReactionExposureComponent.getDate());
        }
        if (jsonObject.has("type")) {
            adverseReactionExposureComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), AdverseReaction.ExposureType.Null, new AdverseReaction.ExposureTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), adverseReactionExposureComponent.getType());
        }
        if (jsonObject.has("causalityExpectation")) {
            adverseReactionExposureComponent.setCausalityExpectation(this.parseEnumeration(jsonObject.get("causalityExpectation").getAsString(), AdverseReaction.CausalityExpectation.Null, new AdverseReaction.CausalityExpectationEnumFactory()));
        }
        if (jsonObject.has("_causalityExpectation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_causalityExpectation"), adverseReactionExposureComponent.getCausalityExpectation());
        }
        if (jsonObject.has("substance")) {
            adverseReactionExposureComponent.setSubstance(this.parseResourceReference(jsonObject.getAsJsonObject("substance")));
        }
        return adverseReactionExposureComponent;
    }

    private Alert parseAlert(JsonObject jsonObject) throws Exception {
        Alert alert = new Alert();
        this.parseResourceProperties(jsonObject, alert);
        if (jsonObject.has("identifier")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < jsonArray.size(); ++i) {
                alert.getIdentifier().add(this.parseIdentifier(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("category")) {
            alert.setCategory(this.parseCodeableConcept(jsonObject.getAsJsonObject("category")));
        }
        if (jsonObject.has("status")) {
            alert.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Alert.AlertStatus.Null, new Alert.AlertStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), alert.getStatus());
        }
        if (jsonObject.has("subject")) {
            alert.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("author")) {
            alert.setAuthor(this.parseResourceReference(jsonObject.getAsJsonObject("author")));
        }
        if (jsonObject.has("note")) {
            alert.setNote(this.parseString(jsonObject.get("note").getAsString()));
        }
        if (jsonObject.has("_note")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_note"), alert.getNote());
        }
        return alert;
    }

    private AllergyIntolerance parseAllergyIntolerance(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        AllergyIntolerance allergyIntolerance = new AllergyIntolerance();
        this.parseResourceProperties(jsonObject, allergyIntolerance);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                allergyIntolerance.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("criticality")) {
            allergyIntolerance.setCriticality(this.parseEnumeration(jsonObject.get("criticality").getAsString(), AllergyIntolerance.Criticality.Null, new AllergyIntolerance.CriticalityEnumFactory()));
        }
        if (jsonObject.has("_criticality")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_criticality"), allergyIntolerance.getCriticality());
        }
        if (jsonObject.has("sensitivityType")) {
            allergyIntolerance.setSensitivityType(this.parseEnumeration(jsonObject.get("sensitivityType").getAsString(), AllergyIntolerance.Sensitivitytype.Null, new AllergyIntolerance.SensitivitytypeEnumFactory()));
        }
        if (jsonObject.has("_sensitivityType")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_sensitivityType"), allergyIntolerance.getSensitivityType());
        }
        if (jsonObject.has("recordedDate")) {
            allergyIntolerance.setRecordedDate(this.parseDateTime(jsonObject.get("recordedDate").getAsString()));
        }
        if (jsonObject.has("_recordedDate")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_recordedDate"), allergyIntolerance.getRecordedDate());
        }
        if (jsonObject.has("status")) {
            allergyIntolerance.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), AllergyIntolerance.Sensitivitystatus.Null, new AllergyIntolerance.SensitivitystatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), allergyIntolerance.getStatus());
        }
        if (jsonObject.has("subject")) {
            allergyIntolerance.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("recorder")) {
            allergyIntolerance.setRecorder(this.parseResourceReference(jsonObject.getAsJsonObject("recorder")));
        }
        if (jsonObject.has("substance")) {
            allergyIntolerance.setSubstance(this.parseResourceReference(jsonObject.getAsJsonObject("substance")));
        }
        if (jsonObject.has("reaction")) {
            jsonArray = jsonObject.getAsJsonArray("reaction");
            for (n = 0; n < jsonArray.size(); ++n) {
                allergyIntolerance.getReaction().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("sensitivityTest")) {
            jsonArray = jsonObject.getAsJsonArray("sensitivityTest");
            for (n = 0; n < jsonArray.size(); ++n) {
                allergyIntolerance.getSensitivityTest().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return allergyIntolerance;
    }

    private CarePlan parseCarePlan(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        CarePlan carePlan = new CarePlan();
        this.parseResourceProperties(jsonObject, carePlan);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                carePlan.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("patient")) {
            carePlan.setPatient(this.parseResourceReference(jsonObject.getAsJsonObject("patient")));
        }
        if (jsonObject.has("status")) {
            carePlan.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), CarePlan.CarePlanStatus.Null, new CarePlan.CarePlanStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), carePlan.getStatus());
        }
        if (jsonObject.has("period")) {
            carePlan.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("modified")) {
            carePlan.setModified(this.parseDateTime(jsonObject.get("modified").getAsString()));
        }
        if (jsonObject.has("_modified")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_modified"), carePlan.getModified());
        }
        if (jsonObject.has("concern")) {
            jsonArray = jsonObject.getAsJsonArray("concern");
            for (n = 0; n < jsonArray.size(); ++n) {
                carePlan.getConcern().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("participant")) {
            jsonArray = jsonObject.getAsJsonArray("participant");
            for (n = 0; n < jsonArray.size(); ++n) {
                carePlan.getParticipant().add(this.parseCarePlanCarePlanParticipantComponent(jsonArray.get(n).getAsJsonObject(), carePlan));
            }
        }
        if (jsonObject.has("goal")) {
            jsonArray = jsonObject.getAsJsonArray("goal");
            for (n = 0; n < jsonArray.size(); ++n) {
                carePlan.getGoal().add(this.parseCarePlanCarePlanGoalComponent(jsonArray.get(n).getAsJsonObject(), carePlan));
            }
        }
        if (jsonObject.has("activity")) {
            jsonArray = jsonObject.getAsJsonArray("activity");
            for (n = 0; n < jsonArray.size(); ++n) {
                carePlan.getActivity().add(this.parseCarePlanCarePlanActivityComponent(jsonArray.get(n).getAsJsonObject(), carePlan));
            }
        }
        if (jsonObject.has("notes")) {
            carePlan.setNotes(this.parseString(jsonObject.get("notes").getAsString()));
        }
        if (jsonObject.has("_notes")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_notes"), carePlan.getNotes());
        }
        return carePlan;
    }

    private CarePlan.CarePlanParticipantComponent parseCarePlanCarePlanParticipantComponent(JsonObject jsonObject, CarePlan carePlan) throws Exception {
        CarePlan.CarePlanParticipantComponent carePlanParticipantComponent = new CarePlan.CarePlanParticipantComponent();
        this.parseBackboneProperties(jsonObject, carePlanParticipantComponent);
        if (jsonObject.has("role")) {
            carePlanParticipantComponent.setRole(this.parseCodeableConcept(jsonObject.getAsJsonObject("role")));
        }
        if (jsonObject.has("member")) {
            carePlanParticipantComponent.setMember(this.parseResourceReference(jsonObject.getAsJsonObject("member")));
        }
        return carePlanParticipantComponent;
    }

    private CarePlan.CarePlanGoalComponent parseCarePlanCarePlanGoalComponent(JsonObject jsonObject, CarePlan carePlan) throws Exception {
        CarePlan.CarePlanGoalComponent carePlanGoalComponent = new CarePlan.CarePlanGoalComponent();
        this.parseBackboneProperties(jsonObject, carePlanGoalComponent);
        if (jsonObject.has("description")) {
            carePlanGoalComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), carePlanGoalComponent.getDescription());
        }
        if (jsonObject.has("status")) {
            carePlanGoalComponent.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), CarePlan.CarePlanGoalStatus.Null, new CarePlan.CarePlanGoalStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), carePlanGoalComponent.getStatus());
        }
        if (jsonObject.has("notes")) {
            carePlanGoalComponent.setNotes(this.parseString(jsonObject.get("notes").getAsString()));
        }
        if (jsonObject.has("_notes")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_notes"), carePlanGoalComponent.getNotes());
        }
        if (jsonObject.has("concern")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("concern");
            for (int i = 0; i < jsonArray.size(); ++i) {
                carePlanGoalComponent.getConcern().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return carePlanGoalComponent;
    }

    private CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(JsonObject jsonObject, CarePlan carePlan) throws Exception {
        int n;
        JsonArray jsonArray;
        CarePlan.CarePlanActivityComponent carePlanActivityComponent = new CarePlan.CarePlanActivityComponent();
        this.parseBackboneProperties(jsonObject, carePlanActivityComponent);
        if (jsonObject.has("goal")) {
            jsonArray = jsonObject.getAsJsonArray("goal");
            for (n = 0; n < jsonArray.size(); ++n) {
                carePlanActivityComponent.getGoal().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_goal")) {
            jsonArray = jsonObject.getAsJsonArray("_goal");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == carePlanActivityComponent.getGoal().size()) {
                    carePlanActivityComponent.getGoal().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), carePlanActivityComponent.getGoal().get(n));
            }
        }
        if (jsonObject.has("status")) {
            carePlanActivityComponent.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), CarePlan.CarePlanActivityStatus.Null, new CarePlan.CarePlanActivityStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), carePlanActivityComponent.getStatus());
        }
        if (jsonObject.has("prohibited")) {
            carePlanActivityComponent.setProhibited(this.parseBoolean(jsonObject.get("prohibited").getAsBoolean()));
        }
        if (jsonObject.has("_prohibited")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_prohibited"), carePlanActivityComponent.getProhibited());
        }
        if (jsonObject.has("actionResulting")) {
            jsonArray = jsonObject.getAsJsonArray("actionResulting");
            for (n = 0; n < jsonArray.size(); ++n) {
                carePlanActivityComponent.getActionResulting().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("notes")) {
            carePlanActivityComponent.setNotes(this.parseString(jsonObject.get("notes").getAsString()));
        }
        if (jsonObject.has("_notes")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_notes"), carePlanActivityComponent.getNotes());
        }
        if (jsonObject.has("detail")) {
            carePlanActivityComponent.setDetail(this.parseResourceReference(jsonObject.getAsJsonObject("detail")));
        }
        if (jsonObject.has("simple")) {
            carePlanActivityComponent.setSimple(this.parseCarePlanCarePlanActivitySimpleComponent(jsonObject.getAsJsonObject("simple"), carePlan));
        }
        return carePlanActivityComponent;
    }

    private CarePlan.CarePlanActivitySimpleComponent parseCarePlanCarePlanActivitySimpleComponent(JsonObject jsonObject, CarePlan carePlan) throws Exception {
        Type type;
        CarePlan.CarePlanActivitySimpleComponent carePlanActivitySimpleComponent = new CarePlan.CarePlanActivitySimpleComponent();
        this.parseBackboneProperties(jsonObject, carePlanActivitySimpleComponent);
        if (jsonObject.has("category")) {
            carePlanActivitySimpleComponent.setCategory(this.parseEnumeration(jsonObject.get("category").getAsString(), CarePlan.CarePlanActivityCategory.Null, new CarePlan.CarePlanActivityCategoryEnumFactory()));
        }
        if (jsonObject.has("_category")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_category"), carePlanActivitySimpleComponent.getCategory());
        }
        if (jsonObject.has("code")) {
            carePlanActivitySimpleComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if ((type = this.parseType("timing", jsonObject)) != null) {
            carePlanActivitySimpleComponent.setTiming(type);
        }
        if (jsonObject.has("location")) {
            carePlanActivitySimpleComponent.setLocation(this.parseResourceReference(jsonObject.getAsJsonObject("location")));
        }
        if (jsonObject.has("performer")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("performer");
            for (int i = 0; i < jsonArray.size(); ++i) {
                carePlanActivitySimpleComponent.getPerformer().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("product")) {
            carePlanActivitySimpleComponent.setProduct(this.parseResourceReference(jsonObject.getAsJsonObject("product")));
        }
        if (jsonObject.has("dailyAmount")) {
            carePlanActivitySimpleComponent.setDailyAmount(this.parseQuantity(jsonObject.getAsJsonObject("dailyAmount")));
        }
        if (jsonObject.has("quantity")) {
            carePlanActivitySimpleComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("details")) {
            carePlanActivitySimpleComponent.setDetails(this.parseString(jsonObject.get("details").getAsString()));
        }
        if (jsonObject.has("_details")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_details"), carePlanActivitySimpleComponent.getDetails());
        }
        return carePlanActivitySimpleComponent;
    }

    private Composition parseComposition(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Composition composition = new Composition();
        this.parseResourceProperties(jsonObject, composition);
        if (jsonObject.has("identifier")) {
            composition.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("date")) {
            composition.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), composition.getDate());
        }
        if (jsonObject.has("type")) {
            composition.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("class")) {
            composition.setClass_(this.parseCodeableConcept(jsonObject.getAsJsonObject("class")));
        }
        if (jsonObject.has("title")) {
            composition.setTitle(this.parseString(jsonObject.get("title").getAsString()));
        }
        if (jsonObject.has("_title")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_title"), composition.getTitle());
        }
        if (jsonObject.has("status")) {
            composition.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Composition.CompositionStatus.Null, new Composition.CompositionStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), composition.getStatus());
        }
        if (jsonObject.has("confidentiality")) {
            composition.setConfidentiality(this.parseCoding(jsonObject.getAsJsonObject("confidentiality")));
        }
        if (jsonObject.has("subject")) {
            composition.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("author")) {
            jsonArray = jsonObject.getAsJsonArray("author");
            for (n = 0; n < jsonArray.size(); ++n) {
                composition.getAuthor().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("attester")) {
            jsonArray = jsonObject.getAsJsonArray("attester");
            for (n = 0; n < jsonArray.size(); ++n) {
                composition.getAttester().add(this.parseCompositionCompositionAttesterComponent(jsonArray.get(n).getAsJsonObject(), composition));
            }
        }
        if (jsonObject.has("custodian")) {
            composition.setCustodian(this.parseResourceReference(jsonObject.getAsJsonObject("custodian")));
        }
        if (jsonObject.has("event")) {
            composition.setEvent(this.parseCompositionCompositionEventComponent(jsonObject.getAsJsonObject("event"), composition));
        }
        if (jsonObject.has("encounter")) {
            composition.setEncounter(this.parseResourceReference(jsonObject.getAsJsonObject("encounter")));
        }
        if (jsonObject.has("section")) {
            jsonArray = jsonObject.getAsJsonArray("section");
            for (n = 0; n < jsonArray.size(); ++n) {
                composition.getSection().add(this.parseCompositionSectionComponent(jsonArray.get(n).getAsJsonObject(), composition));
            }
        }
        return composition;
    }

    private Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(JsonObject jsonObject, Composition composition) throws Exception {
        int n;
        JsonArray jsonArray;
        Composition.CompositionAttesterComponent compositionAttesterComponent = new Composition.CompositionAttesterComponent();
        this.parseBackboneProperties(jsonObject, compositionAttesterComponent);
        if (jsonObject.has("mode")) {
            jsonArray = jsonObject.getAsJsonArray("mode");
            for (n = 0; n < jsonArray.size(); ++n) {
                compositionAttesterComponent.getMode().add(this.parseEnumeration(jsonArray.get(n).getAsString(), Composition.CompositionAttestationMode.Null, new Composition.CompositionAttestationModeEnumFactory()));
            }
        }
        if (jsonObject.has("_mode")) {
            jsonArray = jsonObject.getAsJsonArray("_mode");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == compositionAttesterComponent.getMode().size()) {
                    compositionAttesterComponent.getMode().add(this.parseEnumeration(null, Composition.CompositionAttestationMode.Null, new Composition.CompositionAttestationModeEnumFactory()));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), compositionAttesterComponent.getMode().get(n));
            }
        }
        if (jsonObject.has("time")) {
            compositionAttesterComponent.setTime(this.parseDateTime(jsonObject.get("time").getAsString()));
        }
        if (jsonObject.has("_time")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_time"), compositionAttesterComponent.getTime());
        }
        if (jsonObject.has("party")) {
            compositionAttesterComponent.setParty(this.parseResourceReference(jsonObject.getAsJsonObject("party")));
        }
        return compositionAttesterComponent;
    }

    private Composition.CompositionEventComponent parseCompositionCompositionEventComponent(JsonObject jsonObject, Composition composition) throws Exception {
        int n;
        JsonArray jsonArray;
        Composition.CompositionEventComponent compositionEventComponent = new Composition.CompositionEventComponent();
        this.parseBackboneProperties(jsonObject, compositionEventComponent);
        if (jsonObject.has("code")) {
            jsonArray = jsonObject.getAsJsonArray("code");
            for (n = 0; n < jsonArray.size(); ++n) {
                compositionEventComponent.getCode().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("period")) {
            compositionEventComponent.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("detail")) {
            jsonArray = jsonObject.getAsJsonArray("detail");
            for (n = 0; n < jsonArray.size(); ++n) {
                compositionEventComponent.getDetail().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return compositionEventComponent;
    }

    private Composition.SectionComponent parseCompositionSectionComponent(JsonObject jsonObject, Composition composition) throws Exception {
        Composition.SectionComponent sectionComponent = new Composition.SectionComponent();
        this.parseBackboneProperties(jsonObject, sectionComponent);
        if (jsonObject.has("title")) {
            sectionComponent.setTitle(this.parseString(jsonObject.get("title").getAsString()));
        }
        if (jsonObject.has("_title")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_title"), sectionComponent.getTitle());
        }
        if (jsonObject.has("code")) {
            sectionComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("subject")) {
            sectionComponent.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("content")) {
            sectionComponent.setContent(this.parseResourceReference(jsonObject.getAsJsonObject("content")));
        }
        if (jsonObject.has("section")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("section");
            for (int i = 0; i < jsonArray.size(); ++i) {
                sectionComponent.getSection().add(this.parseCompositionSectionComponent(jsonArray.get(i).getAsJsonObject(), composition));
            }
        }
        return sectionComponent;
    }

    private ConceptMap parseConceptMap(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        ConceptMap conceptMap = new ConceptMap();
        this.parseResourceProperties(jsonObject, conceptMap);
        if (jsonObject.has("identifier")) {
            conceptMap.setIdentifier(this.parseString(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), conceptMap.getIdentifier());
        }
        if (jsonObject.has("version")) {
            conceptMap.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), conceptMap.getVersion());
        }
        if (jsonObject.has("name")) {
            conceptMap.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), conceptMap.getName());
        }
        if (jsonObject.has("publisher")) {
            conceptMap.setPublisher(this.parseString(jsonObject.get("publisher").getAsString()));
        }
        if (jsonObject.has("_publisher")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_publisher"), conceptMap.getPublisher());
        }
        if (jsonObject.has("telecom")) {
            jsonArray = jsonObject.getAsJsonArray("telecom");
            for (n = 0; n < jsonArray.size(); ++n) {
                conceptMap.getTelecom().add(this.parseContact(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("description")) {
            conceptMap.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), conceptMap.getDescription());
        }
        if (jsonObject.has("copyright")) {
            conceptMap.setCopyright(this.parseString(jsonObject.get("copyright").getAsString()));
        }
        if (jsonObject.has("_copyright")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_copyright"), conceptMap.getCopyright());
        }
        if (jsonObject.has("status")) {
            conceptMap.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), ConceptMap.ValuesetStatus.Null, new ConceptMap.ValuesetStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), conceptMap.getStatus());
        }
        if (jsonObject.has("experimental")) {
            conceptMap.setExperimental(this.parseBoolean(jsonObject.get("experimental").getAsBoolean()));
        }
        if (jsonObject.has("_experimental")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_experimental"), conceptMap.getExperimental());
        }
        if (jsonObject.has("date")) {
            conceptMap.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), conceptMap.getDate());
        }
        if (jsonObject.has("source")) {
            conceptMap.setSource(this.parseResourceReference(jsonObject.getAsJsonObject("source")));
        }
        if (jsonObject.has("target")) {
            conceptMap.setTarget(this.parseResourceReference(jsonObject.getAsJsonObject("target")));
        }
        if (jsonObject.has("concept")) {
            jsonArray = jsonObject.getAsJsonArray("concept");
            for (n = 0; n < jsonArray.size(); ++n) {
                conceptMap.getConcept().add(this.parseConceptMapConceptMapConceptComponent(jsonArray.get(n).getAsJsonObject(), conceptMap));
            }
        }
        return conceptMap;
    }

    private ConceptMap.ConceptMapConceptComponent parseConceptMapConceptMapConceptComponent(JsonObject jsonObject, ConceptMap conceptMap) throws Exception {
        int n;
        JsonArray jsonArray;
        ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent = new ConceptMap.ConceptMapConceptComponent();
        this.parseBackboneProperties(jsonObject, conceptMapConceptComponent);
        if (jsonObject.has("system")) {
            conceptMapConceptComponent.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), conceptMapConceptComponent.getSystem());
        }
        if (jsonObject.has("code")) {
            conceptMapConceptComponent.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), conceptMapConceptComponent.getCode());
        }
        if (jsonObject.has("dependsOn")) {
            jsonArray = jsonObject.getAsJsonArray("dependsOn");
            for (n = 0; n < jsonArray.size(); ++n) {
                conceptMapConceptComponent.getDependsOn().add(this.parseConceptMapOtherConceptComponent(jsonArray.get(n).getAsJsonObject(), conceptMap));
            }
        }
        if (jsonObject.has("map")) {
            jsonArray = jsonObject.getAsJsonArray("map");
            for (n = 0; n < jsonArray.size(); ++n) {
                conceptMapConceptComponent.getMap().add(this.parseConceptMapConceptMapConceptMapComponent(jsonArray.get(n).getAsJsonObject(), conceptMap));
            }
        }
        return conceptMapConceptComponent;
    }

    private ConceptMap.OtherConceptComponent parseConceptMapOtherConceptComponent(JsonObject jsonObject, ConceptMap conceptMap) throws Exception {
        ConceptMap.OtherConceptComponent otherConceptComponent = new ConceptMap.OtherConceptComponent();
        this.parseBackboneProperties(jsonObject, otherConceptComponent);
        if (jsonObject.has("concept")) {
            otherConceptComponent.setConcept(this.parseUri(jsonObject.get("concept").getAsString()));
        }
        if (jsonObject.has("_concept")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_concept"), otherConceptComponent.getConcept());
        }
        if (jsonObject.has("system")) {
            otherConceptComponent.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), otherConceptComponent.getSystem());
        }
        if (jsonObject.has("code")) {
            otherConceptComponent.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), otherConceptComponent.getCode());
        }
        return otherConceptComponent;
    }

    private ConceptMap.ConceptMapConceptMapComponent parseConceptMapConceptMapConceptMapComponent(JsonObject jsonObject, ConceptMap conceptMap) throws Exception {
        ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent = new ConceptMap.ConceptMapConceptMapComponent();
        this.parseBackboneProperties(jsonObject, conceptMapConceptMapComponent);
        if (jsonObject.has("system")) {
            conceptMapConceptMapComponent.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), conceptMapConceptMapComponent.getSystem());
        }
        if (jsonObject.has("code")) {
            conceptMapConceptMapComponent.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), conceptMapConceptMapComponent.getCode());
        }
        if (jsonObject.has("equivalence")) {
            conceptMapConceptMapComponent.setEquivalence(this.parseEnumeration(jsonObject.get("equivalence").getAsString(), ConceptMap.ConceptEquivalence.Null, new ConceptMap.ConceptEquivalenceEnumFactory()));
        }
        if (jsonObject.has("_equivalence")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_equivalence"), conceptMapConceptMapComponent.getEquivalence());
        }
        if (jsonObject.has("comments")) {
            conceptMapConceptMapComponent.setComments(this.parseString(jsonObject.get("comments").getAsString()));
        }
        if (jsonObject.has("_comments")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comments"), conceptMapConceptMapComponent.getComments());
        }
        if (jsonObject.has("product")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("product");
            for (int i = 0; i < jsonArray.size(); ++i) {
                conceptMapConceptMapComponent.getProduct().add(this.parseConceptMapOtherConceptComponent(jsonArray.get(i).getAsJsonObject(), conceptMap));
            }
        }
        return conceptMapConceptMapComponent;
    }

    private Condition parseCondition(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Type type;
        Object object;
        Condition condition = new Condition();
        this.parseResourceProperties(jsonObject, condition);
        if (jsonObject.has("identifier")) {
            object = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < object.size(); ++i) {
                condition.getIdentifier().add(this.parseIdentifier(object.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("subject")) {
            condition.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("encounter")) {
            condition.setEncounter(this.parseResourceReference(jsonObject.getAsJsonObject("encounter")));
        }
        if (jsonObject.has("asserter")) {
            condition.setAsserter(this.parseResourceReference(jsonObject.getAsJsonObject("asserter")));
        }
        if (jsonObject.has("dateAsserted")) {
            condition.setDateAsserted(this.parseDate(jsonObject.get("dateAsserted").getAsString()));
        }
        if (jsonObject.has("_dateAsserted")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_dateAsserted"), condition.getDateAsserted());
        }
        if (jsonObject.has("code")) {
            condition.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("category")) {
            condition.setCategory(this.parseCodeableConcept(jsonObject.getAsJsonObject("category")));
        }
        if (jsonObject.has("status")) {
            condition.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Condition.ConditionStatus.Null, new Condition.ConditionStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), condition.getStatus());
        }
        if (jsonObject.has("certainty")) {
            condition.setCertainty(this.parseCodeableConcept(jsonObject.getAsJsonObject("certainty")));
        }
        if (jsonObject.has("severity")) {
            condition.setSeverity(this.parseCodeableConcept(jsonObject.getAsJsonObject("severity")));
        }
        if ((object = this.parseType("onset", jsonObject)) != null) {
            condition.setOnset((Type)object);
        }
        if ((type = this.parseType("abatement", jsonObject)) != null) {
            condition.setAbatement(type);
        }
        if (jsonObject.has("stage")) {
            condition.setStage(this.parseConditionConditionStageComponent(jsonObject.getAsJsonObject("stage"), condition));
        }
        if (jsonObject.has("evidence")) {
            jsonArray = jsonObject.getAsJsonArray("evidence");
            for (n = 0; n < jsonArray.size(); ++n) {
                condition.getEvidence().add(this.parseConditionConditionEvidenceComponent(jsonArray.get(n).getAsJsonObject(), condition));
            }
        }
        if (jsonObject.has("location")) {
            jsonArray = jsonObject.getAsJsonArray("location");
            for (n = 0; n < jsonArray.size(); ++n) {
                condition.getLocation().add(this.parseConditionConditionLocationComponent(jsonArray.get(n).getAsJsonObject(), condition));
            }
        }
        if (jsonObject.has("relatedItem")) {
            jsonArray = jsonObject.getAsJsonArray("relatedItem");
            for (n = 0; n < jsonArray.size(); ++n) {
                condition.getRelatedItem().add(this.parseConditionConditionRelatedItemComponent(jsonArray.get(n).getAsJsonObject(), condition));
            }
        }
        if (jsonObject.has("notes")) {
            condition.setNotes(this.parseString(jsonObject.get("notes").getAsString()));
        }
        if (jsonObject.has("_notes")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_notes"), condition.getNotes());
        }
        return condition;
    }

    private Condition.ConditionStageComponent parseConditionConditionStageComponent(JsonObject jsonObject, Condition condition) throws Exception {
        Condition.ConditionStageComponent conditionStageComponent = new Condition.ConditionStageComponent();
        this.parseBackboneProperties(jsonObject, conditionStageComponent);
        if (jsonObject.has("summary")) {
            conditionStageComponent.setSummary(this.parseCodeableConcept(jsonObject.getAsJsonObject("summary")));
        }
        if (jsonObject.has("assessment")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("assessment");
            for (int i = 0; i < jsonArray.size(); ++i) {
                conditionStageComponent.getAssessment().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return conditionStageComponent;
    }

    private Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(JsonObject jsonObject, Condition condition) throws Exception {
        Condition.ConditionEvidenceComponent conditionEvidenceComponent = new Condition.ConditionEvidenceComponent();
        this.parseBackboneProperties(jsonObject, conditionEvidenceComponent);
        if (jsonObject.has("code")) {
            conditionEvidenceComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("detail")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("detail");
            for (int i = 0; i < jsonArray.size(); ++i) {
                conditionEvidenceComponent.getDetail().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return conditionEvidenceComponent;
    }

    private Condition.ConditionLocationComponent parseConditionConditionLocationComponent(JsonObject jsonObject, Condition condition) throws Exception {
        Condition.ConditionLocationComponent conditionLocationComponent = new Condition.ConditionLocationComponent();
        this.parseBackboneProperties(jsonObject, conditionLocationComponent);
        if (jsonObject.has("code")) {
            conditionLocationComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("detail")) {
            conditionLocationComponent.setDetail(this.parseString(jsonObject.get("detail").getAsString()));
        }
        if (jsonObject.has("_detail")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_detail"), conditionLocationComponent.getDetail());
        }
        return conditionLocationComponent;
    }

    private Condition.ConditionRelatedItemComponent parseConditionConditionRelatedItemComponent(JsonObject jsonObject, Condition condition) throws Exception {
        Condition.ConditionRelatedItemComponent conditionRelatedItemComponent = new Condition.ConditionRelatedItemComponent();
        this.parseBackboneProperties(jsonObject, conditionRelatedItemComponent);
        if (jsonObject.has("type")) {
            conditionRelatedItemComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), Condition.ConditionRelationshipType.Null, new Condition.ConditionRelationshipTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), conditionRelatedItemComponent.getType());
        }
        if (jsonObject.has("code")) {
            conditionRelatedItemComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("target")) {
            conditionRelatedItemComponent.setTarget(this.parseResourceReference(jsonObject.getAsJsonObject("target")));
        }
        return conditionRelatedItemComponent;
    }

    private Conformance parseConformance(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Conformance conformance = new Conformance();
        this.parseResourceProperties(jsonObject, conformance);
        if (jsonObject.has("identifier")) {
            conformance.setIdentifier(this.parseString(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), conformance.getIdentifier());
        }
        if (jsonObject.has("version")) {
            conformance.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), conformance.getVersion());
        }
        if (jsonObject.has("name")) {
            conformance.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), conformance.getName());
        }
        if (jsonObject.has("publisher")) {
            conformance.setPublisher(this.parseString(jsonObject.get("publisher").getAsString()));
        }
        if (jsonObject.has("_publisher")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_publisher"), conformance.getPublisher());
        }
        if (jsonObject.has("telecom")) {
            jsonArray = jsonObject.getAsJsonArray("telecom");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformance.getTelecom().add(this.parseContact(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("description")) {
            conformance.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), conformance.getDescription());
        }
        if (jsonObject.has("status")) {
            conformance.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Conformance.ConformanceStatementStatus.Null, new Conformance.ConformanceStatementStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), conformance.getStatus());
        }
        if (jsonObject.has("experimental")) {
            conformance.setExperimental(this.parseBoolean(jsonObject.get("experimental").getAsBoolean()));
        }
        if (jsonObject.has("_experimental")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_experimental"), conformance.getExperimental());
        }
        if (jsonObject.has("date")) {
            conformance.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), conformance.getDate());
        }
        if (jsonObject.has("software")) {
            conformance.setSoftware(this.parseConformanceConformanceSoftwareComponent(jsonObject.getAsJsonObject("software"), conformance));
        }
        if (jsonObject.has("implementation")) {
            conformance.setImplementation(this.parseConformanceConformanceImplementationComponent(jsonObject.getAsJsonObject("implementation"), conformance));
        }
        if (jsonObject.has("fhirVersion")) {
            conformance.setFhirVersion(this.parseId(jsonObject.get("fhirVersion").getAsString()));
        }
        if (jsonObject.has("_fhirVersion")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_fhirVersion"), conformance.getFhirVersion());
        }
        if (jsonObject.has("acceptUnknown")) {
            conformance.setAcceptUnknown(this.parseBoolean(jsonObject.get("acceptUnknown").getAsBoolean()));
        }
        if (jsonObject.has("_acceptUnknown")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_acceptUnknown"), conformance.getAcceptUnknown());
        }
        if (jsonObject.has("format")) {
            jsonArray = jsonObject.getAsJsonArray("format");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformance.getFormat().add(this.parseCode(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_format")) {
            jsonArray = jsonObject.getAsJsonArray("_format");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == conformance.getFormat().size()) {
                    conformance.getFormat().add(this.parseCode(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), conformance.getFormat().get(n));
            }
        }
        if (jsonObject.has("profile")) {
            jsonArray = jsonObject.getAsJsonArray("profile");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformance.getProfile().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("rest")) {
            jsonArray = jsonObject.getAsJsonArray("rest");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformance.getRest().add(this.parseConformanceConformanceRestComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        if (jsonObject.has("messaging")) {
            jsonArray = jsonObject.getAsJsonArray("messaging");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformance.getMessaging().add(this.parseConformanceConformanceMessagingComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        if (jsonObject.has("document")) {
            jsonArray = jsonObject.getAsJsonArray("document");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformance.getDocument().add(this.parseConformanceConformanceDocumentComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        return conformance;
    }

    private Conformance.ConformanceSoftwareComponent parseConformanceConformanceSoftwareComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceSoftwareComponent conformanceSoftwareComponent = new Conformance.ConformanceSoftwareComponent();
        this.parseBackboneProperties(jsonObject, conformanceSoftwareComponent);
        if (jsonObject.has("name")) {
            conformanceSoftwareComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), conformanceSoftwareComponent.getName());
        }
        if (jsonObject.has("version")) {
            conformanceSoftwareComponent.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), conformanceSoftwareComponent.getVersion());
        }
        if (jsonObject.has("releaseDate")) {
            conformanceSoftwareComponent.setReleaseDate(this.parseDateTime(jsonObject.get("releaseDate").getAsString()));
        }
        if (jsonObject.has("_releaseDate")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_releaseDate"), conformanceSoftwareComponent.getReleaseDate());
        }
        return conformanceSoftwareComponent;
    }

    private Conformance.ConformanceImplementationComponent parseConformanceConformanceImplementationComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceImplementationComponent conformanceImplementationComponent = new Conformance.ConformanceImplementationComponent();
        this.parseBackboneProperties(jsonObject, conformanceImplementationComponent);
        if (jsonObject.has("description")) {
            conformanceImplementationComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), conformanceImplementationComponent.getDescription());
        }
        if (jsonObject.has("url")) {
            conformanceImplementationComponent.setUrl(this.parseUri(jsonObject.get("url").getAsString()));
        }
        if (jsonObject.has("_url")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_url"), conformanceImplementationComponent.getUrl());
        }
        return conformanceImplementationComponent;
    }

    private Conformance.ConformanceRestComponent parseConformanceConformanceRestComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        int n;
        JsonArray jsonArray;
        Conformance.ConformanceRestComponent conformanceRestComponent = new Conformance.ConformanceRestComponent();
        this.parseBackboneProperties(jsonObject, conformanceRestComponent);
        if (jsonObject.has("mode")) {
            conformanceRestComponent.setMode(this.parseEnumeration(jsonObject.get("mode").getAsString(), Conformance.RestfulConformanceMode.Null, new Conformance.RestfulConformanceModeEnumFactory()));
        }
        if (jsonObject.has("_mode")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_mode"), conformanceRestComponent.getMode());
        }
        if (jsonObject.has("documentation")) {
            conformanceRestComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), conformanceRestComponent.getDocumentation());
        }
        if (jsonObject.has("security")) {
            conformanceRestComponent.setSecurity(this.parseConformanceConformanceRestSecurityComponent(jsonObject.getAsJsonObject("security"), conformance));
        }
        if (jsonObject.has("resource")) {
            jsonArray = jsonObject.getAsJsonArray("resource");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestComponent.getResource().add(this.parseConformanceConformanceRestResourceComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        if (jsonObject.has("operation")) {
            jsonArray = jsonObject.getAsJsonArray("operation");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestComponent.getOperation().add(this.parseConformanceConformanceRestOperationComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        if (jsonObject.has("query")) {
            jsonArray = jsonObject.getAsJsonArray("query");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestComponent.getQuery().add(this.parseConformanceConformanceRestQueryComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        if (jsonObject.has("documentMailbox")) {
            jsonArray = jsonObject.getAsJsonArray("documentMailbox");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestComponent.getDocumentMailbox().add(this.parseUri(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_documentMailbox")) {
            jsonArray = jsonObject.getAsJsonArray("_documentMailbox");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == conformanceRestComponent.getDocumentMailbox().size()) {
                    conformanceRestComponent.getDocumentMailbox().add(this.parseUri(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), conformanceRestComponent.getDocumentMailbox().get(n));
            }
        }
        return conformanceRestComponent;
    }

    private Conformance.ConformanceRestSecurityComponent parseConformanceConformanceRestSecurityComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        int n;
        JsonArray jsonArray;
        Conformance.ConformanceRestSecurityComponent conformanceRestSecurityComponent = new Conformance.ConformanceRestSecurityComponent();
        this.parseBackboneProperties(jsonObject, conformanceRestSecurityComponent);
        if (jsonObject.has("cors")) {
            conformanceRestSecurityComponent.setCors(this.parseBoolean(jsonObject.get("cors").getAsBoolean()));
        }
        if (jsonObject.has("_cors")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_cors"), conformanceRestSecurityComponent.getCors());
        }
        if (jsonObject.has("service")) {
            jsonArray = jsonObject.getAsJsonArray("service");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestSecurityComponent.getService().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("description")) {
            conformanceRestSecurityComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), conformanceRestSecurityComponent.getDescription());
        }
        if (jsonObject.has("certificate")) {
            jsonArray = jsonObject.getAsJsonArray("certificate");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestSecurityComponent.getCertificate().add(this.parseConformanceConformanceRestSecurityCertificateComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        return conformanceRestSecurityComponent;
    }

    private Conformance.ConformanceRestSecurityCertificateComponent parseConformanceConformanceRestSecurityCertificateComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent = new Conformance.ConformanceRestSecurityCertificateComponent();
        this.parseBackboneProperties(jsonObject, conformanceRestSecurityCertificateComponent);
        if (jsonObject.has("type")) {
            conformanceRestSecurityCertificateComponent.setType(this.parseCode(jsonObject.get("type").getAsString()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), conformanceRestSecurityCertificateComponent.getType());
        }
        if (jsonObject.has("blob")) {
            conformanceRestSecurityCertificateComponent.setBlob(this.parseBase64Binary(jsonObject.get("blob").getAsString()));
        }
        if (jsonObject.has("_blob")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_blob"), conformanceRestSecurityCertificateComponent.getBlob());
        }
        return conformanceRestSecurityCertificateComponent;
    }

    private Conformance.ConformanceRestResourceComponent parseConformanceConformanceRestResourceComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        int n;
        JsonArray jsonArray;
        Conformance.ConformanceRestResourceComponent conformanceRestResourceComponent = new Conformance.ConformanceRestResourceComponent();
        this.parseBackboneProperties(jsonObject, conformanceRestResourceComponent);
        if (jsonObject.has("type")) {
            conformanceRestResourceComponent.setType(this.parseCode(jsonObject.get("type").getAsString()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), conformanceRestResourceComponent.getType());
        }
        if (jsonObject.has("profile")) {
            conformanceRestResourceComponent.setProfile(this.parseResourceReference(jsonObject.getAsJsonObject("profile")));
        }
        if (jsonObject.has("operation")) {
            jsonArray = jsonObject.getAsJsonArray("operation");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestResourceComponent.getOperation().add(this.parseConformanceConformanceRestResourceOperationComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        if (jsonObject.has("readHistory")) {
            conformanceRestResourceComponent.setReadHistory(this.parseBoolean(jsonObject.get("readHistory").getAsBoolean()));
        }
        if (jsonObject.has("_readHistory")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_readHistory"), conformanceRestResourceComponent.getReadHistory());
        }
        if (jsonObject.has("updateCreate")) {
            conformanceRestResourceComponent.setUpdateCreate(this.parseBoolean(jsonObject.get("updateCreate").getAsBoolean()));
        }
        if (jsonObject.has("_updateCreate")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_updateCreate"), conformanceRestResourceComponent.getUpdateCreate());
        }
        if (jsonObject.has("searchInclude")) {
            jsonArray = jsonObject.getAsJsonArray("searchInclude");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestResourceComponent.getSearchInclude().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_searchInclude")) {
            jsonArray = jsonObject.getAsJsonArray("_searchInclude");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == conformanceRestResourceComponent.getSearchInclude().size()) {
                    conformanceRestResourceComponent.getSearchInclude().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), conformanceRestResourceComponent.getSearchInclude().get(n));
            }
        }
        if (jsonObject.has("searchParam")) {
            jsonArray = jsonObject.getAsJsonArray("searchParam");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestResourceComponent.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(jsonArray.get(n).getAsJsonObject(), conformance));
            }
        }
        return conformanceRestResourceComponent;
    }

    private Conformance.ConformanceRestResourceOperationComponent parseConformanceConformanceRestResourceOperationComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceRestResourceOperationComponent conformanceRestResourceOperationComponent = new Conformance.ConformanceRestResourceOperationComponent();
        this.parseBackboneProperties(jsonObject, conformanceRestResourceOperationComponent);
        if (jsonObject.has("code")) {
            conformanceRestResourceOperationComponent.setCode(this.parseEnumeration(jsonObject.get("code").getAsString(), Conformance.TypeRestfulOperation.Null, new Conformance.TypeRestfulOperationEnumFactory()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), conformanceRestResourceOperationComponent.getCode());
        }
        if (jsonObject.has("documentation")) {
            conformanceRestResourceOperationComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), conformanceRestResourceOperationComponent.getDocumentation());
        }
        return conformanceRestResourceOperationComponent;
    }

    private Conformance.ConformanceRestResourceSearchParamComponent parseConformanceConformanceRestResourceSearchParamComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        int n;
        JsonArray jsonArray;
        Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent = new Conformance.ConformanceRestResourceSearchParamComponent();
        this.parseBackboneProperties(jsonObject, conformanceRestResourceSearchParamComponent);
        if (jsonObject.has("name")) {
            conformanceRestResourceSearchParamComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), conformanceRestResourceSearchParamComponent.getName());
        }
        if (jsonObject.has("definition")) {
            conformanceRestResourceSearchParamComponent.setDefinition(this.parseUri(jsonObject.get("definition").getAsString()));
        }
        if (jsonObject.has("_definition")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_definition"), conformanceRestResourceSearchParamComponent.getDefinition());
        }
        if (jsonObject.has("type")) {
            conformanceRestResourceSearchParamComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), Conformance.SearchParamType.Null, new Conformance.SearchParamTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), conformanceRestResourceSearchParamComponent.getType());
        }
        if (jsonObject.has("documentation")) {
            conformanceRestResourceSearchParamComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), conformanceRestResourceSearchParamComponent.getDocumentation());
        }
        if (jsonObject.has("target")) {
            jsonArray = jsonObject.getAsJsonArray("target");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestResourceSearchParamComponent.getTarget().add(this.parseCode(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_target")) {
            jsonArray = jsonObject.getAsJsonArray("_target");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == conformanceRestResourceSearchParamComponent.getTarget().size()) {
                    conformanceRestResourceSearchParamComponent.getTarget().add(this.parseCode(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), conformanceRestResourceSearchParamComponent.getTarget().get(n));
            }
        }
        if (jsonObject.has("chain")) {
            jsonArray = jsonObject.getAsJsonArray("chain");
            for (n = 0; n < jsonArray.size(); ++n) {
                conformanceRestResourceSearchParamComponent.getChain().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_chain")) {
            jsonArray = jsonObject.getAsJsonArray("_chain");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == conformanceRestResourceSearchParamComponent.getChain().size()) {
                    conformanceRestResourceSearchParamComponent.getChain().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), conformanceRestResourceSearchParamComponent.getChain().get(n));
            }
        }
        return conformanceRestResourceSearchParamComponent;
    }

    private Conformance.ConformanceRestOperationComponent parseConformanceConformanceRestOperationComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent = new Conformance.ConformanceRestOperationComponent();
        this.parseBackboneProperties(jsonObject, conformanceRestOperationComponent);
        if (jsonObject.has("code")) {
            conformanceRestOperationComponent.setCode(this.parseEnumeration(jsonObject.get("code").getAsString(), Conformance.SystemRestfulOperation.Null, new Conformance.SystemRestfulOperationEnumFactory()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), conformanceRestOperationComponent.getCode());
        }
        if (jsonObject.has("documentation")) {
            conformanceRestOperationComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), conformanceRestOperationComponent.getDocumentation());
        }
        return conformanceRestOperationComponent;
    }

    private Conformance.ConformanceRestQueryComponent parseConformanceConformanceRestQueryComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceRestQueryComponent conformanceRestQueryComponent = new Conformance.ConformanceRestQueryComponent();
        this.parseBackboneProperties(jsonObject, conformanceRestQueryComponent);
        if (jsonObject.has("name")) {
            conformanceRestQueryComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), conformanceRestQueryComponent.getName());
        }
        if (jsonObject.has("definition")) {
            conformanceRestQueryComponent.setDefinition(this.parseUri(jsonObject.get("definition").getAsString()));
        }
        if (jsonObject.has("_definition")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_definition"), conformanceRestQueryComponent.getDefinition());
        }
        if (jsonObject.has("documentation")) {
            conformanceRestQueryComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), conformanceRestQueryComponent.getDocumentation());
        }
        if (jsonObject.has("parameter")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("parameter");
            for (int i = 0; i < jsonArray.size(); ++i) {
                conformanceRestQueryComponent.getParameter().add(this.parseConformanceConformanceRestResourceSearchParamComponent(jsonArray.get(i).getAsJsonObject(), conformance));
            }
        }
        return conformanceRestQueryComponent;
    }

    private Conformance.ConformanceMessagingComponent parseConformanceConformanceMessagingComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceMessagingComponent conformanceMessagingComponent = new Conformance.ConformanceMessagingComponent();
        this.parseBackboneProperties(jsonObject, conformanceMessagingComponent);
        if (jsonObject.has("endpoint")) {
            conformanceMessagingComponent.setEndpoint(this.parseUri(jsonObject.get("endpoint").getAsString()));
        }
        if (jsonObject.has("_endpoint")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_endpoint"), conformanceMessagingComponent.getEndpoint());
        }
        if (jsonObject.has("reliableCache")) {
            conformanceMessagingComponent.setReliableCache(this.parseInteger(jsonObject.get("reliableCache").getAsLong()));
        }
        if (jsonObject.has("_reliableCache")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_reliableCache"), conformanceMessagingComponent.getReliableCache());
        }
        if (jsonObject.has("documentation")) {
            conformanceMessagingComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), conformanceMessagingComponent.getDocumentation());
        }
        if (jsonObject.has("event")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("event");
            for (int i = 0; i < jsonArray.size(); ++i) {
                conformanceMessagingComponent.getEvent().add(this.parseConformanceConformanceMessagingEventComponent(jsonArray.get(i).getAsJsonObject(), conformance));
            }
        }
        return conformanceMessagingComponent;
    }

    private Conformance.ConformanceMessagingEventComponent parseConformanceConformanceMessagingEventComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceMessagingEventComponent conformanceMessagingEventComponent = new Conformance.ConformanceMessagingEventComponent();
        this.parseBackboneProperties(jsonObject, conformanceMessagingEventComponent);
        if (jsonObject.has("code")) {
            conformanceMessagingEventComponent.setCode(this.parseCoding(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("category")) {
            conformanceMessagingEventComponent.setCategory(this.parseEnumeration(jsonObject.get("category").getAsString(), Conformance.MessageSignificanceCategory.Null, new Conformance.MessageSignificanceCategoryEnumFactory()));
        }
        if (jsonObject.has("_category")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_category"), conformanceMessagingEventComponent.getCategory());
        }
        if (jsonObject.has("mode")) {
            conformanceMessagingEventComponent.setMode(this.parseEnumeration(jsonObject.get("mode").getAsString(), Conformance.MessageConformanceEventMode.Null, new Conformance.MessageConformanceEventModeEnumFactory()));
        }
        if (jsonObject.has("_mode")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_mode"), conformanceMessagingEventComponent.getMode());
        }
        if (jsonObject.has("protocol")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("protocol");
            for (int i = 0; i < jsonArray.size(); ++i) {
                conformanceMessagingEventComponent.getProtocol().add(this.parseCoding(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("focus")) {
            conformanceMessagingEventComponent.setFocus(this.parseCode(jsonObject.get("focus").getAsString()));
        }
        if (jsonObject.has("_focus")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_focus"), conformanceMessagingEventComponent.getFocus());
        }
        if (jsonObject.has("request")) {
            conformanceMessagingEventComponent.setRequest(this.parseResourceReference(jsonObject.getAsJsonObject("request")));
        }
        if (jsonObject.has("response")) {
            conformanceMessagingEventComponent.setResponse(this.parseResourceReference(jsonObject.getAsJsonObject("response")));
        }
        if (jsonObject.has("documentation")) {
            conformanceMessagingEventComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), conformanceMessagingEventComponent.getDocumentation());
        }
        return conformanceMessagingEventComponent;
    }

    private Conformance.ConformanceDocumentComponent parseConformanceConformanceDocumentComponent(JsonObject jsonObject, Conformance conformance) throws Exception {
        Conformance.ConformanceDocumentComponent conformanceDocumentComponent = new Conformance.ConformanceDocumentComponent();
        this.parseBackboneProperties(jsonObject, conformanceDocumentComponent);
        if (jsonObject.has("mode")) {
            conformanceDocumentComponent.setMode(this.parseEnumeration(jsonObject.get("mode").getAsString(), Conformance.DocumentMode.Null, new Conformance.DocumentModeEnumFactory()));
        }
        if (jsonObject.has("_mode")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_mode"), conformanceDocumentComponent.getMode());
        }
        if (jsonObject.has("documentation")) {
            conformanceDocumentComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), conformanceDocumentComponent.getDocumentation());
        }
        if (jsonObject.has("profile")) {
            conformanceDocumentComponent.setProfile(this.parseResourceReference(jsonObject.getAsJsonObject("profile")));
        }
        return conformanceDocumentComponent;
    }

    private Device parseDevice(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Device device = new Device();
        this.parseResourceProperties(jsonObject, device);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                device.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("type")) {
            device.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("manufacturer")) {
            device.setManufacturer(this.parseString(jsonObject.get("manufacturer").getAsString()));
        }
        if (jsonObject.has("_manufacturer")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_manufacturer"), device.getManufacturer());
        }
        if (jsonObject.has("model")) {
            device.setModel(this.parseString(jsonObject.get("model").getAsString()));
        }
        if (jsonObject.has("_model")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_model"), device.getModel());
        }
        if (jsonObject.has("version")) {
            device.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), device.getVersion());
        }
        if (jsonObject.has("expiry")) {
            device.setExpiry(this.parseDate(jsonObject.get("expiry").getAsString()));
        }
        if (jsonObject.has("_expiry")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_expiry"), device.getExpiry());
        }
        if (jsonObject.has("udi")) {
            device.setUdi(this.parseString(jsonObject.get("udi").getAsString()));
        }
        if (jsonObject.has("_udi")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_udi"), device.getUdi());
        }
        if (jsonObject.has("lotNumber")) {
            device.setLotNumber(this.parseString(jsonObject.get("lotNumber").getAsString()));
        }
        if (jsonObject.has("_lotNumber")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_lotNumber"), device.getLotNumber());
        }
        if (jsonObject.has("owner")) {
            device.setOwner(this.parseResourceReference(jsonObject.getAsJsonObject("owner")));
        }
        if (jsonObject.has("location")) {
            device.setLocation(this.parseResourceReference(jsonObject.getAsJsonObject("location")));
        }
        if (jsonObject.has("patient")) {
            device.setPatient(this.parseResourceReference(jsonObject.getAsJsonObject("patient")));
        }
        if (jsonObject.has("contact")) {
            jsonArray = jsonObject.getAsJsonArray("contact");
            for (n = 0; n < jsonArray.size(); ++n) {
                device.getContact().add(this.parseContact(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("url")) {
            device.setUrl(this.parseUri(jsonObject.get("url").getAsString()));
        }
        if (jsonObject.has("_url")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_url"), device.getUrl());
        }
        return device;
    }

    private DeviceObservationReport parseDeviceObservationReport(JsonObject jsonObject) throws Exception {
        DeviceObservationReport deviceObservationReport = new DeviceObservationReport();
        this.parseResourceProperties(jsonObject, deviceObservationReport);
        if (jsonObject.has("instant")) {
            deviceObservationReport.setInstant(this.parseInstant(jsonObject.get("instant").getAsString()));
        }
        if (jsonObject.has("_instant")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_instant"), deviceObservationReport.getInstant());
        }
        if (jsonObject.has("identifier")) {
            deviceObservationReport.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("source")) {
            deviceObservationReport.setSource(this.parseResourceReference(jsonObject.getAsJsonObject("source")));
        }
        if (jsonObject.has("subject")) {
            deviceObservationReport.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("virtualDevice")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("virtualDevice");
            for (int i = 0; i < jsonArray.size(); ++i) {
                deviceObservationReport.getVirtualDevice().add(this.parseDeviceObservationReportDeviceObservationReportVirtualDeviceComponent(jsonArray.get(i).getAsJsonObject(), deviceObservationReport));
            }
        }
        return deviceObservationReport;
    }

    private DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent parseDeviceObservationReportDeviceObservationReportVirtualDeviceComponent(JsonObject jsonObject, DeviceObservationReport deviceObservationReport) throws Exception {
        DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent = new DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent();
        this.parseBackboneProperties(jsonObject, deviceObservationReportVirtualDeviceComponent);
        if (jsonObject.has("code")) {
            deviceObservationReportVirtualDeviceComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("channel")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("channel");
            for (int i = 0; i < jsonArray.size(); ++i) {
                deviceObservationReportVirtualDeviceComponent.getChannel().add(this.parseDeviceObservationReportDeviceObservationReportVirtualDeviceChannelComponent(jsonArray.get(i).getAsJsonObject(), deviceObservationReport));
            }
        }
        return deviceObservationReportVirtualDeviceComponent;
    }

    private DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent parseDeviceObservationReportDeviceObservationReportVirtualDeviceChannelComponent(JsonObject jsonObject, DeviceObservationReport deviceObservationReport) throws Exception {
        DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent = new DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent();
        this.parseBackboneProperties(jsonObject, deviceObservationReportVirtualDeviceChannelComponent);
        if (jsonObject.has("code")) {
            deviceObservationReportVirtualDeviceChannelComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("metric")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("metric");
            for (int i = 0; i < jsonArray.size(); ++i) {
                deviceObservationReportVirtualDeviceChannelComponent.getMetric().add(this.parseDeviceObservationReportDeviceObservationReportVirtualDeviceChannelMetricComponent(jsonArray.get(i).getAsJsonObject(), deviceObservationReport));
            }
        }
        return deviceObservationReportVirtualDeviceChannelComponent;
    }

    private DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent parseDeviceObservationReportDeviceObservationReportVirtualDeviceChannelMetricComponent(JsonObject jsonObject, DeviceObservationReport deviceObservationReport) throws Exception {
        DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent = new DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent();
        this.parseBackboneProperties(jsonObject, deviceObservationReportVirtualDeviceChannelMetricComponent);
        if (jsonObject.has("observation")) {
            deviceObservationReportVirtualDeviceChannelMetricComponent.setObservation(this.parseResourceReference(jsonObject.getAsJsonObject("observation")));
        }
        return deviceObservationReportVirtualDeviceChannelMetricComponent;
    }

    private DiagnosticOrder parseDiagnosticOrder(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        DiagnosticOrder diagnosticOrder = new DiagnosticOrder();
        this.parseResourceProperties(jsonObject, diagnosticOrder);
        if (jsonObject.has("subject")) {
            diagnosticOrder.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("orderer")) {
            diagnosticOrder.setOrderer(this.parseResourceReference(jsonObject.getAsJsonObject("orderer")));
        }
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticOrder.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("encounter")) {
            diagnosticOrder.setEncounter(this.parseResourceReference(jsonObject.getAsJsonObject("encounter")));
        }
        if (jsonObject.has("clinicalNotes")) {
            diagnosticOrder.setClinicalNotes(this.parseString(jsonObject.get("clinicalNotes").getAsString()));
        }
        if (jsonObject.has("_clinicalNotes")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_clinicalNotes"), diagnosticOrder.getClinicalNotes());
        }
        if (jsonObject.has("specimen")) {
            jsonArray = jsonObject.getAsJsonArray("specimen");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticOrder.getSpecimen().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("status")) {
            diagnosticOrder.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.Null, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), diagnosticOrder.getStatus());
        }
        if (jsonObject.has("priority")) {
            diagnosticOrder.setPriority(this.parseEnumeration(jsonObject.get("priority").getAsString(), DiagnosticOrder.DiagnosticOrderPriority.Null, new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory()));
        }
        if (jsonObject.has("_priority")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_priority"), diagnosticOrder.getPriority());
        }
        if (jsonObject.has("event")) {
            jsonArray = jsonObject.getAsJsonArray("event");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticOrder.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(jsonArray.get(n).getAsJsonObject(), diagnosticOrder));
            }
        }
        if (jsonObject.has("item")) {
            jsonArray = jsonObject.getAsJsonArray("item");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticOrder.getItem().add(this.parseDiagnosticOrderDiagnosticOrderItemComponent(jsonArray.get(n).getAsJsonObject(), diagnosticOrder));
            }
        }
        return diagnosticOrder;
    }

    private DiagnosticOrder.DiagnosticOrderEventComponent parseDiagnosticOrderDiagnosticOrderEventComponent(JsonObject jsonObject, DiagnosticOrder diagnosticOrder) throws Exception {
        DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent = new DiagnosticOrder.DiagnosticOrderEventComponent();
        this.parseBackboneProperties(jsonObject, diagnosticOrderEventComponent);
        if (jsonObject.has("status")) {
            diagnosticOrderEventComponent.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.Null, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), diagnosticOrderEventComponent.getStatus());
        }
        if (jsonObject.has("description")) {
            diagnosticOrderEventComponent.setDescription(this.parseCodeableConcept(jsonObject.getAsJsonObject("description")));
        }
        if (jsonObject.has("dateTime")) {
            diagnosticOrderEventComponent.setDateTime(this.parseDateTime(jsonObject.get("dateTime").getAsString()));
        }
        if (jsonObject.has("_dateTime")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_dateTime"), diagnosticOrderEventComponent.getDateTime());
        }
        if (jsonObject.has("actor")) {
            diagnosticOrderEventComponent.setActor(this.parseResourceReference(jsonObject.getAsJsonObject("actor")));
        }
        return diagnosticOrderEventComponent;
    }

    private DiagnosticOrder.DiagnosticOrderItemComponent parseDiagnosticOrderDiagnosticOrderItemComponent(JsonObject jsonObject, DiagnosticOrder diagnosticOrder) throws Exception {
        int n;
        JsonArray jsonArray;
        DiagnosticOrder.DiagnosticOrderItemComponent diagnosticOrderItemComponent = new DiagnosticOrder.DiagnosticOrderItemComponent();
        this.parseBackboneProperties(jsonObject, diagnosticOrderItemComponent);
        if (jsonObject.has("code")) {
            diagnosticOrderItemComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("specimen")) {
            jsonArray = jsonObject.getAsJsonArray("specimen");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticOrderItemComponent.getSpecimen().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("bodySite")) {
            diagnosticOrderItemComponent.setBodySite(this.parseCodeableConcept(jsonObject.getAsJsonObject("bodySite")));
        }
        if (jsonObject.has("status")) {
            diagnosticOrderItemComponent.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.Null, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), diagnosticOrderItemComponent.getStatus());
        }
        if (jsonObject.has("event")) {
            jsonArray = jsonObject.getAsJsonArray("event");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticOrderItemComponent.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(jsonArray.get(n).getAsJsonObject(), diagnosticOrder));
            }
        }
        return diagnosticOrderItemComponent;
    }

    private DiagnosticReport parseDiagnosticReport(JsonObject jsonObject) throws Exception {
        int n;
        Object object;
        DiagnosticReport diagnosticReport = new DiagnosticReport();
        this.parseResourceProperties(jsonObject, diagnosticReport);
        if (jsonObject.has("name")) {
            diagnosticReport.setName(this.parseCodeableConcept(jsonObject.getAsJsonObject("name")));
        }
        if (jsonObject.has("status")) {
            diagnosticReport.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.Null, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), diagnosticReport.getStatus());
        }
        if (jsonObject.has("issued")) {
            diagnosticReport.setIssued(this.parseDateTime(jsonObject.get("issued").getAsString()));
        }
        if (jsonObject.has("_issued")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_issued"), diagnosticReport.getIssued());
        }
        if (jsonObject.has("subject")) {
            diagnosticReport.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("performer")) {
            diagnosticReport.setPerformer(this.parseResourceReference(jsonObject.getAsJsonObject("performer")));
        }
        if (jsonObject.has("identifier")) {
            diagnosticReport.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("requestDetail")) {
            object = jsonObject.getAsJsonArray("requestDetail");
            for (int i = 0; i < object.size(); ++i) {
                diagnosticReport.getRequestDetail().add(this.parseResourceReference(object.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("serviceCategory")) {
            diagnosticReport.setServiceCategory(this.parseCodeableConcept(jsonObject.getAsJsonObject("serviceCategory")));
        }
        if ((object = this.parseType("diagnostic", jsonObject)) != null) {
            diagnosticReport.setDiagnostic((Type)object);
        }
        if (jsonObject.has("specimen")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("specimen");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticReport.getSpecimen().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("result")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticReport.getResult().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("imagingStudy")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("imagingStudy");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticReport.getImagingStudy().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("image")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("image");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticReport.getImage().add(this.parseDiagnosticReportDiagnosticReportImageComponent(jsonArray.get(n).getAsJsonObject(), diagnosticReport));
            }
        }
        if (jsonObject.has("conclusion")) {
            diagnosticReport.setConclusion(this.parseString(jsonObject.get("conclusion").getAsString()));
        }
        if (jsonObject.has("_conclusion")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_conclusion"), diagnosticReport.getConclusion());
        }
        if (jsonObject.has("codedDiagnosis")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("codedDiagnosis");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticReport.getCodedDiagnosis().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("presentedForm")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("presentedForm");
            for (n = 0; n < jsonArray.size(); ++n) {
                diagnosticReport.getPresentedForm().add(this.parseAttachment(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return diagnosticReport;
    }

    private DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(JsonObject jsonObject, DiagnosticReport diagnosticReport) throws Exception {
        DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent = new DiagnosticReport.DiagnosticReportImageComponent();
        this.parseBackboneProperties(jsonObject, diagnosticReportImageComponent);
        if (jsonObject.has("comment")) {
            diagnosticReportImageComponent.setComment(this.parseString(jsonObject.get("comment").getAsString()));
        }
        if (jsonObject.has("_comment")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comment"), diagnosticReportImageComponent.getComment());
        }
        if (jsonObject.has("link")) {
            diagnosticReportImageComponent.setLink(this.parseResourceReference(jsonObject.getAsJsonObject("link")));
        }
        return diagnosticReportImageComponent;
    }

    private DocumentManifest parseDocumentManifest(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        DocumentManifest documentManifest = new DocumentManifest();
        this.parseResourceProperties(jsonObject, documentManifest);
        if (jsonObject.has("masterIdentifier")) {
            documentManifest.setMasterIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("masterIdentifier")));
        }
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentManifest.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("subject")) {
            jsonArray = jsonObject.getAsJsonArray("subject");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentManifest.getSubject().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("recipient")) {
            jsonArray = jsonObject.getAsJsonArray("recipient");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentManifest.getRecipient().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("type")) {
            documentManifest.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("author")) {
            jsonArray = jsonObject.getAsJsonArray("author");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentManifest.getAuthor().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("created")) {
            documentManifest.setCreated(this.parseDateTime(jsonObject.get("created").getAsString()));
        }
        if (jsonObject.has("_created")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_created"), documentManifest.getCreated());
        }
        if (jsonObject.has("source")) {
            documentManifest.setSource(this.parseUri(jsonObject.get("source").getAsString()));
        }
        if (jsonObject.has("_source")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_source"), documentManifest.getSource());
        }
        if (jsonObject.has("status")) {
            documentManifest.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), DocumentManifest.DocumentReferenceStatus.Null, new DocumentManifest.DocumentReferenceStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), documentManifest.getStatus());
        }
        if (jsonObject.has("supercedes")) {
            documentManifest.setSupercedes(this.parseResourceReference(jsonObject.getAsJsonObject("supercedes")));
        }
        if (jsonObject.has("description")) {
            documentManifest.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), documentManifest.getDescription());
        }
        if (jsonObject.has("confidentiality")) {
            documentManifest.setConfidentiality(this.parseCodeableConcept(jsonObject.getAsJsonObject("confidentiality")));
        }
        if (jsonObject.has("content")) {
            jsonArray = jsonObject.getAsJsonArray("content");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentManifest.getContent().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return documentManifest;
    }

    private DocumentReference parseDocumentReference(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        DocumentReference documentReference = new DocumentReference();
        this.parseResourceProperties(jsonObject, documentReference);
        if (jsonObject.has("masterIdentifier")) {
            documentReference.setMasterIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("masterIdentifier")));
        }
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentReference.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("subject")) {
            documentReference.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("type")) {
            documentReference.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("class")) {
            documentReference.setClass_(this.parseCodeableConcept(jsonObject.getAsJsonObject("class")));
        }
        if (jsonObject.has("author")) {
            jsonArray = jsonObject.getAsJsonArray("author");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentReference.getAuthor().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("custodian")) {
            documentReference.setCustodian(this.parseResourceReference(jsonObject.getAsJsonObject("custodian")));
        }
        if (jsonObject.has("policyManager")) {
            documentReference.setPolicyManager(this.parseUri(jsonObject.get("policyManager").getAsString()));
        }
        if (jsonObject.has("_policyManager")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_policyManager"), documentReference.getPolicyManager());
        }
        if (jsonObject.has("authenticator")) {
            documentReference.setAuthenticator(this.parseResourceReference(jsonObject.getAsJsonObject("authenticator")));
        }
        if (jsonObject.has("created")) {
            documentReference.setCreated(this.parseDateTime(jsonObject.get("created").getAsString()));
        }
        if (jsonObject.has("_created")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_created"), documentReference.getCreated());
        }
        if (jsonObject.has("indexed")) {
            documentReference.setIndexed(this.parseInstant(jsonObject.get("indexed").getAsString()));
        }
        if (jsonObject.has("_indexed")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_indexed"), documentReference.getIndexed());
        }
        if (jsonObject.has("status")) {
            documentReference.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), DocumentReference.DocumentReferenceStatus.Null, new DocumentReference.DocumentReferenceStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), documentReference.getStatus());
        }
        if (jsonObject.has("docStatus")) {
            documentReference.setDocStatus(this.parseCodeableConcept(jsonObject.getAsJsonObject("docStatus")));
        }
        if (jsonObject.has("relatesTo")) {
            jsonArray = jsonObject.getAsJsonArray("relatesTo");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentReference.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(jsonArray.get(n).getAsJsonObject(), documentReference));
            }
        }
        if (jsonObject.has("description")) {
            documentReference.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), documentReference.getDescription());
        }
        if (jsonObject.has("confidentiality")) {
            jsonArray = jsonObject.getAsJsonArray("confidentiality");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentReference.getConfidentiality().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("primaryLanguage")) {
            documentReference.setPrimaryLanguage(this.parseCode(jsonObject.get("primaryLanguage").getAsString()));
        }
        if (jsonObject.has("_primaryLanguage")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_primaryLanguage"), documentReference.getPrimaryLanguage());
        }
        if (jsonObject.has("mimeType")) {
            documentReference.setMimeType(this.parseCode(jsonObject.get("mimeType").getAsString()));
        }
        if (jsonObject.has("_mimeType")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_mimeType"), documentReference.getMimeType());
        }
        if (jsonObject.has("format")) {
            jsonArray = jsonObject.getAsJsonArray("format");
            for (n = 0; n < jsonArray.size(); ++n) {
                documentReference.getFormat().add(this.parseUri(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_format")) {
            jsonArray = jsonObject.getAsJsonArray("_format");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == documentReference.getFormat().size()) {
                    documentReference.getFormat().add(this.parseUri(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), documentReference.getFormat().get(n));
            }
        }
        if (jsonObject.has("size")) {
            documentReference.setSize(this.parseInteger(jsonObject.get("size").getAsLong()));
        }
        if (jsonObject.has("_size")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_size"), documentReference.getSize());
        }
        if (jsonObject.has("hash")) {
            documentReference.setHash(this.parseString(jsonObject.get("hash").getAsString()));
        }
        if (jsonObject.has("_hash")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_hash"), documentReference.getHash());
        }
        if (jsonObject.has("location")) {
            documentReference.setLocation(this.parseUri(jsonObject.get("location").getAsString()));
        }
        if (jsonObject.has("_location")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_location"), documentReference.getLocation());
        }
        if (jsonObject.has("service")) {
            documentReference.setService(this.parseDocumentReferenceDocumentReferenceServiceComponent(jsonObject.getAsJsonObject("service"), documentReference));
        }
        if (jsonObject.has("context")) {
            documentReference.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(jsonObject.getAsJsonObject("context"), documentReference));
        }
        return documentReference;
    }

    private DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(JsonObject jsonObject, DocumentReference documentReference) throws Exception {
        DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseBackboneProperties(jsonObject, documentReferenceRelatesToComponent);
        if (jsonObject.has("code")) {
            documentReferenceRelatesToComponent.setCode(this.parseEnumeration(jsonObject.get("code").getAsString(), DocumentReference.DocumentRelationshipType.Null, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), documentReferenceRelatesToComponent.getCode());
        }
        if (jsonObject.has("target")) {
            documentReferenceRelatesToComponent.setTarget(this.parseResourceReference(jsonObject.getAsJsonObject("target")));
        }
        return documentReferenceRelatesToComponent;
    }

    private DocumentReference.DocumentReferenceServiceComponent parseDocumentReferenceDocumentReferenceServiceComponent(JsonObject jsonObject, DocumentReference documentReference) throws Exception {
        DocumentReference.DocumentReferenceServiceComponent documentReferenceServiceComponent = new DocumentReference.DocumentReferenceServiceComponent();
        this.parseBackboneProperties(jsonObject, documentReferenceServiceComponent);
        if (jsonObject.has("type")) {
            documentReferenceServiceComponent.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("address")) {
            documentReferenceServiceComponent.setAddress(this.parseString(jsonObject.get("address").getAsString()));
        }
        if (jsonObject.has("_address")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_address"), documentReferenceServiceComponent.getAddress());
        }
        if (jsonObject.has("parameter")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("parameter");
            for (int i = 0; i < jsonArray.size(); ++i) {
                documentReferenceServiceComponent.getParameter().add(this.parseDocumentReferenceDocumentReferenceServiceParameterComponent(jsonArray.get(i).getAsJsonObject(), documentReference));
            }
        }
        return documentReferenceServiceComponent;
    }

    private DocumentReference.DocumentReferenceServiceParameterComponent parseDocumentReferenceDocumentReferenceServiceParameterComponent(JsonObject jsonObject, DocumentReference documentReference) throws Exception {
        DocumentReference.DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent = new DocumentReference.DocumentReferenceServiceParameterComponent();
        this.parseBackboneProperties(jsonObject, documentReferenceServiceParameterComponent);
        if (jsonObject.has("name")) {
            documentReferenceServiceParameterComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), documentReferenceServiceParameterComponent.getName());
        }
        if (jsonObject.has("value")) {
            documentReferenceServiceParameterComponent.setValue(this.parseString(jsonObject.get("value").getAsString()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), documentReferenceServiceParameterComponent.getValue());
        }
        return documentReferenceServiceParameterComponent;
    }

    private DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(JsonObject jsonObject, DocumentReference documentReference) throws Exception {
        DocumentReference.DocumentReferenceContextComponent documentReferenceContextComponent = new DocumentReference.DocumentReferenceContextComponent();
        this.parseBackboneProperties(jsonObject, documentReferenceContextComponent);
        if (jsonObject.has("event")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("event");
            for (int i = 0; i < jsonArray.size(); ++i) {
                documentReferenceContextComponent.getEvent().add(this.parseCodeableConcept(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("period")) {
            documentReferenceContextComponent.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("facilityType")) {
            documentReferenceContextComponent.setFacilityType(this.parseCodeableConcept(jsonObject.getAsJsonObject("facilityType")));
        }
        return documentReferenceContextComponent;
    }

    private Encounter parseEncounter(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Encounter encounter = new Encounter();
        this.parseResourceProperties(jsonObject, encounter);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                encounter.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("status")) {
            encounter.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Encounter.EncounterState.Null, new Encounter.EncounterStateEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), encounter.getStatus());
        }
        if (jsonObject.has("class")) {
            encounter.setClass_(this.parseEnumeration(jsonObject.get("class").getAsString(), Encounter.EncounterClass.Null, new Encounter.EncounterClassEnumFactory()));
        }
        if (jsonObject.has("_class")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_class"), encounter.getClass_());
        }
        if (jsonObject.has("type")) {
            jsonArray = jsonObject.getAsJsonArray("type");
            for (n = 0; n < jsonArray.size(); ++n) {
                encounter.getType().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("subject")) {
            encounter.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("participant")) {
            jsonArray = jsonObject.getAsJsonArray("participant");
            for (n = 0; n < jsonArray.size(); ++n) {
                encounter.getParticipant().add(this.parseEncounterEncounterParticipantComponent(jsonArray.get(n).getAsJsonObject(), encounter));
            }
        }
        if (jsonObject.has("period")) {
            encounter.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("length")) {
            encounter.setLength(this.parseDuration(jsonObject.getAsJsonObject("length")));
        }
        if (jsonObject.has("reason")) {
            encounter.setReason(this.parseCodeableConcept(jsonObject.getAsJsonObject("reason")));
        }
        if (jsonObject.has("indication")) {
            encounter.setIndication(this.parseResourceReference(jsonObject.getAsJsonObject("indication")));
        }
        if (jsonObject.has("priority")) {
            encounter.setPriority(this.parseCodeableConcept(jsonObject.getAsJsonObject("priority")));
        }
        if (jsonObject.has("hospitalization")) {
            encounter.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(jsonObject.getAsJsonObject("hospitalization"), encounter));
        }
        if (jsonObject.has("location")) {
            jsonArray = jsonObject.getAsJsonArray("location");
            for (n = 0; n < jsonArray.size(); ++n) {
                encounter.getLocation().add(this.parseEncounterEncounterLocationComponent(jsonArray.get(n).getAsJsonObject(), encounter));
            }
        }
        if (jsonObject.has("serviceProvider")) {
            encounter.setServiceProvider(this.parseResourceReference(jsonObject.getAsJsonObject("serviceProvider")));
        }
        if (jsonObject.has("partOf")) {
            encounter.setPartOf(this.parseResourceReference(jsonObject.getAsJsonObject("partOf")));
        }
        return encounter;
    }

    private Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(JsonObject jsonObject, Encounter encounter) throws Exception {
        Encounter.EncounterParticipantComponent encounterParticipantComponent = new Encounter.EncounterParticipantComponent();
        this.parseBackboneProperties(jsonObject, encounterParticipantComponent);
        if (jsonObject.has("type")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("type");
            for (int i = 0; i < jsonArray.size(); ++i) {
                encounterParticipantComponent.getType().add(this.parseCodeableConcept(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("individual")) {
            encounterParticipantComponent.setIndividual(this.parseResourceReference(jsonObject.getAsJsonObject("individual")));
        }
        return encounterParticipantComponent;
    }

    private Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(JsonObject jsonObject, Encounter encounter) throws Exception {
        int n;
        JsonArray jsonArray;
        Encounter.EncounterHospitalizationComponent encounterHospitalizationComponent = new Encounter.EncounterHospitalizationComponent();
        this.parseBackboneProperties(jsonObject, encounterHospitalizationComponent);
        if (jsonObject.has("preAdmissionIdentifier")) {
            encounterHospitalizationComponent.setPreAdmissionIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("preAdmissionIdentifier")));
        }
        if (jsonObject.has("origin")) {
            encounterHospitalizationComponent.setOrigin(this.parseResourceReference(jsonObject.getAsJsonObject("origin")));
        }
        if (jsonObject.has("admitSource")) {
            encounterHospitalizationComponent.setAdmitSource(this.parseCodeableConcept(jsonObject.getAsJsonObject("admitSource")));
        }
        if (jsonObject.has("period")) {
            encounterHospitalizationComponent.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("accomodation")) {
            jsonArray = jsonObject.getAsJsonArray("accomodation");
            for (n = 0; n < jsonArray.size(); ++n) {
                encounterHospitalizationComponent.getAccomodation().add(this.parseEncounterEncounterHospitalizationAccomodationComponent(jsonArray.get(n).getAsJsonObject(), encounter));
            }
        }
        if (jsonObject.has("diet")) {
            encounterHospitalizationComponent.setDiet(this.parseCodeableConcept(jsonObject.getAsJsonObject("diet")));
        }
        if (jsonObject.has("specialCourtesy")) {
            jsonArray = jsonObject.getAsJsonArray("specialCourtesy");
            for (n = 0; n < jsonArray.size(); ++n) {
                encounterHospitalizationComponent.getSpecialCourtesy().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("specialArrangement")) {
            jsonArray = jsonObject.getAsJsonArray("specialArrangement");
            for (n = 0; n < jsonArray.size(); ++n) {
                encounterHospitalizationComponent.getSpecialArrangement().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("destination")) {
            encounterHospitalizationComponent.setDestination(this.parseResourceReference(jsonObject.getAsJsonObject("destination")));
        }
        if (jsonObject.has("dischargeDisposition")) {
            encounterHospitalizationComponent.setDischargeDisposition(this.parseCodeableConcept(jsonObject.getAsJsonObject("dischargeDisposition")));
        }
        if (jsonObject.has("dischargeDiagnosis")) {
            encounterHospitalizationComponent.setDischargeDiagnosis(this.parseResourceReference(jsonObject.getAsJsonObject("dischargeDiagnosis")));
        }
        if (jsonObject.has("reAdmission")) {
            encounterHospitalizationComponent.setReAdmission(this.parseBoolean(jsonObject.get("reAdmission").getAsBoolean()));
        }
        if (jsonObject.has("_reAdmission")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_reAdmission"), encounterHospitalizationComponent.getReAdmission());
        }
        return encounterHospitalizationComponent;
    }

    private Encounter.EncounterHospitalizationAccomodationComponent parseEncounterEncounterHospitalizationAccomodationComponent(JsonObject jsonObject, Encounter encounter) throws Exception {
        Encounter.EncounterHospitalizationAccomodationComponent encounterHospitalizationAccomodationComponent = new Encounter.EncounterHospitalizationAccomodationComponent();
        this.parseBackboneProperties(jsonObject, encounterHospitalizationAccomodationComponent);
        if (jsonObject.has("bed")) {
            encounterHospitalizationAccomodationComponent.setBed(this.parseResourceReference(jsonObject.getAsJsonObject("bed")));
        }
        if (jsonObject.has("period")) {
            encounterHospitalizationAccomodationComponent.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        return encounterHospitalizationAccomodationComponent;
    }

    private Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(JsonObject jsonObject, Encounter encounter) throws Exception {
        Encounter.EncounterLocationComponent encounterLocationComponent = new Encounter.EncounterLocationComponent();
        this.parseBackboneProperties(jsonObject, encounterLocationComponent);
        if (jsonObject.has("location")) {
            encounterLocationComponent.setLocation(this.parseResourceReference(jsonObject.getAsJsonObject("location")));
        }
        if (jsonObject.has("period")) {
            encounterLocationComponent.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        return encounterLocationComponent;
    }

    private FamilyHistory parseFamilyHistory(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        FamilyHistory familyHistory = new FamilyHistory();
        this.parseResourceProperties(jsonObject, familyHistory);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                familyHistory.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("subject")) {
            familyHistory.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("note")) {
            familyHistory.setNote(this.parseString(jsonObject.get("note").getAsString()));
        }
        if (jsonObject.has("_note")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_note"), familyHistory.getNote());
        }
        if (jsonObject.has("relation")) {
            jsonArray = jsonObject.getAsJsonArray("relation");
            for (n = 0; n < jsonArray.size(); ++n) {
                familyHistory.getRelation().add(this.parseFamilyHistoryFamilyHistoryRelationComponent(jsonArray.get(n).getAsJsonObject(), familyHistory));
            }
        }
        return familyHistory;
    }

    private FamilyHistory.FamilyHistoryRelationComponent parseFamilyHistoryFamilyHistoryRelationComponent(JsonObject jsonObject, FamilyHistory familyHistory) throws Exception {
        Type type;
        Type type2;
        FamilyHistory.FamilyHistoryRelationComponent familyHistoryRelationComponent = new FamilyHistory.FamilyHistoryRelationComponent();
        this.parseBackboneProperties(jsonObject, familyHistoryRelationComponent);
        if (jsonObject.has("name")) {
            familyHistoryRelationComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), familyHistoryRelationComponent.getName());
        }
        if (jsonObject.has("relationship")) {
            familyHistoryRelationComponent.setRelationship(this.parseCodeableConcept(jsonObject.getAsJsonObject("relationship")));
        }
        if ((type2 = this.parseType("born", jsonObject)) != null) {
            familyHistoryRelationComponent.setBorn(type2);
        }
        if ((type = this.parseType("deceased", jsonObject)) != null) {
            familyHistoryRelationComponent.setDeceased(type);
        }
        if (jsonObject.has("note")) {
            familyHistoryRelationComponent.setNote(this.parseString(jsonObject.get("note").getAsString()));
        }
        if (jsonObject.has("_note")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_note"), familyHistoryRelationComponent.getNote());
        }
        if (jsonObject.has("condition")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("condition");
            for (int i = 0; i < jsonArray.size(); ++i) {
                familyHistoryRelationComponent.getCondition().add(this.parseFamilyHistoryFamilyHistoryRelationConditionComponent(jsonArray.get(i).getAsJsonObject(), familyHistory));
            }
        }
        return familyHistoryRelationComponent;
    }

    private FamilyHistory.FamilyHistoryRelationConditionComponent parseFamilyHistoryFamilyHistoryRelationConditionComponent(JsonObject jsonObject, FamilyHistory familyHistory) throws Exception {
        Type type;
        FamilyHistory.FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent = new FamilyHistory.FamilyHistoryRelationConditionComponent();
        this.parseBackboneProperties(jsonObject, familyHistoryRelationConditionComponent);
        if (jsonObject.has("type")) {
            familyHistoryRelationConditionComponent.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("outcome")) {
            familyHistoryRelationConditionComponent.setOutcome(this.parseCodeableConcept(jsonObject.getAsJsonObject("outcome")));
        }
        if ((type = this.parseType("onset", jsonObject)) != null) {
            familyHistoryRelationConditionComponent.setOnset(type);
        }
        if (jsonObject.has("note")) {
            familyHistoryRelationConditionComponent.setNote(this.parseString(jsonObject.get("note").getAsString()));
        }
        if (jsonObject.has("_note")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_note"), familyHistoryRelationConditionComponent.getNote());
        }
        return familyHistoryRelationConditionComponent;
    }

    private Group parseGroup(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Group group = new Group();
        this.parseResourceProperties(jsonObject, group);
        if (jsonObject.has("identifier")) {
            group.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("type")) {
            group.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), Group.GroupType.Null, new Group.GroupTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), group.getType());
        }
        if (jsonObject.has("actual")) {
            group.setActual(this.parseBoolean(jsonObject.get("actual").getAsBoolean()));
        }
        if (jsonObject.has("_actual")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_actual"), group.getActual());
        }
        if (jsonObject.has("code")) {
            group.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("name")) {
            group.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), group.getName());
        }
        if (jsonObject.has("quantity")) {
            group.setQuantity(this.parseInteger(jsonObject.get("quantity").getAsLong()));
        }
        if (jsonObject.has("_quantity")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_quantity"), group.getQuantity());
        }
        if (jsonObject.has("characteristic")) {
            jsonArray = jsonObject.getAsJsonArray("characteristic");
            for (n = 0; n < jsonArray.size(); ++n) {
                group.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(jsonArray.get(n).getAsJsonObject(), group));
            }
        }
        if (jsonObject.has("member")) {
            jsonArray = jsonObject.getAsJsonArray("member");
            for (n = 0; n < jsonArray.size(); ++n) {
                group.getMember().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return group;
    }

    private Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(JsonObject jsonObject, Group group) throws Exception {
        Type type;
        Group.GroupCharacteristicComponent groupCharacteristicComponent = new Group.GroupCharacteristicComponent();
        this.parseBackboneProperties(jsonObject, groupCharacteristicComponent);
        if (jsonObject.has("code")) {
            groupCharacteristicComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if ((type = this.parseType("value", jsonObject)) != null) {
            groupCharacteristicComponent.setValue(type);
        }
        if (jsonObject.has("exclude")) {
            groupCharacteristicComponent.setExclude(this.parseBoolean(jsonObject.get("exclude").getAsBoolean()));
        }
        if (jsonObject.has("_exclude")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_exclude"), groupCharacteristicComponent.getExclude());
        }
        return groupCharacteristicComponent;
    }

    private ImagingStudy parseImagingStudy(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        ImagingStudy imagingStudy = new ImagingStudy();
        this.parseResourceProperties(jsonObject, imagingStudy);
        if (jsonObject.has("dateTime")) {
            imagingStudy.setDateTime(this.parseDateTime(jsonObject.get("dateTime").getAsString()));
        }
        if (jsonObject.has("_dateTime")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_dateTime"), imagingStudy.getDateTime());
        }
        if (jsonObject.has("subject")) {
            imagingStudy.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("uid")) {
            imagingStudy.setUid(this.parseOid(jsonObject.get("uid").getAsString()));
        }
        if (jsonObject.has("_uid")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_uid"), imagingStudy.getUid());
        }
        if (jsonObject.has("accessionNo")) {
            imagingStudy.setAccessionNo(this.parseIdentifier(jsonObject.getAsJsonObject("accessionNo")));
        }
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                imagingStudy.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("order")) {
            jsonArray = jsonObject.getAsJsonArray("order");
            for (n = 0; n < jsonArray.size(); ++n) {
                imagingStudy.getOrder().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("modality")) {
            jsonArray = jsonObject.getAsJsonArray("modality");
            for (n = 0; n < jsonArray.size(); ++n) {
                imagingStudy.getModality().add(this.parseEnumeration(jsonArray.get(n).getAsString(), ImagingStudy.ImagingModality.Null, new ImagingStudy.ImagingModalityEnumFactory()));
            }
        }
        if (jsonObject.has("_modality")) {
            jsonArray = jsonObject.getAsJsonArray("_modality");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == imagingStudy.getModality().size()) {
                    imagingStudy.getModality().add(this.parseEnumeration(null, ImagingStudy.ImagingModality.Null, new ImagingStudy.ImagingModalityEnumFactory()));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), imagingStudy.getModality().get(n));
            }
        }
        if (jsonObject.has("referrer")) {
            imagingStudy.setReferrer(this.parseResourceReference(jsonObject.getAsJsonObject("referrer")));
        }
        if (jsonObject.has("availability")) {
            imagingStudy.setAvailability(this.parseEnumeration(jsonObject.get("availability").getAsString(), ImagingStudy.InstanceAvailability.Null, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        }
        if (jsonObject.has("_availability")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_availability"), imagingStudy.getAvailability());
        }
        if (jsonObject.has("url")) {
            imagingStudy.setUrl(this.parseUri(jsonObject.get("url").getAsString()));
        }
        if (jsonObject.has("_url")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_url"), imagingStudy.getUrl());
        }
        if (jsonObject.has("numberOfSeries")) {
            imagingStudy.setNumberOfSeries(this.parseInteger(jsonObject.get("numberOfSeries").getAsLong()));
        }
        if (jsonObject.has("_numberOfSeries")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_numberOfSeries"), imagingStudy.getNumberOfSeries());
        }
        if (jsonObject.has("numberOfInstances")) {
            imagingStudy.setNumberOfInstances(this.parseInteger(jsonObject.get("numberOfInstances").getAsLong()));
        }
        if (jsonObject.has("_numberOfInstances")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_numberOfInstances"), imagingStudy.getNumberOfInstances());
        }
        if (jsonObject.has("clinicalInformation")) {
            imagingStudy.setClinicalInformation(this.parseString(jsonObject.get("clinicalInformation").getAsString()));
        }
        if (jsonObject.has("_clinicalInformation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_clinicalInformation"), imagingStudy.getClinicalInformation());
        }
        if (jsonObject.has("procedure")) {
            jsonArray = jsonObject.getAsJsonArray("procedure");
            for (n = 0; n < jsonArray.size(); ++n) {
                imagingStudy.getProcedure().add(this.parseCoding(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("interpreter")) {
            imagingStudy.setInterpreter(this.parseResourceReference(jsonObject.getAsJsonObject("interpreter")));
        }
        if (jsonObject.has("description")) {
            imagingStudy.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), imagingStudy.getDescription());
        }
        if (jsonObject.has("series")) {
            jsonArray = jsonObject.getAsJsonArray("series");
            for (n = 0; n < jsonArray.size(); ++n) {
                imagingStudy.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(jsonArray.get(n).getAsJsonObject(), imagingStudy));
            }
        }
        return imagingStudy;
    }

    private ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(JsonObject jsonObject, ImagingStudy imagingStudy) throws Exception {
        ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseBackboneProperties(jsonObject, imagingStudySeriesComponent);
        if (jsonObject.has("number")) {
            imagingStudySeriesComponent.setNumber(this.parseInteger(jsonObject.get("number").getAsLong()));
        }
        if (jsonObject.has("_number")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_number"), imagingStudySeriesComponent.getNumber());
        }
        if (jsonObject.has("modality")) {
            imagingStudySeriesComponent.setModality(this.parseEnumeration(jsonObject.get("modality").getAsString(), ImagingStudy.Modality.Null, new ImagingStudy.ModalityEnumFactory()));
        }
        if (jsonObject.has("_modality")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_modality"), imagingStudySeriesComponent.getModality());
        }
        if (jsonObject.has("uid")) {
            imagingStudySeriesComponent.setUid(this.parseOid(jsonObject.get("uid").getAsString()));
        }
        if (jsonObject.has("_uid")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_uid"), imagingStudySeriesComponent.getUid());
        }
        if (jsonObject.has("description")) {
            imagingStudySeriesComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), imagingStudySeriesComponent.getDescription());
        }
        if (jsonObject.has("numberOfInstances")) {
            imagingStudySeriesComponent.setNumberOfInstances(this.parseInteger(jsonObject.get("numberOfInstances").getAsLong()));
        }
        if (jsonObject.has("_numberOfInstances")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_numberOfInstances"), imagingStudySeriesComponent.getNumberOfInstances());
        }
        if (jsonObject.has("availability")) {
            imagingStudySeriesComponent.setAvailability(this.parseEnumeration(jsonObject.get("availability").getAsString(), ImagingStudy.InstanceAvailability.Null, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        }
        if (jsonObject.has("_availability")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_availability"), imagingStudySeriesComponent.getAvailability());
        }
        if (jsonObject.has("url")) {
            imagingStudySeriesComponent.setUrl(this.parseUri(jsonObject.get("url").getAsString()));
        }
        if (jsonObject.has("_url")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_url"), imagingStudySeriesComponent.getUrl());
        }
        if (jsonObject.has("bodySite")) {
            imagingStudySeriesComponent.setBodySite(this.parseCoding(jsonObject.getAsJsonObject("bodySite")));
        }
        if (jsonObject.has("dateTime")) {
            imagingStudySeriesComponent.setDateTime(this.parseDateTime(jsonObject.get("dateTime").getAsString()));
        }
        if (jsonObject.has("_dateTime")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_dateTime"), imagingStudySeriesComponent.getDateTime());
        }
        if (jsonObject.has("instance")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("instance");
            for (int i = 0; i < jsonArray.size(); ++i) {
                imagingStudySeriesComponent.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(jsonArray.get(i).getAsJsonObject(), imagingStudy));
            }
        }
        return imagingStudySeriesComponent;
    }

    private ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(JsonObject jsonObject, ImagingStudy imagingStudy) throws Exception {
        ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseBackboneProperties(jsonObject, imagingStudySeriesInstanceComponent);
        if (jsonObject.has("number")) {
            imagingStudySeriesInstanceComponent.setNumber(this.parseInteger(jsonObject.get("number").getAsLong()));
        }
        if (jsonObject.has("_number")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_number"), imagingStudySeriesInstanceComponent.getNumber());
        }
        if (jsonObject.has("uid")) {
            imagingStudySeriesInstanceComponent.setUid(this.parseOid(jsonObject.get("uid").getAsString()));
        }
        if (jsonObject.has("_uid")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_uid"), imagingStudySeriesInstanceComponent.getUid());
        }
        if (jsonObject.has("sopclass")) {
            imagingStudySeriesInstanceComponent.setSopclass(this.parseOid(jsonObject.get("sopclass").getAsString()));
        }
        if (jsonObject.has("_sopclass")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_sopclass"), imagingStudySeriesInstanceComponent.getSopclass());
        }
        if (jsonObject.has("type")) {
            imagingStudySeriesInstanceComponent.setType(this.parseString(jsonObject.get("type").getAsString()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), imagingStudySeriesInstanceComponent.getType());
        }
        if (jsonObject.has("title")) {
            imagingStudySeriesInstanceComponent.setTitle(this.parseString(jsonObject.get("title").getAsString()));
        }
        if (jsonObject.has("_title")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_title"), imagingStudySeriesInstanceComponent.getTitle());
        }
        if (jsonObject.has("url")) {
            imagingStudySeriesInstanceComponent.setUrl(this.parseUri(jsonObject.get("url").getAsString()));
        }
        if (jsonObject.has("_url")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_url"), imagingStudySeriesInstanceComponent.getUrl());
        }
        if (jsonObject.has("attachment")) {
            imagingStudySeriesInstanceComponent.setAttachment(this.parseResourceReference(jsonObject.getAsJsonObject("attachment")));
        }
        return imagingStudySeriesInstanceComponent;
    }

    private Immunization parseImmunization(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Immunization immunization = new Immunization();
        this.parseResourceProperties(jsonObject, immunization);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunization.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("date")) {
            immunization.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), immunization.getDate());
        }
        if (jsonObject.has("vaccineType")) {
            immunization.setVaccineType(this.parseCodeableConcept(jsonObject.getAsJsonObject("vaccineType")));
        }
        if (jsonObject.has("subject")) {
            immunization.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("refusedIndicator")) {
            immunization.setRefusedIndicator(this.parseBoolean(jsonObject.get("refusedIndicator").getAsBoolean()));
        }
        if (jsonObject.has("_refusedIndicator")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_refusedIndicator"), immunization.getRefusedIndicator());
        }
        if (jsonObject.has("reported")) {
            immunization.setReported(this.parseBoolean(jsonObject.get("reported").getAsBoolean()));
        }
        if (jsonObject.has("_reported")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_reported"), immunization.getReported());
        }
        if (jsonObject.has("performer")) {
            immunization.setPerformer(this.parseResourceReference(jsonObject.getAsJsonObject("performer")));
        }
        if (jsonObject.has("requester")) {
            immunization.setRequester(this.parseResourceReference(jsonObject.getAsJsonObject("requester")));
        }
        if (jsonObject.has("manufacturer")) {
            immunization.setManufacturer(this.parseResourceReference(jsonObject.getAsJsonObject("manufacturer")));
        }
        if (jsonObject.has("location")) {
            immunization.setLocation(this.parseResourceReference(jsonObject.getAsJsonObject("location")));
        }
        if (jsonObject.has("lotNumber")) {
            immunization.setLotNumber(this.parseString(jsonObject.get("lotNumber").getAsString()));
        }
        if (jsonObject.has("_lotNumber")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_lotNumber"), immunization.getLotNumber());
        }
        if (jsonObject.has("expirationDate")) {
            immunization.setExpirationDate(this.parseDate(jsonObject.get("expirationDate").getAsString()));
        }
        if (jsonObject.has("_expirationDate")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_expirationDate"), immunization.getExpirationDate());
        }
        if (jsonObject.has("site")) {
            immunization.setSite(this.parseCodeableConcept(jsonObject.getAsJsonObject("site")));
        }
        if (jsonObject.has("route")) {
            immunization.setRoute(this.parseCodeableConcept(jsonObject.getAsJsonObject("route")));
        }
        if (jsonObject.has("doseQuantity")) {
            immunization.setDoseQuantity(this.parseQuantity(jsonObject.getAsJsonObject("doseQuantity")));
        }
        if (jsonObject.has("explanation")) {
            immunization.setExplanation(this.parseImmunizationImmunizationExplanationComponent(jsonObject.getAsJsonObject("explanation"), immunization));
        }
        if (jsonObject.has("reaction")) {
            jsonArray = jsonObject.getAsJsonArray("reaction");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunization.getReaction().add(this.parseImmunizationImmunizationReactionComponent(jsonArray.get(n).getAsJsonObject(), immunization));
            }
        }
        if (jsonObject.has("vaccinationProtocol")) {
            jsonArray = jsonObject.getAsJsonArray("vaccinationProtocol");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunization.getVaccinationProtocol().add(this.parseImmunizationImmunizationVaccinationProtocolComponent(jsonArray.get(n).getAsJsonObject(), immunization));
            }
        }
        return immunization;
    }

    private Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(JsonObject jsonObject, Immunization immunization) throws Exception {
        int n;
        JsonArray jsonArray;
        Immunization.ImmunizationExplanationComponent immunizationExplanationComponent = new Immunization.ImmunizationExplanationComponent();
        this.parseBackboneProperties(jsonObject, immunizationExplanationComponent);
        if (jsonObject.has("reason")) {
            jsonArray = jsonObject.getAsJsonArray("reason");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunizationExplanationComponent.getReason().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("refusalReason")) {
            jsonArray = jsonObject.getAsJsonArray("refusalReason");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunizationExplanationComponent.getRefusalReason().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return immunizationExplanationComponent;
    }

    private Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(JsonObject jsonObject, Immunization immunization) throws Exception {
        Immunization.ImmunizationReactionComponent immunizationReactionComponent = new Immunization.ImmunizationReactionComponent();
        this.parseBackboneProperties(jsonObject, immunizationReactionComponent);
        if (jsonObject.has("date")) {
            immunizationReactionComponent.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), immunizationReactionComponent.getDate());
        }
        if (jsonObject.has("detail")) {
            immunizationReactionComponent.setDetail(this.parseResourceReference(jsonObject.getAsJsonObject("detail")));
        }
        if (jsonObject.has("reported")) {
            immunizationReactionComponent.setReported(this.parseBoolean(jsonObject.get("reported").getAsBoolean()));
        }
        if (jsonObject.has("_reported")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_reported"), immunizationReactionComponent.getReported());
        }
        return immunizationReactionComponent;
    }

    private Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(JsonObject jsonObject, Immunization immunization) throws Exception {
        Immunization.ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent = new Immunization.ImmunizationVaccinationProtocolComponent();
        this.parseBackboneProperties(jsonObject, immunizationVaccinationProtocolComponent);
        if (jsonObject.has("doseSequence")) {
            immunizationVaccinationProtocolComponent.setDoseSequence(this.parseInteger(jsonObject.get("doseSequence").getAsLong()));
        }
        if (jsonObject.has("_doseSequence")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_doseSequence"), immunizationVaccinationProtocolComponent.getDoseSequence());
        }
        if (jsonObject.has("description")) {
            immunizationVaccinationProtocolComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), immunizationVaccinationProtocolComponent.getDescription());
        }
        if (jsonObject.has("authority")) {
            immunizationVaccinationProtocolComponent.setAuthority(this.parseResourceReference(jsonObject.getAsJsonObject("authority")));
        }
        if (jsonObject.has("series")) {
            immunizationVaccinationProtocolComponent.setSeries(this.parseString(jsonObject.get("series").getAsString()));
        }
        if (jsonObject.has("_series")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_series"), immunizationVaccinationProtocolComponent.getSeries());
        }
        if (jsonObject.has("seriesDoses")) {
            immunizationVaccinationProtocolComponent.setSeriesDoses(this.parseInteger(jsonObject.get("seriesDoses").getAsLong()));
        }
        if (jsonObject.has("_seriesDoses")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_seriesDoses"), immunizationVaccinationProtocolComponent.getSeriesDoses());
        }
        if (jsonObject.has("doseTarget")) {
            immunizationVaccinationProtocolComponent.setDoseTarget(this.parseCodeableConcept(jsonObject.getAsJsonObject("doseTarget")));
        }
        if (jsonObject.has("doseStatus")) {
            immunizationVaccinationProtocolComponent.setDoseStatus(this.parseCodeableConcept(jsonObject.getAsJsonObject("doseStatus")));
        }
        if (jsonObject.has("doseStatusReason")) {
            immunizationVaccinationProtocolComponent.setDoseStatusReason(this.parseCodeableConcept(jsonObject.getAsJsonObject("doseStatusReason")));
        }
        return immunizationVaccinationProtocolComponent;
    }

    private ImmunizationRecommendation parseImmunizationRecommendation(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        ImmunizationRecommendation immunizationRecommendation = new ImmunizationRecommendation();
        this.parseResourceProperties(jsonObject, immunizationRecommendation);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunizationRecommendation.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("subject")) {
            immunizationRecommendation.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("recommendation")) {
            jsonArray = jsonObject.getAsJsonArray("recommendation");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunizationRecommendation.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(jsonArray.get(n).getAsJsonObject(), immunizationRecommendation));
            }
        }
        return immunizationRecommendation;
    }

    private ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(JsonObject jsonObject, ImmunizationRecommendation immunizationRecommendation) throws Exception {
        int n;
        JsonArray jsonArray;
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseBackboneProperties(jsonObject, immunizationRecommendationRecommendationComponent);
        if (jsonObject.has("date")) {
            immunizationRecommendationRecommendationComponent.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), immunizationRecommendationRecommendationComponent.getDate());
        }
        if (jsonObject.has("vaccineType")) {
            immunizationRecommendationRecommendationComponent.setVaccineType(this.parseCodeableConcept(jsonObject.getAsJsonObject("vaccineType")));
        }
        if (jsonObject.has("doseNumber")) {
            immunizationRecommendationRecommendationComponent.setDoseNumber(this.parseInteger(jsonObject.get("doseNumber").getAsLong()));
        }
        if (jsonObject.has("_doseNumber")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_doseNumber"), immunizationRecommendationRecommendationComponent.getDoseNumber());
        }
        if (jsonObject.has("forecastStatus")) {
            immunizationRecommendationRecommendationComponent.setForecastStatus(this.parseCodeableConcept(jsonObject.getAsJsonObject("forecastStatus")));
        }
        if (jsonObject.has("dateCriterion")) {
            jsonArray = jsonObject.getAsJsonArray("dateCriterion");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunizationRecommendationRecommendationComponent.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(jsonArray.get(n).getAsJsonObject(), immunizationRecommendation));
            }
        }
        if (jsonObject.has("protocol")) {
            immunizationRecommendationRecommendationComponent.setProtocol(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(jsonObject.getAsJsonObject("protocol"), immunizationRecommendation));
        }
        if (jsonObject.has("supportingImmunization")) {
            jsonArray = jsonObject.getAsJsonArray("supportingImmunization");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunizationRecommendationRecommendationComponent.getSupportingImmunization().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("supportingPatientInformation")) {
            jsonArray = jsonObject.getAsJsonArray("supportingPatientInformation");
            for (n = 0; n < jsonArray.size(); ++n) {
                immunizationRecommendationRecommendationComponent.getSupportingPatientInformation().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return immunizationRecommendationRecommendationComponent;
    }

    private ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject jsonObject, ImmunizationRecommendation immunizationRecommendation) throws Exception {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseBackboneProperties(jsonObject, immunizationRecommendationRecommendationDateCriterionComponent);
        if (jsonObject.has("code")) {
            immunizationRecommendationRecommendationDateCriterionComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("value")) {
            immunizationRecommendationRecommendationDateCriterionComponent.setValue(this.parseDateTime(jsonObject.get("value").getAsString()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), immunizationRecommendationRecommendationDateCriterionComponent.getValue());
        }
        return immunizationRecommendationRecommendationDateCriterionComponent;
    }

    private ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(JsonObject jsonObject, ImmunizationRecommendation immunizationRecommendation) throws Exception {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent immunizationRecommendationRecommendationProtocolComponent = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
        this.parseBackboneProperties(jsonObject, immunizationRecommendationRecommendationProtocolComponent);
        if (jsonObject.has("doseSequence")) {
            immunizationRecommendationRecommendationProtocolComponent.setDoseSequence(this.parseInteger(jsonObject.get("doseSequence").getAsLong()));
        }
        if (jsonObject.has("_doseSequence")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_doseSequence"), immunizationRecommendationRecommendationProtocolComponent.getDoseSequence());
        }
        if (jsonObject.has("description")) {
            immunizationRecommendationRecommendationProtocolComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), immunizationRecommendationRecommendationProtocolComponent.getDescription());
        }
        if (jsonObject.has("authority")) {
            immunizationRecommendationRecommendationProtocolComponent.setAuthority(this.parseResourceReference(jsonObject.getAsJsonObject("authority")));
        }
        if (jsonObject.has("series")) {
            immunizationRecommendationRecommendationProtocolComponent.setSeries(this.parseString(jsonObject.get("series").getAsString()));
        }
        if (jsonObject.has("_series")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_series"), immunizationRecommendationRecommendationProtocolComponent.getSeries());
        }
        return immunizationRecommendationRecommendationProtocolComponent;
    }

    private List_ parseList_(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        List_ list_ = new List_();
        this.parseResourceProperties(jsonObject, list_);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                list_.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("code")) {
            list_.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("subject")) {
            list_.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("source")) {
            list_.setSource(this.parseResourceReference(jsonObject.getAsJsonObject("source")));
        }
        if (jsonObject.has("date")) {
            list_.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), list_.getDate());
        }
        if (jsonObject.has("ordered")) {
            list_.setOrdered(this.parseBoolean(jsonObject.get("ordered").getAsBoolean()));
        }
        if (jsonObject.has("_ordered")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_ordered"), list_.getOrdered());
        }
        if (jsonObject.has("mode")) {
            list_.setMode(this.parseEnumeration(jsonObject.get("mode").getAsString(), List_.ListMode.Null, new List_.ListModeEnumFactory()));
        }
        if (jsonObject.has("_mode")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_mode"), list_.getMode());
        }
        if (jsonObject.has("entry")) {
            jsonArray = jsonObject.getAsJsonArray("entry");
            for (n = 0; n < jsonArray.size(); ++n) {
                list_.getEntry().add(this.parseList_ListEntryComponent(jsonArray.get(n).getAsJsonObject(), list_));
            }
        }
        if (jsonObject.has("emptyReason")) {
            list_.setEmptyReason(this.parseCodeableConcept(jsonObject.getAsJsonObject("emptyReason")));
        }
        return list_;
    }

    private List_.ListEntryComponent parseList_ListEntryComponent(JsonObject jsonObject, List_ list_) throws Exception {
        List_.ListEntryComponent listEntryComponent = new List_.ListEntryComponent();
        this.parseBackboneProperties(jsonObject, listEntryComponent);
        if (jsonObject.has("flag")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("flag");
            for (int i = 0; i < jsonArray.size(); ++i) {
                listEntryComponent.getFlag().add(this.parseCodeableConcept(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("deleted")) {
            listEntryComponent.setDeleted(this.parseBoolean(jsonObject.get("deleted").getAsBoolean()));
        }
        if (jsonObject.has("_deleted")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_deleted"), listEntryComponent.getDeleted());
        }
        if (jsonObject.has("date")) {
            listEntryComponent.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), listEntryComponent.getDate());
        }
        if (jsonObject.has("item")) {
            listEntryComponent.setItem(this.parseResourceReference(jsonObject.getAsJsonObject("item")));
        }
        return listEntryComponent;
    }

    private Location parseLocation(JsonObject jsonObject) throws Exception {
        Location location = new Location();
        this.parseResourceProperties(jsonObject, location);
        if (jsonObject.has("identifier")) {
            location.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("name")) {
            location.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), location.getName());
        }
        if (jsonObject.has("description")) {
            location.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), location.getDescription());
        }
        if (jsonObject.has("type")) {
            location.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("telecom")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("telecom");
            for (int i = 0; i < jsonArray.size(); ++i) {
                location.getTelecom().add(this.parseContact(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("address")) {
            location.setAddress(this.parseAddress(jsonObject.getAsJsonObject("address")));
        }
        if (jsonObject.has("physicalType")) {
            location.setPhysicalType(this.parseCodeableConcept(jsonObject.getAsJsonObject("physicalType")));
        }
        if (jsonObject.has("position")) {
            location.setPosition(this.parseLocationLocationPositionComponent(jsonObject.getAsJsonObject("position"), location));
        }
        if (jsonObject.has("managingOrganization")) {
            location.setManagingOrganization(this.parseResourceReference(jsonObject.getAsJsonObject("managingOrganization")));
        }
        if (jsonObject.has("status")) {
            location.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Location.LocationStatus.Null, new Location.LocationStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), location.getStatus());
        }
        if (jsonObject.has("partOf")) {
            location.setPartOf(this.parseResourceReference(jsonObject.getAsJsonObject("partOf")));
        }
        if (jsonObject.has("mode")) {
            location.setMode(this.parseEnumeration(jsonObject.get("mode").getAsString(), Location.LocationMode.Null, new Location.LocationModeEnumFactory()));
        }
        if (jsonObject.has("_mode")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_mode"), location.getMode());
        }
        return location;
    }

    private Location.LocationPositionComponent parseLocationLocationPositionComponent(JsonObject jsonObject, Location location) throws Exception {
        Location.LocationPositionComponent locationPositionComponent = new Location.LocationPositionComponent();
        this.parseBackboneProperties(jsonObject, locationPositionComponent);
        if (jsonObject.has("longitude")) {
            locationPositionComponent.setLongitude(this.parseDecimal(jsonObject.get("longitude").getAsBigDecimal()));
        }
        if (jsonObject.has("_longitude")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_longitude"), locationPositionComponent.getLongitude());
        }
        if (jsonObject.has("latitude")) {
            locationPositionComponent.setLatitude(this.parseDecimal(jsonObject.get("latitude").getAsBigDecimal()));
        }
        if (jsonObject.has("_latitude")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_latitude"), locationPositionComponent.getLatitude());
        }
        if (jsonObject.has("altitude")) {
            locationPositionComponent.setAltitude(this.parseDecimal(jsonObject.get("altitude").getAsBigDecimal()));
        }
        if (jsonObject.has("_altitude")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_altitude"), locationPositionComponent.getAltitude());
        }
        return locationPositionComponent;
    }

    private Media parseMedia(JsonObject jsonObject) throws Exception {
        Media media = new Media();
        this.parseResourceProperties(jsonObject, media);
        if (jsonObject.has("type")) {
            media.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), Media.MediaType.Null, new Media.MediaTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), media.getType());
        }
        if (jsonObject.has("subtype")) {
            media.setSubtype(this.parseCodeableConcept(jsonObject.getAsJsonObject("subtype")));
        }
        if (jsonObject.has("identifier")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < jsonArray.size(); ++i) {
                media.getIdentifier().add(this.parseIdentifier(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("dateTime")) {
            media.setDateTime(this.parseDateTime(jsonObject.get("dateTime").getAsString()));
        }
        if (jsonObject.has("_dateTime")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_dateTime"), media.getDateTime());
        }
        if (jsonObject.has("subject")) {
            media.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("operator")) {
            media.setOperator(this.parseResourceReference(jsonObject.getAsJsonObject("operator")));
        }
        if (jsonObject.has("view")) {
            media.setView(this.parseCodeableConcept(jsonObject.getAsJsonObject("view")));
        }
        if (jsonObject.has("deviceName")) {
            media.setDeviceName(this.parseString(jsonObject.get("deviceName").getAsString()));
        }
        if (jsonObject.has("_deviceName")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_deviceName"), media.getDeviceName());
        }
        if (jsonObject.has("height")) {
            media.setHeight(this.parseInteger(jsonObject.get("height").getAsLong()));
        }
        if (jsonObject.has("_height")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_height"), media.getHeight());
        }
        if (jsonObject.has("width")) {
            media.setWidth(this.parseInteger(jsonObject.get("width").getAsLong()));
        }
        if (jsonObject.has("_width")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_width"), media.getWidth());
        }
        if (jsonObject.has("frames")) {
            media.setFrames(this.parseInteger(jsonObject.get("frames").getAsLong()));
        }
        if (jsonObject.has("_frames")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_frames"), media.getFrames());
        }
        if (jsonObject.has("length")) {
            media.setLength(this.parseInteger(jsonObject.get("length").getAsLong()));
        }
        if (jsonObject.has("_length")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_length"), media.getLength());
        }
        if (jsonObject.has("content")) {
            media.setContent(this.parseAttachment(jsonObject.getAsJsonObject("content")));
        }
        return media;
    }

    private Medication parseMedication(JsonObject jsonObject) throws Exception {
        Medication medication = new Medication();
        this.parseResourceProperties(jsonObject, medication);
        if (jsonObject.has("name")) {
            medication.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), medication.getName());
        }
        if (jsonObject.has("code")) {
            medication.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("isBrand")) {
            medication.setIsBrand(this.parseBoolean(jsonObject.get("isBrand").getAsBoolean()));
        }
        if (jsonObject.has("_isBrand")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_isBrand"), medication.getIsBrand());
        }
        if (jsonObject.has("manufacturer")) {
            medication.setManufacturer(this.parseResourceReference(jsonObject.getAsJsonObject("manufacturer")));
        }
        if (jsonObject.has("kind")) {
            medication.setKind(this.parseEnumeration(jsonObject.get("kind").getAsString(), Medication.MedicationKind.Null, new Medication.MedicationKindEnumFactory()));
        }
        if (jsonObject.has("_kind")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_kind"), medication.getKind());
        }
        if (jsonObject.has("product")) {
            medication.setProduct(this.parseMedicationMedicationProductComponent(jsonObject.getAsJsonObject("product"), medication));
        }
        if (jsonObject.has("package")) {
            medication.setPackage(this.parseMedicationMedicationPackageComponent(jsonObject.getAsJsonObject("package"), medication));
        }
        return medication;
    }

    private Medication.MedicationProductComponent parseMedicationMedicationProductComponent(JsonObject jsonObject, Medication medication) throws Exception {
        Medication.MedicationProductComponent medicationProductComponent = new Medication.MedicationProductComponent();
        this.parseBackboneProperties(jsonObject, medicationProductComponent);
        if (jsonObject.has("form")) {
            medicationProductComponent.setForm(this.parseCodeableConcept(jsonObject.getAsJsonObject("form")));
        }
        if (jsonObject.has("ingredient")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("ingredient");
            for (int i = 0; i < jsonArray.size(); ++i) {
                medicationProductComponent.getIngredient().add(this.parseMedicationMedicationProductIngredientComponent(jsonArray.get(i).getAsJsonObject(), medication));
            }
        }
        return medicationProductComponent;
    }

    private Medication.MedicationProductIngredientComponent parseMedicationMedicationProductIngredientComponent(JsonObject jsonObject, Medication medication) throws Exception {
        Medication.MedicationProductIngredientComponent medicationProductIngredientComponent = new Medication.MedicationProductIngredientComponent();
        this.parseBackboneProperties(jsonObject, medicationProductIngredientComponent);
        if (jsonObject.has("item")) {
            medicationProductIngredientComponent.setItem(this.parseResourceReference(jsonObject.getAsJsonObject("item")));
        }
        if (jsonObject.has("amount")) {
            medicationProductIngredientComponent.setAmount(this.parseRatio(jsonObject.getAsJsonObject("amount")));
        }
        return medicationProductIngredientComponent;
    }

    private Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(JsonObject jsonObject, Medication medication) throws Exception {
        Medication.MedicationPackageComponent medicationPackageComponent = new Medication.MedicationPackageComponent();
        this.parseBackboneProperties(jsonObject, medicationPackageComponent);
        if (jsonObject.has("container")) {
            medicationPackageComponent.setContainer(this.parseCodeableConcept(jsonObject.getAsJsonObject("container")));
        }
        if (jsonObject.has("content")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("content");
            for (int i = 0; i < jsonArray.size(); ++i) {
                medicationPackageComponent.getContent().add(this.parseMedicationMedicationPackageContentComponent(jsonArray.get(i).getAsJsonObject(), medication));
            }
        }
        return medicationPackageComponent;
    }

    private Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(JsonObject jsonObject, Medication medication) throws Exception {
        Medication.MedicationPackageContentComponent medicationPackageContentComponent = new Medication.MedicationPackageContentComponent();
        this.parseBackboneProperties(jsonObject, medicationPackageContentComponent);
        if (jsonObject.has("item")) {
            medicationPackageContentComponent.setItem(this.parseResourceReference(jsonObject.getAsJsonObject("item")));
        }
        if (jsonObject.has("amount")) {
            medicationPackageContentComponent.setAmount(this.parseQuantity(jsonObject.getAsJsonObject("amount")));
        }
        return medicationPackageContentComponent;
    }

    private MedicationAdministration parseMedicationAdministration(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        MedicationAdministration medicationAdministration = new MedicationAdministration();
        this.parseResourceProperties(jsonObject, medicationAdministration);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationAdministration.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("status")) {
            medicationAdministration.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), MedicationAdministration.MedicationAdminStatus.Null, new MedicationAdministration.MedicationAdminStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), medicationAdministration.getStatus());
        }
        if (jsonObject.has("patient")) {
            medicationAdministration.setPatient(this.parseResourceReference(jsonObject.getAsJsonObject("patient")));
        }
        if (jsonObject.has("practitioner")) {
            medicationAdministration.setPractitioner(this.parseResourceReference(jsonObject.getAsJsonObject("practitioner")));
        }
        if (jsonObject.has("encounter")) {
            medicationAdministration.setEncounter(this.parseResourceReference(jsonObject.getAsJsonObject("encounter")));
        }
        if (jsonObject.has("prescription")) {
            medicationAdministration.setPrescription(this.parseResourceReference(jsonObject.getAsJsonObject("prescription")));
        }
        if (jsonObject.has("wasNotGiven")) {
            medicationAdministration.setWasNotGiven(this.parseBoolean(jsonObject.get("wasNotGiven").getAsBoolean()));
        }
        if (jsonObject.has("_wasNotGiven")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_wasNotGiven"), medicationAdministration.getWasNotGiven());
        }
        if (jsonObject.has("reasonNotGiven")) {
            jsonArray = jsonObject.getAsJsonArray("reasonNotGiven");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationAdministration.getReasonNotGiven().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("whenGiven")) {
            medicationAdministration.setWhenGiven(this.parsePeriod(jsonObject.getAsJsonObject("whenGiven")));
        }
        if (jsonObject.has("medication")) {
            medicationAdministration.setMedication(this.parseResourceReference(jsonObject.getAsJsonObject("medication")));
        }
        if (jsonObject.has("device")) {
            jsonArray = jsonObject.getAsJsonArray("device");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationAdministration.getDevice().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("dosage")) {
            jsonArray = jsonObject.getAsJsonArray("dosage");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationAdministration.getDosage().add(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(jsonArray.get(n).getAsJsonObject(), medicationAdministration));
            }
        }
        return medicationAdministration;
    }

    private MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(JsonObject jsonObject, MedicationAdministration medicationAdministration) throws Exception {
        Type type;
        MedicationAdministration.MedicationAdministrationDosageComponent medicationAdministrationDosageComponent = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseBackboneProperties(jsonObject, medicationAdministrationDosageComponent);
        Type type2 = this.parseType("timing", jsonObject);
        if (type2 != null) {
            medicationAdministrationDosageComponent.setTiming(type2);
        }
        if ((type = this.parseType("asNeeded", jsonObject)) != null) {
            medicationAdministrationDosageComponent.setAsNeeded(type);
        }
        if (jsonObject.has("site")) {
            medicationAdministrationDosageComponent.setSite(this.parseCodeableConcept(jsonObject.getAsJsonObject("site")));
        }
        if (jsonObject.has("route")) {
            medicationAdministrationDosageComponent.setRoute(this.parseCodeableConcept(jsonObject.getAsJsonObject("route")));
        }
        if (jsonObject.has("method")) {
            medicationAdministrationDosageComponent.setMethod(this.parseCodeableConcept(jsonObject.getAsJsonObject("method")));
        }
        if (jsonObject.has("quantity")) {
            medicationAdministrationDosageComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("rate")) {
            medicationAdministrationDosageComponent.setRate(this.parseRatio(jsonObject.getAsJsonObject("rate")));
        }
        if (jsonObject.has("maxDosePerPeriod")) {
            medicationAdministrationDosageComponent.setMaxDosePerPeriod(this.parseRatio(jsonObject.getAsJsonObject("maxDosePerPeriod")));
        }
        return medicationAdministrationDosageComponent;
    }

    private MedicationDispense parseMedicationDispense(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        MedicationDispense medicationDispense = new MedicationDispense();
        this.parseResourceProperties(jsonObject, medicationDispense);
        if (jsonObject.has("identifier")) {
            medicationDispense.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("status")) {
            medicationDispense.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.Null, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), medicationDispense.getStatus());
        }
        if (jsonObject.has("patient")) {
            medicationDispense.setPatient(this.parseResourceReference(jsonObject.getAsJsonObject("patient")));
        }
        if (jsonObject.has("dispenser")) {
            medicationDispense.setDispenser(this.parseResourceReference(jsonObject.getAsJsonObject("dispenser")));
        }
        if (jsonObject.has("authorizingPrescription")) {
            jsonArray = jsonObject.getAsJsonArray("authorizingPrescription");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationDispense.getAuthorizingPrescription().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("dispense")) {
            jsonArray = jsonObject.getAsJsonArray("dispense");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationDispense.getDispense().add(this.parseMedicationDispenseMedicationDispenseDispenseComponent(jsonArray.get(n).getAsJsonObject(), medicationDispense));
            }
        }
        if (jsonObject.has("substitution")) {
            medicationDispense.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(jsonObject.getAsJsonObject("substitution"), medicationDispense));
        }
        return medicationDispense;
    }

    private MedicationDispense.MedicationDispenseDispenseComponent parseMedicationDispenseMedicationDispenseDispenseComponent(JsonObject jsonObject, MedicationDispense medicationDispense) throws Exception {
        int n;
        JsonArray jsonArray;
        MedicationDispense.MedicationDispenseDispenseComponent medicationDispenseDispenseComponent = new MedicationDispense.MedicationDispenseDispenseComponent();
        this.parseBackboneProperties(jsonObject, medicationDispenseDispenseComponent);
        if (jsonObject.has("identifier")) {
            medicationDispenseDispenseComponent.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("status")) {
            medicationDispenseDispenseComponent.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.Null, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), medicationDispenseDispenseComponent.getStatus());
        }
        if (jsonObject.has("type")) {
            medicationDispenseDispenseComponent.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("quantity")) {
            medicationDispenseDispenseComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("medication")) {
            medicationDispenseDispenseComponent.setMedication(this.parseResourceReference(jsonObject.getAsJsonObject("medication")));
        }
        if (jsonObject.has("whenPrepared")) {
            medicationDispenseDispenseComponent.setWhenPrepared(this.parseDateTime(jsonObject.get("whenPrepared").getAsString()));
        }
        if (jsonObject.has("_whenPrepared")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_whenPrepared"), medicationDispenseDispenseComponent.getWhenPrepared());
        }
        if (jsonObject.has("whenHandedOver")) {
            medicationDispenseDispenseComponent.setWhenHandedOver(this.parseDateTime(jsonObject.get("whenHandedOver").getAsString()));
        }
        if (jsonObject.has("_whenHandedOver")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_whenHandedOver"), medicationDispenseDispenseComponent.getWhenHandedOver());
        }
        if (jsonObject.has("destination")) {
            medicationDispenseDispenseComponent.setDestination(this.parseResourceReference(jsonObject.getAsJsonObject("destination")));
        }
        if (jsonObject.has("receiver")) {
            jsonArray = jsonObject.getAsJsonArray("receiver");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationDispenseDispenseComponent.getReceiver().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("dosage")) {
            jsonArray = jsonObject.getAsJsonArray("dosage");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationDispenseDispenseComponent.getDosage().add(this.parseMedicationDispenseMedicationDispenseDispenseDosageComponent(jsonArray.get(n).getAsJsonObject(), medicationDispense));
            }
        }
        return medicationDispenseDispenseComponent;
    }

    private MedicationDispense.MedicationDispenseDispenseDosageComponent parseMedicationDispenseMedicationDispenseDispenseDosageComponent(JsonObject jsonObject, MedicationDispense medicationDispense) throws Exception {
        Type type;
        Type type2;
        MedicationDispense.MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent = new MedicationDispense.MedicationDispenseDispenseDosageComponent();
        this.parseBackboneProperties(jsonObject, medicationDispenseDispenseDosageComponent);
        if (jsonObject.has("additionalInstructions")) {
            medicationDispenseDispenseDosageComponent.setAdditionalInstructions(this.parseCodeableConcept(jsonObject.getAsJsonObject("additionalInstructions")));
        }
        if ((type2 = this.parseType("timing", jsonObject)) != null) {
            medicationDispenseDispenseDosageComponent.setTiming(type2);
        }
        if ((type = this.parseType("asNeeded", jsonObject)) != null) {
            medicationDispenseDispenseDosageComponent.setAsNeeded(type);
        }
        if (jsonObject.has("site")) {
            medicationDispenseDispenseDosageComponent.setSite(this.parseCodeableConcept(jsonObject.getAsJsonObject("site")));
        }
        if (jsonObject.has("route")) {
            medicationDispenseDispenseDosageComponent.setRoute(this.parseCodeableConcept(jsonObject.getAsJsonObject("route")));
        }
        if (jsonObject.has("method")) {
            medicationDispenseDispenseDosageComponent.setMethod(this.parseCodeableConcept(jsonObject.getAsJsonObject("method")));
        }
        if (jsonObject.has("quantity")) {
            medicationDispenseDispenseDosageComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("rate")) {
            medicationDispenseDispenseDosageComponent.setRate(this.parseRatio(jsonObject.getAsJsonObject("rate")));
        }
        if (jsonObject.has("maxDosePerPeriod")) {
            medicationDispenseDispenseDosageComponent.setMaxDosePerPeriod(this.parseRatio(jsonObject.getAsJsonObject("maxDosePerPeriod")));
        }
        return medicationDispenseDispenseDosageComponent;
    }

    private MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(JsonObject jsonObject, MedicationDispense medicationDispense) throws Exception {
        int n;
        JsonArray jsonArray;
        MedicationDispense.MedicationDispenseSubstitutionComponent medicationDispenseSubstitutionComponent = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseBackboneProperties(jsonObject, medicationDispenseSubstitutionComponent);
        if (jsonObject.has("type")) {
            medicationDispenseSubstitutionComponent.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("reason")) {
            jsonArray = jsonObject.getAsJsonArray("reason");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationDispenseSubstitutionComponent.getReason().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("responsibleParty")) {
            jsonArray = jsonObject.getAsJsonArray("responsibleParty");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationDispenseSubstitutionComponent.getResponsibleParty().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return medicationDispenseSubstitutionComponent;
    }

    private MedicationPrescription parseMedicationPrescription(JsonObject jsonObject) throws Exception {
        Object object;
        MedicationPrescription medicationPrescription = new MedicationPrescription();
        this.parseResourceProperties(jsonObject, medicationPrescription);
        if (jsonObject.has("identifier")) {
            object = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < object.size(); ++i) {
                medicationPrescription.getIdentifier().add(this.parseIdentifier(object.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("dateWritten")) {
            medicationPrescription.setDateWritten(this.parseDateTime(jsonObject.get("dateWritten").getAsString()));
        }
        if (jsonObject.has("_dateWritten")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_dateWritten"), medicationPrescription.getDateWritten());
        }
        if (jsonObject.has("status")) {
            medicationPrescription.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), MedicationPrescription.MedicationPrescriptionStatus.Null, new MedicationPrescription.MedicationPrescriptionStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), medicationPrescription.getStatus());
        }
        if (jsonObject.has("patient")) {
            medicationPrescription.setPatient(this.parseResourceReference(jsonObject.getAsJsonObject("patient")));
        }
        if (jsonObject.has("prescriber")) {
            medicationPrescription.setPrescriber(this.parseResourceReference(jsonObject.getAsJsonObject("prescriber")));
        }
        if (jsonObject.has("encounter")) {
            medicationPrescription.setEncounter(this.parseResourceReference(jsonObject.getAsJsonObject("encounter")));
        }
        if ((object = this.parseType("reason", jsonObject)) != null) {
            medicationPrescription.setReason((Type)object);
        }
        if (jsonObject.has("medication")) {
            medicationPrescription.setMedication(this.parseResourceReference(jsonObject.getAsJsonObject("medication")));
        }
        if (jsonObject.has("dosageInstruction")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("dosageInstruction");
            for (int i = 0; i < jsonArray.size(); ++i) {
                medicationPrescription.getDosageInstruction().add(this.parseMedicationPrescriptionMedicationPrescriptionDosageInstructionComponent(jsonArray.get(i).getAsJsonObject(), medicationPrescription));
            }
        }
        if (jsonObject.has("dispense")) {
            medicationPrescription.setDispense(this.parseMedicationPrescriptionMedicationPrescriptionDispenseComponent(jsonObject.getAsJsonObject("dispense"), medicationPrescription));
        }
        if (jsonObject.has("substitution")) {
            medicationPrescription.setSubstitution(this.parseMedicationPrescriptionMedicationPrescriptionSubstitutionComponent(jsonObject.getAsJsonObject("substitution"), medicationPrescription));
        }
        return medicationPrescription;
    }

    private MedicationPrescription.MedicationPrescriptionDosageInstructionComponent parseMedicationPrescriptionMedicationPrescriptionDosageInstructionComponent(JsonObject jsonObject, MedicationPrescription medicationPrescription) throws Exception {
        Type type;
        Type type2;
        MedicationPrescription.MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent = new MedicationPrescription.MedicationPrescriptionDosageInstructionComponent();
        this.parseBackboneProperties(jsonObject, medicationPrescriptionDosageInstructionComponent);
        if (jsonObject.has("text")) {
            medicationPrescriptionDosageInstructionComponent.setText(this.parseString(jsonObject.get("text").getAsString()));
        }
        if (jsonObject.has("_text")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_text"), medicationPrescriptionDosageInstructionComponent.getText());
        }
        if (jsonObject.has("additionalInstructions")) {
            medicationPrescriptionDosageInstructionComponent.setAdditionalInstructions(this.parseCodeableConcept(jsonObject.getAsJsonObject("additionalInstructions")));
        }
        if ((type2 = this.parseType("timing", jsonObject)) != null) {
            medicationPrescriptionDosageInstructionComponent.setTiming(type2);
        }
        if ((type = this.parseType("asNeeded", jsonObject)) != null) {
            medicationPrescriptionDosageInstructionComponent.setAsNeeded(type);
        }
        if (jsonObject.has("site")) {
            medicationPrescriptionDosageInstructionComponent.setSite(this.parseCodeableConcept(jsonObject.getAsJsonObject("site")));
        }
        if (jsonObject.has("route")) {
            medicationPrescriptionDosageInstructionComponent.setRoute(this.parseCodeableConcept(jsonObject.getAsJsonObject("route")));
        }
        if (jsonObject.has("method")) {
            medicationPrescriptionDosageInstructionComponent.setMethod(this.parseCodeableConcept(jsonObject.getAsJsonObject("method")));
        }
        if (jsonObject.has("doseQuantity")) {
            medicationPrescriptionDosageInstructionComponent.setDoseQuantity(this.parseQuantity(jsonObject.getAsJsonObject("doseQuantity")));
        }
        if (jsonObject.has("rate")) {
            medicationPrescriptionDosageInstructionComponent.setRate(this.parseRatio(jsonObject.getAsJsonObject("rate")));
        }
        if (jsonObject.has("maxDosePerPeriod")) {
            medicationPrescriptionDosageInstructionComponent.setMaxDosePerPeriod(this.parseRatio(jsonObject.getAsJsonObject("maxDosePerPeriod")));
        }
        return medicationPrescriptionDosageInstructionComponent;
    }

    private MedicationPrescription.MedicationPrescriptionDispenseComponent parseMedicationPrescriptionMedicationPrescriptionDispenseComponent(JsonObject jsonObject, MedicationPrescription medicationPrescription) throws Exception {
        MedicationPrescription.MedicationPrescriptionDispenseComponent medicationPrescriptionDispenseComponent = new MedicationPrescription.MedicationPrescriptionDispenseComponent();
        this.parseBackboneProperties(jsonObject, medicationPrescriptionDispenseComponent);
        if (jsonObject.has("medication")) {
            medicationPrescriptionDispenseComponent.setMedication(this.parseResourceReference(jsonObject.getAsJsonObject("medication")));
        }
        if (jsonObject.has("validityPeriod")) {
            medicationPrescriptionDispenseComponent.setValidityPeriod(this.parsePeriod(jsonObject.getAsJsonObject("validityPeriod")));
        }
        if (jsonObject.has("numberOfRepeatsAllowed")) {
            medicationPrescriptionDispenseComponent.setNumberOfRepeatsAllowed(this.parseInteger(jsonObject.get("numberOfRepeatsAllowed").getAsLong()));
        }
        if (jsonObject.has("_numberOfRepeatsAllowed")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_numberOfRepeatsAllowed"), medicationPrescriptionDispenseComponent.getNumberOfRepeatsAllowed());
        }
        if (jsonObject.has("quantity")) {
            medicationPrescriptionDispenseComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("expectedSupplyDuration")) {
            medicationPrescriptionDispenseComponent.setExpectedSupplyDuration(this.parseDuration(jsonObject.getAsJsonObject("expectedSupplyDuration")));
        }
        return medicationPrescriptionDispenseComponent;
    }

    private MedicationPrescription.MedicationPrescriptionSubstitutionComponent parseMedicationPrescriptionMedicationPrescriptionSubstitutionComponent(JsonObject jsonObject, MedicationPrescription medicationPrescription) throws Exception {
        MedicationPrescription.MedicationPrescriptionSubstitutionComponent medicationPrescriptionSubstitutionComponent = new MedicationPrescription.MedicationPrescriptionSubstitutionComponent();
        this.parseBackboneProperties(jsonObject, medicationPrescriptionSubstitutionComponent);
        if (jsonObject.has("type")) {
            medicationPrescriptionSubstitutionComponent.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("reason")) {
            medicationPrescriptionSubstitutionComponent.setReason(this.parseCodeableConcept(jsonObject.getAsJsonObject("reason")));
        }
        return medicationPrescriptionSubstitutionComponent;
    }

    private MedicationStatement parseMedicationStatement(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        MedicationStatement medicationStatement = new MedicationStatement();
        this.parseResourceProperties(jsonObject, medicationStatement);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationStatement.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("patient")) {
            medicationStatement.setPatient(this.parseResourceReference(jsonObject.getAsJsonObject("patient")));
        }
        if (jsonObject.has("wasNotGiven")) {
            medicationStatement.setWasNotGiven(this.parseBoolean(jsonObject.get("wasNotGiven").getAsBoolean()));
        }
        if (jsonObject.has("_wasNotGiven")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_wasNotGiven"), medicationStatement.getWasNotGiven());
        }
        if (jsonObject.has("reasonNotGiven")) {
            jsonArray = jsonObject.getAsJsonArray("reasonNotGiven");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationStatement.getReasonNotGiven().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("whenGiven")) {
            medicationStatement.setWhenGiven(this.parsePeriod(jsonObject.getAsJsonObject("whenGiven")));
        }
        if (jsonObject.has("medication")) {
            medicationStatement.setMedication(this.parseResourceReference(jsonObject.getAsJsonObject("medication")));
        }
        if (jsonObject.has("device")) {
            jsonArray = jsonObject.getAsJsonArray("device");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationStatement.getDevice().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("dosage")) {
            jsonArray = jsonObject.getAsJsonArray("dosage");
            for (n = 0; n < jsonArray.size(); ++n) {
                medicationStatement.getDosage().add(this.parseMedicationStatementMedicationStatementDosageComponent(jsonArray.get(n).getAsJsonObject(), medicationStatement));
            }
        }
        return medicationStatement;
    }

    private MedicationStatement.MedicationStatementDosageComponent parseMedicationStatementMedicationStatementDosageComponent(JsonObject jsonObject, MedicationStatement medicationStatement) throws Exception {
        Type type;
        MedicationStatement.MedicationStatementDosageComponent medicationStatementDosageComponent = new MedicationStatement.MedicationStatementDosageComponent();
        this.parseBackboneProperties(jsonObject, medicationStatementDosageComponent);
        if (jsonObject.has("timing")) {
            medicationStatementDosageComponent.setTiming(this.parseSchedule(jsonObject.getAsJsonObject("timing")));
        }
        if ((type = this.parseType("asNeeded", jsonObject)) != null) {
            medicationStatementDosageComponent.setAsNeeded(type);
        }
        if (jsonObject.has("site")) {
            medicationStatementDosageComponent.setSite(this.parseCodeableConcept(jsonObject.getAsJsonObject("site")));
        }
        if (jsonObject.has("route")) {
            medicationStatementDosageComponent.setRoute(this.parseCodeableConcept(jsonObject.getAsJsonObject("route")));
        }
        if (jsonObject.has("method")) {
            medicationStatementDosageComponent.setMethod(this.parseCodeableConcept(jsonObject.getAsJsonObject("method")));
        }
        if (jsonObject.has("quantity")) {
            medicationStatementDosageComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("rate")) {
            medicationStatementDosageComponent.setRate(this.parseRatio(jsonObject.getAsJsonObject("rate")));
        }
        if (jsonObject.has("maxDosePerPeriod")) {
            medicationStatementDosageComponent.setMaxDosePerPeriod(this.parseRatio(jsonObject.getAsJsonObject("maxDosePerPeriod")));
        }
        return medicationStatementDosageComponent;
    }

    private MessageHeader parseMessageHeader(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        MessageHeader messageHeader = new MessageHeader();
        this.parseResourceProperties(jsonObject, messageHeader);
        if (jsonObject.has("identifier")) {
            messageHeader.setIdentifier(this.parseId(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), messageHeader.getIdentifier());
        }
        if (jsonObject.has("timestamp")) {
            messageHeader.setTimestamp(this.parseInstant(jsonObject.get("timestamp").getAsString()));
        }
        if (jsonObject.has("_timestamp")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_timestamp"), messageHeader.getTimestamp());
        }
        if (jsonObject.has("event")) {
            messageHeader.setEvent(this.parseCoding(jsonObject.getAsJsonObject("event")));
        }
        if (jsonObject.has("response")) {
            messageHeader.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(jsonObject.getAsJsonObject("response"), messageHeader));
        }
        if (jsonObject.has("source")) {
            messageHeader.setSource(this.parseMessageHeaderMessageSourceComponent(jsonObject.getAsJsonObject("source"), messageHeader));
        }
        if (jsonObject.has("destination")) {
            jsonArray = jsonObject.getAsJsonArray("destination");
            for (n = 0; n < jsonArray.size(); ++n) {
                messageHeader.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(jsonArray.get(n).getAsJsonObject(), messageHeader));
            }
        }
        if (jsonObject.has("enterer")) {
            messageHeader.setEnterer(this.parseResourceReference(jsonObject.getAsJsonObject("enterer")));
        }
        if (jsonObject.has("author")) {
            messageHeader.setAuthor(this.parseResourceReference(jsonObject.getAsJsonObject("author")));
        }
        if (jsonObject.has("receiver")) {
            messageHeader.setReceiver(this.parseResourceReference(jsonObject.getAsJsonObject("receiver")));
        }
        if (jsonObject.has("responsible")) {
            messageHeader.setResponsible(this.parseResourceReference(jsonObject.getAsJsonObject("responsible")));
        }
        if (jsonObject.has("reason")) {
            messageHeader.setReason(this.parseCodeableConcept(jsonObject.getAsJsonObject("reason")));
        }
        if (jsonObject.has("data")) {
            jsonArray = jsonObject.getAsJsonArray("data");
            for (n = 0; n < jsonArray.size(); ++n) {
                messageHeader.getData().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return messageHeader;
    }

    private MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(JsonObject jsonObject, MessageHeader messageHeader) throws Exception {
        MessageHeader.MessageHeaderResponseComponent messageHeaderResponseComponent = new MessageHeader.MessageHeaderResponseComponent();
        this.parseBackboneProperties(jsonObject, messageHeaderResponseComponent);
        if (jsonObject.has("identifier")) {
            messageHeaderResponseComponent.setIdentifier(this.parseId(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), messageHeaderResponseComponent.getIdentifier());
        }
        if (jsonObject.has("code")) {
            messageHeaderResponseComponent.setCode(this.parseEnumeration(jsonObject.get("code").getAsString(), MessageHeader.ResponseCode.Null, new MessageHeader.ResponseCodeEnumFactory()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), messageHeaderResponseComponent.getCode());
        }
        if (jsonObject.has("details")) {
            messageHeaderResponseComponent.setDetails(this.parseResourceReference(jsonObject.getAsJsonObject("details")));
        }
        return messageHeaderResponseComponent;
    }

    private MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject jsonObject, MessageHeader messageHeader) throws Exception {
        MessageHeader.MessageSourceComponent messageSourceComponent = new MessageHeader.MessageSourceComponent();
        this.parseBackboneProperties(jsonObject, messageSourceComponent);
        if (jsonObject.has("name")) {
            messageSourceComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), messageSourceComponent.getName());
        }
        if (jsonObject.has("software")) {
            messageSourceComponent.setSoftware(this.parseString(jsonObject.get("software").getAsString()));
        }
        if (jsonObject.has("_software")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_software"), messageSourceComponent.getSoftware());
        }
        if (jsonObject.has("version")) {
            messageSourceComponent.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), messageSourceComponent.getVersion());
        }
        if (jsonObject.has("contact")) {
            messageSourceComponent.setContact(this.parseContact(jsonObject.getAsJsonObject("contact")));
        }
        if (jsonObject.has("endpoint")) {
            messageSourceComponent.setEndpoint(this.parseUri(jsonObject.get("endpoint").getAsString()));
        }
        if (jsonObject.has("_endpoint")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_endpoint"), messageSourceComponent.getEndpoint());
        }
        return messageSourceComponent;
    }

    private MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject jsonObject, MessageHeader messageHeader) throws Exception {
        MessageHeader.MessageDestinationComponent messageDestinationComponent = new MessageHeader.MessageDestinationComponent();
        this.parseBackboneProperties(jsonObject, messageDestinationComponent);
        if (jsonObject.has("name")) {
            messageDestinationComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), messageDestinationComponent.getName());
        }
        if (jsonObject.has("target")) {
            messageDestinationComponent.setTarget(this.parseResourceReference(jsonObject.getAsJsonObject("target")));
        }
        if (jsonObject.has("endpoint")) {
            messageDestinationComponent.setEndpoint(this.parseUri(jsonObject.get("endpoint").getAsString()));
        }
        if (jsonObject.has("_endpoint")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_endpoint"), messageDestinationComponent.getEndpoint());
        }
        return messageDestinationComponent;
    }

    private Observation parseObservation(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Type type;
        Type type2;
        Observation observation = new Observation();
        this.parseResourceProperties(jsonObject, observation);
        if (jsonObject.has("name")) {
            observation.setName(this.parseCodeableConcept(jsonObject.getAsJsonObject("name")));
        }
        if ((type2 = this.parseType("value", jsonObject)) != null) {
            observation.setValue(type2);
        }
        if (jsonObject.has("interpretation")) {
            observation.setInterpretation(this.parseCodeableConcept(jsonObject.getAsJsonObject("interpretation")));
        }
        if (jsonObject.has("comments")) {
            observation.setComments(this.parseString(jsonObject.get("comments").getAsString()));
        }
        if (jsonObject.has("_comments")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comments"), observation.getComments());
        }
        if ((type = this.parseType("applies", jsonObject)) != null) {
            observation.setApplies(type);
        }
        if (jsonObject.has("issued")) {
            observation.setIssued(this.parseInstant(jsonObject.get("issued").getAsString()));
        }
        if (jsonObject.has("_issued")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_issued"), observation.getIssued());
        }
        if (jsonObject.has("status")) {
            observation.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Observation.ObservationStatus.Null, new Observation.ObservationStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), observation.getStatus());
        }
        if (jsonObject.has("reliability")) {
            observation.setReliability(this.parseEnumeration(jsonObject.get("reliability").getAsString(), Observation.ObservationReliability.Null, new Observation.ObservationReliabilityEnumFactory()));
        }
        if (jsonObject.has("_reliability")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_reliability"), observation.getReliability());
        }
        if (jsonObject.has("bodySite")) {
            observation.setBodySite(this.parseCodeableConcept(jsonObject.getAsJsonObject("bodySite")));
        }
        if (jsonObject.has("method")) {
            observation.setMethod(this.parseCodeableConcept(jsonObject.getAsJsonObject("method")));
        }
        if (jsonObject.has("identifier")) {
            observation.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("subject")) {
            observation.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("specimen")) {
            observation.setSpecimen(this.parseResourceReference(jsonObject.getAsJsonObject("specimen")));
        }
        if (jsonObject.has("performer")) {
            jsonArray = jsonObject.getAsJsonArray("performer");
            for (n = 0; n < jsonArray.size(); ++n) {
                observation.getPerformer().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("referenceRange")) {
            jsonArray = jsonObject.getAsJsonArray("referenceRange");
            for (n = 0; n < jsonArray.size(); ++n) {
                observation.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(jsonArray.get(n).getAsJsonObject(), observation));
            }
        }
        if (jsonObject.has("related")) {
            jsonArray = jsonObject.getAsJsonArray("related");
            for (n = 0; n < jsonArray.size(); ++n) {
                observation.getRelated().add(this.parseObservationObservationRelatedComponent(jsonArray.get(n).getAsJsonObject(), observation));
            }
        }
        return observation;
    }

    private Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(JsonObject jsonObject, Observation observation) throws Exception {
        Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent = new Observation.ObservationReferenceRangeComponent();
        this.parseBackboneProperties(jsonObject, observationReferenceRangeComponent);
        if (jsonObject.has("low")) {
            observationReferenceRangeComponent.setLow(this.parseQuantity(jsonObject.getAsJsonObject("low")));
        }
        if (jsonObject.has("high")) {
            observationReferenceRangeComponent.setHigh(this.parseQuantity(jsonObject.getAsJsonObject("high")));
        }
        if (jsonObject.has("meaning")) {
            observationReferenceRangeComponent.setMeaning(this.parseCodeableConcept(jsonObject.getAsJsonObject("meaning")));
        }
        if (jsonObject.has("age")) {
            observationReferenceRangeComponent.setAge(this.parseRange(jsonObject.getAsJsonObject("age")));
        }
        return observationReferenceRangeComponent;
    }

    private Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(JsonObject jsonObject, Observation observation) throws Exception {
        Observation.ObservationRelatedComponent observationRelatedComponent = new Observation.ObservationRelatedComponent();
        this.parseBackboneProperties(jsonObject, observationRelatedComponent);
        if (jsonObject.has("type")) {
            observationRelatedComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), Observation.ObservationRelationshiptypes.Null, new Observation.ObservationRelationshiptypesEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), observationRelatedComponent.getType());
        }
        if (jsonObject.has("target")) {
            observationRelatedComponent.setTarget(this.parseResourceReference(jsonObject.getAsJsonObject("target")));
        }
        return observationRelatedComponent;
    }

    private OperationOutcome parseOperationOutcome(JsonObject jsonObject) throws Exception {
        OperationOutcome operationOutcome = new OperationOutcome();
        this.parseResourceProperties(jsonObject, operationOutcome);
        if (jsonObject.has("issue")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("issue");
            for (int i = 0; i < jsonArray.size(); ++i) {
                operationOutcome.getIssue().add(this.parseOperationOutcomeOperationOutcomeIssueComponent(jsonArray.get(i).getAsJsonObject(), operationOutcome));
            }
        }
        return operationOutcome;
    }

    private OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(JsonObject jsonObject, OperationOutcome operationOutcome) throws Exception {
        int n;
        JsonArray jsonArray;
        OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent = new OperationOutcome.OperationOutcomeIssueComponent();
        this.parseBackboneProperties(jsonObject, operationOutcomeIssueComponent);
        if (jsonObject.has("severity")) {
            operationOutcomeIssueComponent.setSeverity(this.parseEnumeration(jsonObject.get("severity").getAsString(), OperationOutcome.IssueSeverity.Null, new OperationOutcome.IssueSeverityEnumFactory()));
        }
        if (jsonObject.has("_severity")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_severity"), operationOutcomeIssueComponent.getSeverity());
        }
        if (jsonObject.has("type")) {
            operationOutcomeIssueComponent.setType(this.parseCoding(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("details")) {
            operationOutcomeIssueComponent.setDetails(this.parseString(jsonObject.get("details").getAsString()));
        }
        if (jsonObject.has("_details")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_details"), operationOutcomeIssueComponent.getDetails());
        }
        if (jsonObject.has("location")) {
            jsonArray = jsonObject.getAsJsonArray("location");
            for (n = 0; n < jsonArray.size(); ++n) {
                operationOutcomeIssueComponent.getLocation().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_location")) {
            jsonArray = jsonObject.getAsJsonArray("_location");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == operationOutcomeIssueComponent.getLocation().size()) {
                    operationOutcomeIssueComponent.getLocation().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), operationOutcomeIssueComponent.getLocation().get(n));
            }
        }
        return operationOutcomeIssueComponent;
    }

    private Order parseOrder(JsonObject jsonObject) throws Exception {
        Object object;
        Order order = new Order();
        this.parseResourceProperties(jsonObject, order);
        if (jsonObject.has("identifier")) {
            object = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < object.size(); ++i) {
                order.getIdentifier().add(this.parseIdentifier(object.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("date")) {
            order.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), order.getDate());
        }
        if (jsonObject.has("subject")) {
            order.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("source")) {
            order.setSource(this.parseResourceReference(jsonObject.getAsJsonObject("source")));
        }
        if (jsonObject.has("target")) {
            order.setTarget(this.parseResourceReference(jsonObject.getAsJsonObject("target")));
        }
        if ((object = this.parseType("reason", jsonObject)) != null) {
            order.setReason((Type)object);
        }
        if (jsonObject.has("authority")) {
            order.setAuthority(this.parseResourceReference(jsonObject.getAsJsonObject("authority")));
        }
        if (jsonObject.has("when")) {
            order.setWhen(this.parseOrderOrderWhenComponent(jsonObject.getAsJsonObject("when"), order));
        }
        if (jsonObject.has("detail")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("detail");
            for (int i = 0; i < jsonArray.size(); ++i) {
                order.getDetail().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return order;
    }

    private Order.OrderWhenComponent parseOrderOrderWhenComponent(JsonObject jsonObject, Order order) throws Exception {
        Order.OrderWhenComponent orderWhenComponent = new Order.OrderWhenComponent();
        this.parseBackboneProperties(jsonObject, orderWhenComponent);
        if (jsonObject.has("code")) {
            orderWhenComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("schedule")) {
            orderWhenComponent.setSchedule(this.parseSchedule(jsonObject.getAsJsonObject("schedule")));
        }
        return orderWhenComponent;
    }

    private OrderResponse parseOrderResponse(JsonObject jsonObject) throws Exception {
        Object object;
        OrderResponse orderResponse = new OrderResponse();
        this.parseResourceProperties(jsonObject, orderResponse);
        if (jsonObject.has("identifier")) {
            object = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < object.size(); ++i) {
                orderResponse.getIdentifier().add(this.parseIdentifier(object.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("request")) {
            orderResponse.setRequest(this.parseResourceReference(jsonObject.getAsJsonObject("request")));
        }
        if (jsonObject.has("date")) {
            orderResponse.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), orderResponse.getDate());
        }
        if (jsonObject.has("who")) {
            orderResponse.setWho(this.parseResourceReference(jsonObject.getAsJsonObject("who")));
        }
        if ((object = this.parseType("authority", jsonObject)) != null) {
            orderResponse.setAuthority((Type)object);
        }
        if (jsonObject.has("code")) {
            orderResponse.setCode(this.parseEnumeration(jsonObject.get("code").getAsString(), OrderResponse.OrderOutcomeCode.Null, new OrderResponse.OrderOutcomeCodeEnumFactory()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), orderResponse.getCode());
        }
        if (jsonObject.has("description")) {
            orderResponse.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), orderResponse.getDescription());
        }
        if (jsonObject.has("fulfillment")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("fulfillment");
            for (int i = 0; i < jsonArray.size(); ++i) {
                orderResponse.getFulfillment().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return orderResponse;
    }

    private Organization parseOrganization(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Organization organization = new Organization();
        this.parseResourceProperties(jsonObject, organization);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                organization.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("name")) {
            organization.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), organization.getName());
        }
        if (jsonObject.has("type")) {
            organization.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("telecom")) {
            jsonArray = jsonObject.getAsJsonArray("telecom");
            for (n = 0; n < jsonArray.size(); ++n) {
                organization.getTelecom().add(this.parseContact(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("address")) {
            jsonArray = jsonObject.getAsJsonArray("address");
            for (n = 0; n < jsonArray.size(); ++n) {
                organization.getAddress().add(this.parseAddress(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("partOf")) {
            organization.setPartOf(this.parseResourceReference(jsonObject.getAsJsonObject("partOf")));
        }
        if (jsonObject.has("contact")) {
            jsonArray = jsonObject.getAsJsonArray("contact");
            for (n = 0; n < jsonArray.size(); ++n) {
                organization.getContact().add(this.parseOrganizationOrganizationContactComponent(jsonArray.get(n).getAsJsonObject(), organization));
            }
        }
        if (jsonObject.has("location")) {
            jsonArray = jsonObject.getAsJsonArray("location");
            for (n = 0; n < jsonArray.size(); ++n) {
                organization.getLocation().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("active")) {
            organization.setActive(this.parseBoolean(jsonObject.get("active").getAsBoolean()));
        }
        if (jsonObject.has("_active")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_active"), organization.getActive());
        }
        return organization;
    }

    private Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(JsonObject jsonObject, Organization organization) throws Exception {
        Organization.OrganizationContactComponent organizationContactComponent = new Organization.OrganizationContactComponent();
        this.parseBackboneProperties(jsonObject, organizationContactComponent);
        if (jsonObject.has("purpose")) {
            organizationContactComponent.setPurpose(this.parseCodeableConcept(jsonObject.getAsJsonObject("purpose")));
        }
        if (jsonObject.has("name")) {
            organizationContactComponent.setName(this.parseHumanName(jsonObject.getAsJsonObject("name")));
        }
        if (jsonObject.has("telecom")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("telecom");
            for (int i = 0; i < jsonArray.size(); ++i) {
                organizationContactComponent.getTelecom().add(this.parseContact(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("address")) {
            organizationContactComponent.setAddress(this.parseAddress(jsonObject.getAsJsonObject("address")));
        }
        if (jsonObject.has("gender")) {
            organizationContactComponent.setGender(this.parseCodeableConcept(jsonObject.getAsJsonObject("gender")));
        }
        return organizationContactComponent;
    }

    private Other parseOther(JsonObject jsonObject) throws Exception {
        Other other = new Other();
        this.parseResourceProperties(jsonObject, other);
        if (jsonObject.has("identifier")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < jsonArray.size(); ++i) {
                other.getIdentifier().add(this.parseIdentifier(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("code")) {
            other.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("subject")) {
            other.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("author")) {
            other.setAuthor(this.parseResourceReference(jsonObject.getAsJsonObject("author")));
        }
        if (jsonObject.has("created")) {
            other.setCreated(this.parseDate(jsonObject.get("created").getAsString()));
        }
        if (jsonObject.has("_created")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_created"), other.getCreated());
        }
        return other;
    }

    private Patient parsePatient(JsonObject jsonObject) throws Exception {
        int n;
        Type type;
        int n2;
        Object object;
        Patient patient = new Patient();
        this.parseResourceProperties(jsonObject, patient);
        if (jsonObject.has("identifier")) {
            object = jsonObject.getAsJsonArray("identifier");
            for (n2 = 0; n2 < object.size(); ++n2) {
                patient.getIdentifier().add(this.parseIdentifier(object.get(n2).getAsJsonObject()));
            }
        }
        if (jsonObject.has("name")) {
            object = jsonObject.getAsJsonArray("name");
            for (n2 = 0; n2 < object.size(); ++n2) {
                patient.getName().add(this.parseHumanName(object.get(n2).getAsJsonObject()));
            }
        }
        if (jsonObject.has("telecom")) {
            object = jsonObject.getAsJsonArray("telecom");
            for (n2 = 0; n2 < object.size(); ++n2) {
                patient.getTelecom().add(this.parseContact(object.get(n2).getAsJsonObject()));
            }
        }
        if (jsonObject.has("gender")) {
            patient.setGender(this.parseCodeableConcept(jsonObject.getAsJsonObject("gender")));
        }
        if (jsonObject.has("birthDate")) {
            patient.setBirthDate(this.parseDateTime(jsonObject.get("birthDate").getAsString()));
        }
        if (jsonObject.has("_birthDate")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_birthDate"), patient.getBirthDate());
        }
        if ((object = this.parseType("deceased", jsonObject)) != null) {
            patient.setDeceased((Type)object);
        }
        if (jsonObject.has("address")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("address");
            for (int i = 0; i < jsonArray.size(); ++i) {
                patient.getAddress().add(this.parseAddress(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("maritalStatus")) {
            patient.setMaritalStatus(this.parseCodeableConcept(jsonObject.getAsJsonObject("maritalStatus")));
        }
        if ((type = this.parseType("multipleBirth", jsonObject)) != null) {
            patient.setMultipleBirth(type);
        }
        if (jsonObject.has("photo")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("photo");
            for (n = 0; n < jsonArray.size(); ++n) {
                patient.getPhoto().add(this.parseAttachment(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("contact")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("contact");
            for (n = 0; n < jsonArray.size(); ++n) {
                patient.getContact().add(this.parsePatientContactComponent(jsonArray.get(n).getAsJsonObject(), patient));
            }
        }
        if (jsonObject.has("animal")) {
            patient.setAnimal(this.parsePatientAnimalComponent(jsonObject.getAsJsonObject("animal"), patient));
        }
        if (jsonObject.has("communication")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("communication");
            for (n = 0; n < jsonArray.size(); ++n) {
                patient.getCommunication().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("careProvider")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("careProvider");
            for (n = 0; n < jsonArray.size(); ++n) {
                patient.getCareProvider().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("managingOrganization")) {
            patient.setManagingOrganization(this.parseResourceReference(jsonObject.getAsJsonObject("managingOrganization")));
        }
        if (jsonObject.has("link")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("link");
            for (n = 0; n < jsonArray.size(); ++n) {
                patient.getLink().add(this.parsePatientPatientLinkComponent(jsonArray.get(n).getAsJsonObject(), patient));
            }
        }
        if (jsonObject.has("active")) {
            patient.setActive(this.parseBoolean(jsonObject.get("active").getAsBoolean()));
        }
        if (jsonObject.has("_active")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_active"), patient.getActive());
        }
        return patient;
    }

    private Patient.ContactComponent parsePatientContactComponent(JsonObject jsonObject, Patient patient) throws Exception {
        int n;
        JsonArray jsonArray;
        Patient.ContactComponent contactComponent = new Patient.ContactComponent();
        this.parseBackboneProperties(jsonObject, contactComponent);
        if (jsonObject.has("relationship")) {
            jsonArray = jsonObject.getAsJsonArray("relationship");
            for (n = 0; n < jsonArray.size(); ++n) {
                contactComponent.getRelationship().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("name")) {
            contactComponent.setName(this.parseHumanName(jsonObject.getAsJsonObject("name")));
        }
        if (jsonObject.has("telecom")) {
            jsonArray = jsonObject.getAsJsonArray("telecom");
            for (n = 0; n < jsonArray.size(); ++n) {
                contactComponent.getTelecom().add(this.parseContact(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("address")) {
            contactComponent.setAddress(this.parseAddress(jsonObject.getAsJsonObject("address")));
        }
        if (jsonObject.has("gender")) {
            contactComponent.setGender(this.parseCodeableConcept(jsonObject.getAsJsonObject("gender")));
        }
        if (jsonObject.has("organization")) {
            contactComponent.setOrganization(this.parseResourceReference(jsonObject.getAsJsonObject("organization")));
        }
        return contactComponent;
    }

    private Patient.AnimalComponent parsePatientAnimalComponent(JsonObject jsonObject, Patient patient) throws Exception {
        Patient.AnimalComponent animalComponent = new Patient.AnimalComponent();
        this.parseBackboneProperties(jsonObject, animalComponent);
        if (jsonObject.has("species")) {
            animalComponent.setSpecies(this.parseCodeableConcept(jsonObject.getAsJsonObject("species")));
        }
        if (jsonObject.has("breed")) {
            animalComponent.setBreed(this.parseCodeableConcept(jsonObject.getAsJsonObject("breed")));
        }
        if (jsonObject.has("genderStatus")) {
            animalComponent.setGenderStatus(this.parseCodeableConcept(jsonObject.getAsJsonObject("genderStatus")));
        }
        return animalComponent;
    }

    private Patient.PatientLinkComponent parsePatientPatientLinkComponent(JsonObject jsonObject, Patient patient) throws Exception {
        Patient.PatientLinkComponent patientLinkComponent = new Patient.PatientLinkComponent();
        this.parseBackboneProperties(jsonObject, patientLinkComponent);
        if (jsonObject.has("other")) {
            patientLinkComponent.setOther(this.parseResourceReference(jsonObject.getAsJsonObject("other")));
        }
        if (jsonObject.has("type")) {
            patientLinkComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), Patient.LinkType.Null, new Patient.LinkTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), patientLinkComponent.getType());
        }
        return patientLinkComponent;
    }

    private Practitioner parsePractitioner(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Practitioner practitioner = new Practitioner();
        this.parseResourceProperties(jsonObject, practitioner);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                practitioner.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("name")) {
            practitioner.setName(this.parseHumanName(jsonObject.getAsJsonObject("name")));
        }
        if (jsonObject.has("telecom")) {
            jsonArray = jsonObject.getAsJsonArray("telecom");
            for (n = 0; n < jsonArray.size(); ++n) {
                practitioner.getTelecom().add(this.parseContact(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("address")) {
            practitioner.setAddress(this.parseAddress(jsonObject.getAsJsonObject("address")));
        }
        if (jsonObject.has("gender")) {
            practitioner.setGender(this.parseCodeableConcept(jsonObject.getAsJsonObject("gender")));
        }
        if (jsonObject.has("birthDate")) {
            practitioner.setBirthDate(this.parseDateTime(jsonObject.get("birthDate").getAsString()));
        }
        if (jsonObject.has("_birthDate")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_birthDate"), practitioner.getBirthDate());
        }
        if (jsonObject.has("photo")) {
            jsonArray = jsonObject.getAsJsonArray("photo");
            for (n = 0; n < jsonArray.size(); ++n) {
                practitioner.getPhoto().add(this.parseAttachment(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("organization")) {
            practitioner.setOrganization(this.parseResourceReference(jsonObject.getAsJsonObject("organization")));
        }
        if (jsonObject.has("role")) {
            jsonArray = jsonObject.getAsJsonArray("role");
            for (n = 0; n < jsonArray.size(); ++n) {
                practitioner.getRole().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("specialty")) {
            jsonArray = jsonObject.getAsJsonArray("specialty");
            for (n = 0; n < jsonArray.size(); ++n) {
                practitioner.getSpecialty().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("period")) {
            practitioner.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("location")) {
            jsonArray = jsonObject.getAsJsonArray("location");
            for (n = 0; n < jsonArray.size(); ++n) {
                practitioner.getLocation().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("qualification")) {
            jsonArray = jsonObject.getAsJsonArray("qualification");
            for (n = 0; n < jsonArray.size(); ++n) {
                practitioner.getQualification().add(this.parsePractitionerPractitionerQualificationComponent(jsonArray.get(n).getAsJsonObject(), practitioner));
            }
        }
        if (jsonObject.has("communication")) {
            jsonArray = jsonObject.getAsJsonArray("communication");
            for (n = 0; n < jsonArray.size(); ++n) {
                practitioner.getCommunication().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return practitioner;
    }

    private Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(JsonObject jsonObject, Practitioner practitioner) throws Exception {
        Practitioner.PractitionerQualificationComponent practitionerQualificationComponent = new Practitioner.PractitionerQualificationComponent();
        this.parseBackboneProperties(jsonObject, practitionerQualificationComponent);
        if (jsonObject.has("code")) {
            practitionerQualificationComponent.setCode(this.parseCodeableConcept(jsonObject.getAsJsonObject("code")));
        }
        if (jsonObject.has("period")) {
            practitionerQualificationComponent.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("issuer")) {
            practitionerQualificationComponent.setIssuer(this.parseResourceReference(jsonObject.getAsJsonObject("issuer")));
        }
        return practitionerQualificationComponent;
    }

    private Procedure parseProcedure(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Procedure procedure = new Procedure();
        this.parseResourceProperties(jsonObject, procedure);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                procedure.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("subject")) {
            procedure.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("type")) {
            procedure.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("bodySite")) {
            jsonArray = jsonObject.getAsJsonArray("bodySite");
            for (n = 0; n < jsonArray.size(); ++n) {
                procedure.getBodySite().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("indication")) {
            jsonArray = jsonObject.getAsJsonArray("indication");
            for (n = 0; n < jsonArray.size(); ++n) {
                procedure.getIndication().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("performer")) {
            jsonArray = jsonObject.getAsJsonArray("performer");
            for (n = 0; n < jsonArray.size(); ++n) {
                procedure.getPerformer().add(this.parseProcedureProcedurePerformerComponent(jsonArray.get(n).getAsJsonObject(), procedure));
            }
        }
        if (jsonObject.has("date")) {
            procedure.setDate(this.parsePeriod(jsonObject.getAsJsonObject("date")));
        }
        if (jsonObject.has("encounter")) {
            procedure.setEncounter(this.parseResourceReference(jsonObject.getAsJsonObject("encounter")));
        }
        if (jsonObject.has("outcome")) {
            procedure.setOutcome(this.parseString(jsonObject.get("outcome").getAsString()));
        }
        if (jsonObject.has("_outcome")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_outcome"), procedure.getOutcome());
        }
        if (jsonObject.has("report")) {
            jsonArray = jsonObject.getAsJsonArray("report");
            for (n = 0; n < jsonArray.size(); ++n) {
                procedure.getReport().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("complication")) {
            jsonArray = jsonObject.getAsJsonArray("complication");
            for (n = 0; n < jsonArray.size(); ++n) {
                procedure.getComplication().add(this.parseCodeableConcept(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("followUp")) {
            procedure.setFollowUp(this.parseString(jsonObject.get("followUp").getAsString()));
        }
        if (jsonObject.has("_followUp")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_followUp"), procedure.getFollowUp());
        }
        if (jsonObject.has("relatedItem")) {
            jsonArray = jsonObject.getAsJsonArray("relatedItem");
            for (n = 0; n < jsonArray.size(); ++n) {
                procedure.getRelatedItem().add(this.parseProcedureProcedureRelatedItemComponent(jsonArray.get(n).getAsJsonObject(), procedure));
            }
        }
        if (jsonObject.has("notes")) {
            procedure.setNotes(this.parseString(jsonObject.get("notes").getAsString()));
        }
        if (jsonObject.has("_notes")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_notes"), procedure.getNotes());
        }
        return procedure;
    }

    private Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(JsonObject jsonObject, Procedure procedure) throws Exception {
        Procedure.ProcedurePerformerComponent procedurePerformerComponent = new Procedure.ProcedurePerformerComponent();
        this.parseBackboneProperties(jsonObject, procedurePerformerComponent);
        if (jsonObject.has("person")) {
            procedurePerformerComponent.setPerson(this.parseResourceReference(jsonObject.getAsJsonObject("person")));
        }
        if (jsonObject.has("role")) {
            procedurePerformerComponent.setRole(this.parseCodeableConcept(jsonObject.getAsJsonObject("role")));
        }
        return procedurePerformerComponent;
    }

    private Procedure.ProcedureRelatedItemComponent parseProcedureProcedureRelatedItemComponent(JsonObject jsonObject, Procedure procedure) throws Exception {
        Procedure.ProcedureRelatedItemComponent procedureRelatedItemComponent = new Procedure.ProcedureRelatedItemComponent();
        this.parseBackboneProperties(jsonObject, procedureRelatedItemComponent);
        if (jsonObject.has("type")) {
            procedureRelatedItemComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), Procedure.ProcedureRelationshipType.Null, new Procedure.ProcedureRelationshipTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), procedureRelatedItemComponent.getType());
        }
        if (jsonObject.has("target")) {
            procedureRelatedItemComponent.setTarget(this.parseResourceReference(jsonObject.getAsJsonObject("target")));
        }
        return procedureRelatedItemComponent;
    }

    private Profile parseProfile(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Profile profile = new Profile();
        this.parseResourceProperties(jsonObject, profile);
        if (jsonObject.has("identifier")) {
            profile.setIdentifier(this.parseString(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), profile.getIdentifier());
        }
        if (jsonObject.has("version")) {
            profile.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), profile.getVersion());
        }
        if (jsonObject.has("name")) {
            profile.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), profile.getName());
        }
        if (jsonObject.has("publisher")) {
            profile.setPublisher(this.parseString(jsonObject.get("publisher").getAsString()));
        }
        if (jsonObject.has("_publisher")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_publisher"), profile.getPublisher());
        }
        if (jsonObject.has("telecom")) {
            jsonArray = jsonObject.getAsJsonArray("telecom");
            for (n = 0; n < jsonArray.size(); ++n) {
                profile.getTelecom().add(this.parseContact(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("description")) {
            profile.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), profile.getDescription());
        }
        if (jsonObject.has("code")) {
            jsonArray = jsonObject.getAsJsonArray("code");
            for (n = 0; n < jsonArray.size(); ++n) {
                profile.getCode().add(this.parseCoding(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("status")) {
            profile.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Profile.ResourceProfileStatus.Null, new Profile.ResourceProfileStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), profile.getStatus());
        }
        if (jsonObject.has("experimental")) {
            profile.setExperimental(this.parseBoolean(jsonObject.get("experimental").getAsBoolean()));
        }
        if (jsonObject.has("_experimental")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_experimental"), profile.getExperimental());
        }
        if (jsonObject.has("date")) {
            profile.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), profile.getDate());
        }
        if (jsonObject.has("requirements")) {
            profile.setRequirements(this.parseString(jsonObject.get("requirements").getAsString()));
        }
        if (jsonObject.has("_requirements")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_requirements"), profile.getRequirements());
        }
        if (jsonObject.has("fhirVersion")) {
            profile.setFhirVersion(this.parseId(jsonObject.get("fhirVersion").getAsString()));
        }
        if (jsonObject.has("_fhirVersion")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_fhirVersion"), profile.getFhirVersion());
        }
        if (jsonObject.has("mapping")) {
            jsonArray = jsonObject.getAsJsonArray("mapping");
            for (n = 0; n < jsonArray.size(); ++n) {
                profile.getMapping().add(this.parseProfileProfileMappingComponent(jsonArray.get(n).getAsJsonObject(), profile));
            }
        }
        if (jsonObject.has("structure")) {
            jsonArray = jsonObject.getAsJsonArray("structure");
            for (n = 0; n < jsonArray.size(); ++n) {
                profile.getStructure().add(this.parseProfileProfileStructureComponent(jsonArray.get(n).getAsJsonObject(), profile));
            }
        }
        if (jsonObject.has("extensionDefn")) {
            jsonArray = jsonObject.getAsJsonArray("extensionDefn");
            for (n = 0; n < jsonArray.size(); ++n) {
                profile.getExtensionDefn().add(this.parseProfileProfileExtensionDefnComponent(jsonArray.get(n).getAsJsonObject(), profile));
            }
        }
        if (jsonObject.has("query")) {
            jsonArray = jsonObject.getAsJsonArray("query");
            for (n = 0; n < jsonArray.size(); ++n) {
                profile.getQuery().add(this.parseProfileProfileQueryComponent(jsonArray.get(n).getAsJsonObject(), profile));
            }
        }
        return profile;
    }

    private Profile.ProfileMappingComponent parseProfileProfileMappingComponent(JsonObject jsonObject, Profile profile) throws Exception {
        Profile.ProfileMappingComponent profileMappingComponent = new Profile.ProfileMappingComponent();
        this.parseBackboneProperties(jsonObject, profileMappingComponent);
        if (jsonObject.has("identity")) {
            profileMappingComponent.setIdentity(this.parseId(jsonObject.get("identity").getAsString()));
        }
        if (jsonObject.has("_identity")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identity"), profileMappingComponent.getIdentity());
        }
        if (jsonObject.has("uri")) {
            profileMappingComponent.setUri(this.parseUri(jsonObject.get("uri").getAsString()));
        }
        if (jsonObject.has("_uri")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_uri"), profileMappingComponent.getUri());
        }
        if (jsonObject.has("name")) {
            profileMappingComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), profileMappingComponent.getName());
        }
        if (jsonObject.has("comments")) {
            profileMappingComponent.setComments(this.parseString(jsonObject.get("comments").getAsString()));
        }
        if (jsonObject.has("_comments")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comments"), profileMappingComponent.getComments());
        }
        return profileMappingComponent;
    }

    private Profile.ProfileStructureComponent parseProfileProfileStructureComponent(JsonObject jsonObject, Profile profile) throws Exception {
        int n;
        JsonArray jsonArray;
        Profile.ProfileStructureComponent profileStructureComponent = new Profile.ProfileStructureComponent();
        this.parseBackboneProperties(jsonObject, profileStructureComponent);
        if (jsonObject.has("type")) {
            profileStructureComponent.setType(this.parseCode(jsonObject.get("type").getAsString()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), profileStructureComponent.getType());
        }
        if (jsonObject.has("name")) {
            profileStructureComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), profileStructureComponent.getName());
        }
        if (jsonObject.has("publish")) {
            profileStructureComponent.setPublish(this.parseBoolean(jsonObject.get("publish").getAsBoolean()));
        }
        if (jsonObject.has("_publish")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_publish"), profileStructureComponent.getPublish());
        }
        if (jsonObject.has("purpose")) {
            profileStructureComponent.setPurpose(this.parseString(jsonObject.get("purpose").getAsString()));
        }
        if (jsonObject.has("_purpose")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_purpose"), profileStructureComponent.getPurpose());
        }
        if (jsonObject.has("element")) {
            jsonArray = jsonObject.getAsJsonArray("element");
            for (n = 0; n < jsonArray.size(); ++n) {
                profileStructureComponent.getElement().add(this.parseProfileElementComponent(jsonArray.get(n).getAsJsonObject(), profile));
            }
        }
        if (jsonObject.has("searchParam")) {
            jsonArray = jsonObject.getAsJsonArray("searchParam");
            for (n = 0; n < jsonArray.size(); ++n) {
                profileStructureComponent.getSearchParam().add(this.parseProfileProfileStructureSearchParamComponent(jsonArray.get(n).getAsJsonObject(), profile));
            }
        }
        return profileStructureComponent;
    }

    private Profile.ElementComponent parseProfileElementComponent(JsonObject jsonObject, Profile profile) throws Exception {
        int n;
        JsonArray jsonArray;
        Profile.ElementComponent elementComponent = new Profile.ElementComponent();
        this.parseBackboneProperties(jsonObject, elementComponent);
        if (jsonObject.has("path")) {
            elementComponent.setPath(this.parseString(jsonObject.get("path").getAsString()));
        }
        if (jsonObject.has("_path")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_path"), elementComponent.getPath());
        }
        if (jsonObject.has("representation")) {
            jsonArray = jsonObject.getAsJsonArray("representation");
            for (n = 0; n < jsonArray.size(); ++n) {
                elementComponent.getRepresentation().add(this.parseEnumeration(jsonArray.get(n).getAsString(), Profile.PropertyRepresentation.Null, new Profile.PropertyRepresentationEnumFactory()));
            }
        }
        if (jsonObject.has("_representation")) {
            jsonArray = jsonObject.getAsJsonArray("_representation");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == elementComponent.getRepresentation().size()) {
                    elementComponent.getRepresentation().add(this.parseEnumeration(null, Profile.PropertyRepresentation.Null, new Profile.PropertyRepresentationEnumFactory()));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), elementComponent.getRepresentation().get(n));
            }
        }
        if (jsonObject.has("name")) {
            elementComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), elementComponent.getName());
        }
        if (jsonObject.has("slicing")) {
            elementComponent.setSlicing(this.parseProfileElementSlicingComponent(jsonObject.getAsJsonObject("slicing"), profile));
        }
        if (jsonObject.has("definition")) {
            elementComponent.setDefinition(this.parseProfileElementDefinitionComponent(jsonObject.getAsJsonObject("definition"), profile));
        }
        return elementComponent;
    }

    private Profile.ElementSlicingComponent parseProfileElementSlicingComponent(JsonObject jsonObject, Profile profile) throws Exception {
        Profile.ElementSlicingComponent elementSlicingComponent = new Profile.ElementSlicingComponent();
        this.parseBackboneProperties(jsonObject, elementSlicingComponent);
        if (jsonObject.has("discriminator")) {
            elementSlicingComponent.setDiscriminator(this.parseId(jsonObject.get("discriminator").getAsString()));
        }
        if (jsonObject.has("_discriminator")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_discriminator"), elementSlicingComponent.getDiscriminator());
        }
        if (jsonObject.has("ordered")) {
            elementSlicingComponent.setOrdered(this.parseBoolean(jsonObject.get("ordered").getAsBoolean()));
        }
        if (jsonObject.has("_ordered")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_ordered"), elementSlicingComponent.getOrdered());
        }
        if (jsonObject.has("rules")) {
            elementSlicingComponent.setRules(this.parseEnumeration(jsonObject.get("rules").getAsString(), Profile.ResourceSlicingRules.Null, new Profile.ResourceSlicingRulesEnumFactory()));
        }
        if (jsonObject.has("_rules")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_rules"), elementSlicingComponent.getRules());
        }
        return elementSlicingComponent;
    }

    private Profile.ElementDefinitionComponent parseProfileElementDefinitionComponent(JsonObject jsonObject, Profile profile) throws Exception {
        int n;
        JsonArray jsonArray;
        Type type;
        int n2;
        Object object;
        Profile.ElementDefinitionComponent elementDefinitionComponent = new Profile.ElementDefinitionComponent();
        this.parseBackboneProperties(jsonObject, elementDefinitionComponent);
        if (jsonObject.has("short")) {
            elementDefinitionComponent.setShort(this.parseString(jsonObject.get("short").getAsString()));
        }
        if (jsonObject.has("_short")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_short"), elementDefinitionComponent.getShort());
        }
        if (jsonObject.has("formal")) {
            elementDefinitionComponent.setFormal(this.parseString(jsonObject.get("formal").getAsString()));
        }
        if (jsonObject.has("_formal")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_formal"), elementDefinitionComponent.getFormal());
        }
        if (jsonObject.has("comments")) {
            elementDefinitionComponent.setComments(this.parseString(jsonObject.get("comments").getAsString()));
        }
        if (jsonObject.has("_comments")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_comments"), elementDefinitionComponent.getComments());
        }
        if (jsonObject.has("requirements")) {
            elementDefinitionComponent.setRequirements(this.parseString(jsonObject.get("requirements").getAsString()));
        }
        if (jsonObject.has("_requirements")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_requirements"), elementDefinitionComponent.getRequirements());
        }
        if (jsonObject.has("synonym")) {
            object = jsonObject.getAsJsonArray("synonym");
            for (n2 = 0; n2 < object.size(); ++n2) {
                elementDefinitionComponent.getSynonym().add(this.parseString(object.get(n2).getAsString()));
            }
        }
        if (jsonObject.has("_synonym")) {
            object = jsonObject.getAsJsonArray("_synonym");
            for (n2 = 0; n2 < object.size(); ++n2) {
                if (n2 == elementDefinitionComponent.getSynonym().size()) {
                    elementDefinitionComponent.getSynonym().add(this.parseString(null));
                }
                if (!(object.get(n2) instanceof JsonObject)) continue;
                this.parseElementProperties(object.get(n2).getAsJsonObject(), elementDefinitionComponent.getSynonym().get(n2));
            }
        }
        if (jsonObject.has("min")) {
            elementDefinitionComponent.setMin(this.parseInteger(jsonObject.get("min").getAsLong()));
        }
        if (jsonObject.has("_min")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_min"), elementDefinitionComponent.getMin());
        }
        if (jsonObject.has("max")) {
            elementDefinitionComponent.setMax(this.parseString(jsonObject.get("max").getAsString()));
        }
        if (jsonObject.has("_max")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_max"), elementDefinitionComponent.getMax());
        }
        if (jsonObject.has("type")) {
            object = jsonObject.getAsJsonArray("type");
            for (n2 = 0; n2 < object.size(); ++n2) {
                elementDefinitionComponent.getType().add(this.parseProfileTypeRefComponent(object.get(n2).getAsJsonObject(), profile));
            }
        }
        if (jsonObject.has("nameReference")) {
            elementDefinitionComponent.setNameReference(this.parseString(jsonObject.get("nameReference").getAsString()));
        }
        if (jsonObject.has("_nameReference")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_nameReference"), elementDefinitionComponent.getNameReference());
        }
        if ((object = this.parseType("value", jsonObject)) != null) {
            elementDefinitionComponent.setValue((Type)object);
        }
        if ((type = this.parseType("example", jsonObject)) != null) {
            elementDefinitionComponent.setExample(type);
        }
        if (jsonObject.has("maxLength")) {
            elementDefinitionComponent.setMaxLength(this.parseInteger(jsonObject.get("maxLength").getAsLong()));
        }
        if (jsonObject.has("_maxLength")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_maxLength"), elementDefinitionComponent.getMaxLength());
        }
        if (jsonObject.has("condition")) {
            jsonArray = jsonObject.getAsJsonArray("condition");
            for (n = 0; n < jsonArray.size(); ++n) {
                elementDefinitionComponent.getCondition().add(this.parseId(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_condition")) {
            jsonArray = jsonObject.getAsJsonArray("_condition");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == elementDefinitionComponent.getCondition().size()) {
                    elementDefinitionComponent.getCondition().add(this.parseId(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), elementDefinitionComponent.getCondition().get(n));
            }
        }
        if (jsonObject.has("constraint")) {
            jsonArray = jsonObject.getAsJsonArray("constraint");
            for (n = 0; n < jsonArray.size(); ++n) {
                elementDefinitionComponent.getConstraint().add(this.parseProfileElementDefinitionConstraintComponent(jsonArray.get(n).getAsJsonObject(), profile));
            }
        }
        if (jsonObject.has("mustSupport")) {
            elementDefinitionComponent.setMustSupport(this.parseBoolean(jsonObject.get("mustSupport").getAsBoolean()));
        }
        if (jsonObject.has("_mustSupport")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_mustSupport"), elementDefinitionComponent.getMustSupport());
        }
        if (jsonObject.has("isModifier")) {
            elementDefinitionComponent.setIsModifier(this.parseBoolean(jsonObject.get("isModifier").getAsBoolean()));
        }
        if (jsonObject.has("_isModifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_isModifier"), elementDefinitionComponent.getIsModifier());
        }
        if (jsonObject.has("binding")) {
            elementDefinitionComponent.setBinding(this.parseProfileElementDefinitionBindingComponent(jsonObject.getAsJsonObject("binding"), profile));
        }
        if (jsonObject.has("mapping")) {
            jsonArray = jsonObject.getAsJsonArray("mapping");
            for (n = 0; n < jsonArray.size(); ++n) {
                elementDefinitionComponent.getMapping().add(this.parseProfileElementDefinitionMappingComponent(jsonArray.get(n).getAsJsonObject(), profile));
            }
        }
        return elementDefinitionComponent;
    }

    private Profile.TypeRefComponent parseProfileTypeRefComponent(JsonObject jsonObject, Profile profile) throws Exception {
        int n;
        JsonArray jsonArray;
        Profile.TypeRefComponent typeRefComponent = new Profile.TypeRefComponent();
        this.parseBackboneProperties(jsonObject, typeRefComponent);
        if (jsonObject.has("code")) {
            typeRefComponent.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), typeRefComponent.getCode());
        }
        if (jsonObject.has("profile")) {
            typeRefComponent.setProfile(this.parseUri(jsonObject.get("profile").getAsString()));
        }
        if (jsonObject.has("_profile")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_profile"), typeRefComponent.getProfile());
        }
        if (jsonObject.has("aggregation")) {
            jsonArray = jsonObject.getAsJsonArray("aggregation");
            for (n = 0; n < jsonArray.size(); ++n) {
                typeRefComponent.getAggregation().add(this.parseEnumeration(jsonArray.get(n).getAsString(), Profile.ResourceAggregationMode.Null, new Profile.ResourceAggregationModeEnumFactory()));
            }
        }
        if (jsonObject.has("_aggregation")) {
            jsonArray = jsonObject.getAsJsonArray("_aggregation");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == typeRefComponent.getAggregation().size()) {
                    typeRefComponent.getAggregation().add(this.parseEnumeration(null, Profile.ResourceAggregationMode.Null, new Profile.ResourceAggregationModeEnumFactory()));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), typeRefComponent.getAggregation().get(n));
            }
        }
        return typeRefComponent;
    }

    private Profile.ElementDefinitionConstraintComponent parseProfileElementDefinitionConstraintComponent(JsonObject jsonObject, Profile profile) throws Exception {
        Profile.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent = new Profile.ElementDefinitionConstraintComponent();
        this.parseBackboneProperties(jsonObject, elementDefinitionConstraintComponent);
        if (jsonObject.has("key")) {
            elementDefinitionConstraintComponent.setKey(this.parseId(jsonObject.get("key").getAsString()));
        }
        if (jsonObject.has("_key")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_key"), elementDefinitionConstraintComponent.getKey());
        }
        if (jsonObject.has("name")) {
            elementDefinitionConstraintComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), elementDefinitionConstraintComponent.getName());
        }
        if (jsonObject.has("severity")) {
            elementDefinitionConstraintComponent.setSeverity(this.parseEnumeration(jsonObject.get("severity").getAsString(), Profile.ConstraintSeverity.Null, new Profile.ConstraintSeverityEnumFactory()));
        }
        if (jsonObject.has("_severity")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_severity"), elementDefinitionConstraintComponent.getSeverity());
        }
        if (jsonObject.has("human")) {
            elementDefinitionConstraintComponent.setHuman(this.parseString(jsonObject.get("human").getAsString()));
        }
        if (jsonObject.has("_human")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_human"), elementDefinitionConstraintComponent.getHuman());
        }
        if (jsonObject.has("xpath")) {
            elementDefinitionConstraintComponent.setXpath(this.parseString(jsonObject.get("xpath").getAsString()));
        }
        if (jsonObject.has("_xpath")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_xpath"), elementDefinitionConstraintComponent.getXpath());
        }
        return elementDefinitionConstraintComponent;
    }

    private Profile.ElementDefinitionBindingComponent parseProfileElementDefinitionBindingComponent(JsonObject jsonObject, Profile profile) throws Exception {
        Type type;
        Profile.ElementDefinitionBindingComponent elementDefinitionBindingComponent = new Profile.ElementDefinitionBindingComponent();
        this.parseBackboneProperties(jsonObject, elementDefinitionBindingComponent);
        if (jsonObject.has("name")) {
            elementDefinitionBindingComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), elementDefinitionBindingComponent.getName());
        }
        if (jsonObject.has("isExtensible")) {
            elementDefinitionBindingComponent.setIsExtensible(this.parseBoolean(jsonObject.get("isExtensible").getAsBoolean()));
        }
        if (jsonObject.has("_isExtensible")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_isExtensible"), elementDefinitionBindingComponent.getIsExtensible());
        }
        if (jsonObject.has("conformance")) {
            elementDefinitionBindingComponent.setConformance(this.parseEnumeration(jsonObject.get("conformance").getAsString(), Profile.BindingConformance.Null, new Profile.BindingConformanceEnumFactory()));
        }
        if (jsonObject.has("_conformance")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_conformance"), elementDefinitionBindingComponent.getConformance());
        }
        if (jsonObject.has("description")) {
            elementDefinitionBindingComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), elementDefinitionBindingComponent.getDescription());
        }
        if ((type = this.parseType("reference", jsonObject)) != null) {
            elementDefinitionBindingComponent.setReference(type);
        }
        return elementDefinitionBindingComponent;
    }

    private Profile.ElementDefinitionMappingComponent parseProfileElementDefinitionMappingComponent(JsonObject jsonObject, Profile profile) throws Exception {
        Profile.ElementDefinitionMappingComponent elementDefinitionMappingComponent = new Profile.ElementDefinitionMappingComponent();
        this.parseBackboneProperties(jsonObject, elementDefinitionMappingComponent);
        if (jsonObject.has("identity")) {
            elementDefinitionMappingComponent.setIdentity(this.parseId(jsonObject.get("identity").getAsString()));
        }
        if (jsonObject.has("_identity")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identity"), elementDefinitionMappingComponent.getIdentity());
        }
        if (jsonObject.has("map")) {
            elementDefinitionMappingComponent.setMap(this.parseString(jsonObject.get("map").getAsString()));
        }
        if (jsonObject.has("_map")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_map"), elementDefinitionMappingComponent.getMap());
        }
        return elementDefinitionMappingComponent;
    }

    private Profile.ProfileStructureSearchParamComponent parseProfileProfileStructureSearchParamComponent(JsonObject jsonObject, Profile profile) throws Exception {
        int n;
        JsonArray jsonArray;
        Profile.ProfileStructureSearchParamComponent profileStructureSearchParamComponent = new Profile.ProfileStructureSearchParamComponent();
        this.parseBackboneProperties(jsonObject, profileStructureSearchParamComponent);
        if (jsonObject.has("name")) {
            profileStructureSearchParamComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), profileStructureSearchParamComponent.getName());
        }
        if (jsonObject.has("type")) {
            profileStructureSearchParamComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), Profile.SearchParamType.Null, new Profile.SearchParamTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), profileStructureSearchParamComponent.getType());
        }
        if (jsonObject.has("documentation")) {
            profileStructureSearchParamComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), profileStructureSearchParamComponent.getDocumentation());
        }
        if (jsonObject.has("xpath")) {
            profileStructureSearchParamComponent.setXpath(this.parseString(jsonObject.get("xpath").getAsString()));
        }
        if (jsonObject.has("_xpath")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_xpath"), profileStructureSearchParamComponent.getXpath());
        }
        if (jsonObject.has("target")) {
            jsonArray = jsonObject.getAsJsonArray("target");
            for (n = 0; n < jsonArray.size(); ++n) {
                profileStructureSearchParamComponent.getTarget().add(this.parseCode(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_target")) {
            jsonArray = jsonObject.getAsJsonArray("_target");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == profileStructureSearchParamComponent.getTarget().size()) {
                    profileStructureSearchParamComponent.getTarget().add(this.parseCode(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), profileStructureSearchParamComponent.getTarget().get(n));
            }
        }
        return profileStructureSearchParamComponent;
    }

    private Profile.ProfileExtensionDefnComponent parseProfileProfileExtensionDefnComponent(JsonObject jsonObject, Profile profile) throws Exception {
        int n;
        JsonArray jsonArray;
        Profile.ProfileExtensionDefnComponent profileExtensionDefnComponent = new Profile.ProfileExtensionDefnComponent();
        this.parseBackboneProperties(jsonObject, profileExtensionDefnComponent);
        if (jsonObject.has("code")) {
            profileExtensionDefnComponent.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), profileExtensionDefnComponent.getCode());
        }
        if (jsonObject.has("display")) {
            profileExtensionDefnComponent.setDisplay(this.parseString(jsonObject.get("display").getAsString()));
        }
        if (jsonObject.has("_display")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_display"), profileExtensionDefnComponent.getDisplay());
        }
        if (jsonObject.has("contextType")) {
            profileExtensionDefnComponent.setContextType(this.parseEnumeration(jsonObject.get("contextType").getAsString(), Profile.ExtensionContext.Null, new Profile.ExtensionContextEnumFactory()));
        }
        if (jsonObject.has("_contextType")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_contextType"), profileExtensionDefnComponent.getContextType());
        }
        if (jsonObject.has("context")) {
            jsonArray = jsonObject.getAsJsonArray("context");
            for (n = 0; n < jsonArray.size(); ++n) {
                profileExtensionDefnComponent.getContext().add(this.parseString(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_context")) {
            jsonArray = jsonObject.getAsJsonArray("_context");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == profileExtensionDefnComponent.getContext().size()) {
                    profileExtensionDefnComponent.getContext().add(this.parseString(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), profileExtensionDefnComponent.getContext().get(n));
            }
        }
        if (jsonObject.has("definition")) {
            profileExtensionDefnComponent.setDefinition(this.parseProfileElementDefinitionComponent(jsonObject.getAsJsonObject("definition"), profile));
        }
        return profileExtensionDefnComponent;
    }

    private Profile.ProfileQueryComponent parseProfileProfileQueryComponent(JsonObject jsonObject, Profile profile) throws Exception {
        Profile.ProfileQueryComponent profileQueryComponent = new Profile.ProfileQueryComponent();
        this.parseBackboneProperties(jsonObject, profileQueryComponent);
        if (jsonObject.has("name")) {
            profileQueryComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), profileQueryComponent.getName());
        }
        if (jsonObject.has("documentation")) {
            profileQueryComponent.setDocumentation(this.parseString(jsonObject.get("documentation").getAsString()));
        }
        if (jsonObject.has("_documentation")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_documentation"), profileQueryComponent.getDocumentation());
        }
        if (jsonObject.has("parameter")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("parameter");
            for (int i = 0; i < jsonArray.size(); ++i) {
                profileQueryComponent.getParameter().add(this.parseProfileProfileStructureSearchParamComponent(jsonArray.get(i).getAsJsonObject(), profile));
            }
        }
        return profileQueryComponent;
    }

    private Provenance parseProvenance(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Provenance provenance = new Provenance();
        this.parseResourceProperties(jsonObject, provenance);
        if (jsonObject.has("target")) {
            jsonArray = jsonObject.getAsJsonArray("target");
            for (n = 0; n < jsonArray.size(); ++n) {
                provenance.getTarget().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("period")) {
            provenance.setPeriod(this.parsePeriod(jsonObject.getAsJsonObject("period")));
        }
        if (jsonObject.has("recorded")) {
            provenance.setRecorded(this.parseInstant(jsonObject.get("recorded").getAsString()));
        }
        if (jsonObject.has("_recorded")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_recorded"), provenance.getRecorded());
        }
        if (jsonObject.has("reason")) {
            provenance.setReason(this.parseCodeableConcept(jsonObject.getAsJsonObject("reason")));
        }
        if (jsonObject.has("location")) {
            provenance.setLocation(this.parseResourceReference(jsonObject.getAsJsonObject("location")));
        }
        if (jsonObject.has("policy")) {
            jsonArray = jsonObject.getAsJsonArray("policy");
            for (n = 0; n < jsonArray.size(); ++n) {
                provenance.getPolicy().add(this.parseUri(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_policy")) {
            jsonArray = jsonObject.getAsJsonArray("_policy");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == provenance.getPolicy().size()) {
                    provenance.getPolicy().add(this.parseUri(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), provenance.getPolicy().get(n));
            }
        }
        if (jsonObject.has("agent")) {
            jsonArray = jsonObject.getAsJsonArray("agent");
            for (n = 0; n < jsonArray.size(); ++n) {
                provenance.getAgent().add(this.parseProvenanceProvenanceAgentComponent(jsonArray.get(n).getAsJsonObject(), provenance));
            }
        }
        if (jsonObject.has("entity")) {
            jsonArray = jsonObject.getAsJsonArray("entity");
            for (n = 0; n < jsonArray.size(); ++n) {
                provenance.getEntity().add(this.parseProvenanceProvenanceEntityComponent(jsonArray.get(n).getAsJsonObject(), provenance));
            }
        }
        if (jsonObject.has("integritySignature")) {
            provenance.setIntegritySignature(this.parseString(jsonObject.get("integritySignature").getAsString()));
        }
        if (jsonObject.has("_integritySignature")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_integritySignature"), provenance.getIntegritySignature());
        }
        return provenance;
    }

    private Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(JsonObject jsonObject, Provenance provenance) throws Exception {
        Provenance.ProvenanceAgentComponent provenanceAgentComponent = new Provenance.ProvenanceAgentComponent();
        this.parseBackboneProperties(jsonObject, provenanceAgentComponent);
        if (jsonObject.has("role")) {
            provenanceAgentComponent.setRole(this.parseCoding(jsonObject.getAsJsonObject("role")));
        }
        if (jsonObject.has("type")) {
            provenanceAgentComponent.setType(this.parseCoding(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("reference")) {
            provenanceAgentComponent.setReference(this.parseUri(jsonObject.get("reference").getAsString()));
        }
        if (jsonObject.has("_reference")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_reference"), provenanceAgentComponent.getReference());
        }
        if (jsonObject.has("display")) {
            provenanceAgentComponent.setDisplay(this.parseString(jsonObject.get("display").getAsString()));
        }
        if (jsonObject.has("_display")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_display"), provenanceAgentComponent.getDisplay());
        }
        return provenanceAgentComponent;
    }

    private Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(JsonObject jsonObject, Provenance provenance) throws Exception {
        Provenance.ProvenanceEntityComponent provenanceEntityComponent = new Provenance.ProvenanceEntityComponent();
        this.parseBackboneProperties(jsonObject, provenanceEntityComponent);
        if (jsonObject.has("role")) {
            provenanceEntityComponent.setRole(this.parseEnumeration(jsonObject.get("role").getAsString(), Provenance.ProvenanceEntityRole.Null, new Provenance.ProvenanceEntityRoleEnumFactory()));
        }
        if (jsonObject.has("_role")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_role"), provenanceEntityComponent.getRole());
        }
        if (jsonObject.has("type")) {
            provenanceEntityComponent.setType(this.parseCoding(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("reference")) {
            provenanceEntityComponent.setReference(this.parseUri(jsonObject.get("reference").getAsString()));
        }
        if (jsonObject.has("_reference")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_reference"), provenanceEntityComponent.getReference());
        }
        if (jsonObject.has("display")) {
            provenanceEntityComponent.setDisplay(this.parseString(jsonObject.get("display").getAsString()));
        }
        if (jsonObject.has("_display")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_display"), provenanceEntityComponent.getDisplay());
        }
        if (jsonObject.has("agent")) {
            provenanceEntityComponent.setAgent(this.parseProvenanceProvenanceAgentComponent(jsonObject.getAsJsonObject("agent"), provenance));
        }
        return provenanceEntityComponent;
    }

    private Query parseQuery(JsonObject jsonObject) throws Exception {
        Query query = new Query();
        this.parseResourceProperties(jsonObject, query);
        if (jsonObject.has("identifier")) {
            query.setIdentifier(this.parseUri(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), query.getIdentifier());
        }
        if (jsonObject.has("parameter")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("parameter");
            for (int i = 0; i < jsonArray.size(); ++i) {
                query.getParameter().add(this.parseExtension(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("response")) {
            query.setResponse(this.parseQueryQueryResponseComponent(jsonObject.getAsJsonObject("response"), query));
        }
        return query;
    }

    private Query.QueryResponseComponent parseQueryQueryResponseComponent(JsonObject jsonObject, Query query) throws Exception {
        int n;
        JsonArray jsonArray;
        Query.QueryResponseComponent queryResponseComponent = new Query.QueryResponseComponent();
        this.parseBackboneProperties(jsonObject, queryResponseComponent);
        if (jsonObject.has("identifier")) {
            queryResponseComponent.setIdentifier(this.parseUri(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), queryResponseComponent.getIdentifier());
        }
        if (jsonObject.has("outcome")) {
            queryResponseComponent.setOutcome(this.parseEnumeration(jsonObject.get("outcome").getAsString(), Query.QueryOutcome.Null, new Query.QueryOutcomeEnumFactory()));
        }
        if (jsonObject.has("_outcome")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_outcome"), queryResponseComponent.getOutcome());
        }
        if (jsonObject.has("total")) {
            queryResponseComponent.setTotal(this.parseInteger(jsonObject.get("total").getAsLong()));
        }
        if (jsonObject.has("_total")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_total"), queryResponseComponent.getTotal());
        }
        if (jsonObject.has("parameter")) {
            jsonArray = jsonObject.getAsJsonArray("parameter");
            for (n = 0; n < jsonArray.size(); ++n) {
                queryResponseComponent.getParameter().add(this.parseExtension(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("first")) {
            jsonArray = jsonObject.getAsJsonArray("first");
            for (n = 0; n < jsonArray.size(); ++n) {
                queryResponseComponent.getFirst().add(this.parseExtension(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("previous")) {
            jsonArray = jsonObject.getAsJsonArray("previous");
            for (n = 0; n < jsonArray.size(); ++n) {
                queryResponseComponent.getPrevious().add(this.parseExtension(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("next")) {
            jsonArray = jsonObject.getAsJsonArray("next");
            for (n = 0; n < jsonArray.size(); ++n) {
                queryResponseComponent.getNext().add(this.parseExtension(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("last")) {
            jsonArray = jsonObject.getAsJsonArray("last");
            for (n = 0; n < jsonArray.size(); ++n) {
                queryResponseComponent.getLast().add(this.parseExtension(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("reference")) {
            jsonArray = jsonObject.getAsJsonArray("reference");
            for (n = 0; n < jsonArray.size(); ++n) {
                queryResponseComponent.getReference().add(this.parseResourceReference(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return queryResponseComponent;
    }

    private Questionnaire parseQuestionnaire(JsonObject jsonObject) throws Exception {
        Questionnaire questionnaire = new Questionnaire();
        this.parseResourceProperties(jsonObject, questionnaire);
        if (jsonObject.has("status")) {
            questionnaire.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Questionnaire.QuestionnaireStatus.Null, new Questionnaire.QuestionnaireStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), questionnaire.getStatus());
        }
        if (jsonObject.has("authored")) {
            questionnaire.setAuthored(this.parseDateTime(jsonObject.get("authored").getAsString()));
        }
        if (jsonObject.has("_authored")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_authored"), questionnaire.getAuthored());
        }
        if (jsonObject.has("subject")) {
            questionnaire.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("author")) {
            questionnaire.setAuthor(this.parseResourceReference(jsonObject.getAsJsonObject("author")));
        }
        if (jsonObject.has("source")) {
            questionnaire.setSource(this.parseResourceReference(jsonObject.getAsJsonObject("source")));
        }
        if (jsonObject.has("name")) {
            questionnaire.setName(this.parseCodeableConcept(jsonObject.getAsJsonObject("name")));
        }
        if (jsonObject.has("identifier")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < jsonArray.size(); ++i) {
                questionnaire.getIdentifier().add(this.parseIdentifier(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("encounter")) {
            questionnaire.setEncounter(this.parseResourceReference(jsonObject.getAsJsonObject("encounter")));
        }
        if (jsonObject.has("group")) {
            questionnaire.setGroup(this.parseQuestionnaireGroupComponent(jsonObject.getAsJsonObject("group"), questionnaire));
        }
        return questionnaire;
    }

    private Questionnaire.GroupComponent parseQuestionnaireGroupComponent(JsonObject jsonObject, Questionnaire questionnaire) throws Exception {
        int n;
        JsonArray jsonArray;
        Questionnaire.GroupComponent groupComponent = new Questionnaire.GroupComponent();
        this.parseBackboneProperties(jsonObject, groupComponent);
        if (jsonObject.has("name")) {
            groupComponent.setName(this.parseCodeableConcept(jsonObject.getAsJsonObject("name")));
        }
        if (jsonObject.has("header")) {
            groupComponent.setHeader(this.parseString(jsonObject.get("header").getAsString()));
        }
        if (jsonObject.has("_header")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_header"), groupComponent.getHeader());
        }
        if (jsonObject.has("text")) {
            groupComponent.setText(this.parseString(jsonObject.get("text").getAsString()));
        }
        if (jsonObject.has("_text")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_text"), groupComponent.getText());
        }
        if (jsonObject.has("subject")) {
            groupComponent.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("group")) {
            jsonArray = jsonObject.getAsJsonArray("group");
            for (n = 0; n < jsonArray.size(); ++n) {
                groupComponent.getGroup().add(this.parseQuestionnaireGroupComponent(jsonArray.get(n).getAsJsonObject(), questionnaire));
            }
        }
        if (jsonObject.has("question")) {
            jsonArray = jsonObject.getAsJsonArray("question");
            for (n = 0; n < jsonArray.size(); ++n) {
                groupComponent.getQuestion().add(this.parseQuestionnaireQuestionComponent(jsonArray.get(n).getAsJsonObject(), questionnaire));
            }
        }
        return groupComponent;
    }

    private Questionnaire.QuestionComponent parseQuestionnaireQuestionComponent(JsonObject jsonObject, Questionnaire questionnaire) throws Exception {
        Object object;
        Type type;
        Questionnaire.QuestionComponent questionComponent = new Questionnaire.QuestionComponent();
        this.parseBackboneProperties(jsonObject, questionComponent);
        if (jsonObject.has("name")) {
            questionComponent.setName(this.parseCodeableConcept(jsonObject.getAsJsonObject("name")));
        }
        if (jsonObject.has("text")) {
            questionComponent.setText(this.parseString(jsonObject.get("text").getAsString()));
        }
        if (jsonObject.has("_text")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_text"), questionComponent.getText());
        }
        if ((type = this.parseType("answer", jsonObject)) != null) {
            questionComponent.setAnswer(type);
        }
        if (jsonObject.has("choice")) {
            object = jsonObject.getAsJsonArray("choice");
            for (int i = 0; i < object.size(); ++i) {
                questionComponent.getChoice().add(this.parseCoding(object.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("options")) {
            questionComponent.setOptions(this.parseResourceReference(jsonObject.getAsJsonObject("options")));
        }
        if ((object = this.parseType("data", jsonObject)) != null) {
            questionComponent.setData((Type)object);
        }
        if (jsonObject.has("remarks")) {
            questionComponent.setRemarks(this.parseString(jsonObject.get("remarks").getAsString()));
        }
        if (jsonObject.has("_remarks")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_remarks"), questionComponent.getRemarks());
        }
        if (jsonObject.has("group")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("group");
            for (int i = 0; i < jsonArray.size(); ++i) {
                questionComponent.getGroup().add(this.parseQuestionnaireGroupComponent(jsonArray.get(i).getAsJsonObject(), questionnaire));
            }
        }
        return questionComponent;
    }

    private RelatedPerson parseRelatedPerson(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        RelatedPerson relatedPerson = new RelatedPerson();
        this.parseResourceProperties(jsonObject, relatedPerson);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                relatedPerson.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("patient")) {
            relatedPerson.setPatient(this.parseResourceReference(jsonObject.getAsJsonObject("patient")));
        }
        if (jsonObject.has("relationship")) {
            relatedPerson.setRelationship(this.parseCodeableConcept(jsonObject.getAsJsonObject("relationship")));
        }
        if (jsonObject.has("name")) {
            relatedPerson.setName(this.parseHumanName(jsonObject.getAsJsonObject("name")));
        }
        if (jsonObject.has("telecom")) {
            jsonArray = jsonObject.getAsJsonArray("telecom");
            for (n = 0; n < jsonArray.size(); ++n) {
                relatedPerson.getTelecom().add(this.parseContact(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("gender")) {
            relatedPerson.setGender(this.parseCodeableConcept(jsonObject.getAsJsonObject("gender")));
        }
        if (jsonObject.has("address")) {
            relatedPerson.setAddress(this.parseAddress(jsonObject.getAsJsonObject("address")));
        }
        if (jsonObject.has("photo")) {
            jsonArray = jsonObject.getAsJsonArray("photo");
            for (n = 0; n < jsonArray.size(); ++n) {
                relatedPerson.getPhoto().add(this.parseAttachment(jsonArray.get(n).getAsJsonObject()));
            }
        }
        return relatedPerson;
    }

    private SecurityEvent parseSecurityEvent(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        SecurityEvent securityEvent = new SecurityEvent();
        this.parseResourceProperties(jsonObject, securityEvent);
        if (jsonObject.has("event")) {
            securityEvent.setEvent(this.parseSecurityEventSecurityEventEventComponent(jsonObject.getAsJsonObject("event"), securityEvent));
        }
        if (jsonObject.has("participant")) {
            jsonArray = jsonObject.getAsJsonArray("participant");
            for (n = 0; n < jsonArray.size(); ++n) {
                securityEvent.getParticipant().add(this.parseSecurityEventSecurityEventParticipantComponent(jsonArray.get(n).getAsJsonObject(), securityEvent));
            }
        }
        if (jsonObject.has("source")) {
            securityEvent.setSource(this.parseSecurityEventSecurityEventSourceComponent(jsonObject.getAsJsonObject("source"), securityEvent));
        }
        if (jsonObject.has("object")) {
            jsonArray = jsonObject.getAsJsonArray("object");
            for (n = 0; n < jsonArray.size(); ++n) {
                securityEvent.getObject().add(this.parseSecurityEventSecurityEventObjectComponent(jsonArray.get(n).getAsJsonObject(), securityEvent));
            }
        }
        return securityEvent;
    }

    private SecurityEvent.SecurityEventEventComponent parseSecurityEventSecurityEventEventComponent(JsonObject jsonObject, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventEventComponent securityEventEventComponent = new SecurityEvent.SecurityEventEventComponent();
        this.parseBackboneProperties(jsonObject, securityEventEventComponent);
        if (jsonObject.has("type")) {
            securityEventEventComponent.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("subtype")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("subtype");
            for (int i = 0; i < jsonArray.size(); ++i) {
                securityEventEventComponent.getSubtype().add(this.parseCodeableConcept(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("action")) {
            securityEventEventComponent.setAction(this.parseEnumeration(jsonObject.get("action").getAsString(), SecurityEvent.SecurityEventAction.Null, new SecurityEvent.SecurityEventActionEnumFactory()));
        }
        if (jsonObject.has("_action")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_action"), securityEventEventComponent.getAction());
        }
        if (jsonObject.has("dateTime")) {
            securityEventEventComponent.setDateTime(this.parseInstant(jsonObject.get("dateTime").getAsString()));
        }
        if (jsonObject.has("_dateTime")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_dateTime"), securityEventEventComponent.getDateTime());
        }
        if (jsonObject.has("outcome")) {
            securityEventEventComponent.setOutcome(this.parseEnumeration(jsonObject.get("outcome").getAsString(), SecurityEvent.SecurityEventOutcome.Null, new SecurityEvent.SecurityEventOutcomeEnumFactory()));
        }
        if (jsonObject.has("_outcome")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_outcome"), securityEventEventComponent.getOutcome());
        }
        if (jsonObject.has("outcomeDesc")) {
            securityEventEventComponent.setOutcomeDesc(this.parseString(jsonObject.get("outcomeDesc").getAsString()));
        }
        if (jsonObject.has("_outcomeDesc")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_outcomeDesc"), securityEventEventComponent.getOutcomeDesc());
        }
        return securityEventEventComponent;
    }

    private SecurityEvent.SecurityEventParticipantComponent parseSecurityEventSecurityEventParticipantComponent(JsonObject jsonObject, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventParticipantComponent securityEventParticipantComponent = new SecurityEvent.SecurityEventParticipantComponent();
        this.parseBackboneProperties(jsonObject, securityEventParticipantComponent);
        if (jsonObject.has("role")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("role");
            for (int i = 0; i < jsonArray.size(); ++i) {
                securityEventParticipantComponent.getRole().add(this.parseCodeableConcept(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("reference")) {
            securityEventParticipantComponent.setReference(this.parseResourceReference(jsonObject.getAsJsonObject("reference")));
        }
        if (jsonObject.has("userId")) {
            securityEventParticipantComponent.setUserId(this.parseString(jsonObject.get("userId").getAsString()));
        }
        if (jsonObject.has("_userId")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_userId"), securityEventParticipantComponent.getUserId());
        }
        if (jsonObject.has("altId")) {
            securityEventParticipantComponent.setAltId(this.parseString(jsonObject.get("altId").getAsString()));
        }
        if (jsonObject.has("_altId")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_altId"), securityEventParticipantComponent.getAltId());
        }
        if (jsonObject.has("name")) {
            securityEventParticipantComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), securityEventParticipantComponent.getName());
        }
        if (jsonObject.has("requestor")) {
            securityEventParticipantComponent.setRequestor(this.parseBoolean(jsonObject.get("requestor").getAsBoolean()));
        }
        if (jsonObject.has("_requestor")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_requestor"), securityEventParticipantComponent.getRequestor());
        }
        if (jsonObject.has("media")) {
            securityEventParticipantComponent.setMedia(this.parseCoding(jsonObject.getAsJsonObject("media")));
        }
        if (jsonObject.has("network")) {
            securityEventParticipantComponent.setNetwork(this.parseSecurityEventSecurityEventParticipantNetworkComponent(jsonObject.getAsJsonObject("network"), securityEvent));
        }
        return securityEventParticipantComponent;
    }

    private SecurityEvent.SecurityEventParticipantNetworkComponent parseSecurityEventSecurityEventParticipantNetworkComponent(JsonObject jsonObject, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventParticipantNetworkComponent securityEventParticipantNetworkComponent = new SecurityEvent.SecurityEventParticipantNetworkComponent();
        this.parseBackboneProperties(jsonObject, securityEventParticipantNetworkComponent);
        if (jsonObject.has("identifier")) {
            securityEventParticipantNetworkComponent.setIdentifier(this.parseString(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), securityEventParticipantNetworkComponent.getIdentifier());
        }
        if (jsonObject.has("type")) {
            securityEventParticipantNetworkComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), SecurityEvent.NetworkType.Null, new SecurityEvent.NetworkTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), securityEventParticipantNetworkComponent.getType());
        }
        return securityEventParticipantNetworkComponent;
    }

    private SecurityEvent.SecurityEventSourceComponent parseSecurityEventSecurityEventSourceComponent(JsonObject jsonObject, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventSourceComponent securityEventSourceComponent = new SecurityEvent.SecurityEventSourceComponent();
        this.parseBackboneProperties(jsonObject, securityEventSourceComponent);
        if (jsonObject.has("site")) {
            securityEventSourceComponent.setSite(this.parseString(jsonObject.get("site").getAsString()));
        }
        if (jsonObject.has("_site")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_site"), securityEventSourceComponent.getSite());
        }
        if (jsonObject.has("identifier")) {
            securityEventSourceComponent.setIdentifier(this.parseString(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), securityEventSourceComponent.getIdentifier());
        }
        if (jsonObject.has("type")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("type");
            for (int i = 0; i < jsonArray.size(); ++i) {
                securityEventSourceComponent.getType().add(this.parseCoding(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return securityEventSourceComponent;
    }

    private SecurityEvent.SecurityEventObjectComponent parseSecurityEventSecurityEventObjectComponent(JsonObject jsonObject, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventObjectComponent securityEventObjectComponent = new SecurityEvent.SecurityEventObjectComponent();
        this.parseBackboneProperties(jsonObject, securityEventObjectComponent);
        if (jsonObject.has("identifier")) {
            securityEventObjectComponent.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("reference")) {
            securityEventObjectComponent.setReference(this.parseResourceReference(jsonObject.getAsJsonObject("reference")));
        }
        if (jsonObject.has("type")) {
            securityEventObjectComponent.setType(this.parseEnumeration(jsonObject.get("type").getAsString(), SecurityEvent.ObjectType.Null, new SecurityEvent.ObjectTypeEnumFactory()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), securityEventObjectComponent.getType());
        }
        if (jsonObject.has("role")) {
            securityEventObjectComponent.setRole(this.parseEnumeration(jsonObject.get("role").getAsString(), SecurityEvent.ObjectRole.Null, new SecurityEvent.ObjectRoleEnumFactory()));
        }
        if (jsonObject.has("_role")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_role"), securityEventObjectComponent.getRole());
        }
        if (jsonObject.has("lifecycle")) {
            securityEventObjectComponent.setLifecycle(this.parseEnumeration(jsonObject.get("lifecycle").getAsString(), SecurityEvent.ObjectLifecycle.Null, new SecurityEvent.ObjectLifecycleEnumFactory()));
        }
        if (jsonObject.has("_lifecycle")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_lifecycle"), securityEventObjectComponent.getLifecycle());
        }
        if (jsonObject.has("sensitivity")) {
            securityEventObjectComponent.setSensitivity(this.parseCodeableConcept(jsonObject.getAsJsonObject("sensitivity")));
        }
        if (jsonObject.has("name")) {
            securityEventObjectComponent.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), securityEventObjectComponent.getName());
        }
        if (jsonObject.has("description")) {
            securityEventObjectComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), securityEventObjectComponent.getDescription());
        }
        if (jsonObject.has("query")) {
            securityEventObjectComponent.setQuery(this.parseBase64Binary(jsonObject.get("query").getAsString()));
        }
        if (jsonObject.has("_query")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_query"), securityEventObjectComponent.getQuery());
        }
        if (jsonObject.has("detail")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("detail");
            for (int i = 0; i < jsonArray.size(); ++i) {
                securityEventObjectComponent.getDetail().add(this.parseSecurityEventSecurityEventObjectDetailComponent(jsonArray.get(i).getAsJsonObject(), securityEvent));
            }
        }
        return securityEventObjectComponent;
    }

    private SecurityEvent.SecurityEventObjectDetailComponent parseSecurityEventSecurityEventObjectDetailComponent(JsonObject jsonObject, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventObjectDetailComponent securityEventObjectDetailComponent = new SecurityEvent.SecurityEventObjectDetailComponent();
        this.parseBackboneProperties(jsonObject, securityEventObjectDetailComponent);
        if (jsonObject.has("type")) {
            securityEventObjectDetailComponent.setType(this.parseString(jsonObject.get("type").getAsString()));
        }
        if (jsonObject.has("_type")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_type"), securityEventObjectDetailComponent.getType());
        }
        if (jsonObject.has("value")) {
            securityEventObjectDetailComponent.setValue(this.parseBase64Binary(jsonObject.get("value").getAsString()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), securityEventObjectDetailComponent.getValue());
        }
        return securityEventObjectDetailComponent;
    }

    private Specimen parseSpecimen(JsonObject jsonObject) throws Exception {
        int n;
        JsonArray jsonArray;
        Specimen specimen = new Specimen();
        this.parseResourceProperties(jsonObject, specimen);
        if (jsonObject.has("identifier")) {
            jsonArray = jsonObject.getAsJsonArray("identifier");
            for (n = 0; n < jsonArray.size(); ++n) {
                specimen.getIdentifier().add(this.parseIdentifier(jsonArray.get(n).getAsJsonObject()));
            }
        }
        if (jsonObject.has("type")) {
            specimen.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("source")) {
            jsonArray = jsonObject.getAsJsonArray("source");
            for (n = 0; n < jsonArray.size(); ++n) {
                specimen.getSource().add(this.parseSpecimenSpecimenSourceComponent(jsonArray.get(n).getAsJsonObject(), specimen));
            }
        }
        if (jsonObject.has("subject")) {
            specimen.setSubject(this.parseResourceReference(jsonObject.getAsJsonObject("subject")));
        }
        if (jsonObject.has("accessionIdentifier")) {
            specimen.setAccessionIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("accessionIdentifier")));
        }
        if (jsonObject.has("receivedTime")) {
            specimen.setReceivedTime(this.parseDateTime(jsonObject.get("receivedTime").getAsString()));
        }
        if (jsonObject.has("_receivedTime")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_receivedTime"), specimen.getReceivedTime());
        }
        if (jsonObject.has("collection")) {
            specimen.setCollection(this.parseSpecimenSpecimenCollectionComponent(jsonObject.getAsJsonObject("collection"), specimen));
        }
        if (jsonObject.has("treatment")) {
            jsonArray = jsonObject.getAsJsonArray("treatment");
            for (n = 0; n < jsonArray.size(); ++n) {
                specimen.getTreatment().add(this.parseSpecimenSpecimenTreatmentComponent(jsonArray.get(n).getAsJsonObject(), specimen));
            }
        }
        if (jsonObject.has("container")) {
            jsonArray = jsonObject.getAsJsonArray("container");
            for (n = 0; n < jsonArray.size(); ++n) {
                specimen.getContainer().add(this.parseSpecimenSpecimenContainerComponent(jsonArray.get(n).getAsJsonObject(), specimen));
            }
        }
        return specimen;
    }

    private Specimen.SpecimenSourceComponent parseSpecimenSpecimenSourceComponent(JsonObject jsonObject, Specimen specimen) throws Exception {
        Specimen.SpecimenSourceComponent specimenSourceComponent = new Specimen.SpecimenSourceComponent();
        this.parseBackboneProperties(jsonObject, specimenSourceComponent);
        if (jsonObject.has("relationship")) {
            specimenSourceComponent.setRelationship(this.parseEnumeration(jsonObject.get("relationship").getAsString(), Specimen.HierarchicalRelationshipType.Null, new Specimen.HierarchicalRelationshipTypeEnumFactory()));
        }
        if (jsonObject.has("_relationship")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_relationship"), specimenSourceComponent.getRelationship());
        }
        if (jsonObject.has("target")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("target");
            for (int i = 0; i < jsonArray.size(); ++i) {
                specimenSourceComponent.getTarget().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return specimenSourceComponent;
    }

    private Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(JsonObject jsonObject, Specimen specimen) throws Exception {
        int n;
        Object object;
        Specimen.SpecimenCollectionComponent specimenCollectionComponent = new Specimen.SpecimenCollectionComponent();
        this.parseBackboneProperties(jsonObject, specimenCollectionComponent);
        if (jsonObject.has("collector")) {
            specimenCollectionComponent.setCollector(this.parseResourceReference(jsonObject.getAsJsonObject("collector")));
        }
        if (jsonObject.has("comment")) {
            object = jsonObject.getAsJsonArray("comment");
            for (n = 0; n < object.size(); ++n) {
                specimenCollectionComponent.getComment().add(this.parseString(object.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_comment")) {
            object = jsonObject.getAsJsonArray("_comment");
            for (n = 0; n < object.size(); ++n) {
                if (n == specimenCollectionComponent.getComment().size()) {
                    specimenCollectionComponent.getComment().add(this.parseString(null));
                }
                if (!(object.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(object.get(n).getAsJsonObject(), specimenCollectionComponent.getComment().get(n));
            }
        }
        if ((object = this.parseType("collected", jsonObject)) != null) {
            specimenCollectionComponent.setCollected((Type)object);
        }
        if (jsonObject.has("quantity")) {
            specimenCollectionComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("method")) {
            specimenCollectionComponent.setMethod(this.parseCodeableConcept(jsonObject.getAsJsonObject("method")));
        }
        if (jsonObject.has("sourceSite")) {
            specimenCollectionComponent.setSourceSite(this.parseCodeableConcept(jsonObject.getAsJsonObject("sourceSite")));
        }
        return specimenCollectionComponent;
    }

    private Specimen.SpecimenTreatmentComponent parseSpecimenSpecimenTreatmentComponent(JsonObject jsonObject, Specimen specimen) throws Exception {
        Specimen.SpecimenTreatmentComponent specimenTreatmentComponent = new Specimen.SpecimenTreatmentComponent();
        this.parseBackboneProperties(jsonObject, specimenTreatmentComponent);
        if (jsonObject.has("description")) {
            specimenTreatmentComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), specimenTreatmentComponent.getDescription());
        }
        if (jsonObject.has("procedure")) {
            specimenTreatmentComponent.setProcedure(this.parseCodeableConcept(jsonObject.getAsJsonObject("procedure")));
        }
        if (jsonObject.has("additive")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("additive");
            for (int i = 0; i < jsonArray.size(); ++i) {
                specimenTreatmentComponent.getAdditive().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return specimenTreatmentComponent;
    }

    private Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(JsonObject jsonObject, Specimen specimen) throws Exception {
        Specimen.SpecimenContainerComponent specimenContainerComponent = new Specimen.SpecimenContainerComponent();
        this.parseBackboneProperties(jsonObject, specimenContainerComponent);
        if (jsonObject.has("identifier")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("identifier");
            for (int i = 0; i < jsonArray.size(); ++i) {
                specimenContainerComponent.getIdentifier().add(this.parseIdentifier(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("description")) {
            specimenContainerComponent.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), specimenContainerComponent.getDescription());
        }
        if (jsonObject.has("type")) {
            specimenContainerComponent.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("capacity")) {
            specimenContainerComponent.setCapacity(this.parseQuantity(jsonObject.getAsJsonObject("capacity")));
        }
        if (jsonObject.has("specimenQuantity")) {
            specimenContainerComponent.setSpecimenQuantity(this.parseQuantity(jsonObject.getAsJsonObject("specimenQuantity")));
        }
        if (jsonObject.has("additive")) {
            specimenContainerComponent.setAdditive(this.parseResourceReference(jsonObject.getAsJsonObject("additive")));
        }
        return specimenContainerComponent;
    }

    private Substance parseSubstance(JsonObject jsonObject) throws Exception {
        Substance substance = new Substance();
        this.parseResourceProperties(jsonObject, substance);
        if (jsonObject.has("type")) {
            substance.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("description")) {
            substance.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), substance.getDescription());
        }
        if (jsonObject.has("instance")) {
            substance.setInstance(this.parseSubstanceSubstanceInstanceComponent(jsonObject.getAsJsonObject("instance"), substance));
        }
        if (jsonObject.has("ingredient")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("ingredient");
            for (int i = 0; i < jsonArray.size(); ++i) {
                substance.getIngredient().add(this.parseSubstanceSubstanceIngredientComponent(jsonArray.get(i).getAsJsonObject(), substance));
            }
        }
        return substance;
    }

    private Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(JsonObject jsonObject, Substance substance) throws Exception {
        Substance.SubstanceInstanceComponent substanceInstanceComponent = new Substance.SubstanceInstanceComponent();
        this.parseBackboneProperties(jsonObject, substanceInstanceComponent);
        if (jsonObject.has("identifier")) {
            substanceInstanceComponent.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("expiry")) {
            substanceInstanceComponent.setExpiry(this.parseDateTime(jsonObject.get("expiry").getAsString()));
        }
        if (jsonObject.has("_expiry")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_expiry"), substanceInstanceComponent.getExpiry());
        }
        if (jsonObject.has("quantity")) {
            substanceInstanceComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        return substanceInstanceComponent;
    }

    private Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(JsonObject jsonObject, Substance substance) throws Exception {
        Substance.SubstanceIngredientComponent substanceIngredientComponent = new Substance.SubstanceIngredientComponent();
        this.parseBackboneProperties(jsonObject, substanceIngredientComponent);
        if (jsonObject.has("quantity")) {
            substanceIngredientComponent.setQuantity(this.parseRatio(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("substance")) {
            substanceIngredientComponent.setSubstance(this.parseResourceReference(jsonObject.getAsJsonObject("substance")));
        }
        return substanceIngredientComponent;
    }

    private Supply parseSupply(JsonObject jsonObject) throws Exception {
        Supply supply = new Supply();
        this.parseResourceProperties(jsonObject, supply);
        if (jsonObject.has("kind")) {
            supply.setKind(this.parseCodeableConcept(jsonObject.getAsJsonObject("kind")));
        }
        if (jsonObject.has("identifier")) {
            supply.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("status")) {
            supply.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Supply.ValuesetSupplyStatus.Null, new Supply.ValuesetSupplyStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), supply.getStatus());
        }
        if (jsonObject.has("orderedItem")) {
            supply.setOrderedItem(this.parseResourceReference(jsonObject.getAsJsonObject("orderedItem")));
        }
        if (jsonObject.has("patient")) {
            supply.setPatient(this.parseResourceReference(jsonObject.getAsJsonObject("patient")));
        }
        if (jsonObject.has("dispense")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("dispense");
            for (int i = 0; i < jsonArray.size(); ++i) {
                supply.getDispense().add(this.parseSupplySupplyDispenseComponent(jsonArray.get(i).getAsJsonObject(), supply));
            }
        }
        return supply;
    }

    private Supply.SupplyDispenseComponent parseSupplySupplyDispenseComponent(JsonObject jsonObject, Supply supply) throws Exception {
        Supply.SupplyDispenseComponent supplyDispenseComponent = new Supply.SupplyDispenseComponent();
        this.parseBackboneProperties(jsonObject, supplyDispenseComponent);
        if (jsonObject.has("identifier")) {
            supplyDispenseComponent.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("status")) {
            supplyDispenseComponent.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), Supply.ValuesetSupplyDispenseStatus.Null, new Supply.ValuesetSupplyDispenseStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), supplyDispenseComponent.getStatus());
        }
        if (jsonObject.has("type")) {
            supplyDispenseComponent.setType(this.parseCodeableConcept(jsonObject.getAsJsonObject("type")));
        }
        if (jsonObject.has("quantity")) {
            supplyDispenseComponent.setQuantity(this.parseQuantity(jsonObject.getAsJsonObject("quantity")));
        }
        if (jsonObject.has("suppliedItem")) {
            supplyDispenseComponent.setSuppliedItem(this.parseResourceReference(jsonObject.getAsJsonObject("suppliedItem")));
        }
        if (jsonObject.has("supplier")) {
            supplyDispenseComponent.setSupplier(this.parseResourceReference(jsonObject.getAsJsonObject("supplier")));
        }
        if (jsonObject.has("whenPrepared")) {
            supplyDispenseComponent.setWhenPrepared(this.parsePeriod(jsonObject.getAsJsonObject("whenPrepared")));
        }
        if (jsonObject.has("whenHandedOver")) {
            supplyDispenseComponent.setWhenHandedOver(this.parsePeriod(jsonObject.getAsJsonObject("whenHandedOver")));
        }
        if (jsonObject.has("destination")) {
            supplyDispenseComponent.setDestination(this.parseResourceReference(jsonObject.getAsJsonObject("destination")));
        }
        if (jsonObject.has("receiver")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("receiver");
            for (int i = 0; i < jsonArray.size(); ++i) {
                supplyDispenseComponent.getReceiver().add(this.parseResourceReference(jsonArray.get(i).getAsJsonObject()));
            }
        }
        return supplyDispenseComponent;
    }

    private ValueSet parseValueSet(JsonObject jsonObject) throws Exception {
        ValueSet valueSet = new ValueSet();
        this.parseResourceProperties(jsonObject, valueSet);
        if (jsonObject.has("identifier")) {
            valueSet.setIdentifier(this.parseString(jsonObject.get("identifier").getAsString()));
        }
        if (jsonObject.has("_identifier")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_identifier"), valueSet.getIdentifier());
        }
        if (jsonObject.has("version")) {
            valueSet.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), valueSet.getVersion());
        }
        if (jsonObject.has("name")) {
            valueSet.setName(this.parseString(jsonObject.get("name").getAsString()));
        }
        if (jsonObject.has("_name")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_name"), valueSet.getName());
        }
        if (jsonObject.has("publisher")) {
            valueSet.setPublisher(this.parseString(jsonObject.get("publisher").getAsString()));
        }
        if (jsonObject.has("_publisher")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_publisher"), valueSet.getPublisher());
        }
        if (jsonObject.has("telecom")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("telecom");
            for (int i = 0; i < jsonArray.size(); ++i) {
                valueSet.getTelecom().add(this.parseContact(jsonArray.get(i).getAsJsonObject()));
            }
        }
        if (jsonObject.has("description")) {
            valueSet.setDescription(this.parseString(jsonObject.get("description").getAsString()));
        }
        if (jsonObject.has("_description")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_description"), valueSet.getDescription());
        }
        if (jsonObject.has("copyright")) {
            valueSet.setCopyright(this.parseString(jsonObject.get("copyright").getAsString()));
        }
        if (jsonObject.has("_copyright")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_copyright"), valueSet.getCopyright());
        }
        if (jsonObject.has("status")) {
            valueSet.setStatus(this.parseEnumeration(jsonObject.get("status").getAsString(), ValueSet.ValuesetStatus.Null, new ValueSet.ValuesetStatusEnumFactory()));
        }
        if (jsonObject.has("_status")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_status"), valueSet.getStatus());
        }
        if (jsonObject.has("experimental")) {
            valueSet.setExperimental(this.parseBoolean(jsonObject.get("experimental").getAsBoolean()));
        }
        if (jsonObject.has("_experimental")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_experimental"), valueSet.getExperimental());
        }
        if (jsonObject.has("extensible")) {
            valueSet.setExtensible(this.parseBoolean(jsonObject.get("extensible").getAsBoolean()));
        }
        if (jsonObject.has("_extensible")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_extensible"), valueSet.getExtensible());
        }
        if (jsonObject.has("date")) {
            valueSet.setDate(this.parseDateTime(jsonObject.get("date").getAsString()));
        }
        if (jsonObject.has("_date")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_date"), valueSet.getDate());
        }
        if (jsonObject.has("define")) {
            valueSet.setDefine(this.parseValueSetValueSetDefineComponent(jsonObject.getAsJsonObject("define"), valueSet));
        }
        if (jsonObject.has("compose")) {
            valueSet.setCompose(this.parseValueSetValueSetComposeComponent(jsonObject.getAsJsonObject("compose"), valueSet));
        }
        if (jsonObject.has("expansion")) {
            valueSet.setExpansion(this.parseValueSetValueSetExpansionComponent(jsonObject.getAsJsonObject("expansion"), valueSet));
        }
        return valueSet;
    }

    private ValueSet.ValueSetDefineComponent parseValueSetValueSetDefineComponent(JsonObject jsonObject, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetDefineComponent valueSetDefineComponent = new ValueSet.ValueSetDefineComponent();
        this.parseBackboneProperties(jsonObject, valueSetDefineComponent);
        if (jsonObject.has("system")) {
            valueSetDefineComponent.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), valueSetDefineComponent.getSystem());
        }
        if (jsonObject.has("version")) {
            valueSetDefineComponent.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), valueSetDefineComponent.getVersion());
        }
        if (jsonObject.has("caseSensitive")) {
            valueSetDefineComponent.setCaseSensitive(this.parseBoolean(jsonObject.get("caseSensitive").getAsBoolean()));
        }
        if (jsonObject.has("_caseSensitive")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_caseSensitive"), valueSetDefineComponent.getCaseSensitive());
        }
        if (jsonObject.has("concept")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("concept");
            for (int i = 0; i < jsonArray.size(); ++i) {
                valueSetDefineComponent.getConcept().add(this.parseValueSetValueSetDefineConceptComponent(jsonArray.get(i).getAsJsonObject(), valueSet));
            }
        }
        return valueSetDefineComponent;
    }

    private ValueSet.ValueSetDefineConceptComponent parseValueSetValueSetDefineConceptComponent(JsonObject jsonObject, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent = new ValueSet.ValueSetDefineConceptComponent();
        this.parseBackboneProperties(jsonObject, valueSetDefineConceptComponent);
        if (jsonObject.has("code")) {
            valueSetDefineConceptComponent.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), valueSetDefineConceptComponent.getCode());
        }
        if (jsonObject.has("abstract")) {
            valueSetDefineConceptComponent.setAbstract(this.parseBoolean(jsonObject.get("abstract").getAsBoolean()));
        }
        if (jsonObject.has("_abstract")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_abstract"), valueSetDefineConceptComponent.getAbstract());
        }
        if (jsonObject.has("display")) {
            valueSetDefineConceptComponent.setDisplay(this.parseString(jsonObject.get("display").getAsString()));
        }
        if (jsonObject.has("_display")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_display"), valueSetDefineConceptComponent.getDisplay());
        }
        if (jsonObject.has("definition")) {
            valueSetDefineConceptComponent.setDefinition(this.parseString(jsonObject.get("definition").getAsString()));
        }
        if (jsonObject.has("_definition")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_definition"), valueSetDefineConceptComponent.getDefinition());
        }
        if (jsonObject.has("concept")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("concept");
            for (int i = 0; i < jsonArray.size(); ++i) {
                valueSetDefineConceptComponent.getConcept().add(this.parseValueSetValueSetDefineConceptComponent(jsonArray.get(i).getAsJsonObject(), valueSet));
            }
        }
        return valueSetDefineConceptComponent;
    }

    private ValueSet.ValueSetComposeComponent parseValueSetValueSetComposeComponent(JsonObject jsonObject, ValueSet valueSet) throws Exception {
        int n;
        JsonArray jsonArray;
        ValueSet.ValueSetComposeComponent valueSetComposeComponent = new ValueSet.ValueSetComposeComponent();
        this.parseBackboneProperties(jsonObject, valueSetComposeComponent);
        if (jsonObject.has("import")) {
            jsonArray = jsonObject.getAsJsonArray("import");
            for (n = 0; n < jsonArray.size(); ++n) {
                valueSetComposeComponent.getImport().add(this.parseUri(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_import")) {
            jsonArray = jsonObject.getAsJsonArray("_import");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == valueSetComposeComponent.getImport().size()) {
                    valueSetComposeComponent.getImport().add(this.parseUri(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), valueSetComposeComponent.getImport().get(n));
            }
        }
        if (jsonObject.has("include")) {
            jsonArray = jsonObject.getAsJsonArray("include");
            for (n = 0; n < jsonArray.size(); ++n) {
                valueSetComposeComponent.getInclude().add(this.parseValueSetConceptSetComponent(jsonArray.get(n).getAsJsonObject(), valueSet));
            }
        }
        if (jsonObject.has("exclude")) {
            jsonArray = jsonObject.getAsJsonArray("exclude");
            for (n = 0; n < jsonArray.size(); ++n) {
                valueSetComposeComponent.getExclude().add(this.parseValueSetConceptSetComponent(jsonArray.get(n).getAsJsonObject(), valueSet));
            }
        }
        return valueSetComposeComponent;
    }

    private ValueSet.ConceptSetComponent parseValueSetConceptSetComponent(JsonObject jsonObject, ValueSet valueSet) throws Exception {
        int n;
        JsonArray jsonArray;
        ValueSet.ConceptSetComponent conceptSetComponent = new ValueSet.ConceptSetComponent();
        this.parseBackboneProperties(jsonObject, conceptSetComponent);
        if (jsonObject.has("system")) {
            conceptSetComponent.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), conceptSetComponent.getSystem());
        }
        if (jsonObject.has("version")) {
            conceptSetComponent.setVersion(this.parseString(jsonObject.get("version").getAsString()));
        }
        if (jsonObject.has("_version")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_version"), conceptSetComponent.getVersion());
        }
        if (jsonObject.has("code")) {
            jsonArray = jsonObject.getAsJsonArray("code");
            for (n = 0; n < jsonArray.size(); ++n) {
                conceptSetComponent.getCode().add(this.parseCode(jsonArray.get(n).getAsString()));
            }
        }
        if (jsonObject.has("_code")) {
            jsonArray = jsonObject.getAsJsonArray("_code");
            for (n = 0; n < jsonArray.size(); ++n) {
                if (n == conceptSetComponent.getCode().size()) {
                    conceptSetComponent.getCode().add(this.parseCode(null));
                }
                if (!(jsonArray.get(n) instanceof JsonObject)) continue;
                this.parseElementProperties(jsonArray.get(n).getAsJsonObject(), conceptSetComponent.getCode().get(n));
            }
        }
        if (jsonObject.has("filter")) {
            jsonArray = jsonObject.getAsJsonArray("filter");
            for (n = 0; n < jsonArray.size(); ++n) {
                conceptSetComponent.getFilter().add(this.parseValueSetConceptSetFilterComponent(jsonArray.get(n).getAsJsonObject(), valueSet));
            }
        }
        return conceptSetComponent;
    }

    private ValueSet.ConceptSetFilterComponent parseValueSetConceptSetFilterComponent(JsonObject jsonObject, ValueSet valueSet) throws Exception {
        ValueSet.ConceptSetFilterComponent conceptSetFilterComponent = new ValueSet.ConceptSetFilterComponent();
        this.parseBackboneProperties(jsonObject, conceptSetFilterComponent);
        if (jsonObject.has("property")) {
            conceptSetFilterComponent.setProperty(this.parseCode(jsonObject.get("property").getAsString()));
        }
        if (jsonObject.has("_property")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_property"), conceptSetFilterComponent.getProperty());
        }
        if (jsonObject.has("op")) {
            conceptSetFilterComponent.setOp(this.parseEnumeration(jsonObject.get("op").getAsString(), ValueSet.FilterOperator.Null, new ValueSet.FilterOperatorEnumFactory()));
        }
        if (jsonObject.has("_op")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_op"), conceptSetFilterComponent.getOp());
        }
        if (jsonObject.has("value")) {
            conceptSetFilterComponent.setValue(this.parseCode(jsonObject.get("value").getAsString()));
        }
        if (jsonObject.has("_value")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_value"), conceptSetFilterComponent.getValue());
        }
        return conceptSetFilterComponent;
    }

    private ValueSet.ValueSetExpansionComponent parseValueSetValueSetExpansionComponent(JsonObject jsonObject, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetExpansionComponent valueSetExpansionComponent = new ValueSet.ValueSetExpansionComponent();
        this.parseBackboneProperties(jsonObject, valueSetExpansionComponent);
        if (jsonObject.has("identifier")) {
            valueSetExpansionComponent.setIdentifier(this.parseIdentifier(jsonObject.getAsJsonObject("identifier")));
        }
        if (jsonObject.has("timestamp")) {
            valueSetExpansionComponent.setTimestamp(this.parseInstant(jsonObject.get("timestamp").getAsString()));
        }
        if (jsonObject.has("_timestamp")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_timestamp"), valueSetExpansionComponent.getTimestamp());
        }
        if (jsonObject.has("contains")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("contains");
            for (int i = 0; i < jsonArray.size(); ++i) {
                valueSetExpansionComponent.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(jsonArray.get(i).getAsJsonObject(), valueSet));
            }
        }
        return valueSetExpansionComponent;
    }

    private ValueSet.ValueSetExpansionContainsComponent parseValueSetValueSetExpansionContainsComponent(JsonObject jsonObject, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent = new ValueSet.ValueSetExpansionContainsComponent();
        this.parseBackboneProperties(jsonObject, valueSetExpansionContainsComponent);
        if (jsonObject.has("system")) {
            valueSetExpansionContainsComponent.setSystem(this.parseUri(jsonObject.get("system").getAsString()));
        }
        if (jsonObject.has("_system")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_system"), valueSetExpansionContainsComponent.getSystem());
        }
        if (jsonObject.has("code")) {
            valueSetExpansionContainsComponent.setCode(this.parseCode(jsonObject.get("code").getAsString()));
        }
        if (jsonObject.has("_code")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_code"), valueSetExpansionContainsComponent.getCode());
        }
        if (jsonObject.has("display")) {
            valueSetExpansionContainsComponent.setDisplay(this.parseString(jsonObject.get("display").getAsString()));
        }
        if (jsonObject.has("_display")) {
            this.parseElementProperties(jsonObject.getAsJsonObject("_display"), valueSetExpansionContainsComponent.getDisplay());
        }
        if (jsonObject.has("contains")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("contains");
            for (int i = 0; i < jsonArray.size(); ++i) {
                valueSetExpansionContainsComponent.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(jsonArray.get(i).getAsJsonObject(), valueSet));
            }
        }
        return valueSetExpansionContainsComponent;
    }

    @Override
    protected Resource parseResource(JsonObject jsonObject) throws Exception {
        String string = jsonObject.get("resourceType").getAsString();
        if (Utilities.noString(string)) {
            throw new Exception("Unable to find resource type - maybe not a FHIR resource?");
        }
        if (string.equals("AdverseReaction")) {
            return this.parseAdverseReaction(jsonObject);
        }
        if (string.equals("Alert")) {
            return this.parseAlert(jsonObject);
        }
        if (string.equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(jsonObject);
        }
        if (string.equals("CarePlan")) {
            return this.parseCarePlan(jsonObject);
        }
        if (string.equals("Composition")) {
            return this.parseComposition(jsonObject);
        }
        if (string.equals("ConceptMap")) {
            return this.parseConceptMap(jsonObject);
        }
        if (string.equals("Condition")) {
            return this.parseCondition(jsonObject);
        }
        if (string.equals("Conformance")) {
            return this.parseConformance(jsonObject);
        }
        if (string.equals("Device")) {
            return this.parseDevice(jsonObject);
        }
        if (string.equals("DeviceObservationReport")) {
            return this.parseDeviceObservationReport(jsonObject);
        }
        if (string.equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(jsonObject);
        }
        if (string.equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(jsonObject);
        }
        if (string.equals("DocumentManifest")) {
            return this.parseDocumentManifest(jsonObject);
        }
        if (string.equals("DocumentReference")) {
            return this.parseDocumentReference(jsonObject);
        }
        if (string.equals("Encounter")) {
            return this.parseEncounter(jsonObject);
        }
        if (string.equals("FamilyHistory")) {
            return this.parseFamilyHistory(jsonObject);
        }
        if (string.equals("Group")) {
            return this.parseGroup(jsonObject);
        }
        if (string.equals("ImagingStudy")) {
            return this.parseImagingStudy(jsonObject);
        }
        if (string.equals("Immunization")) {
            return this.parseImmunization(jsonObject);
        }
        if (string.equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(jsonObject);
        }
        if (string.equals("List")) {
            return this.parseList_(jsonObject);
        }
        if (string.equals("Location")) {
            return this.parseLocation(jsonObject);
        }
        if (string.equals("Media")) {
            return this.parseMedia(jsonObject);
        }
        if (string.equals("Medication")) {
            return this.parseMedication(jsonObject);
        }
        if (string.equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(jsonObject);
        }
        if (string.equals("MedicationDispense")) {
            return this.parseMedicationDispense(jsonObject);
        }
        if (string.equals("MedicationPrescription")) {
            return this.parseMedicationPrescription(jsonObject);
        }
        if (string.equals("MedicationStatement")) {
            return this.parseMedicationStatement(jsonObject);
        }
        if (string.equals("MessageHeader")) {
            return this.parseMessageHeader(jsonObject);
        }
        if (string.equals("Observation")) {
            return this.parseObservation(jsonObject);
        }
        if (string.equals("OperationOutcome")) {
            return this.parseOperationOutcome(jsonObject);
        }
        if (string.equals("Order")) {
            return this.parseOrder(jsonObject);
        }
        if (string.equals("OrderResponse")) {
            return this.parseOrderResponse(jsonObject);
        }
        if (string.equals("Organization")) {
            return this.parseOrganization(jsonObject);
        }
        if (string.equals("Other")) {
            return this.parseOther(jsonObject);
        }
        if (string.equals("Patient")) {
            return this.parsePatient(jsonObject);
        }
        if (string.equals("Practitioner")) {
            return this.parsePractitioner(jsonObject);
        }
        if (string.equals("Procedure")) {
            return this.parseProcedure(jsonObject);
        }
        if (string.equals("Profile")) {
            return this.parseProfile(jsonObject);
        }
        if (string.equals("Provenance")) {
            return this.parseProvenance(jsonObject);
        }
        if (string.equals("Query")) {
            return this.parseQuery(jsonObject);
        }
        if (string.equals("Questionnaire")) {
            return this.parseQuestionnaire(jsonObject);
        }
        if (string.equals("RelatedPerson")) {
            return this.parseRelatedPerson(jsonObject);
        }
        if (string.equals("SecurityEvent")) {
            return this.parseSecurityEvent(jsonObject);
        }
        if (string.equals("Specimen")) {
            return this.parseSpecimen(jsonObject);
        }
        if (string.equals("Substance")) {
            return this.parseSubstance(jsonObject);
        }
        if (string.equals("Supply")) {
            return this.parseSupply(jsonObject);
        }
        if (string.equals("ValueSet")) {
            return this.parseValueSet(jsonObject);
        }
        if (string.equals("Binary")) {
            return this.parseBinary(jsonObject);
        }
        throw new Exception("Unknown.Unrecognised resource type '" + string + "' (in property 'resourceType')");
    }

    protected Type parseType(String string, JsonObject jsonObject) throws Exception {
        if (jsonObject.has(string + "Period")) {
            return this.parsePeriod(jsonObject.getAsJsonObject(string + "Period"));
        }
        if (jsonObject.has(string + "Coding")) {
            return this.parseCoding(jsonObject.getAsJsonObject(string + "Coding"));
        }
        if (jsonObject.has(string + "Range")) {
            return this.parseRange(jsonObject.getAsJsonObject(string + "Range"));
        }
        if (jsonObject.has(string + "Quantity")) {
            return this.parseQuantity(jsonObject.getAsJsonObject(string + "Quantity"));
        }
        if (jsonObject.has(string + "Attachment")) {
            return this.parseAttachment(jsonObject.getAsJsonObject(string + "Attachment"));
        }
        if (jsonObject.has(string + "Ratio")) {
            return this.parseRatio(jsonObject.getAsJsonObject(string + "Ratio"));
        }
        if (jsonObject.has(string + "SampledData")) {
            return this.parseSampledData(jsonObject.getAsJsonObject(string + "SampledData"));
        }
        if (jsonObject.has(string + "Resource")) {
            return this.parseResourceReference(jsonObject.getAsJsonObject(string + "Resource"));
        }
        if (jsonObject.has(string + "CodeableConcept")) {
            return this.parseCodeableConcept(jsonObject.getAsJsonObject(string + "CodeableConcept"));
        }
        if (jsonObject.has(string + "Identifier")) {
            return this.parseIdentifier(jsonObject.getAsJsonObject(string + "Identifier"));
        }
        if (jsonObject.has(string + "Age")) {
            return this.parseAge(jsonObject.getAsJsonObject(string + "Age"));
        }
        if (jsonObject.has(string + "Count")) {
            return this.parseCount(jsonObject.getAsJsonObject(string + "Count"));
        }
        if (jsonObject.has(string + "Money")) {
            return this.parseMoney(jsonObject.getAsJsonObject(string + "Money"));
        }
        if (jsonObject.has(string + "Distance")) {
            return this.parseDistance(jsonObject.getAsJsonObject(string + "Distance"));
        }
        if (jsonObject.has(string + "Duration")) {
            return this.parseDuration(jsonObject.getAsJsonObject(string + "Duration"));
        }
        if (jsonObject.has(string + "Schedule")) {
            return this.parseSchedule(jsonObject.getAsJsonObject(string + "Schedule"));
        }
        if (jsonObject.has(string + "Contact")) {
            return this.parseContact(jsonObject.getAsJsonObject(string + "Contact"));
        }
        if (jsonObject.has(string + "Address")) {
            return this.parseAddress(jsonObject.getAsJsonObject(string + "Address"));
        }
        if (jsonObject.has(string + "HumanName")) {
            return this.parseHumanName(jsonObject.getAsJsonObject(string + "HumanName"));
        }
        if (jsonObject.has(string + "Id") || jsonObject.has("_" + string + "Id")) {
            IdType idType;
            IdType idType2 = idType = jsonObject.has(string + "Id") ? this.parseId(jsonObject.get(string + "Id").getAsString()) : new IdType();
            if (jsonObject.has("_" + string + "Id")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Id"), idType);
            }
            return idType;
        }
        if (jsonObject.has(string + "Base64Binary") || jsonObject.has("_" + string + "Base64Binary")) {
            Base64BinaryType base64BinaryType;
            Base64BinaryType base64BinaryType2 = base64BinaryType = jsonObject.has(string + "Base64Binary") ? this.parseBase64Binary(jsonObject.get(string + "Base64Binary").getAsString()) : new Base64BinaryType();
            if (jsonObject.has("_" + string + "Base64Binary")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Base64Binary"), base64BinaryType);
            }
            return base64BinaryType;
        }
        if (jsonObject.has(string + "DateTime") || jsonObject.has("_" + string + "DateTime")) {
            DateTimeType dateTimeType;
            DateTimeType dateTimeType2 = dateTimeType = jsonObject.has(string + "DateTime") ? this.parseDateTime(jsonObject.get(string + "DateTime").getAsString()) : new DateTimeType();
            if (jsonObject.has("_" + string + "DateTime")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "DateTime"), dateTimeType);
            }
            return dateTimeType;
        }
        if (jsonObject.has(string + "Integer") || jsonObject.has("_" + string + "Integer")) {
            IntegerType integerType;
            IntegerType integerType2 = integerType = jsonObject.has(string + "Integer") ? this.parseInteger(jsonObject.get(string + "Integer").getAsLong()) : new IntegerType();
            if (jsonObject.has("_" + string + "Integer")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Integer"), integerType);
            }
            return integerType;
        }
        if (jsonObject.has(string + "Oid") || jsonObject.has("_" + string + "Oid")) {
            OidType oidType;
            OidType oidType2 = oidType = jsonObject.has(string + "Oid") ? this.parseOid(jsonObject.get(string + "Oid").getAsString()) : new OidType();
            if (jsonObject.has("_" + string + "Oid")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Oid"), oidType);
            }
            return oidType;
        }
        if (jsonObject.has(string + "String") || jsonObject.has("_" + string + "String")) {
            StringType stringType;
            StringType stringType2 = stringType = jsonObject.has(string + "String") ? this.parseString(jsonObject.get(string + "String").getAsString()) : new StringType();
            if (jsonObject.has("_" + string + "String")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "String"), stringType);
            }
            return stringType;
        }
        if (jsonObject.has(string + "Boolean") || jsonObject.has("_" + string + "Boolean")) {
            BooleanType booleanType;
            BooleanType booleanType2 = booleanType = jsonObject.has(string + "Boolean") ? this.parseBoolean(jsonObject.get(string + "Boolean").getAsBoolean()) : new BooleanType();
            if (jsonObject.has("_" + string + "Boolean")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Boolean"), booleanType);
            }
            return booleanType;
        }
        if (jsonObject.has(string + "Uuid") || jsonObject.has("_" + string + "Uuid")) {
            UuidType uuidType;
            UuidType uuidType2 = uuidType = jsonObject.has(string + "Uuid") ? this.parseUuid(jsonObject.get(string + "Uuid").getAsString()) : new UuidType();
            if (jsonObject.has("_" + string + "Uuid")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Uuid"), uuidType);
            }
            return uuidType;
        }
        if (jsonObject.has(string + "Code") || jsonObject.has("_" + string + "Code")) {
            CodeType codeType;
            CodeType codeType2 = codeType = jsonObject.has(string + "Code") ? this.parseCode(jsonObject.get(string + "Code").getAsString()) : new CodeType();
            if (jsonObject.has("_" + string + "Code")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Code"), codeType);
            }
            return codeType;
        }
        if (jsonObject.has(string + "Date") || jsonObject.has("_" + string + "Date")) {
            DateType dateType;
            DateType dateType2 = dateType = jsonObject.has(string + "Date") ? this.parseDate(jsonObject.get(string + "Date").getAsString()) : new DateType();
            if (jsonObject.has("_" + string + "Date")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Date"), dateType);
            }
            return dateType;
        }
        if (jsonObject.has(string + "Uri") || jsonObject.has("_" + string + "Uri")) {
            UriType uriType;
            UriType uriType2 = uriType = jsonObject.has(string + "Uri") ? this.parseUri(jsonObject.get(string + "Uri").getAsString()) : new UriType();
            if (jsonObject.has("_" + string + "Uri")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Uri"), uriType);
            }
            return uriType;
        }
        if (jsonObject.has(string + "Instant") || jsonObject.has("_" + string + "Instant")) {
            InstantType instantType;
            InstantType instantType2 = instantType = jsonObject.has(string + "Instant") ? this.parseInstant(jsonObject.get(string + "Instant").getAsString()) : new InstantType();
            if (jsonObject.has("_" + string + "Instant")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Instant"), instantType);
            }
            return instantType;
        }
        if (jsonObject.has(string + "Decimal") || jsonObject.has("_" + string + "Decimal")) {
            DecimalType decimalType;
            DecimalType decimalType2 = decimalType = jsonObject.has(string + "Decimal") ? this.parseDecimal(jsonObject.get(string + "Decimal").getAsBigDecimal()) : new DecimalType();
            if (jsonObject.has("_" + string + "Decimal")) {
                this.parseElementProperties(jsonObject.getAsJsonObject("_" + string + "Decimal"), decimalType);
            }
            return decimalType;
        }
        return null;
    }

    private boolean hasTypeName(JsonObject jsonObject, String string) {
        if (jsonObject.has(string + "Period")) {
            return true;
        }
        if (jsonObject.has(string + "Coding")) {
            return true;
        }
        if (jsonObject.has(string + "Range")) {
            return true;
        }
        if (jsonObject.has(string + "Quantity")) {
            return true;
        }
        if (jsonObject.has(string + "Attachment")) {
            return true;
        }
        if (jsonObject.has(string + "Ratio")) {
            return true;
        }
        if (jsonObject.has(string + "SampledData")) {
            return true;
        }
        if (jsonObject.has(string + "Resource")) {
            return true;
        }
        if (jsonObject.has(string + "CodeableConcept")) {
            return true;
        }
        if (jsonObject.has(string + "Identifier")) {
            return true;
        }
        if (jsonObject.has(string + "Age")) {
            return true;
        }
        if (jsonObject.has(string + "Count")) {
            return true;
        }
        if (jsonObject.has(string + "Money")) {
            return true;
        }
        if (jsonObject.has(string + "Distance")) {
            return true;
        }
        if (jsonObject.has(string + "Duration")) {
            return true;
        }
        if (jsonObject.has(string + "Schedule")) {
            return true;
        }
        if (jsonObject.has(string + "Contact")) {
            return true;
        }
        if (jsonObject.has(string + "Address")) {
            return true;
        }
        if (jsonObject.has(string + "HumanName")) {
            return true;
        }
        if (jsonObject.has(string + "AdverseReaction")) {
            return true;
        }
        if (jsonObject.has(string + "Alert")) {
            return true;
        }
        if (jsonObject.has(string + "AllergyIntolerance")) {
            return true;
        }
        if (jsonObject.has(string + "CarePlan")) {
            return true;
        }
        if (jsonObject.has(string + "Composition")) {
            return true;
        }
        if (jsonObject.has(string + "ConceptMap")) {
            return true;
        }
        if (jsonObject.has(string + "Condition")) {
            return true;
        }
        if (jsonObject.has(string + "Conformance")) {
            return true;
        }
        if (jsonObject.has(string + "Device")) {
            return true;
        }
        if (jsonObject.has(string + "DeviceObservationReport")) {
            return true;
        }
        if (jsonObject.has(string + "DiagnosticOrder")) {
            return true;
        }
        if (jsonObject.has(string + "DiagnosticReport")) {
            return true;
        }
        if (jsonObject.has(string + "DocumentManifest")) {
            return true;
        }
        if (jsonObject.has(string + "DocumentReference")) {
            return true;
        }
        if (jsonObject.has(string + "Encounter")) {
            return true;
        }
        if (jsonObject.has(string + "FamilyHistory")) {
            return true;
        }
        if (jsonObject.has(string + "Group")) {
            return true;
        }
        if (jsonObject.has(string + "ImagingStudy")) {
            return true;
        }
        if (jsonObject.has(string + "Immunization")) {
            return true;
        }
        if (jsonObject.has(string + "ImmunizationRecommendation")) {
            return true;
        }
        if (jsonObject.has(string + "List")) {
            return true;
        }
        if (jsonObject.has(string + "Location")) {
            return true;
        }
        if (jsonObject.has(string + "Media")) {
            return true;
        }
        if (jsonObject.has(string + "Medication")) {
            return true;
        }
        if (jsonObject.has(string + "MedicationAdministration")) {
            return true;
        }
        if (jsonObject.has(string + "MedicationDispense")) {
            return true;
        }
        if (jsonObject.has(string + "MedicationPrescription")) {
            return true;
        }
        if (jsonObject.has(string + "MedicationStatement")) {
            return true;
        }
        if (jsonObject.has(string + "MessageHeader")) {
            return true;
        }
        if (jsonObject.has(string + "Observation")) {
            return true;
        }
        if (jsonObject.has(string + "OperationOutcome")) {
            return true;
        }
        if (jsonObject.has(string + "Order")) {
            return true;
        }
        if (jsonObject.has(string + "OrderResponse")) {
            return true;
        }
        if (jsonObject.has(string + "Organization")) {
            return true;
        }
        if (jsonObject.has(string + "Other")) {
            return true;
        }
        if (jsonObject.has(string + "Patient")) {
            return true;
        }
        if (jsonObject.has(string + "Practitioner")) {
            return true;
        }
        if (jsonObject.has(string + "Procedure")) {
            return true;
        }
        if (jsonObject.has(string + "Profile")) {
            return true;
        }
        if (jsonObject.has(string + "Provenance")) {
            return true;
        }
        if (jsonObject.has(string + "Query")) {
            return true;
        }
        if (jsonObject.has(string + "Questionnaire")) {
            return true;
        }
        if (jsonObject.has(string + "RelatedPerson")) {
            return true;
        }
        if (jsonObject.has(string + "SecurityEvent")) {
            return true;
        }
        if (jsonObject.has(string + "Specimen")) {
            return true;
        }
        if (jsonObject.has(string + "Substance")) {
            return true;
        }
        if (jsonObject.has(string + "Supply")) {
            return true;
        }
        if (jsonObject.has(string + "ValueSet")) {
            return true;
        }
        if (jsonObject.has(string + "Id") || jsonObject.has("_" + string + "Id")) {
            return true;
        }
        if (jsonObject.has(string + "Base64Binary") || jsonObject.has("_" + string + "Base64Binary")) {
            return true;
        }
        if (jsonObject.has(string + "DateTime") || jsonObject.has("_" + string + "DateTime")) {
            return true;
        }
        if (jsonObject.has(string + "Integer") || jsonObject.has("_" + string + "Integer")) {
            return true;
        }
        if (jsonObject.has(string + "Oid") || jsonObject.has("_" + string + "Oid")) {
            return true;
        }
        if (jsonObject.has(string + "String") || jsonObject.has("_" + string + "String")) {
            return true;
        }
        if (jsonObject.has(string + "Boolean") || jsonObject.has("_" + string + "Boolean")) {
            return true;
        }
        if (jsonObject.has(string + "Uuid") || jsonObject.has("_" + string + "Uuid")) {
            return true;
        }
        if (jsonObject.has(string + "Code") || jsonObject.has("_" + string + "Code")) {
            return true;
        }
        if (jsonObject.has(string + "Date") || jsonObject.has("_" + string + "Date")) {
            return true;
        }
        if (jsonObject.has(string + "Uri") || jsonObject.has("_" + string + "Uri")) {
            return true;
        }
        if (jsonObject.has(string + "Instant") || jsonObject.has("_" + string + "Instant")) {
            return true;
        }
        return jsonObject.has(string + "Decimal") || jsonObject.has("_" + string + "Decimal");
    }
}

